/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.tuple.Pair;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.multiContact.CenterOfMassMotionControlAnchorDescription;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.avatar.multiContact.MultiContactScriptReader;
import us.ihmc.avatar.multiContact.OneDoFMotionControlAnchorDescription;
import us.ihmc.avatar.multiContact.SixDoFMotionControlAnchorDescription;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.WorkspacePathTools;

public class MultiContactScriptStatistics {
    public static void main(String[] args) {
        String addRemoved;
        String suffix;
        int i;
        Path currentDirectory = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software").resolve("valkyrie/src/main/resources/multiContact/scripts").toAbsolutePath().normalize();
        LogTools.info((Object)currentDirectory);
        JFileChooser fileChooser = new JFileChooser(currentDirectory.toFile());
        fileChooser.setFileFilter(new FileNameExtensionFilter("JSON log", "json"));
        int chooserState = fileChooser.showOpenDialog(null);
        if (chooserState != 0) {
            return;
        }
        MultiContactScriptReader scriptReader = new MultiContactScriptReader();
        File selectedFile = fileChooser.getSelectedFile();
        if (!scriptReader.loadScript(selectedFile)) {
            return;
        }
        List<KinematicsToolboxSnapshotDescription> script = scriptReader.getAllItems();
        ArrayList<KFStats> kfStatList = new ArrayList<KFStats>();
        for (int i2 = 0; i2 < script.size(); ++i2) {
            KinematicsToolboxSnapshotDescription snapshot = script.get(i2);
            List<SixDoFMotionControlAnchorDescription> contactAnchors = snapshot.getSixDoFAnchors().stream().filter(SixDoFMotionControlAnchorDescription::isContactState).toList();
            List<SixDoFMotionControlAnchorDescription> taskspaceAnchors = snapshot.getSixDoFAnchors().stream().filter(a -> !a.isContactState()).toList();
            List<OneDoFMotionControlAnchorDescription> oneDoFAnchors = snapshot.getOneDoFAnchors();
            CenterOfMassMotionControlAnchorDescription centerOfMassAnchor = snapshot.getCenterOfMassAnchor();
            int numContacts = contactAnchors.size();
            int numTaskspace = taskspaceAnchors.size();
            int numOneDoF = oneDoFAnchors.size();
            boolean hasCom = MultiContactScriptStatistics.isCoMEnabled(centerOfMassAnchor);
            KFStats kfStats = new KFStats(numContacts, numTaskspace, numOneDoF, hasCom);
            if (i2 > 0) {
                KinematicsToolboxSnapshotDescription prevSnapshot = script.get(i2 - 1);
                List<SixDoFMotionControlAnchorDescription> prevContactAnchors = prevSnapshot.getSixDoFAnchors().stream().filter(SixDoFMotionControlAnchorDescription::isContactState).toList();
                List<SixDoFMotionControlAnchorDescription> prevTaskspaceAnchors = prevSnapshot.getSixDoFAnchors().stream().filter(a -> !a.isContactState()).toList();
                List<OneDoFMotionControlAnchorDescription> prevOneDoFAnchors = prevSnapshot.getOneDoFAnchors();
                CenterOfMassMotionControlAnchorDescription prevCenterOfMassAnchor = prevSnapshot.getCenterOfMassAnchor();
                Pair<Integer, Integer> contactsRemovedAndModified = MultiContactScriptStatistics.amountSixDofRemovedAndModified(prevContactAnchors, contactAnchors, true);
                int contactsAdded = numContacts - (((KFStats)kfStatList.get((int)(i2 - 1))).nContactAnchors - (Integer)contactsRemovedAndModified.getLeft());
                kfStats.setContactData(contactsAdded, (Integer)contactsRemovedAndModified.getLeft(), (Integer)contactsRemovedAndModified.getRight());
                Pair<Integer, Integer> taskspaceRemovedAndModified = MultiContactScriptStatistics.amountSixDofRemovedAndModified(prevTaskspaceAnchors, taskspaceAnchors, false);
                int taskspaceAdded = numTaskspace - (((KFStats)kfStatList.get((int)(i2 - 1))).nTaskspaceAnchors - (Integer)taskspaceRemovedAndModified.getLeft());
                kfStats.setTaskspaceData(taskspaceAdded, (Integer)taskspaceRemovedAndModified.getLeft(), (Integer)taskspaceRemovedAndModified.getRight());
                Pair<Integer, Integer> oneDoFRemovedAndModified = MultiContactScriptStatistics.amountOneDoFRemovedAndModified(prevOneDoFAnchors, oneDoFAnchors);
                int oneDoFAdded = numOneDoF - (((KFStats)kfStatList.get((int)(i2 - 1))).nOneDoF - (Integer)oneDoFRemovedAndModified.getLeft());
                kfStats.setOneDoFData(oneDoFAdded, (Integer)oneDoFRemovedAndModified.getLeft(), (Integer)oneDoFRemovedAndModified.getRight());
                kfStats.setComModified(MultiContactScriptStatistics.isCoMModified(prevCenterOfMassAnchor, centerOfMassAnchor));
            }
            kfStatList.add(kfStats);
        }
        int startingIndex = 1;
        System.out.print("\\begin{tabular}{|");
        for (i = startingIndex; i < kfStatList.size() + 2; ++i) {
            System.out.print(" c |");
        }
        System.out.println("}");
        System.out.println("\\hline");
        System.out.print(" & Keyframe & ");
        for (i = startingIndex; i < kfStatList.size(); ++i) {
            suffix = i == kfStatList.size() - 1 ? " \\\\\n " : " & ";
            System.out.print(i + suffix);
        }
        System.out.println("\\hline");
        System.out.println("\\hline");
        System.out.print("\\rotatebox[origin=c]{90}{Contact} & ");
        System.out.print("\\makecell{Total \\\\ Modified} & ");
        for (i = startingIndex; i < kfStatList.size(); ++i) {
            suffix = i == kfStatList.size() - 1 ? " \\\\\n " : " & ";
            int nContactAnchors = ((KFStats)kfStatList.get((int)i)).nContactAnchors;
            String contactsModified = MultiContactScriptStatistics.formatModified(((KFStats)kfStatList.get((int)i)).contactModified);
            addRemoved = MultiContactScriptStatistics.formatAddedRemoved(((KFStats)kfStatList.get((int)i)).contactsAdded, ((KFStats)kfStatList.get((int)i)).contactsRemoved);
            System.out.print("\\makecell{" + nContactAnchors + "\\\\ " + contactsModified + "} " + suffix);
        }
        System.out.println("\\hline");
        System.out.print("\\rotatebox[origin=c]{90}{Taskspace} & ");
        System.out.print("\\makecell{Total \\\\ Modified} & ");
        for (i = startingIndex; i < kfStatList.size(); ++i) {
            suffix = i == kfStatList.size() - 1 ? " \\\\\n " : " & ";
            int nTaskspaceAnchors = ((KFStats)kfStatList.get((int)i)).nTaskspaceAnchors;
            String taskspaceModified = MultiContactScriptStatistics.formatModified(((KFStats)kfStatList.get((int)i)).taskspaceModified);
            addRemoved = MultiContactScriptStatistics.formatAddedRemoved(((KFStats)kfStatList.get((int)i)).taskspaceAdded, ((KFStats)kfStatList.get((int)i)).taskspaceRemoved);
            System.out.print("\\makecell{" + nTaskspaceAnchors + "\\\\ " + taskspaceModified + "} " + suffix);
        }
        System.out.println("\\hline");
        System.out.print("\\rotatebox[origin=c]{90}{Joint} & ");
        System.out.print("\\makecell{Total \\\\ Modified} & ");
        for (i = startingIndex; i < kfStatList.size(); ++i) {
            suffix = i == kfStatList.size() - 1 ? " \\\\\n " : " & ";
            int nOneDoFAnchors = ((KFStats)kfStatList.get((int)i)).nOneDoF;
            String oneDoFModified = MultiContactScriptStatistics.formatModified(((KFStats)kfStatList.get((int)i)).oneDoFModified);
            addRemoved = MultiContactScriptStatistics.formatAddedRemoved(((KFStats)kfStatList.get((int)i)).oneDoFAdded, ((KFStats)kfStatList.get((int)i)).oneDoFRemoved);
            System.out.print("\\makecell{" + nOneDoFAnchors + "\\\\ " + oneDoFModified + "\\\\} " + suffix);
        }
        System.out.println("\\hline");
        System.out.print("\\rotatebox[origin=c]{90}{CoM} & ");
        System.out.print("\\makecell{Present \\\\ Modified } & ");
        for (i = startingIndex; i < kfStatList.size(); ++i) {
            suffix = i == kfStatList.size() - 1 ? " \\\\\n " : " & ";
            boolean hasCoM = ((KFStats)kfStatList.get((int)i)).hasCoM;
            boolean comModified = ((KFStats)kfStatList.get((int)i)).comModified;
            String hasCoMStr = hasCoM ? "\\checkmark" : " - ";
            String comModifiedStr = comModified ? "\\checkmark" : " - ";
            System.out.print("\\makecell{" + hasCoMStr + "\\\\ " + comModifiedStr + "} " + suffix);
        }
        System.out.println("\\hline");
    }

    private static Pair<Integer, Integer> amountSixDofRemovedAndModified(List<SixDoFMotionControlAnchorDescription> prev, List<SixDoFMotionControlAnchorDescription> next, boolean contactAnchor) {
        int removalCount = 0;
        int modifiedCount = 0;
        block0: for (SixDoFMotionControlAnchorDescription prevAnchor : prev) {
            for (SixDoFMotionControlAnchorDescription nextAnchor : next) {
                if (!MultiContactScriptStatistics.areSameSixDoFAnchor(prevAnchor, nextAnchor, contactAnchor)) continue;
                if (!MultiContactScriptStatistics.wasSixDoFAnchorModified(prevAnchor, nextAnchor, contactAnchor)) continue block0;
                ++modifiedCount;
                continue block0;
            }
            ++removalCount;
        }
        return Pair.of((Object)removalCount, (Object)modifiedCount);
    }

    private static Pair<Integer, Integer> amountOneDoFRemovedAndModified(List<OneDoFMotionControlAnchorDescription> prev, List<OneDoFMotionControlAnchorDescription> next) {
        int removalCount = 0;
        int modifiedCount = 0;
        block0: for (OneDoFMotionControlAnchorDescription prevAnchor : prev) {
            for (OneDoFMotionControlAnchorDescription nextAnchor : next) {
                if (!prevAnchor.getJointName().equals(nextAnchor.getJointName())) continue;
                if (!MultiContactScriptStatistics.wasOneDoFAnchorModified(prevAnchor, nextAnchor)) continue block0;
                ++modifiedCount;
                continue block0;
            }
            ++removalCount;
        }
        return Pair.of((Object)removalCount, (Object)modifiedCount);
    }

    private static boolean isCoMModified(CenterOfMassMotionControlAnchorDescription prev, CenterOfMassMotionControlAnchorDescription next) {
        if (prev == null || next == null) {
            return false;
        }
        return !prev.getInputMessage().epsilonEquals(next.getInputMessage(), 0.001);
    }

    private static String formatModified(int modified) {
        return modified == 0 ? " - " : Integer.toString(modified);
    }

    private static String formatAddedRemoved(int added, int removed) {
        if (added == 0 && removed == 0) {
            return " - ";
        }
        if (added == 0) {
            return "-" + removed;
        }
        if (removed == 0) {
            return "+" + added;
        }
        return "+" + added + ",-" + removed;
    }

    private static boolean areSameSixDoFAnchor(SixDoFMotionControlAnchorDescription anchorA, SixDoFMotionControlAnchorDescription anchorB, boolean contactAnchor) {
        if (!anchorA.getRigidBodyName().equals(anchorB.getRigidBodyName())) {
            return false;
        }
        if (!anchorA.getInputMessage().getControlFramePositionInEndEffector().epsilonEquals((EuclidGeometry)anchorB.getInputMessage().getControlFramePositionInEndEffector(), 1.0E-4)) {
            return false;
        }
        return contactAnchor || anchorA.getInputMessage().getControlFrameOrientationInEndEffector().epsilonEquals((EuclidGeometry)anchorB.getInputMessage().getControlFrameOrientationInEndEffector(), 1.0E-4);
    }

    private static boolean wasSixDoFAnchorModified(SixDoFMotionControlAnchorDescription anchorA, SixDoFMotionControlAnchorDescription anchorB, boolean contactAnchor) {
        KinematicsToolboxRigidBodyMessage messageA = anchorA.getInputMessage();
        KinematicsToolboxRigidBodyMessage messageB = anchorB.getInputMessage();
        if (!messageA.getLinearSelectionMatrix().epsilonEquals(messageB.getLinearSelectionMatrix(), 0.0)) {
            return true;
        }
        if (!messageA.getAngularSelectionMatrix().epsilonEquals(messageB.getAngularSelectionMatrix(), 0.0)) {
            return true;
        }
        if (!messageA.getLinearWeightMatrix().epsilonEquals(messageB.getLinearWeightMatrix(), 1.0E-5)) {
            return true;
        }
        if (!messageA.getLinearWeightMatrix().epsilonEquals(messageB.getLinearWeightMatrix(), 1.0E-5)) {
            return true;
        }
        if (messageA.getLinearSelectionMatrix().getXSelected() && !EuclidCoreTools.epsilonEquals((double)messageA.getDesiredPositionInWorld().getX(), (double)messageB.getDesiredPositionInWorld().getX(), (double)0.001)) {
            return true;
        }
        if (messageA.getLinearSelectionMatrix().getYSelected() && !EuclidCoreTools.epsilonEquals((double)messageA.getDesiredPositionInWorld().getY(), (double)messageB.getDesiredPositionInWorld().getY(), (double)0.001)) {
            return true;
        }
        if (messageA.getLinearSelectionMatrix().getZSelected() && !EuclidCoreTools.epsilonEquals((double)messageA.getDesiredPositionInWorld().getZ(), (double)messageB.getDesiredPositionInWorld().getZ(), (double)0.001)) {
            return true;
        }
        if (contactAnchor) {
            return false;
        }
        Vector3D rotationA = new Vector3D();
        Vector3D rotationB = new Vector3D();
        messageA.getDesiredOrientationInWorld().getRotationVector((Vector3DBasics)rotationA);
        messageB.getDesiredOrientationInWorld().getRotationVector((Vector3DBasics)rotationB);
        if (messageA.getAngularSelectionMatrix().getXSelected() && !EuclidCoreTools.epsilonEquals((double)rotationA.getX(), (double)rotationB.getX(), (double)0.001)) {
            return true;
        }
        if (messageA.getAngularSelectionMatrix().getYSelected() && !EuclidCoreTools.epsilonEquals((double)rotationA.getY(), (double)rotationB.getY(), (double)0.001)) {
            return true;
        }
        return messageA.getAngularSelectionMatrix().getZSelected() && !EuclidCoreTools.epsilonEquals((double)rotationA.getZ(), (double)rotationB.getZ(), (double)0.001);
    }

    private static boolean wasOneDoFAnchorModified(OneDoFMotionControlAnchorDescription anchorA, OneDoFMotionControlAnchorDescription anchorB) {
        if (!EuclidCoreTools.epsilonEquals((double)anchorA.getInputMessage().getWeight(), (double)anchorB.getInputMessage().getWeight(), (double)0.001)) {
            return true;
        }
        return !EuclidCoreTools.epsilonEquals((double)anchorA.getInputMessage().getDesiredPosition(), (double)anchorB.getInputMessage().getDesiredPosition(), (double)0.001);
    }

    private static boolean areSixDoFAnchorsEqual(KinematicsToolboxRigidBodyMessage messageA, KinematicsToolboxRigidBodyMessage messageB) {
        if (!messageA.getLinearSelectionMatrix().epsilonEquals(messageB.getLinearSelectionMatrix(), 0.0)) {
            return false;
        }
        if (!messageA.getAngularSelectionMatrix().epsilonEquals(messageB.getAngularSelectionMatrix(), 0.0)) {
            return false;
        }
        if (!messageA.getLinearWeightMatrix().epsilonEquals(messageB.getLinearWeightMatrix(), 0.0)) {
            return false;
        }
        if (!messageA.getLinearWeightMatrix().epsilonEquals(messageB.getLinearWeightMatrix(), 0.0)) {
            return false;
        }
        if (messageA.getLinearSelectionMatrix().getXSelected() && !EuclidCoreTools.epsilonEquals((double)messageA.getDesiredPositionInWorld().getX(), (double)messageB.getDesiredPositionInWorld().getX(), (double)0.001)) {
            return false;
        }
        if (messageA.getLinearSelectionMatrix().getYSelected() && !EuclidCoreTools.epsilonEquals((double)messageA.getDesiredPositionInWorld().getY(), (double)messageB.getDesiredPositionInWorld().getY(), (double)0.001)) {
            return false;
        }
        if (messageA.getLinearSelectionMatrix().getZSelected() && !EuclidCoreTools.epsilonEquals((double)messageA.getDesiredPositionInWorld().getZ(), (double)messageB.getDesiredPositionInWorld().getZ(), (double)0.001)) {
            return false;
        }
        Vector3D rotationA = new Vector3D();
        Vector3D rotationB = new Vector3D();
        messageA.getDesiredOrientationInWorld().getRotationVector((Vector3DBasics)rotationA);
        messageB.getDesiredOrientationInWorld().getRotationVector((Vector3DBasics)rotationB);
        if (messageA.getAngularSelectionMatrix().getXSelected() && !EuclidCoreTools.epsilonEquals((double)rotationA.getX(), (double)rotationB.getX(), (double)0.001)) {
            return false;
        }
        if (messageA.getAngularSelectionMatrix().getYSelected() && !EuclidCoreTools.epsilonEquals((double)rotationA.getY(), (double)rotationB.getY(), (double)0.001)) {
            return false;
        }
        return !messageA.getAngularSelectionMatrix().getZSelected() || EuclidCoreTools.epsilonEquals((double)rotationA.getZ(), (double)rotationB.getZ(), (double)0.001);
    }

    private static boolean isCoMEnabled(CenterOfMassMotionControlAnchorDescription description) {
        return description != null && (description.getInputMessage().getSelectionMatrix().getXSelected() || description.getInputMessage().getSelectionMatrix().getYSelected() || description.getInputMessage().getSelectionMatrix().getZSelected());
    }

    private static class KFStats {
        int nContactAnchors;
        int nTaskspaceAnchors;
        int nOneDoF;
        boolean hasCoM;
        int contactsAdded;
        int contactsRemoved;
        int taskspaceAdded;
        int taskspaceRemoved;
        int oneDoFAdded;
        int oneDoFRemoved;
        boolean comModified;
        int contactModified;
        int taskspaceModified;
        int oneDoFModified;

        public KFStats(int nContactAnchors, int nTaskspaceAnchors, int nJointAnchors, boolean hasCoM) {
            this.nContactAnchors = nContactAnchors;
            this.nTaskspaceAnchors = nTaskspaceAnchors;
            this.nOneDoF = nJointAnchors;
            this.hasCoM = hasCoM;
        }

        public void setContactData(int contactsAdded, int contactsRemoved, int contactModified) {
            this.contactsAdded = contactsAdded;
            this.contactsRemoved = contactsRemoved;
            this.contactModified = contactModified;
        }

        public void setTaskspaceData(int taskspaceAdded, int taskspaceRemoved, int taskspaceModified) {
            this.taskspaceAdded = taskspaceAdded;
            this.taskspaceRemoved = taskspaceRemoved;
            this.taskspaceModified = taskspaceModified;
        }

        public void setOneDoFData(int jointsAdded, int jointsRemoved, int oneDoFModified) {
            this.oneDoFAdded = jointsAdded;
            this.oneDoFRemoved = jointsRemoved;
            this.oneDoFModified = oneDoFModified;
        }

        public void setComModified(boolean comModified) {
            this.comModified = comModified;
        }
    }
}

