/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.avatar.multiContact.MultiContactEnvironmentDescription;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.log.LogTools;

public class MultiContactScriptReader {
    private int currentMessageIndex = 0;
    private final List<FrameShape3DBasics> loadedEnvironmentShapes = new ArrayList<FrameShape3DBasics>();
    private final List<KinematicsToolboxSnapshotDescription> loadedScriptKeyFrames = new ArrayList<KinematicsToolboxSnapshotDescription>();

    public boolean loadScript(File scriptFile) {
        if (scriptFile == null) {
            LogTools.info((String)"No file provided");
            return false;
        }
        if (!scriptFile.exists()) {
            LogTools.info((String)("Script file does not exist: " + scriptFile));
            return false;
        }
        if (!scriptFile.isFile()) {
            LogTools.info((String)("Not a file: " + scriptFile));
            return false;
        }
        try {
            return this.loadScript(new FileInputStream(scriptFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadScript(InputStream inputStream) {
        if (inputStream == null) {
            LogTools.info((String)"Stream is null");
            return false;
        }
        try {
            int i;
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(inputStream);
            JsonNode environmentNode = jsonNode.get("environment");
            JsonNode scriptNode = jsonNode.get("script");
            if (environmentNode == null || scriptNode == null) {
                return false;
            }
            ArrayList<FrameShape3DBasics> environmentShapes = new ArrayList<FrameShape3DBasics>();
            ArrayList<KinematicsToolboxSnapshotDescription> scriptKeyFrames = new ArrayList<KinematicsToolboxSnapshotDescription>();
            for (i = 0; i < environmentNode.size(); ++i) {
                ObjectNode environmentShape = (ObjectNode)environmentNode.get(i);
                environmentShapes.add(MultiContactEnvironmentDescription.fromJSON((JsonNode)environmentShape));
            }
            this.loadedEnvironmentShapes.clear();
            this.loadedEnvironmentShapes.addAll(environmentShapes);
            for (i = 0; i < scriptNode.size(); ++i) {
                JsonNode keyframe = scriptNode.get(i);
                scriptKeyFrames.add(KinematicsToolboxSnapshotDescription.fromJSON(keyframe));
            }
            this.loadedScriptKeyFrames.clear();
            this.loadedScriptKeyFrames.addAll(scriptKeyFrames);
            this.currentMessageIndex = -1;
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int size() {
        return this.loadedScriptKeyFrames.size();
    }

    public int getCurrentMessageIndex() {
        return this.currentMessageIndex;
    }

    public boolean hasNext() {
        return this.currentMessageIndex < this.loadedScriptKeyFrames.size() - 1;
    }

    public KinematicsToolboxSnapshotDescription rewind() {
        this.currentMessageIndex = 0;
        return this.getCurrent();
    }

    public KinematicsToolboxSnapshotDescription getFirst() {
        if (this.loadedScriptKeyFrames.isEmpty()) {
            return null;
        }
        return this.loadedScriptKeyFrames.get(0);
    }

    public KinematicsToolboxSnapshotDescription next() {
        ++this.currentMessageIndex;
        if (this.currentMessageIndex >= this.loadedScriptKeyFrames.size()) {
            this.currentMessageIndex = this.loadedScriptKeyFrames.size() - 1;
        }
        return this.getCurrent();
    }

    public KinematicsToolboxSnapshotDescription previous() {
        --this.currentMessageIndex;
        if (this.currentMessageIndex < 0) {
            this.currentMessageIndex = 0;
        }
        return this.getCurrent();
    }

    public KinematicsToolboxSnapshotDescription getCurrent() {
        if (this.loadedScriptKeyFrames.isEmpty() || this.currentMessageIndex == -1) {
            return null;
        }
        return this.loadedScriptKeyFrames.get(this.currentMessageIndex);
    }

    public List<FrameShape3DBasics> getEnvironmentShapes() {
        return this.loadedEnvironmentShapes;
    }

    public List<KinematicsToolboxSnapshotDescription> getAllItems() {
        return this.loadedScriptKeyFrames;
    }

    public void applyTransform(Transform transform) {
        for (KinematicsToolboxSnapshotDescription description : this.loadedScriptKeyFrames) {
            description.applyTransform(transform);
        }
    }
}

