/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import controller_msgs.msg.dds.RobotConfigurationData;
import ihmc_common_msgs.msg.dds.SelectionMatrix3DMessage;
import java.util.HashSet;
import java.util.Set;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.avatar.multiContact.RobotTransformOptimizer;
import us.ihmc.avatar.multiContact.SixDoFMotionControlAnchorDescription;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;

public class MultiContactScriptMatcher {
    private final FullHumanoidRobotModel scriptFullRobotModel;
    private final OneDoFJointBasics[] allScriptJoints;
    private final int jointNameHash;
    private final ReferenceFrameHashCodeResolver frameResolver;
    private final RobotTransformOptimizer optimizer;
    private final Set<RigidBodyBasics> defaultScriptBodiesToMatch = new HashSet<RigidBodyBasics>();

    public MultiContactScriptMatcher(FullHumanoidRobotModelFactory factory, FullHumanoidRobotModel controllerFullRobotModel) {
        this.scriptFullRobotModel = factory.createFullRobotModel();
        this.allScriptJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.scriptFullRobotModel);
        this.jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])this.allScriptJoints, (ForceSensorDefinition[])this.scriptFullRobotModel.getForceSensorDefinitions(), (IMUDefinition[])this.scriptFullRobotModel.getIMUDefinitions());
        this.frameResolver = new ReferenceFrameHashCodeResolver();
        this.frameResolver.putAllFullRobotModelReferenceFrames((FullRobotModel)this.scriptFullRobotModel);
        this.optimizer = new RobotTransformOptimizer((RigidBodyReadOnly)controllerFullRobotModel.getElevator(), (RigidBodyReadOnly)this.scriptFullRobotModel.getElevator());
        this.defaultScriptBodiesToMatch.add(this.scriptFullRobotModel.getPelvis());
        this.defaultScriptBodiesToMatch.add(this.scriptFullRobotModel.getChest());
        for (RobotSide robotSide : RobotSide.values) {
            this.defaultScriptBodiesToMatch.add(this.scriptFullRobotModel.getHand(robotSide));
            this.defaultScriptBodiesToMatch.add(this.scriptFullRobotModel.getFoot((Enum)robotSide));
        }
    }

    public void computeTransform(KinematicsToolboxSnapshotDescription description) {
        this.updateScriptRobotConfiguration(description.getControllerConfiguration());
        this.optimizer.clearErrorCalculators();
        this.optimizer.addDefaultRigidBodyLinearErrorCalculators((controllerBody, scriptBody) -> this.defaultScriptBodiesToMatch.contains(scriptBody));
        for (SixDoFMotionControlAnchorDescription anchorDescription : description.getSixDoFAnchors()) {
            RobotTransformOptimizer.RigidBodyPairErrorCalculator errorCalculator;
            if (!anchorDescription.isContactState() && !anchorDescription.isTrackingController()) continue;
            KinematicsToolboxRigidBodyMessage inputMessage = anchorDescription.getInputMessage();
            SelectionMatrix3DMessage linearSelection = inputMessage.getLinearSelectionMatrix();
            SelectionMatrix3DMessage angularSelection = inputMessage.getAngularSelectionMatrix();
            RigidBodyTransform controlFramePose = new RigidBodyTransform((Orientation3DReadOnly)inputMessage.getControlFrameOrientationInEndEffector(), (Tuple3DReadOnly)inputMessage.getControlFramePositionInEndEffector());
            double weight = 1.0;
            if (anchorDescription.isContactState()) {
                weight *= 10.0;
            }
            if (anchorDescription.isTrackingController()) {
                weight *= 10.0;
            }
            if (MultiContactScriptMatcher.isAllFalse(linearSelection)) {
                if (MultiContactScriptMatcher.isAllFalse(angularSelection)) continue;
                errorCalculator = this.optimizer.addAngularRigidBodyErrorCalculator(anchorDescription.getRigidBodyName());
                errorCalculator.setControlFrameOffset(controlFramePose);
                this.packSelectionMatrix3D(angularSelection, ((RobotTransformOptimizer.RigidBodyPairAngularErrorCalculator)errorCalculator).getSelectionMatrix());
                MultiContactScriptMatcher.setWeightMatrix3D(weight, ((RobotTransformOptimizer.RigidBodyPairAngularErrorCalculator)errorCalculator).getWeightMatrix());
                continue;
            }
            if (MultiContactScriptMatcher.isAllFalse(angularSelection)) {
                errorCalculator = this.optimizer.addLinearRigidBodyErrorCalculator(anchorDescription.getRigidBodyName());
                errorCalculator.setControlFrameOffset(controlFramePose);
                this.packSelectionMatrix3D(linearSelection, ((RobotTransformOptimizer.RigidBodyPairLinearErrorCalculator)errorCalculator).getSelectionMatrix());
                MultiContactScriptMatcher.setWeightMatrix3D(weight, ((RobotTransformOptimizer.RigidBodyPairLinearErrorCalculator)errorCalculator).getWeightMatrix());
                continue;
            }
            errorCalculator = this.optimizer.addSpatialRigidBodyErrorCalculator(anchorDescription.getRigidBodyName());
            errorCalculator.setControlFrameOffset(controlFramePose);
            this.packSelectionMatrix3D(linearSelection, ((RobotTransformOptimizer.RigidBodyPairSpatialErrorCalculator)errorCalculator).getSelectionMatrix().getLinearPart());
            this.packSelectionMatrix3D(angularSelection, ((RobotTransformOptimizer.RigidBodyPairSpatialErrorCalculator)errorCalculator).getSelectionMatrix().getAngularPart());
            MultiContactScriptMatcher.setWeightMatrix3D(weight, ((RobotTransformOptimizer.RigidBodyPairSpatialErrorCalculator)errorCalculator).getWeightMatrix().getLinearPart());
            MultiContactScriptMatcher.setWeightMatrix3D(weight, ((RobotTransformOptimizer.RigidBodyPairSpatialErrorCalculator)errorCalculator).getWeightMatrix().getAngularPart());
        }
        this.optimizer.compute();
    }

    public RigidBodyTransform getScriptTransform() {
        return this.optimizer.getTransformFromBToA();
    }

    private void updateScriptRobotConfiguration(RobotConfigurationData configuration) {
        this.scriptFullRobotModel.getRootJoint().getJointPose().set((Tuple3DReadOnly)configuration.getRootPosition(), (Orientation3DReadOnly)configuration.getRootOrientation());
        for (int i = 0; i < configuration.getJointAngles().size(); ++i) {
            this.allScriptJoints[i].setQ((double)configuration.getJointAngles().get(i));
        }
        this.scriptFullRobotModel.updateFrames();
    }

    private void packSelectionMatrix3D(SelectionMatrix3DMessage message, SelectionMatrix3D selectionMatrixToPack) {
        selectionMatrixToPack.setSelectionFrame(this.frameResolver.getReferenceFrame(message.getSelectionFrameId()));
        selectionMatrixToPack.selectXAxis(message.getXSelected());
        selectionMatrixToPack.selectYAxis(message.getYSelected());
        selectionMatrixToPack.selectZAxis(message.getZSelected());
    }

    private static boolean isAllFalse(SelectionMatrix3DMessage selection) {
        return !selection.getXSelected() && !selection.getYSelected() && !selection.getZSelected();
    }

    private static void setWeightMatrix3D(double weight, WeightMatrix3D weightMatrixToPack) {
        weightMatrixToPack.setWeights(weight, weight, weight);
    }
}

