/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import us.ihmc.avatar.logging.PlanarRegionsBufferElement;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.FramePlanarRegionsList;

public class PlanarRegionsReplayBuffer<T> {
    private int bufferLength;
    private HashMap<Integer, PlanarRegionsBufferElement<T>> indexBuffer;
    private TreeSet<PlanarRegionsBufferElement<T>> timeBuffer;
    private long firstEverTime = Long.MAX_VALUE;
    private int index = 0;
    private final Comparator<PlanarRegionsBufferElement<T>> compareByTime = Comparator.comparingLong(PlanarRegionsBufferElement::getTime);

    public void loadFromLog(File planarRegionListLog, Class<?> type) throws IOException {
        this.indexBuffer = new HashMap();
        this.timeBuffer = new TreeSet<PlanarRegionsBufferElement<T>>(this.compareByTime);
        Scanner in = new Scanner(planarRegionListLog);
        in.useDelimiter("##\n");
        in.next();
        int index = 0;
        while (in.hasNext()) {
            in.nextLine();
            long time = Long.parseLong(in.nextLine());
            File temp = File.createTempFile("prll", ".tmp");
            temp.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(temp);){
                IOUtils.copy((Reader)new StringReader(in.next()), (OutputStream)out);
            }
            Object list = type == FramePlanarRegionsList.class ? PlanarRegionFileTools.importFramePlanarRegionsData((File)temp) : PlanarRegionFileTools.importPlanarRegionData((File)temp);
            PlanarRegionsBufferElement<FramePlanarRegionsList> planarRegionsBufferElement = new PlanarRegionsBufferElement<FramePlanarRegionsList>(index, time, (FramePlanarRegionsList)list);
            this.indexBuffer.put(index, planarRegionsBufferElement);
            this.timeBuffer.add(planarRegionsBufferElement);
            this.firstEverTime = this.getStartTime();
            ++index;
        }
        if (this.bufferLength < this.indexBuffer.size()) {
            this.bufferLength = this.indexBuffer.size();
        }
        if (this.bufferLength <= 0) {
            LogTools.warn((String)"Loaded empty log into TBuffer");
        }
    }

    public PlanarRegionsReplayBuffer(File planarRegionListLog, Class<?> type) throws IOException {
        this.loadFromLog(planarRegionListLog, type);
        this.bufferLength = this.indexBuffer.size();
    }

    public PlanarRegionsReplayBuffer() {
        this(Integer.MAX_VALUE);
    }

    public PlanarRegionsReplayBuffer(int bufferLength) {
        this.bufferLength = bufferLength;
        this.indexBuffer = new HashMap();
        this.timeBuffer = new TreeSet<PlanarRegionsBufferElement<T>>(this.compareByTime);
    }

    public void expandBuffer(long additionalSize) {
        if (additionalSize <= 0L) {
            return;
        }
        this.bufferLength = (int)((long)this.bufferLength + additionalSize);
    }

    public void putAndTick(long time, T list) {
        PlanarRegionsBufferElement<T> bufferElement = new PlanarRegionsBufferElement<T>(this.index, time, list);
        this.indexBuffer.put(this.index, bufferElement);
        this.timeBuffer.add(bufferElement);
        if (this.index > this.bufferLength) {
            this.indexBuffer.remove(this.index - this.bufferLength);
            this.timeBuffer.remove(this.timeBuffer.first());
        }
        if (time < this.firstEverTime) {
            this.firstEverTime = time;
        }
        ++this.index;
    }

    public T get(int index) {
        PlanarRegionsBufferElement<T> bufferElement = this.indexBuffer.get(index);
        return bufferElement == null ? null : (T)bufferElement.getList();
    }

    private PlanarRegionsBufferElement<T> getNearTimeInternal(long time) {
        PlanarRegionsBufferElement<Object> value;
        PlanarRegionsBufferElement<Object> lookup = new PlanarRegionsBufferElement<Object>(-1, time, null);
        PlanarRegionsBufferElement<Object> lower = this.timeBuffer.lower(lookup);
        PlanarRegionsBufferElement<Object> higher = this.timeBuffer.higher(lookup);
        if (lower == null) {
            if (higher == null) {
                return null;
            }
            value = higher;
        } else {
            value = higher == null ? lower : (Math.abs(lower.getTime() - time) > Math.abs(higher.getTime() - time) ? higher : lower);
        }
        return value;
    }

    public T getNearTime(long time) {
        PlanarRegionsBufferElement<T> nearTimeElement = this.getNearTimeInternal(time);
        return nearTimeElement != null ? (T)nearTimeElement.getList() : null;
    }

    public long getNextTime(long currentTime) {
        if (this.indexBuffer.size() < 1) {
            return -1L;
        }
        PlanarRegionsBufferElement<T> nextTimeElement = this.indexBuffer.get(this.getNearTimeInternal(currentTime + 1L).getIndex() + 1);
        return nextTimeElement == null ? Long.MAX_VALUE : nextTimeElement.getTime();
    }

    public long getPreviousTime(long currentTime) {
        if (this.indexBuffer.size() < 1) {
            return -1L;
        }
        PlanarRegionsBufferElement<T> container = this.indexBuffer.get(this.getNearTimeInternal(currentTime - 1L).getIndex() - 1);
        return container == null ? 0L : container.getTime();
    }

    public long getCurrentIndex() {
        return this.index;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public long getFirstEverTime() {
        return this.firstEverTime;
    }

    public long getStartTime() {
        if (this.timeBuffer.size() == 0) {
            return -1L;
        }
        return this.timeBuffer.first().getTime();
    }

    public long getEndTime() {
        if (this.timeBuffer.size() == 0) {
            return -1L;
        }
        return this.timeBuffer.last().getTime();
    }
}

