/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.kinematicsSimulation;

import us.ihmc.pubsub.DomainFactory;
import us.ihmc.tools.UnitConversions;

public class HumanoidKinematicsSimulationParameters {
    private boolean createPeriodicThread = true;
    private boolean createYoVariableServer = false;
    private boolean logToFile = false;
    private DomainFactory.PubSubImplementation pubSubImplementation = DomainFactory.PubSubImplementation.INTRAPROCESS;
    private double initialGroundHeight = 0.0;
    private double initialRobotYaw = 0.0;
    private double initialRobotX = 0.0;
    private double initialRobotY = 0.0;
    private double initialRobotZ = 0.0;
    private double playbackSpeedMultiplier = 10.0;
    private double dt = UnitConversions.hertzToSeconds((double)70.0);
    private boolean runNoFasterThanMaxRealtimeRate = true;
    private double maxRealtimeRate = 2.0;

    public double getInitialGroundHeight() {
        return this.initialGroundHeight;
    }

    public void setInitialGroundHeight(double initialGroundHeight) {
        this.initialGroundHeight = initialGroundHeight;
    }

    public double getInitialRobotYaw() {
        return this.initialRobotYaw;
    }

    public void setInitialRobotYaw(double initialRobotYaw) {
        this.initialRobotYaw = initialRobotYaw;
    }

    public double getInitialRobotX() {
        return this.initialRobotX;
    }

    public void setInitialRobotX(double initialRobotX) {
        this.initialRobotX = initialRobotX;
    }

    public double getInitialRobotY() {
        return this.initialRobotY;
    }

    public void setInitialRobotY(double initialRobotY) {
        this.initialRobotY = initialRobotY;
    }

    public double getInitialRobotZ() {
        return this.initialRobotZ;
    }

    public void setInitialRobotZ(double initialRobotZ) {
        this.initialRobotZ = initialRobotZ;
    }

    public void setCreateYoVariableServer(boolean createYoVariableServer) {
        this.createYoVariableServer = createYoVariableServer;
    }

    public boolean getCreateYoVariableServer() {
        return this.createYoVariableServer;
    }

    public void setLogToFile(boolean logToFile) {
        this.logToFile = logToFile;
    }

    public boolean getLogToFile() {
        return this.logToFile;
    }

    public void setPubSubImplementation(DomainFactory.PubSubImplementation pubSubImplementation) {
        this.pubSubImplementation = pubSubImplementation;
    }

    public DomainFactory.PubSubImplementation getPubSubImplementation() {
        return this.pubSubImplementation;
    }

    public void setPlaybackSpeedMultiplier(double playbackSpeedMultiplier) {
        this.playbackSpeedMultiplier = playbackSpeedMultiplier;
    }

    public void setUpdateFrequencyHz(double updateFrequencyHz) {
        this.dt = UnitConversions.hertzToSeconds((double)updateFrequencyHz);
    }

    public double getDt() {
        return this.dt;
    }

    public double getUpdatePeriod() {
        return this.dt / this.playbackSpeedMultiplier;
    }

    public void setRunNoFasterThanMaxRealtimeRate(boolean runNoFasterThanMaxRealtimeRate) {
        this.runNoFasterThanMaxRealtimeRate = runNoFasterThanMaxRealtimeRate;
    }

    public boolean runNoFasterThanMaxRealtimeRate() {
        return this.runNoFasterThanMaxRealtimeRate;
    }

    public void setMaxRealtimeRate(double maxRealtimeRate) {
        this.maxRealtimeRate = maxRealtimeRate;
    }

    public double getMaxRealtimeRate() {
        return this.maxRealtimeRate;
    }

    public boolean isPeriodicThreadEnabled() {
        return this.createPeriodicThread;
    }

    public void setEnablePeriodicThread(boolean createPeriodicThread) {
        this.createPeriodicThread = createPeriodicThread;
    }
}

