/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.kinematicsSimulation;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.WalkingStatusMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.ejml.data.DMatrix;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationContactStateHolder;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.avatar.kinematicsSimulation.SimulatedHandKinematicController;
import us.ihmc.avatar.logging.IntraprocessYoVariableLogger;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModule;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisHeightControlState;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.ControllerNetworkSubscriber;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerAPIDefinition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WalkingHighLevelHumanoidController;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.SettableFootSwitch;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.MessageUnpackingTools;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.ros2.ROS2Heartbeat;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.FrameMessageCommandConverter;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.humanoidRobotics.communication.packets.walking.WalkingStatus;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.humanoidRobotics.model.CenterOfMassStateProvider;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.MultiBodySystemMissingTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataPublisher;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataPublisherFactory;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.imu.IMUSensor;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.sensorProcessing.sensorProcessors.FloatingJointStateReadOnly;
import us.ihmc.sensorProcessing.sensorProcessors.OneDoFJointStateReadOnly;
import us.ihmc.sensorProcessing.sensorProcessors.SensorTimestampHolder;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.tools.thread.PausablePeriodicThread;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class HumanoidKinematicsSimulation {
    private static final double GRAVITY_Z = 9.81;
    private static final double LIDAR_SPINDLE_SPEED = 2.5;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final HumanoidKinematicsSimulationParameters kinematicsSimulationParameters;
    private final PausablePeriodicThread controlThread;
    private final ROS2Node ros2Node;
    private final RealtimeROS2Node realtimeROS2Node;
    private final ROS2Heartbeat heartbeat;
    private final RobotConfigurationDataPublisher robotConfigurationDataPublisher;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private final SimulatedHandKinematicController simulatedHandKinematicController;
    private final RobotMotionStatusHolder robotMotionStatusHolder = new RobotMotionStatusHolder(RobotMotionStatus.UNKNOWN);
    private double yoVariableServerTime = 0.0;
    private final Stopwatch monotonicTimer = new Stopwatch();
    private final Stopwatch updateTimer = new Stopwatch();
    private final YoDouble yoTime;
    private final FullHumanoidRobotModel fullRobotModel;
    private final CommonHumanoidReferenceFrames referenceFrames;
    private final SideDependentList<SettableFootSwitch> footSwitches = new SideDependentList();
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WholeBodyControllerCore controllerCore;
    private final LinearMomentumRateControlModule linearMomentumRateControlModule;
    private final HighLevelControlManagerFactory managerFactory;
    private final WalkingHighLevelHumanoidController walkingController;
    private final CommandInputManager walkingInputManager = new CommandInputManager("walking_preview_internal", ControllerAPIDefinition.getControllerSupportedCommands());
    private final StatusMessageOutputManager walkingOutputManager = new StatusMessageOutputManager(ControllerAPIDefinition.getControllerSupportedStatusMessages());
    private final MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator();
    private AtomicReference<WalkingStatus> latestWalkingStatus = new AtomicReference();
    private SideDependentList<HumanoidKinematicsSimulationContactStateHolder> contactStateHolders = new SideDependentList();
    private InverseDynamicsCommandList inverseDynamicsContactHolderCommandList = new InverseDynamicsCommandList();
    private YoVariableServer yoVariableServer = null;
    private IntraprocessYoVariableLogger intraprocessYoVariableLogger;
    private JointDesiredOutputListReadOnly jointDesiredOutputList;

    public static HumanoidKinematicsSimulation create(DRCRobotModel robotModel, HumanoidKinematicsSimulationParameters kinematicsSimulationParameters) {
        HumanoidKinematicsSimulation humanoidKinematicsSimulation = new HumanoidKinematicsSimulation(robotModel, kinematicsSimulationParameters);
        humanoidKinematicsSimulation.setRunning(true);
        return humanoidKinematicsSimulation;
    }

    public static HumanoidKinematicsSimulation createForPreviews(DRCRobotModel robotModel, HumanoidKinematicsSimulationParameters kinematicsSimulationParameters) {
        return new HumanoidKinematicsSimulation(robotModel, kinematicsSimulationParameters);
    }

    private HumanoidKinematicsSimulation(DRCRobotModel robotModel, HumanoidKinematicsSimulationParameters kinematicsSimulationParameters) {
        this.kinematicsSimulationParameters = kinematicsSimulationParameters;
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)kinematicsSimulationParameters.getPubSubImplementation(), (String)"kinematics_ihmc_controller");
        this.heartbeat = new ROS2Heartbeat((ROS2NodeInterface)this.ros2Node, ROS2Tools.KINEMATICS_SIMULATION_HEARTBEAT);
        String robotName = robotModel.getSimpleRobotName();
        this.fullRobotModel = robotModel.createFullRobotModel();
        CenterOfMassStateProvider centerOfMassStateProvider = CenterOfMassStateProvider.createJacobianBasedStateCalculator((RigidBodyReadOnly)this.fullRobotModel.getElevator(), (ReferenceFrame)worldFrame);
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel, centerOfMassStateProvider, null);
        this.yoTime = new YoDouble("time", this.registry);
        YoRegistry drcControllerThreadRegistry = new YoRegistry("DRCControllerThread");
        YoRegistry drcMomentumBasedControllerRegistry = new YoRegistry("DRCMomentumBasedController");
        YoRegistry humanoidHighLevelControllerManagerRegistry = new YoRegistry("HumanoidHighLevelControllerManager");
        YoRegistry managerParentRegistry = new YoRegistry("HighLevelHumanoidControllerFactory");
        YoRegistry walkingParentRegistry = new YoRegistry("WalkingControllerState");
        this.registry.addChild(drcControllerThreadRegistry);
        drcControllerThreadRegistry.addChild(drcMomentumBasedControllerRegistry);
        drcMomentumBasedControllerRegistry.addChild(humanoidHighLevelControllerManagerRegistry);
        humanoidHighLevelControllerManagerRegistry.addChild(walkingParentRegistry);
        humanoidHighLevelControllerManagerRegistry.addChild(managerParentRegistry);
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)contactPointParameters.getAdditionalContactRigidBodyNames().get(i), (String)contactPointParameters.getAdditionalContactNames().get(i), (RigidBodyTransform)contactPointParameters.getAdditionalContactTransforms().get(i));
        }
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)this.fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)this.referenceFrames);
        SideDependentList feet = new SideDependentList(contactableBodiesFactory.createFootContactableFeet());
        ArrayList allContactableBodies = new ArrayList(contactableBodiesFactory.createAdditionalContactPoints());
        allContactableBodies.addAll(feet.values());
        contactableBodiesFactory.disposeFactory();
        double totalRobotWeight = TotalMassCalculator.computeSubTreeMass((RigidBodyReadOnly)this.fullRobotModel.getElevator());
        for (RobotSide robotSide : RobotSide.values) {
            SettableFootSwitch footSwitch = new SettableFootSwitch((ContactablePlaneBody)feet.get((Enum)robotSide), totalRobotWeight, 2, this.registry);
            footSwitch.setFootContactState(true);
            this.footSwitches.put((Enum)robotSide, (Object)footSwitch);
        }
        JointBasics[] jointsToIgnore = AvatarControllerThread.createListOfJointsToIgnore(this.fullRobotModel, robotModel, robotModel.getSensorInformation());
        this.controllerToolbox = new HighLevelHumanoidControllerToolbox(this.fullRobotModel, centerOfMassStateProvider, this.referenceFrames, this.footSwitches, null, this.yoTime, 9.81, robotModel.getWalkingControllerParameters().getOmega0(), feet, kinematicsSimulationParameters.getDt(), Collections.emptyList(), allContactableBodies, this.yoGraphicsListRegistry, jointsToIgnore);
        humanoidHighLevelControllerManagerRegistry.addChild(this.controllerToolbox.getYoVariableRegistry());
        WalkingControllerParameters walkingControllerParameters = robotModel.getWalkingControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = robotModel.getCoPTrajectoryParameters();
        WalkingMessageHandler walkingMessageHandler = new WalkingMessageHandler(walkingControllerParameters.getDefaultTransferTime(), walkingControllerParameters.getDefaultSwingTime(), walkingControllerParameters.getDefaultInitialTransferTime(), walkingControllerParameters.getDefaultFinalTransferTime(), this.controllerToolbox.getContactableFeet(), this.walkingOutputManager, this.yoTime, this.yoGraphicsListRegistry, this.controllerToolbox.getYoVariableRegistry());
        this.controllerToolbox.setWalkingMessageHandler(walkingMessageHandler);
        this.controllerToolbox.attachRobotMotionStatusChangedListener((newStatus, time) -> this.robotMotionStatusHolder.setCurrentRobotMotionStatus(newStatus));
        RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup = robotModel.getDefaultRobotInitialSetup(kinematicsSimulationParameters.getInitialGroundHeight(), kinematicsSimulationParameters.getInitialRobotYaw(), kinematicsSimulationParameters.getInitialRobotX(), kinematicsSimulationParameters.getInitialRobotY(), kinematicsSimulationParameters.getInitialRobotZ());
        robotInitialSetup.initializeFullRobotModel(this.fullRobotModel);
        this.managerFactory = new HighLevelControlManagerFactory(managerParentRegistry);
        this.managerFactory.setHighLevelHumanoidControllerToolbox(this.controllerToolbox);
        this.managerFactory.setCopTrajectoryParameters(copTrajectoryParameters);
        this.managerFactory.setWalkingControllerParameters(walkingControllerParameters);
        this.walkingController = new WalkingHighLevelHumanoidController(this.walkingInputManager, this.walkingOutputManager, this.managerFactory, walkingControllerParameters, this.controllerToolbox);
        walkingParentRegistry.addChild(this.walkingController.getYoVariableRegistry());
        this.realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)kinematicsSimulationParameters.getPubSubImplementation(), (String)"kinematics_ihmc_controller_rt");
        ROS2Topic inputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        ROS2Topic outputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ControllerNetworkSubscriber controllerNetworkSubscriber = new ControllerNetworkSubscriber(inputTopic, this.walkingInputManager, outputTopic, this.walkingOutputManager, (ROS2NodeInterface)this.realtimeROS2Node);
        controllerNetworkSubscriber.addMessageFilter(message -> {
            if (message instanceof FootstepDataListMessage) {
                FootstepDataListMessage footstepDataListMessage = (FootstepDataListMessage)message;
                footstepDataListMessage.setOffsetFootstepsHeightWithExecutionError(false);
            }
            return true;
        });
        this.walkingInputManager.registerConversionHelper((CommandConversionInterface)new FrameMessageCommandConverter(this.controllerToolbox.getReferenceFrameHashCodeResolver()));
        controllerNetworkSubscriber.registerSubcriberWithMessageUnpacker(WholeBodyTrajectoryMessage.class, 9, MessageUnpackingTools.createWholeBodyTrajectoryMessageUnpacker());
        controllerNetworkSubscriber.addMessageCollectors(ControllerAPIDefinition.createDefaultMessageIDExtractor(), 3);
        controllerNetworkSubscriber.addMessageValidator(ControllerAPIDefinition.createDefaultMessageValidation());
        this.simulatedHandKinematicController = robotModel.createSimulatedHandKinematicController(this.fullRobotModel, this.realtimeROS2Node, (DoubleProvider)this.yoTime);
        this.robotConfigurationDataPublisher = this.createRobotConfigurationDataPublisher(robotModel.getSimpleRobotName());
        this.realtimeROS2Node.spin();
        WholeBodyControlCoreToolbox controlCoreToolbox = new WholeBodyControlCoreToolbox(kinematicsSimulationParameters.getDt(), 9.81, this.fullRobotModel.getRootJoint(), this.controllerToolbox.getControlledJoints(), this.controllerToolbox.getCenterOfMassFrame(), (ControllerCoreOptimizationSettings)walkingControllerParameters.getMomentumOptimizationSettings(), this.yoGraphicsListRegistry, this.registry);
        controlCoreToolbox.setJointPrivilegedConfigurationParameters(walkingControllerParameters.getJointPrivilegedConfigurationParameters());
        controlCoreToolbox.setFeedbackControllerSettings(walkingControllerParameters.getFeedbackControllerSettings());
        controlCoreToolbox.setupForInverseDynamicsSolver(this.controllerToolbox.getContactablePlaneBodies());
        this.controllerCore = new WholeBodyControllerCore(controlCoreToolbox, this.managerFactory.createFeedbackControlTemplate(), new JointDesiredOutputList((OneDoFJointReadOnly[])this.controllerToolbox.getControlledOneDoFJoints()), walkingParentRegistry);
        this.jointDesiredOutputList = this.controllerCore.getOutputForLowLevelController();
        this.walkingController.setControllerCoreOutput(this.controllerCore.getOutputForHighLevelController());
        this.linearMomentumRateControlModule = new LinearMomentumRateControlModule(centerOfMassStateProvider, this.referenceFrames, this.controllerToolbox.getContactableFeet(), this.fullRobotModel.getElevator(), walkingControllerParameters, 9.81, this.controllerToolbox.getControlDT(), walkingParentRegistry, this.yoGraphicsListRegistry);
        ParameterLoaderHelper.loadParameters((Object)this, (WholeBodyControllerParameters)robotModel, (YoRegistry)drcControllerThreadRegistry);
        YoVariable defaultHeight = this.registry.findVariable(PelvisHeightControlState.class.getSimpleName(), PelvisHeightControlState.class.getSimpleName() + "DefaultHeight");
        if (Double.isNaN(defaultHeight.getValueAsDouble())) {
            throw new RuntimeException("Need to load a default height.");
        }
        if (kinematicsSimulationParameters.getLogToFile()) {
            this.intraprocessYoVariableLogger = new IntraprocessYoVariableLogger(this.getClass().getSimpleName(), robotModel.getLogModelProvider(), this.registry, this.fullRobotModel.getElevator(), this.yoGraphicsListRegistry, 100000, 0.01);
            this.intraprocessYoVariableLogger.start();
        }
        if (kinematicsSimulationParameters.getCreateYoVariableServer()) {
            LogTools.info((String)"Starting YoVariable server...");
            this.yoVariableServer = new YoVariableServer(this.getClass().getSimpleName(), robotModel.getLogModelProvider(), new DataServerSettings(false), 0.01);
            this.yoVariableServer.setMainRegistry(this.registry, MultiBodySystemMissingTools.getSubtreeJointsIncludingFourBars((RigidBodyBasics)this.fullRobotModel.getElevator()), this.yoGraphicsListRegistry);
            this.yoVariableServer.start();
            LogTools.info((String)"YoVariable server started.");
        }
        this.walkingOutputManager.attachStatusMessageListener(FootstepStatusMessage.class, this::processFootstepStatus);
        this.walkingOutputManager.attachStatusMessageListener(WalkingStatusMessage.class, this::processWalkingStatus);
        this.controlThread = kinematicsSimulationParameters.isPeriodicThreadEnabled() ? new PausablePeriodicThread(this.getClass().getSimpleName(), kinematicsSimulationParameters.getUpdatePeriod(), 5, this::controllerTick) : null;
    }

    public RobotConfigurationDataPublisher createRobotConfigurationDataPublisher(String robotName) {
        RobotConfigurationDataPublisherFactory rcdPublisherFactory = new RobotConfigurationDataPublisherFactory();
        rcdPublisherFactory.setDefinitionsToPublish(this.fullRobotModel);
        SensorTimestampHolder sensorTimestampHolder = new SensorTimestampHolder(){

            public long getWallTime() {
                return Conversions.secondsToNanoseconds((double)HumanoidKinematicsSimulation.this.yoTime.getValue());
            }

            public long getSyncTimestamp() {
                return this.getWallTime();
            }

            public long getMonotonicTime() {
                return this.getWallTime();
            }
        };
        FloatingJointStateReadOnly rootJointStateOutput = FloatingJointStateReadOnly.fromFloatingJoint((FloatingJointReadOnly)this.fullRobotModel.getRootJoint());
        ArrayList<OneDoFJointStateReadOnly> jointSensorOutputs = new ArrayList<OneDoFJointStateReadOnly>();
        for (OneDoFJointBasics joint : FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel)) {
            jointSensorOutputs.add(OneDoFJointStateReadOnly.createFromOneDoFJoint((OneDoFJointReadOnly)joint, (boolean)true));
        }
        ForceSensorDataHolder forceSensorDataHolder = new ForceSensorDataHolder(this.fullRobotModel.getForceSensorDefinitions());
        ArrayList<IMUSensor> imuSensorOutputs = new ArrayList<IMUSensor>();
        for (IMUDefinition imuDefinition : this.fullRobotModel.getIMUDefinitions()) {
            IMUSensor imu = new IMUSensor(imuDefinition, null);
            imuSensorOutputs.add(imu);
        }
        rcdPublisherFactory.setSensorSource(sensorTimestampHolder, rootJointStateOutput, jointSensorOutputs, (ForceSensorDataHolderReadOnly)forceSensorDataHolder, imuSensorOutputs);
        rcdPublisherFactory.setPublishPeriod(0L);
        rcdPublisherFactory.setRobotMotionStatusHolder(this.robotMotionStatusHolder);
        rcdPublisherFactory.setROS2Info(this.realtimeROS2Node, ROS2Tools.getControllerOutputTopic((String)robotName));
        return rcdPublisherFactory.createRobotConfigurationDataPublisher();
    }

    public void setState() {
    }

    public void setRunning(boolean running) {
        if (this.controlThread == null) {
            return;
        }
        if (running && !this.controlThread.isRunning()) {
            this.initialize();
            this.controlThread.start();
            this.heartbeat.setAlive(true);
        } else if (!running && this.controlThread.isRunning()) {
            this.controlThread.stop();
            this.heartbeat.setAlive(false);
        }
    }

    public void initialize() {
        this.zeroMotion();
        this.referenceFrames.updateFrames();
        this.controllerCore.initialize();
        this.walkingController.initialize();
        for (RobotSide robotSide : RobotSide.values) {
            this.contactStateHolders.put((Enum)robotSide, (Object)HumanoidKinematicsSimulationContactStateHolder.holdAtCurrent((PlaneContactState)this.controllerToolbox.getFootContactStates().get((Enum)robotSide)));
        }
        if (this.simulatedHandKinematicController != null) {
            this.simulatedHandKinematicController.initialize();
        }
        this.monotonicTimer.start();
    }

    public void controllerTick() {
        this.updateTimer.reset();
        this.doControl();
        this.robotConfigurationDataPublisher.write();
        if (this.kinematicsSimulationParameters.runNoFasterThanMaxRealtimeRate()) {
            while (this.updateTimer.totalElapsed() < this.kinematicsSimulationParameters.getDt() / this.kinematicsSimulationParameters.getMaxRealtimeRate()) {
                ThreadTools.sleep((long)1L);
            }
        }
    }

    public void doControl() {
        this.yoTime.add(this.kinematicsSimulationParameters.getDt());
        this.fullRobotModel.updateFrames();
        this.referenceFrames.updateFrames();
        this.controllerToolbox.update();
        this.inverseDynamicsContactHolderCommandList.clear();
        for (RobotSide side : this.contactStateHolders.sides()) {
            ((HumanoidKinematicsSimulationContactStateHolder)this.contactStateHolders.get((Enum)side)).doControl();
            this.inverseDynamicsContactHolderCommandList.addCommand(((HumanoidKinematicsSimulationContactStateHolder)this.contactStateHolders.get((Enum)side)).getOutput());
        }
        if (this.contactStateHolders.sides().length == 1 && this.managerFactory.getOrCreateBalanceManager().isICPPlanDone()) {
            ((SettableFootSwitch)this.footSwitches.get((Enum)this.contactStateHolders.sides()[0].getOppositeSide())).setFootContactState(true);
        }
        this.walkingController.doAction();
        this.linearMomentumRateControlModule.setInputFromWalkingStateMachine(this.walkingController.getLinearMomentumRateControlModuleInput());
        if (!this.linearMomentumRateControlModule.computeControllerCoreCommands()) {
            this.controllerToolbox.reportControllerFailureToListeners(new FrameVector2D());
        }
        this.walkingController.setLinearMomentumRateControlModuleOutput(this.linearMomentumRateControlModule.getOutputForWalkingStateMachine());
        ControllerCoreCommand controllerCoreCommand = this.walkingController.getControllerCoreCommand();
        controllerCoreCommand.addInverseDynamicsCommand((InverseDynamicsCommand)this.linearMomentumRateControlModule.getMomentumRateCommand());
        controllerCoreCommand.addInverseDynamicsCommand((InverseDynamicsCommand)this.inverseDynamicsContactHolderCommandList);
        this.controllerCore.compute((ControllerCoreCommandInterface)controllerCoreCommand);
        this.linearMomentumRateControlModule.setInputFromControllerCore(this.controllerCore.getControllerCoreOutput());
        this.linearMomentumRateControlModule.computeAchievedCMP();
        this.fullRobotModel.getRootJoint().setJointAcceleration(0, (DMatrix)this.controllerCore.getOutputForRootJoint().getDesiredAcceleration());
        JointDesiredOutputListReadOnly jointDesiredOutputList = this.controllerCore.getOutputForLowLevelController();
        for (OneDoFJointBasics joint : this.controllerToolbox.getControlledOneDoFJoints()) {
            JointDesiredOutputReadOnly jointDesiredOutput = jointDesiredOutputList.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            joint.setQdd(jointDesiredOutput.getDesiredAcceleration());
            joint.setTau(jointDesiredOutput.getDesiredTorque());
        }
        this.integrator.setIntegrationDT(this.kinematicsSimulationParameters.getDt());
        this.integrator.doubleIntegrateFromAcceleration(Arrays.asList(this.controllerToolbox.getControlledJoints()));
        JointBasics hokuyoJoint = this.fullRobotModel.getLidarJoint("head_hokuyo_sensor");
        if (hokuyoJoint instanceof RevoluteJoint) {
            RevoluteJoint revoluteHokuyoJoint = (RevoluteJoint)hokuyoJoint;
            revoluteHokuyoJoint.setQ(revoluteHokuyoJoint.getQ() + 2.5 * this.kinematicsSimulationParameters.getUpdatePeriod());
        }
        if (this.simulatedHandKinematicController != null) {
            this.simulatedHandKinematicController.doControl();
        }
        this.yoVariableServerTime += Conversions.millisecondsToSeconds((double)1.0);
        if (this.kinematicsSimulationParameters.getLogToFile()) {
            this.intraprocessYoVariableLogger.update(Conversions.secondsToNanoseconds((double)this.yoVariableServerTime));
        }
        if (this.kinematicsSimulationParameters.getCreateYoVariableServer()) {
            this.yoVariableServer.update(Conversions.secondsToNanoseconds((double)this.yoVariableServerTime));
        }
    }

    private void zeroMotion() {
        for (JointBasics joint : this.fullRobotModel.getElevator().childrenSubtreeIterable()) {
            joint.setJointAccelerationToZero();
            joint.setJointTwistToZero();
        }
    }

    private void processFootstepStatus(FootstepStatusMessage statusMessage) {
        RobotSide side = RobotSide.fromByte((byte)statusMessage.getRobotSide());
        FootstepStatus status = FootstepStatus.fromByte((byte)statusMessage.getFootstepStatus());
        FramePose3D desiredFootstep = new FramePose3D(worldFrame, (Tuple3DReadOnly)statusMessage.getDesiredFootPositionInWorld(), (Orientation3DReadOnly)statusMessage.getDesiredFootOrientationInWorld());
        switch (status) {
            case STARTED: {
                this.contactStateHolders.remove((Object)side);
                ((SettableFootSwitch)this.footSwitches.get((Enum)side)).setFootContactState(false);
                break;
            }
            case COMPLETED: {
                this.contactStateHolders.put((Enum)side, (Object)new HumanoidKinematicsSimulationContactStateHolder((PlaneContactState)this.controllerToolbox.getFootContactStates().get((Enum)side), (FramePose3DReadOnly)desiredFootstep));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected status: " + status);
            }
        }
    }

    private void processWalkingStatus(WalkingStatusMessage status) {
        this.latestWalkingStatus.set(WalkingStatus.fromByte((byte)status.getWalkingStatus()));
    }

    public void destroy() {
        LogTools.info((String)"Shutting down...");
        if (this.simulatedHandKinematicController != null) {
            this.simulatedHandKinematicController.cleanup();
        }
        this.controlThread.destroy();
        this.heartbeat.destroy();
        this.ros2Node.destroy();
        this.realtimeROS2Node.destroy();
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
        }
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public JointDesiredOutputListReadOnly getJointDesiredOutputList() {
        return this.jointDesiredOutputList;
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }
}

