/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingControllerFailureStatusMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import perception_msgs.msg.dds.REAStateRequestMessage;
import us.ihmc.avatar.joystickBasedJavaFXController.ButtonState;
import us.ihmc.avatar.joystickBasedJavaFXController.ContinuousStepController;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotKickMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotPunchMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.StepGeneratorJavaFXTopics;
import us.ihmc.avatar.joystickBasedJavaFXController.XBoxOneJavaFXController;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.javaFXToolkit.graphics.JavaFXMeshDataInterpreter;
import us.ihmc.javafx.JavaFXRobotVisualizer;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;

public class StepGeneratorJavaFXController {
    private final long footstepPublishingPeriod = TimeUnit.MILLISECONDS.toNanos(100L);
    private final AtomicBoolean publishFootstepRequest = new AtomicBoolean(true);
    private final SideDependentList<Color> footColors = new SideDependentList((Object)Color.CRIMSON, (Object)Color.YELLOWGREEN);
    private final ContinuousStepController continuousStepController;
    private final AnimationTimer animationTimer = new AnimationTimer(){

        public void handle(long now) {
            StepGeneratorJavaFXController.this.update(now);
        }
    };
    private final AtomicReference<List<Node>> footstepsToVisualizeReference = new AtomicReference<Object>(null);
    private final Group rootNode = new Group();
    private final AtomicReference<FootstepDataListMessage> footstepsToSendReference = new AtomicReference<Object>(null);
    private final AtomicReference<Double> trajectoryDuration;
    private final AtomicReference<Boolean> stepsAreAdjustable;
    private final JavaFXRobotVisualizer javaFXRobotVisualizer;
    private SecondaryControlOption activeSecondaryControlOption = SecondaryControlOption.KICK;
    private final HumanoidRobotKickMessenger kickMessenger;
    private final HumanoidRobotPunchMessenger punchMessenger;
    private final IHMCROS2Publisher<FootstepDataListMessage> footstepPublisher;
    private final IHMCROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;
    private final IHMCROS2Publisher<REAStateRequestMessage> reaStateRequestPublisher;
    private final SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons;
    private final ConcurrentLinkedQueue<Runnable> queuedTasksToProcess = new ConcurrentLinkedQueue();
    private YoVariableServer yoVariableServer = null;
    private final double yoVariableServerDT = 0.016666666666666666;
    private long lastFootstepPublishTime = -1L;
    private long lastYoVariableServerUpdateTime = -1L;
    private long yoVariableServerStartTime = -1L;

    public StepGeneratorJavaFXController(String robotName, JavaFXMessager messager, WalkingControllerParameters walkingControllerParameters, ROS2NodeInterface ros2Node, JavaFXRobotVisualizer javaFXRobotVisualizer, HumanoidRobotKickMessenger kickMessenger, HumanoidRobotPunchMessenger punchMessenger, RobotLowLevelMessenger lowLevelMessenger, SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons) {
        this.javaFXRobotVisualizer = javaFXRobotVisualizer;
        this.kickMessenger = kickMessenger;
        this.punchMessenger = punchMessenger;
        this.footPolygons = footPolygons;
        this.continuousStepController = new ContinuousStepController(walkingControllerParameters);
        messager.addTopicListener(StepGeneratorJavaFXTopics.SteppingParameters, this.continuousStepController::setJoystickStepParameters);
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ROS2Topic controllerInputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> this.continuousStepController.updateControllerMotionStatus(RobotMotionStatus.fromByte((byte)((RobotConfigurationData)s.takeNextData()).getRobotMotionStatus())));
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, FootstepStatusMessage.class, (ROS2Topic)controllerOutputTopic, s -> this.queuedTasksToProcess.add(() -> this.continuousStepController.consumeFootstepStatus((FootstepStatusMessage)s.takeNextData())));
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.outputTopic, s -> this.queuedTasksToProcess.add(() -> this.continuousStepController.consumePlanarRegionsListMessage((PlanarRegionsListMessage)s.takeNextData())));
        this.pauseWalkingPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PauseWalkingMessage.class, (ROS2Topic)controllerInputTopic);
        this.footstepPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, FootstepDataListMessage.class, (ROS2Topic)controllerInputTopic);
        this.reaStateRequestPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, REAStateRequestMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic);
        this.continuousStepController.setFootstepMessenger(this::prepareFootsteps);
        this.continuousStepController.setPauseWalkingPublisher(this::sendPauseWalkingMessage);
        this.continuousStepController.setFootPoseProviders(robotSide -> {
            if (javaFXRobotVisualizer.isRobotConfigurationInitialized()) {
                return new FramePose3D((ReferenceFrame)javaFXRobotVisualizer.getFullRobotModel().getSoleFrame((Enum)robotSide));
            }
            return null;
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerOutputTopic, s -> {
            CapturabilityBasedStatus status = (CapturabilityBasedStatus)s.takeNextData();
            if (status == null) {
                return;
            }
            this.queuedTasksToProcess.add(() -> this.continuousStepController.setContactState(!status.getLeftFootSupportPolygon3d().isEmpty(), !status.getRightFootSupportPolygon3d().isEmpty()));
        });
        this.trajectoryDuration = messager.createInput(StepGeneratorJavaFXTopics.WalkingTrajectoryDuration, (Object)1.0);
        this.stepsAreAdjustable = messager.createInput(StepGeneratorJavaFXTopics.StepsAreAdjustable, (Object)false);
        this.setupKickAction(messager);
        this.setupPunchAction(messager);
        messager.addTopicListener(XBoxOneJavaFXController.ButtonLeftBumperState, state -> {
            if (state == ButtonState.PRESSED) {
                this.sendArmHomeConfiguration(RobotSide.values);
            }
        });
        messager.addTopicListener(XBoxOneJavaFXController.ButtonRightBumperState, state -> {
            if (state == ButtonState.PRESSED) {
                this.continuousStepController.submitWalkingRequest(true);
            } else if (state == ButtonState.RELEASED) {
                this.continuousStepController.submitWalkingRequest(false);
            }
        });
        messager.addFXTopicListener(XBoxOneJavaFXController.LeftStickYAxis, this.continuousStepController::updateForwardVelocity);
        messager.addFXTopicListener(XBoxOneJavaFXController.LeftStickXAxis, this.continuousStepController::updateLateralVelocity);
        messager.addFXTopicListener(XBoxOneJavaFXController.RightStickXAxis, this.continuousStepController::updateTurningVelocity);
        messager.addTopicListener(XBoxOneJavaFXController.DPadLeftState, state -> this.sendREAResumeRequest());
        messager.addTopicListener(XBoxOneJavaFXController.DPadDownState, state -> this.sendREAClearRequest());
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, WalkingControllerFailureStatusMessage.class, (ROS2Topic)controllerOutputTopic, s -> this.continuousStepController.submitWalkingRequest(false));
        messager.addTopicListener(XBoxOneJavaFXController.ButtonSelectState, state -> this.continuousStepController.submitWalkingRequest(false));
        messager.addTopicListener(XBoxOneJavaFXController.ButtonSelectState, state -> lowLevelMessenger.sendFreezeRequest());
        messager.addTopicListener(XBoxOneJavaFXController.ButtonStartState, state -> this.continuousStepController.submitWalkingRequest(false));
        messager.addTopicListener(XBoxOneJavaFXController.ButtonStartState, state -> lowLevelMessenger.sendStandRequest());
    }

    public void createYoVariableServer(DataServerSettings settings, LogModelProvider modelProvider) {
        if (this.yoVariableServer != null) {
            return;
        }
        String name = this.continuousStepController.getClass().getSimpleName();
        LogTools.info((String)"{}: Trying to start YoVariableServer using port: {}.", (Object)name, (Object)settings.getPort());
        this.yoVariableServer = new YoVariableServer(this.getClass(), modelProvider, settings, 0.016666666666666666);
        YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
        this.continuousStepController.setupVisualization(yoGraphicsListRegistry);
        this.yoVariableServer.setMainRegistry(this.continuousStepController.getRegistry(), this.javaFXRobotVisualizer.getFullRobotModel().getElevator(), yoGraphicsListRegistry);
        this.yoVariableServer.start();
    }

    public void update(long now) {
        try {
            while (!this.queuedTasksToProcess.isEmpty()) {
                this.queuedTasksToProcess.poll().run();
            }
            this.continuousStepController.update();
            List footstepsToVisualize = this.footstepsToVisualizeReference.getAndSet(null);
            ObservableList children = this.rootNode.getChildren();
            if (!this.continuousStepController.isWalking()) {
                children.clear();
            } else if (footstepsToVisualize != null) {
                children.clear();
                children.addAll((Collection)footstepsToVisualize);
            }
            if (this.yoVariableServer != null && (this.lastYoVariableServerUpdateTime == -1L || Conversions.nanosecondsToSeconds((long)(now - this.lastYoVariableServerUpdateTime)) >= 0.016666666666666666)) {
                if (this.yoVariableServerStartTime == -1L) {
                    this.yoVariableServerStartTime = now;
                }
                this.yoVariableServer.update(now - this.yoVariableServerStartTime);
                this.lastYoVariableServerUpdateTime = now;
            }
            if (this.lastFootstepPublishTime == -1L || now - this.lastFootstepPublishTime >= this.footstepPublishingPeriod) {
                this.publishFootstepRequest.set(true);
            }
            if (this.publishFootstepRequest.getAndSet(false)) {
                this.lastFootstepPublishTime = now;
                this.sendFootsteps();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LogTools.error((String)"Caught exception, stopping animation timer.");
            this.stop();
        }
    }

    public void setActiveSecondaryControlOption(SecondaryControlOption activeSecondaryControlOption) {
        this.activeSecondaryControlOption = activeSecondaryControlOption;
    }

    private void setupPunchAction(JavaFXMessager messager) {
        messager.addTopicListener(XBoxOneJavaFXController.ButtonXState, state -> this.processPunch(RobotSide.LEFT, (ButtonState)((Object)state)));
        messager.addTopicListener(XBoxOneJavaFXController.ButtonYState, state -> this.processPunch(RobotSide.RIGHT, (ButtonState)((Object)state)));
    }

    private void setupKickAction(JavaFXMessager messager) {
        messager.addTopicListener(XBoxOneJavaFXController.ButtonXState, state -> this.processToggleFlamingoMode(RobotSide.LEFT, (ButtonState)((Object)state)));
        messager.addTopicListener(XBoxOneJavaFXController.ButtonBState, state -> this.processToggleFlamingoMode(RobotSide.RIGHT, (ButtonState)((Object)state)));
        messager.addTopicListener(XBoxOneJavaFXController.ButtonYState, state -> this.processKick((ButtonState)((Object)state)));
    }

    private void prepareFootsteps(FootstepDataListMessage footstepDataListMessage) {
        ArrayList<Node> footstepNode = new ArrayList<Node>();
        for (int i = 0; i < footstepDataListMessage.getFootstepDataList().size(); ++i) {
            FootstepDataMessage footstepDataMessage = (FootstepDataMessage)footstepDataListMessage.getFootstepDataList().get(i);
            footstepDataMessage.setSwingHeight(this.continuousStepController.getJoystickStepParameters().getSwingHeight());
            footstepNode.add(this.createFootstep(footstepDataMessage));
        }
        this.footstepsToVisualizeReference.set(footstepNode);
        FootstepDataListMessage messageCopy = new FootstepDataListMessage(footstepDataListMessage);
        messageCopy.setAreFootstepsAdjustable(this.stepsAreAdjustable.get().booleanValue());
        this.footstepsToSendReference.set(messageCopy);
    }

    private void sendPauseWalkingMessage() {
        this.pauseWalkingPublisher.publish((Object)HumanoidMessageTools.createPauseWalkingMessage((boolean)true));
    }

    private void sendFootsteps() {
        FootstepDataListMessage footstepsToSend = this.footstepsToSendReference.getAndSet(null);
        if (footstepsToSend != null && this.continuousStepController.isWalking()) {
            this.footstepPublisher.publish((Object)footstepsToSend);
        }
    }

    private void sendREAClearRequest() {
        REAStateRequestMessage clearRequest = new REAStateRequestMessage();
        clearRequest.setRequestClear(true);
        this.reaStateRequestPublisher.publish((Object)clearRequest);
    }

    private void sendREAResumeRequest() {
        REAStateRequestMessage resumeRequest = new REAStateRequestMessage();
        resumeRequest.setRequestResume(true);
        this.reaStateRequestPublisher.publish((Object)resumeRequest);
    }

    private Node createFootstep(FootstepDataMessage footstepDataMessage) {
        RobotSide footSide = RobotSide.fromByte((byte)footstepDataMessage.getRobotSide());
        return this.createFootstep((Point3DReadOnly)footstepDataMessage.getLocation(), (QuaternionReadOnly)footstepDataMessage.getOrientation(), (Color)this.footColors.get((Enum)footSide), (ConvexPolygon2DReadOnly)this.footPolygons.get((Enum)footSide));
    }

    private Node createFootstep(Point3DReadOnly position, QuaternionReadOnly orientation, Color footColor, ConvexPolygon2DReadOnly footPolygon) {
        MeshDataHolder polygon = MeshDataGenerator.ExtrudedPolygon((ConvexPolygon2DReadOnly)footPolygon, (double)0.025);
        polygon = MeshDataHolder.rotate((MeshDataHolder)polygon, (Orientation3DReadOnly)orientation);
        polygon = MeshDataHolder.translate((MeshDataHolder)polygon, (Tuple3DReadOnly)position);
        TriangleMesh mesh = JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)polygon, (boolean)true);
        MeshView meshView = new MeshView((Mesh)mesh);
        meshView.setMaterial((Material)new PhongMaterial(footColor));
        return meshView;
    }

    private void processToggleFlamingoMode(RobotSide robotSide, ButtonState state) {
        if (this.activeSecondaryControlOption != SecondaryControlOption.KICK) {
            return;
        }
        if (state != ButtonState.PRESSED) {
            return;
        }
        if (this.continuousStepController.isInDoubleSupport()) {
            this.flamingoHomeStance(robotSide);
        } else if (!this.continuousStepController.isFootInSupport(robotSide)) {
            this.putFootDown(robotSide);
        }
    }

    private void processKick(ButtonState state) {
        RobotSide kickSide;
        if (this.activeSecondaryControlOption != SecondaryControlOption.KICK) {
            return;
        }
        if (this.continuousStepController.isInDoubleSupport()) {
            return;
        }
        RobotSide robotSide = kickSide = this.continuousStepController.isFootInSupport(RobotSide.RIGHT) ? RobotSide.LEFT : RobotSide.RIGHT;
        if (state == ButtonState.PRESSED) {
            this.kick(kickSide);
        } else if (state == ButtonState.RELEASED) {
            this.flamingoHomeStance(kickSide);
        }
    }

    private void processPunch(RobotSide robotSide, ButtonState state) {
        if (this.activeSecondaryControlOption != SecondaryControlOption.PUNCH) {
            return;
        }
        if (state == ButtonState.PRESSED) {
            this.sendArmStraightConfiguration(robotSide);
        } else {
            this.sendArmHomeConfiguration(robotSide);
        }
    }

    private void sendArmHomeConfiguration(RobotSide ... robotSides) {
        this.punchMessenger.sendArmHomeConfiguration(this.trajectoryDuration.get(), robotSides);
    }

    private void sendArmStraightConfiguration(RobotSide robotSide) {
        this.punchMessenger.sendArmStraightConfiguration(this.trajectoryDuration.get(), robotSide);
    }

    private void flamingoHomeStance(RobotSide robotSide) {
        this.kickMessenger.sendFlamingoHomeStance(robotSide, this.trajectoryDuration.get(), this.continuousStepController.getJoystickStepParameters().getDefaultStepWidth(), (SegmentDependentList<RobotSide, ? extends ReferenceFrame>)this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrames());
    }

    private void putFootDown(RobotSide robotSide) {
        if (this.continuousStepController.isFootInSupport(robotSide)) {
            return;
        }
        this.kickMessenger.sendPutFootDown(robotSide, this.trajectoryDuration.get(), this.continuousStepController.getJoystickStepParameters().getDefaultStepWidth(), (SegmentDependentList<RobotSide, ? extends ReferenceFrame>)this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrames());
    }

    private void kick(RobotSide robotSide) {
        if (this.continuousStepController.isFootInSupport(robotSide)) {
            return;
        }
        this.kickMessenger.sendKick(robotSide, this.trajectoryDuration.get(), this.continuousStepController.getJoystickStepParameters().getDefaultStepWidth(), (SegmentDependentList<RobotSide, ? extends ReferenceFrame>)this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrames());
    }

    public void start() {
        this.animationTimer.start();
    }

    public void stop() {
        this.animationTimer.stop();
        this.sendPauseWalkingMessage();
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
            this.yoVariableServer = null;
        }
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public static enum SecondaryControlOption {
        KICK,
        PUNCH,
        NONE;

    }
}

