/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import java.util.Map;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;

public class ListViewTools {
    public static <T> Callback<ListView<T>, ListCell<T>> cellFactoryForDragAndDropReorder(final Function<T, String> textExtractor) {
        return ListViewTools.cellFactoryForDragAndDropReorder(listView -> {
            ListCell cell = new ListCell<T>(){

                public void updateItem(T item, boolean empty) {
                    super.updateItem(item, empty);
                    this.setText((String)textExtractor.apply(item));
                }
            };
            return cell;
        }, textExtractor);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> cellFactoryForDragAndDropReorder(Callback<ListView<T>, ListCell<T>> cellFactory, Function<T, String> textExtractor) {
        SimpleObjectProperty dragSource = new SimpleObjectProperty();
        return arg_0 -> ListViewTools.lambda$cellFactoryForDragAndDropReorder$6(cellFactory, textExtractor, (ObjectProperty)dragSource, arg_0);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> cellFactoryForMouseRightClickContextMenu(Callback<ListView<T>, ListCell<T>> cellFactory, MenuItem ... contextMenuItems) {
        return listView -> {
            ListCell cell = (ListCell)cellFactory.call(listView);
            cell.setOnMousePressed(event -> {
                if (event.getButton() == MouseButton.SECONDARY) {
                    cell.setContextMenu(new ContextMenu(contextMenuItems));
                }
            });
            return cell;
        };
    }

    private static /* synthetic */ ListCell lambda$cellFactoryForDragAndDropReorder$6(Callback cellFactory, Function textExtractor, ObjectProperty dragSource, ListView listView) {
        ListCell cell = (ListCell)cellFactory.call((Object)listView);
        cell.setOnDragDetected(event -> {
            if (cell.getItem() == null || cell.isEmpty()) {
                return;
            }
            Dragboard dragboard = cell.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString((String)textExtractor.apply(cell.getItem()));
            dragboard.setContent((Map)clipboardContent);
            dragSource.set((Object)cell);
            event.consume();
        });
        cell.setOnDragEntered(event -> {
            if (event.getGestureSource() != cell && event.getDragboard().hasString()) {
                cell.setOpacity(0.3);
            }
        });
        cell.setOnDragExited(event -> {
            if (event.getGestureSource() != cell && event.getDragboard().hasString()) {
                cell.setOpacity(1.0);
            }
        });
        cell.setOnDragOver(event -> {
            if (event.getGestureSource() != cell && event.getDragboard().hasString()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
        });
        cell.setOnDragDone(Event::consume);
        cell.setOnDragDropped(event -> {
            if (cell.getItem() == null) {
                return;
            }
            if (event.getDragboard().hasString() && dragSource.get() != null) {
                ObservableList items = listView.getItems();
                int cellIndex = items.indexOf(cell.getItem());
                Object draggedItem = ((ListCell)dragSource.get()).getItem();
                items.remove(draggedItem);
                items.add(cellIndex, draggedItem);
                listView.getSelectionModel().select(draggedItem);
                event.setDropCompleted(true);
                dragSource.set(null);
            } else {
                event.setDropCompleted(false);
            }
        });
        return cell;
    }
}

