/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.Property;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.robotEnvironmentAwareness.ui.properties.ParametersProperty;

public class JoystickStepParametersProperty
extends ParametersProperty<JoystickStepParameters> {
    private final ParametersProperty.IntegerField numberOfFixedFootsteps = new ParametersProperty.IntegerField((ParametersProperty)this, JoystickStepParameters::getNumberOfFixedFootsteps, JoystickStepParameters::setNumberOfFixedFootsteps);
    private final ParametersProperty.DoubleField swingHeight = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getSwingHeight, JoystickStepParameters::setSwingHeight);
    private final ParametersProperty.DoubleField swingDuration = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getSwingDuration, JoystickStepParameters::setSwingDuration);
    private final ParametersProperty.DoubleField transferDuration = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getTransferDuration, JoystickStepParameters::setTransferDuration);
    private final ParametersProperty.DoubleField maxStepLength = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getMaxStepLength, JoystickStepParameters::setMaxStepLength);
    private final ParametersProperty.DoubleField defaultStepWidth = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getDefaultStepWidth, JoystickStepParameters::setDefaultStepWidth);
    private final ParametersProperty.DoubleField minStepWidth = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getMinStepWidth, JoystickStepParameters::setMinStepWidth);
    private final ParametersProperty.DoubleField maxStepWidth = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getMaxStepWidth, JoystickStepParameters::setMaxStepWidth);
    private final ParametersProperty.DoubleField turnMaxAngleInward = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getTurnMaxAngleInward, JoystickStepParameters::setTurnMaxAngleInward);
    private final ParametersProperty.DoubleField turnMaxAngleOutward = new ParametersProperty.DoubleField((ParametersProperty)this, JoystickStepParameters::getTurnMaxAngleOutward, JoystickStepParameters::setTurnMaxAngleOutward);

    public JoystickStepParametersProperty(Object bean, String name) {
        super(bean, name, (Object)new JoystickStepParameters());
    }

    public void bindBidirectionalNumberOfFixedFootsteps(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.numberOfFixedFootsteps);
    }

    public void bindBidirectionalSwingHeight(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.swingHeight);
    }

    public void bindBidirectionalSwingDuration(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.swingDuration);
    }

    public void bindBidirectionalTransferDuration(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.transferDuration);
    }

    public void bindBidirectionalMaxStepLength(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.maxStepLength);
    }

    public void bindBidirectionalDefaultStepWidth(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.defaultStepWidth);
    }

    public void bindBidirectionalMinStepWidth(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.minStepWidth);
    }

    public void bindBidirectionalMaxStepWidth(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.maxStepWidth);
    }

    public void bindBidirectionalTurnMaxAngleInward(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.turnMaxAngleInward);
    }

    public void bindBidirectionalTurnMaxAngleOutward(Property<? extends Number> property) {
        this.bindFieldBidirectionalToNumberProperty(property, (ParametersProperty.Field)this.turnMaxAngleOutward);
    }

    public JoystickStepParameters getValue() {
        return (JoystickStepParameters)super.getValue();
    }

    protected JoystickStepParameters getValueCopy(JoystickStepParameters valueToCopy) {
        return new JoystickStepParameters(valueToCopy);
    }

    public static class JoystickStepParameters
    implements Settable<JoystickStepParameters> {
        private int numberOfFixedFootsteps = 0;
        private double swingHeight;
        private double swingDuration;
        private double transferDuration;
        private double maxStepLength;
        private double defaultStepWidth;
        private double minStepWidth;
        private double maxStepWidth;
        private double turnMaxAngleInward;
        private double turnMaxAngleOutward;

        public JoystickStepParameters() {
        }

        public JoystickStepParameters(WalkingControllerParameters walkingControllerParameters) {
            this.set(walkingControllerParameters);
        }

        public JoystickStepParameters(JoystickStepParameters other) {
            this.set(other);
        }

        public void set(WalkingControllerParameters walkingControllerParameters) {
            this.numberOfFixedFootsteps = 0;
            this.swingDuration = walkingControllerParameters.getDefaultSwingTime();
            this.transferDuration = walkingControllerParameters.getDefaultTransferTime();
            SteppingParameters steppingParameters = walkingControllerParameters.getSteppingParameters();
            this.swingHeight = walkingControllerParameters.getSwingTrajectoryParameters().getMinSwingHeight();
            this.maxStepLength = steppingParameters.getMaxStepLength();
            this.defaultStepWidth = steppingParameters.getInPlaceWidth();
            this.minStepWidth = steppingParameters.getMinStepWidth();
            this.maxStepWidth = steppingParameters.getMaxStepWidth();
            this.turnMaxAngleInward = steppingParameters.getMaxAngleTurnInwards();
            this.turnMaxAngleOutward = steppingParameters.getMaxAngleTurnOutwards();
        }

        public void set(JoystickStepParameters other) {
            this.numberOfFixedFootsteps = other.numberOfFixedFootsteps;
            this.swingHeight = other.swingHeight;
            this.swingDuration = other.swingDuration;
            this.transferDuration = other.transferDuration;
            this.maxStepLength = other.maxStepLength;
            this.defaultStepWidth = other.defaultStepWidth;
            this.minStepWidth = other.minStepWidth;
            this.maxStepWidth = other.maxStepWidth;
            this.turnMaxAngleInward = other.turnMaxAngleInward;
            this.turnMaxAngleOutward = other.turnMaxAngleOutward;
        }

        public void setNumberOfFixedFootsteps(int numberOfFixedFootsteps) {
            this.numberOfFixedFootsteps = numberOfFixedFootsteps;
        }

        public void setSwingHeight(double swingHeight) {
            this.swingHeight = swingHeight;
        }

        public void setSwingDuration(double swingDuration) {
            this.swingDuration = swingDuration;
        }

        public void setTransferDuration(double transferDuration) {
            this.transferDuration = transferDuration;
        }

        public void setMaxStepLength(double maxStepLength) {
            this.maxStepLength = maxStepLength;
        }

        public void setDefaultStepWidth(double defaultStepWidth) {
            this.defaultStepWidth = defaultStepWidth;
        }

        public void setMinStepWidth(double minStepWidth) {
            this.minStepWidth = minStepWidth;
        }

        public void setMaxStepWidth(double maxStepWidth) {
            this.maxStepWidth = maxStepWidth;
        }

        public void setTurnMaxAngleInward(double turnMaxAngleInward) {
            this.turnMaxAngleInward = turnMaxAngleInward;
        }

        public void setTurnMaxAngleOutward(double turnMaxAngleOutward) {
            this.turnMaxAngleOutward = turnMaxAngleOutward;
        }

        public int getNumberOfFixedFootsteps() {
            return this.numberOfFixedFootsteps;
        }

        public double getSwingHeight() {
            return this.swingHeight;
        }

        public double getSwingDuration() {
            return this.swingDuration;
        }

        public double getTransferDuration() {
            return this.transferDuration;
        }

        public double getMaxStepLength() {
            return this.maxStepLength;
        }

        public double getDefaultStepWidth() {
            return this.defaultStepWidth;
        }

        public double getMinStepWidth() {
            return this.minStepWidth;
        }

        public double getMaxStepWidth() {
            return this.maxStepWidth;
        }

        public double getTurnMaxAngleInward() {
            return this.turnMaxAngleInward;
        }

        public double getTurnMaxAngleOutward() {
            return this.turnMaxAngleOutward;
        }

        public static JoystickStepParameters parseFromPropertyMap(Map<String, String> properties, JoystickStepParameters defaultParameters) {
            JoystickStepParameters parsed = new JoystickStepParameters();
            parsed.setNumberOfFixedFootsteps(JoystickStepParameters.extractIntegerProperty(properties, "NumberOfFixedFootsteps", defaultParameters.getNumberOfFixedFootsteps()));
            parsed.setSwingHeight(JoystickStepParameters.extractDoubleProperty(properties, "SwingHeight", defaultParameters.getSwingHeight()));
            parsed.setSwingDuration(JoystickStepParameters.extractDoubleProperty(properties, "SwingDuration", defaultParameters.getSwingDuration()));
            parsed.setTransferDuration(JoystickStepParameters.extractDoubleProperty(properties, "TransferDuration", defaultParameters.getTransferDuration()));
            parsed.setMaxStepLength(JoystickStepParameters.extractDoubleProperty(properties, "MaxStepLength", defaultParameters.getMaxStepLength()));
            parsed.setDefaultStepWidth(JoystickStepParameters.extractDoubleProperty(properties, "DefaultStepWidth", defaultParameters.getDefaultStepWidth()));
            parsed.setMinStepWidth(JoystickStepParameters.extractDoubleProperty(properties, "MinStepWidth", defaultParameters.getMinStepWidth()));
            parsed.setMaxStepWidth(JoystickStepParameters.extractDoubleProperty(properties, "MaxStepWidth", defaultParameters.getMaxStepWidth()));
            parsed.setTurnMaxAngleInward(JoystickStepParameters.extractDoubleProperty(properties, "TurnMaxAngleInward", defaultParameters.getTurnMaxAngleInward()));
            parsed.setTurnMaxAngleOutward(JoystickStepParameters.extractDoubleProperty(properties, "TurnMaxAngleOutward", defaultParameters.getTurnMaxAngleOutward()));
            return parsed;
        }

        private static int extractIntegerProperty(Map<String, String> properties, String propertyName, int defaultValue) {
            return Integer.parseInt(properties.getOrDefault(propertyName, Integer.toString(defaultValue)));
        }

        private static double extractDoubleProperty(Map<String, String> properties, String propertyName, double defaultValue) {
            return Double.parseDouble(properties.getOrDefault(propertyName, Double.toString(defaultValue)));
        }

        public static Map<String, String> exportToPropertyMap(JoystickStepParameters parametersToExport) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("NumberOfFixedFootsteps", Integer.toString(parametersToExport.getNumberOfFixedFootsteps()));
            properties.put("SwingHeight", Double.toString(parametersToExport.getSwingHeight()));
            properties.put("SwingDuration", Double.toString(parametersToExport.getSwingDuration()));
            properties.put("TransferDuration", Double.toString(parametersToExport.getTransferDuration()));
            properties.put("MaxStepLength", Double.toString(parametersToExport.getMaxStepLength()));
            properties.put("DefaultStepWidth", Double.toString(parametersToExport.getDefaultStepWidth()));
            properties.put("MinStepWidth", Double.toString(parametersToExport.getMinStepWidth()));
            properties.put("MaxStepWidth", Double.toString(parametersToExport.getMaxStepWidth()));
            properties.put("TurnMaxAngleInward", Double.toString(parametersToExport.getTurnMaxAngleInward()));
            properties.put("TurnMaxAngleOutward", Double.toString(parametersToExport.getTurnMaxAngleOutward()));
            return properties;
        }

        public String toString() {
            return "number of fixed footsteps: " + this.numberOfFixedFootsteps + ", swing height: " + this.swingHeight + ", swing duration: " + this.swingDuration + ", transfer duration: " + this.transferDuration + ", max step length: " + this.maxStepLength + ", default step width: " + this.defaultStepWidth + ", min step width: " + this.minStepWidth + ", max step width: " + this.maxStepWidth + ", turn max angle inward: " + this.turnMaxAngleInward + ", turn max angle outward: " + this.turnMaxAngleOutward;
        }
    }
}

