/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.jointAnglesWriter;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;

public class JointAnglesWriter {
    private final ArrayList<ImmutablePair<OneDegreeOfFreedomJoint, OneDoFJointBasics>> oneDoFJointPairList = new ArrayList();
    private final ImmutablePair<FloatingJoint, FloatingJointBasics> rootJointPair;
    private boolean writeJointVelocities = true;
    private boolean writeJointAccelerations = true;
    private final FrameVector3D linearVelocity = new FrameVector3D();
    private final FrameVector3D linearAcceleration = new FrameVector3D();

    public JointAnglesWriter(Robot robot, FullRobotModel fullRobotModel) {
        this(robot, fullRobotModel.getRootJoint(), fullRobotModel.getOneDoFJoints());
    }

    public JointAnglesWriter(Robot robot, FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints) {
        this.oneDoFJointPairList.clear();
        HashMap scsJointMap = new HashMap();
        ArrayList<OneDegreeOfFreedomJoint> scsOnDoFJointList = new ArrayList<OneDegreeOfFreedomJoint>();
        robot.getAllOneDegreeOfFreedomJoints(scsOnDoFJointList);
        scsOnDoFJointList.forEach(joint -> scsJointMap.put(joint.getName(), joint));
        for (OneDoFJointBasics joint2 : oneDoFJoints) {
            String name = joint2.getName();
            OneDegreeOfFreedomJoint oneDoFJoint = (OneDegreeOfFreedomJoint)scsJointMap.get(name);
            if (oneDoFJoint == null) {
                throw new RuntimeException("Could not find the SCS joint with the name: " + name);
            }
            ImmutablePair jointPair = new ImmutablePair((Object)oneDoFJoint, (Object)joint2);
            this.oneDoFJointPairList.add((ImmutablePair<OneDegreeOfFreedomJoint, OneDoFJointBasics>)jointPair);
        }
        FloatingJoint scsRootJoint = robot.getRootJoints().get(0) instanceof FloatingJoint ? (FloatingJoint)robot.getRootJoints().get(0) : null;
        if (scsRootJoint == null && rootJoint != null) {
            throw new RuntimeException("A " + FloatingJointBasics.class.getSimpleName() + " was provided but there is no " + FloatingJoint.class.getSimpleName());
        }
        if (rootJoint == null && scsRootJoint != null) {
            throw new RuntimeException("A " + FloatingJoint.class.getSimpleName() + " was provided but there is no " + FloatingJointBasics.class.getSimpleName());
        }
        this.rootJointPair = rootJoint != null ? new ImmutablePair((Object)scsRootJoint, (Object)rootJoint) : null;
    }

    public void setWriteJointVelocities(boolean writeJointVelocities) {
        this.writeJointVelocities = writeJointVelocities;
    }

    public void setWriteJointAccelerations(boolean writeJointAccelerations) {
        this.writeJointAccelerations = writeJointAccelerations;
    }

    public void updateRobotConfigurationBasedOnFullRobotModel() {
        for (ImmutablePair<OneDegreeOfFreedomJoint, OneDoFJointBasics> jointPair : this.oneDoFJointPairList) {
            OneDegreeOfFreedomJoint pinJoint = (OneDegreeOfFreedomJoint)jointPair.getLeft();
            OneDoFJointBasics revoluteJoint = (OneDoFJointBasics)jointPair.getRight();
            pinJoint.setQ(revoluteJoint.getQ());
            if (this.writeJointVelocities) {
                pinJoint.setQd(revoluteJoint.getQd());
            }
            if (!this.writeJointAccelerations) continue;
            pinJoint.setQdd(revoluteJoint.getQdd());
        }
        if (this.rootJointPair != null) {
            FixedFrameTwistBasics jointTwist;
            FloatingJoint floatingJoint = (FloatingJoint)this.rootJointPair.getLeft();
            FloatingJointBasics sixDoFJoint = (FloatingJointBasics)this.rootJointPair.getRight();
            RigidBodyTransform transform = new RigidBodyTransform();
            sixDoFJoint.getJointConfiguration(transform);
            floatingJoint.setRotationAndTranslation((RigidBodyTransformReadOnly)transform);
            if (this.writeJointVelocities) {
                jointTwist = sixDoFJoint.getJointTwist();
                floatingJoint.setAngularVelocityInBody((Vector3DReadOnly)jointTwist.getAngularPart());
                this.linearVelocity.setMatchingFrame((FrameTuple3DReadOnly)jointTwist.getLinearPart());
                floatingJoint.setVelocity((Tuple3DReadOnly)this.linearVelocity);
            }
            if (this.writeJointAccelerations) {
                jointTwist = sixDoFJoint.getJointTwist();
                FixedFrameSpatialAccelerationBasics jointAcceleration = sixDoFJoint.getJointAcceleration();
                floatingJoint.setAngularAccelerationInBody((Vector3DReadOnly)jointAcceleration.getAngularPart());
                jointAcceleration.getLinearAccelerationAtBodyOrigin((TwistReadOnly)jointTwist, (FrameVector3DBasics)this.linearAcceleration);
                this.linearAcceleration.changeFrame(ReferenceFrame.getWorldFrame());
                floatingJoint.setAcceleration((Tuple3DReadOnly)this.linearAcceleration);
            }
        }
    }
}

