/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.inverseKinematics;

import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsSolutionQualityCalculator;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxOptimizationSettings;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointTorqueMinimizationWeightCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointTorqueSoftLimitWeightCalculator;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.MultiBodySystemMissingTools;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultPIDSE3Gains;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ArmIKSolver {
    public static final double CONTROL_DT = 0.001;
    public static final double GRAVITY = 9.81;
    private static final int INVERSE_KINEMATICS_CALCULATIONS_PER_UPDATE = 50;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ReferenceFrame armWorldFrame = ReferenceFrame.getWorldFrame();
    private final RigidBodyBasics workChest;
    private final RigidBodyBasics workHand;
    private final KinematicsToolboxOptimizationSettings optimizationSettings = new KinematicsToolboxOptimizationSettings();
    private final InverseKinematicsOptimizationSettingsCommand activeOptimizationSettings = new InverseKinematicsOptimizationSettingsCommand();
    private final PrivilegedConfigurationCommand privilegedConfigurationCommand = new PrivilegedConfigurationCommand();
    private final WholeBodyControllerCore controllerCore;
    private final SpatialFeedbackControlCommand spatialFeedbackControlCommand = new SpatialFeedbackControlCommand();
    private final ControllerCoreCommand controllerCoreCommand = new ControllerCoreCommand();
    private final DefaultPIDSE3Gains gains = new DefaultPIDSE3Gains();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final FramePose3D handControlDesiredPose = new FramePose3D();
    private final FramePose3D lastHandControlDesiredPose = new FramePose3D();
    private final RigidBodyTransform handControlDesiredPoseToChestCoMTransform = new RigidBodyTransform();
    private final SpatialVectorReadOnly zeroVector6D = new SpatialVector(this.armWorldFrame);
    private final FramePose3D controlFramePose = new FramePose3D();
    private final OneDoFJointBasics[] sourceOneDoFJoints;
    private final OneDoFJointBasics[] workingOneDoFJoints;
    private final KinematicsSolutionQualityCalculator solutionQualityCalculator = new KinematicsSolutionQualityCalculator();
    private final FeedbackControllerDataHolderReadOnly feedbackControllerDataHolder;
    private double quality;

    public ArmIKSolver(RobotSide side, DRCRobotModel robotModel, FullHumanoidRobotModel sourceFullRobotModel) {
        RigidBodyBasics sourceChest = sourceFullRobotModel.getChest();
        OneDoFJointBasics sourceFirstArmJoint = sourceFullRobotModel.getArmJoint(side, robotModel.getJointMap().getArmJointNames()[0]);
        this.sourceOneDoFJoints = FullRobotModelUtils.getArmJoints((FullHumanoidRobotModel)sourceFullRobotModel, (RobotSide)side, (ArmJointName[])robotModel.getJointMap().getArmJointNames());
        this.workChest = MultiBodySystemMissingTools.getDetachedCopyOfSubtree((RigidBodyBasics)sourceChest, (ReferenceFrame)this.armWorldFrame, (OneDoFJointBasics)sourceFirstArmJoint);
        this.workHand = MultiBodySystemTools.findRigidBody((RigidBodyBasics)this.workChest, (String)robotModel.getJointMap().getHandName(side));
        this.workHand.getChildrenJoints().clear();
        FramePose3D sourceControlFramePose = new FramePose3D((ReferenceFrame)sourceFullRobotModel.getHandControlFrame(side));
        sourceControlFramePose.changeFrame((ReferenceFrame)sourceFullRobotModel.getHand(side).getBodyFixedFrame());
        this.controlFramePose.setIncludingFrame((ReferenceFrame)this.workHand.getBodyFixedFrame(), (Pose3DReadOnly)sourceControlFramePose);
        this.workingOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemMissingTools.getSubtreeJointArray(OneDoFJointBasics.class, (RigidBodyReadOnly)this.workChest);
        FloatingJointBasics rootSixDoFJoint = null;
        ReferenceFrame centerOfMassFrame = null;
        YoGraphicsListRegistry yoGraphicsListRegistry = null;
        WholeBodyControlCoreToolbox toolbox = new WholeBodyControlCoreToolbox(0.001, 9.81, rootSixDoFJoint, (JointBasics[])this.workingOneDoFJoints, centerOfMassFrame, (ControllerCoreOptimizationSettings)this.optimizationSettings, yoGraphicsListRegistry, this.registry);
        JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters = new JointPrivilegedConfigurationParameters();
        toolbox.setJointPrivilegedConfigurationParameters(jointPrivilegedConfigurationParameters);
        JointTorqueSoftLimitWeightCalculator jointTorqueMinimizationWeightCalculator = new JointTorqueSoftLimitWeightCalculator(toolbox.getJointIndexHandler());
        jointTorqueMinimizationWeightCalculator.setParameters(0.0, 0.001, 0.1);
        toolbox.setupForInverseKinematicsSolver((JointTorqueMinimizationWeightCalculator)jointTorqueMinimizationWeightCalculator);
        FeedbackControllerTemplate controllerCoreTemplate = new FeedbackControllerTemplate();
        controllerCoreTemplate.setAllowDynamicControllerConstruction(true);
        JointDesiredOutputList lowLevelControllerOutput = new JointDesiredOutputList((OneDoFJointReadOnly[])this.workingOneDoFJoints);
        this.controllerCore = new WholeBodyControllerCore(toolbox, controllerCoreTemplate, lowLevelControllerOutput, this.registry);
        this.feedbackControllerDataHolder = this.controllerCore.getWholeBodyFeedbackControllerDataHolder();
        this.controllerCoreCommand.setControllerCoreMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        double gain = 1200.0;
        double weight = 20.0;
        this.gains.setPositionProportionalGains(gain);
        this.gains.setOrientationProportionalGains(gain);
        this.weightMatrix.setLinearWeights(weight, weight, weight);
        this.weightMatrix.setAngularWeights(weight, weight, weight);
        this.selectionMatrix.resetSelection();
        this.privilegedConfigurationCommand.setDefaultWeight(0.025);
        this.privilegedConfigurationCommand.setDefaultConfigurationGain(50.0);
        for (OneDoFJointBasics workingOneDoFJoint : this.workingOneDoFJoints) {
            this.privilegedConfigurationCommand.addJoint(workingOneDoFJoint, workingOneDoFJoint.getName().contains("ELBOW") ? 1.04 : 0.0);
        }
    }

    public void copySourceToWork() {
        MultiBodySystemMissingTools.copyOneDoFJointsConfiguration((JointBasics[])this.sourceOneDoFJoints, (JointBasics[])this.workingOneDoFJoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ReferenceFrame chestFrame, ReferenceFrame handControlDesiredFrame) {
        FramePose3D framePose3D = this.handControlDesiredPose;
        synchronized (framePose3D) {
            this.handControlDesiredPose.setToZero(handControlDesiredFrame);
            this.handControlDesiredPose.changeFrame(chestFrame);
            this.handControlDesiredPose.get((RigidBodyTransformBasics)this.handControlDesiredPoseToChestCoMTransform);
            this.workChest.getBodyFixedFrame().getTransformToParent().transform((RigidBodyTransformBasics)this.handControlDesiredPoseToChestCoMTransform);
            this.handControlDesiredPose.setToZero(this.armWorldFrame);
            this.handControlDesiredPose.set((RigidBodyTransformReadOnly)this.handControlDesiredPoseToChestCoMTransform);
        }
    }

    public boolean getDesiredHandControlPoseChanged() {
        boolean desiredHandControlPoseChanged = !this.handControlDesiredPose.geometricallyEquals((EuclidFrameGeometry)this.lastHandControlDesiredPose, 1.0E-4);
        this.lastHandControlDesiredPose.setIncludingFrame((FramePose3DReadOnly)this.handControlDesiredPose);
        return desiredHandControlPoseChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solve() {
        this.copySourceToWork();
        this.workChest.updateFramesRecursively();
        this.spatialFeedbackControlCommand.set(this.workChest, this.workHand);
        this.spatialFeedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.gains);
        this.spatialFeedbackControlCommand.setSelectionMatrix(this.selectionMatrix);
        this.spatialFeedbackControlCommand.setWeightMatrixForSolver(this.weightMatrix);
        FramePose3D framePose3D = this.handControlDesiredPose;
        synchronized (framePose3D) {
            this.spatialFeedbackControlCommand.setInverseKinematics((FramePose3DReadOnly)this.handControlDesiredPose, this.zeroVector6D);
        }
        this.spatialFeedbackControlCommand.setControlFrameFixedInEndEffector((FramePose3DReadOnly)this.controlFramePose);
        for (int i = 0; i < 50; ++i) {
            this.controllerCoreCommand.clear();
            this.controllerCoreCommand.addInverseKinematicsCommand((InverseKinematicsCommand)this.activeOptimizationSettings);
            this.controllerCoreCommand.addInverseKinematicsCommand((InverseKinematicsCommand)this.privilegedConfigurationCommand);
            this.controllerCoreCommand.addFeedbackControlCommand((FeedbackControlCommand)this.spatialFeedbackControlCommand);
            this.controllerCore.compute((ControllerCoreCommandInterface)this.controllerCoreCommand);
            ControllerCoreOutput controllerCoreOutput = this.controllerCore.getControllerCoreOutput();
            JointDesiredOutputListBasics output = controllerCoreOutput.getLowLevelOneDoFJointDesiredDataHolder();
            boolean jointIsMoving = false;
            for (int j = 0; j < this.workingOneDoFJoints.length; ++j) {
                double integratedPosition;
                if (!output.hasDataForJoint((OneDoFJointReadOnly)this.workingOneDoFJoints[j])) continue;
                JointDesiredOutputReadOnly jointDesiredOutput = output.getJointDesiredOutput((OneDoFJointReadOnly)this.workingOneDoFJoints[j]);
                double desiredVelocity = jointDesiredOutput.getDesiredVelocity();
                if (Math.abs(desiredVelocity) > 0.001) {
                    jointIsMoving = true;
                }
                if (AngleTools.computeAngleDifferenceMinusPiToPi((double)(integratedPosition = this.workingOneDoFJoints[j].getQ() + 0.001 * desiredVelocity), (double)jointDesiredOutput.getDesiredPosition()) > Math.toRadians(45.0)) {
                    integratedPosition = jointDesiredOutput.getDesiredPosition();
                }
                this.workingOneDoFJoints[j].setQ(integratedPosition);
                this.workingOneDoFJoints[j].setQd(desiredVelocity);
                if (!jointDesiredOutput.hasDesiredTorque()) continue;
                this.workingOneDoFJoints[j].setTau(jointDesiredOutput.getDesiredTorque());
            }
            if (!jointIsMoving) break;
            this.workChest.updateFramesRecursively();
        }
        double totalRobotMass = 0.0;
        this.quality = this.solutionQualityCalculator.calculateSolutionQuality(this.feedbackControllerDataHolder, totalRobotMass, 1.0);
        if (this.quality > 1.0) {
            LogTools.debug((String)"Bad quality solution: {} Try upping the gains, giving more iteration, or setting a more acheivable goal.", (Object)this.quality);
        }
    }

    public double getQuality() {
        return this.quality;
    }

    public OneDoFJointBasics[] getSolutionOneDoFJoints() {
        return this.workingOneDoFJoints;
    }
}

