/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import controller_msgs.msg.dds.RobotConfigurationData;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;

public class RobotConfigurationDataInitialSetup
implements RobotInitialSetup<HumanoidFloatingRootJointRobot> {
    private final RobotConfigurationData robotConfigurationData;
    private final OneDoFJointBasics[] allJointsExcludingHands;

    public RobotConfigurationDataInitialSetup(RobotConfigurationData robotConfigurationData, FullHumanoidRobotModel fullHumanoidRobotModel) {
        this.robotConfigurationData = robotConfigurationData;
        this.allJointsExcludingHands = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullHumanoidRobotModel);
    }

    @Override
    public void initializeRobot(HumanoidFloatingRootJointRobot robot) {
        robot.getRootJoint().setPosition((Tuple3DReadOnly)this.robotConfigurationData.getRootPosition());
        robot.getRootJoint().setOrientation((Orientation3DReadOnly)this.robotConfigurationData.getRootOrientation());
        IDLSequence.Float jointAngles = this.robotConfigurationData.getJointAngles();
        IDLSequence.Float jointVelocities = this.robotConfigurationData.getJointVelocities();
        for (int i = 0; i < this.allJointsExcludingHands.length; ++i) {
            String jointName = this.allJointsExcludingHands[i].getName();
            OneDegreeOfFreedomJoint joint = robot.getOneDegreeOfFreedomJoint(jointName);
            joint.setQ((double)jointAngles.get(i));
            joint.setQd((double)jointVelocities.get(i));
        }
    }

    @Override
    public void initializeFullRobotModel(FullHumanoidRobotModel fullRobotModel) {
        Pose3DBasics rootJointPose = fullRobotModel.getRootJoint().getJointPose();
        rootJointPose.getPosition().set((Tuple3DReadOnly)this.robotConfigurationData.getRootPosition());
        rootJointPose.getOrientation().set((QuaternionReadOnly)this.robotConfigurationData.getRootOrientation());
        IDLSequence.Float jointAngles = this.robotConfigurationData.getJointAngles();
        IDLSequence.Float jointVelocities = this.robotConfigurationData.getJointVelocities();
        for (int i = 0; i < this.allJointsExcludingHands.length; ++i) {
            String jointName = this.allJointsExcludingHands[i].getName();
            OneDoFJointBasics joint = fullRobotModel.getOneDoFJointByName(jointName);
            joint.setQ((double)jointAngles.get(i));
            joint.setQd((double)jointVelocities.get(i));
        }
    }

    @Override
    public void initializeRobot(RigidBodyBasics rootBody) {
        Pose3DBasics rootJointPose = ((FloatingJointBasics)rootBody.getChildrenJoints().get(0)).getJointPose();
        rootJointPose.getPosition().set((Tuple3DReadOnly)this.robotConfigurationData.getRootPosition());
        rootJointPose.getOrientation().set((QuaternionReadOnly)this.robotConfigurationData.getRootOrientation());
        IDLSequence.Float jointAngles = this.robotConfigurationData.getJointAngles();
        IDLSequence.Float jointVelocities = this.robotConfigurationData.getJointVelocities();
        for (int i = 0; i < this.allJointsExcludingHands.length; ++i) {
            String jointName = this.allJointsExcludingHands[i].getName();
            OneDoFJointBasics joint = (OneDoFJointBasics)MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)jointName);
            joint.setQ((double)jointAngles.get(i));
            joint.setQd((double)jointVelocities.get(i));
        }
    }

    @Override
    public void initializeRobotDefinition(RobotDefinition robotDefinition) {
        SixDoFJointState initialRootJointState = new SixDoFJointState((Orientation3DReadOnly)this.robotConfigurationData.getRootOrientation(), (Tuple3DReadOnly)this.robotConfigurationData.getRootPosition());
        ((JointDefinition)robotDefinition.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialRootJointState);
        IDLSequence.Float jointAngles = this.robotConfigurationData.getJointAngles();
        IDLSequence.Float jointVelocities = this.robotConfigurationData.getJointVelocities();
        for (int i = 0; i < this.allJointsExcludingHands.length; ++i) {
            String jointName = this.allJointsExcludingHands[i].getName();
            robotDefinition.getOneDoFJointDefinition(jointName).setInitialJointState((double)jointAngles.get(i), (double)jointVelocities.get(i));
        }
    }

    @Override
    public void setInitialYaw(double yaw) {
    }

    @Override
    public double getInitialYaw() {
        return this.robotConfigurationData.getRootOrientation().getYaw();
    }

    @Override
    public void setInitialGroundHeight(double groundHeight) {
    }

    @Override
    public double getInitialGroundHeight() {
        return this.robotConfigurationData.getRootPosition().getZ();
    }

    @Override
    public void setOffset(Tuple3DReadOnly additionalOffset) {
    }

    @Override
    public Tuple3DReadOnly getOffset() {
        return this.robotConfigurationData.getRootPosition();
    }
}

