/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.handControl.packetsAndConsumers;

import controller_msgs.msg.dds.HandJointAnglePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.avatar.handControl.packetsAndConsumers.HandModel;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HandJointName;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class HandJointAngleProvider
implements PacketConsumer<HandJointAnglePacket> {
    public static final SideDependentList<Boolean> HAND_ENABLED = new SideDependentList((Object)true, (Object)true);
    private final SideDependentList<HashMap<HandJointName, OneDoFJointBasics>> handJoints = new SideDependentList();
    private final SideDependentList<AtomicReference<HandJointAnglePacket>> packets = new SideDependentList();
    private ArrayList<GraphicsUpdatable> graphicsToUpdate = new ArrayList();
    private SideDependentList<HandModel> handModels;

    public HandJointAngleProvider(FullRobotModel fullRobotModel, SideDependentList<HandModel> handModels) {
        this.handModels = handModels;
        if (handModels == null) {
            LogTools.warn((String)"Hand models is null.");
        } else {
            for (RobotSide side : handModels.sides()) {
                HashMap<HandJointName, OneDoFJointBasics> joints = new HashMap<HandJointName, OneDoFJointBasics>();
                this.packets.put((Enum)side, new AtomicReference());
                for (HandJointName jointName : ((HandModel)handModels.get((Enum)side)).getHandJointNames()) {
                    joints.put(jointName, fullRobotModel.getOneDoFJointByName(jointName.getJointName(side)));
                }
                this.handJoints.put((Enum)side, joints);
            }
        }
    }

    public void addGraphicsUpdateable(GraphicsUpdatable updateable) {
        this.graphicsToUpdate.add(updateable);
    }

    public void updateHandModel() {
        if (this.handModels != null) {
            for (RobotSide robotSide : this.handModels.sides()) {
                HandJointAnglePacket handJointAngles = ((AtomicReference)this.packets.get((Enum)robotSide)).getAndSet(null);
                HashMap joints = (HashMap)this.handJoints.get((Enum)robotSide);
                if (handJointAngles == null || joints == null) continue;
                for (HandJointName jointName : ((HandModel)this.handModels.get((Enum)robotSide)).getHandJointNames()) {
                    OneDoFJointBasics oneDoFJoint;
                    if (jointName == null || (oneDoFJoint = (OneDoFJointBasics)joints.get(jointName)) == null || !((Boolean)HAND_ENABLED.get((Enum)robotSide)).booleanValue()) continue;
                    double jointAngle = HumanoidMessageTools.unpackJointAngle((HandJointAnglePacket)handJointAngles, (HandJointName)jointName);
                    oneDoFJoint.setQ(jointAngle);
                }
                for (GraphicsUpdatable graphicsUpdatable : this.graphicsToUpdate) {
                    if (graphicsUpdatable == null) continue;
                    graphicsUpdatable.update();
                }
            }
        }
    }

    public void receivedPacket(HandJointAnglePacket object) {
        RobotSide side;
        if (this.handModels != null && this.handModels.containsKey((Object)(side = RobotSide.fromByte((byte)object.getRobotSide())))) {
            ((AtomicReference)this.packets.get((Enum)side)).set(object);
        }
    }
}

