/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.footstepPlanning;

import java.util.HashSet;
import java.util.Set;
import us.ihmc.concurrent.ConcurrentCopier;

class ConcurrentSet<T>
extends ConcurrentCopier<Set<T>> {
    public ConcurrentSet() {
        super(HashSet::new);
    }

    public boolean isEmpty() {
        Set readCopy = (Set)this.getCopyForReading();
        if (readCopy == null) {
            return true;
        }
        return readCopy.isEmpty();
    }

    public int size() {
        Set currentList = (Set)this.getCopyForReading();
        if (currentList == null) {
            return 0;
        }
        return currentList.size();
    }

    public void clear() {
        Set updatedList = (Set)this.getCopyForWriting();
        updatedList.clear();
        this.commit();
    }

    public void add(T objectToAdd) {
        Set existingList = (Set)this.getCopyForReading();
        Set updatedList = (Set)this.getCopyForWriting();
        updatedList.clear();
        if (existingList != null) {
            updatedList.addAll(existingList);
        }
        updatedList.add(objectToAdd);
        this.commit();
    }

    public boolean remove(T objectToRemove) {
        Set existingList = (Set)this.getCopyForReading();
        Set updatedList = (Set)this.getCopyForWriting();
        updatedList.clear();
        if (existingList != null) {
            updatedList.addAll(existingList);
        }
        boolean success = updatedList.remove(objectToRemove);
        this.commit();
        return success;
    }

    public boolean contains(T object) {
        return ((Set)this.getCopyForReading()).contains(object);
    }

    public Iterable<T> iterable() {
        return (Iterable)this.getCopyForReading();
    }
}

