/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.factory;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.AvatarStepGeneratorThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.SimulatedDRCRobotTimeProvider;
import us.ihmc.avatar.factory.AvatarSimulationFactory;
import us.ihmc.avatar.factory.BarrierScheduledRobotController;
import us.ihmc.avatar.factory.DisposableRobotController;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.logging.IntraprocessYoVariableLogger;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.corruptors.FullRobotModelCorruptor;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AvatarSimulation {
    private SimulationConstructionSet simulationConstructionSet;
    private HighLevelHumanoidControllerFactory highLevelHumanoidControllerFactory;
    private YoVariableServer yoVariableServer;
    private IntraprocessYoVariableLogger intraprocessYoVariableLogger;
    private DisposableRobotController robotController;
    private AvatarEstimatorThread stateEstimationThread;
    private AvatarControllerThread controllerThread;
    private AvatarStepGeneratorThread stepGeneratorThread;
    private HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot;
    private SimulatedDRCRobotTimeProvider simulatedRobotTimeProvider;
    private FullHumanoidRobotModel controllerFullRobotModel;
    private RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup;
    private HumanoidRobotContextData masterContext;
    private DRCRobotModel robotModel;

    public void start() {
        if (this.intraprocessYoVariableLogger != null) {
            this.intraprocessYoVariableLogger.start();
        }
        if (this.yoVariableServer != null) {
            this.yoVariableServer.start();
        }
        this.simulationConstructionSet.startOnAThread();
    }

    public void simulate() {
        this.simulationConstructionSet.simulate();
    }

    public void dispose() {
        if (this.robotController != null) {
            this.robotController.dispose();
        }
        this.robotController = null;
    }

    public void destroy() {
        this.dispose();
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
        }
        this.yoVariableServer = null;
        ThreadTools.startAsDaemon(() -> this.simulationConstructionSet.stopSimulationThread(), (String)"WaitForSimulationThreadToStop");
        this.simulationConstructionSet.closeAndDispose();
    }

    public void resetRobot() {
        this.resetRobot(true);
    }

    public void resetRobot(boolean simulateAfterReset) {
        this.simulationConstructionSet.stop();
        if (this.robotController instanceof BarrierScheduledRobotController) {
            ((BarrierScheduledRobotController)this.robotController).waitUntilTasksDone();
        }
        ThreadTools.sleep((long)100L);
        ArrayList joints = new ArrayList();
        this.humanoidFloatingRootJointRobot.getAllOneDegreeOfFreedomJoints(joints);
        for (OneDegreeOfFreedomJoint joint : joints) {
            joint.setQ(0.0);
            joint.setQd(0.0);
            joint.setQdd(0.0);
            joint.setTau(0.0);
        }
        FloatingJoint rootJoint = this.humanoidFloatingRootJointRobot.getRootJoint();
        rootJoint.setVelocity((Tuple3DReadOnly)new Vector3D());
        rootJoint.setAcceleration((Tuple3DReadOnly)new Vector3D());
        rootJoint.setAngularVelocityInBody((Vector3DReadOnly)new Vector3D());
        rootJoint.setAngularAccelerationInBody((Vector3DReadOnly)new Vector3D());
        List contactPoints = this.humanoidFloatingRootJointRobot.getAllGroundContactPoints();
        for (GroundContactPoint cp : contactPoints) {
            cp.setNotInContact();
        }
        this.robotInitialSetup.initializeRobot(this.humanoidFloatingRootJointRobot);
        AvatarSimulationFactory.initializeEstimator(this.humanoidFloatingRootJointRobot, this.stateEstimationThread);
        this.controllerThread.initialize();
        this.stepGeneratorThread.initialize();
        this.masterContext.setControllerRan(false);
        this.masterContext.setEstimatorRan(false);
        if (simulateAfterReset) {
            this.simulate();
        }
    }

    public void updateEnvironment(CommonAvatarEnvironmentInterface commonAvatarEnvironment) {
        if (commonAvatarEnvironment != null && commonAvatarEnvironment.getEnvironmentRobots() != null) {
            commonAvatarEnvironment.addContactPoints(this.humanoidFloatingRootJointRobot.getAllGroundContactPoints());
            commonAvatarEnvironment.createAndSetContactControllerToARobot();
        }
        if (commonAvatarEnvironment != null && commonAvatarEnvironment.getTerrainObject3D() != null) {
            this.simulationConstructionSet.addStaticLinkGraphics(commonAvatarEnvironment.getTerrainObject3D().getLinkGraphics());
        }
    }

    public FullHumanoidRobotModel getControllerFullRobotModel() {
        return this.controllerFullRobotModel;
    }

    public void addRobotControllerOnControllerThread(RobotController controller) {
        this.controllerThread.addRobotController(controller);
    }

    public FullRobotModelCorruptor getFullRobotModelCorruptor() {
        return this.controllerThread.getFullRobotModelCorruptor();
    }

    public SimulationConstructionSet getSimulationConstructionSet() {
        return this.simulationConstructionSet;
    }

    public HighLevelHumanoidControllerFactory getHighLevelHumanoidControllerFactory() {
        return this.highLevelHumanoidControllerFactory;
    }

    public HumanoidFloatingRootJointRobot getHumanoidFloatingRootJointRobot() {
        return this.humanoidFloatingRootJointRobot;
    }

    public SimulatedDRCRobotTimeProvider getSimulatedRobotTimeProvider() {
        return this.simulatedRobotTimeProvider;
    }

    public void setSimulationConstructionSet(SimulationConstructionSet simulationConstructionSet) {
        this.simulationConstructionSet = simulationConstructionSet;
    }

    public void setHighLevelHumanoidControllerFactory(HighLevelHumanoidControllerFactory momentumBasedControllerFactory) {
        this.highLevelHumanoidControllerFactory = momentumBasedControllerFactory;
    }

    public void setYoVariableServer(YoVariableServer yoVariableServer) {
        this.yoVariableServer = yoVariableServer;
    }

    public void setIntraprocessYoVariableLogger(IntraprocessYoVariableLogger intraprocessYoVariableLogger) {
        this.intraprocessYoVariableLogger = intraprocessYoVariableLogger;
    }

    public void setRobotController(DisposableRobotController robotController) {
        this.robotController = robotController;
    }

    public void setStateEstimationThread(AvatarEstimatorThread stateEstimationThread) {
        this.stateEstimationThread = stateEstimationThread;
    }

    public void setControllerThread(AvatarControllerThread controllerThread) {
        this.controllerThread = controllerThread;
    }

    public void setStepGeneratorThread(AvatarStepGeneratorThread stepGeneratorThread) {
        this.stepGeneratorThread = stepGeneratorThread;
    }

    public void setHumanoidFloatingRootJointRobot(HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot) {
        this.humanoidFloatingRootJointRobot = humanoidFloatingRootJointRobot;
    }

    public void setSimulatedRobotTimeProvider(SimulatedDRCRobotTimeProvider simulatedRobotTimeProvider) {
        this.simulatedRobotTimeProvider = simulatedRobotTimeProvider;
    }

    public void setFullHumanoidRobotModel(FullHumanoidRobotModel controllerFullRobotModel) {
        this.controllerFullRobotModel = controllerFullRobotModel;
    }

    public void addRobotControllerOnEstimatorThread(RobotController controller) {
        this.stateEstimationThread.addRobotController(controller);
    }

    public void setRobotInitialSetup(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup) {
        this.robotInitialSetup = robotInitialSetup;
    }

    public void setRobotModel(DRCRobotModel robotModel) {
        this.robotModel = robotModel;
    }

    public YoRegistry getStateEstimationThreadRegistry() {
        return this.stateEstimationThread.getYoRegistry();
    }

    public YoRegistry getControllerThreadRegistry() {
        return this.controllerThread.getYoVariableRegistry();
    }

    public YoRegistry getStepGeneratorThreadRegistry() {
        return this.stepGeneratorThread.getYoVariableRegistry();
    }

    public void setMasterContext(HumanoidRobotContextData masterContext) {
        this.masterContext = masterContext;
    }

    public HumanoidRobotContextData getMasterContext() {
        return this.masterContext;
    }
}

