/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.environments;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.simulationConstructionSetTools.robotController.ContactController;
import us.ihmc.simulationConstructionSetTools.util.environments.AdjustableStairsEnvironment;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.DefaultCommonAvatarEnvironment;
import us.ihmc.simulationConstructionSetTools.util.environments.SelectableObjectListener;
import us.ihmc.simulationConstructionSetTools.util.environments.ValveType;
import us.ihmc.simulationConstructionSetTools.util.environments.environmentRobots.ContactableCylinderRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.environmentRobots.ContactableDoorRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.environmentRobots.ContactableValveRobot;
import us.ihmc.simulationConstructionSetTools.util.ground.CombinedTerrainObject3D;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.util.LinearGroundContactModel;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.ground.Contactable;
import us.ihmc.simulationconstructionset.util.ground.RotatableBoxTerrainObject;
import us.ihmc.simulationconstructionset.util.ground.RotatableCinderBlockTerrainObject;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class DRCFinalsEnvironment
implements CommonAvatarEnvironmentInterface {
    private final List<Robot> contactableRobots = new ArrayList<Robot>();
    private final CombinedTerrainObject3D combinedTerrainObject;
    private final double WALL_HEIGHT = 2.4384;
    private final ArrayList<ExternalForcePoint> contactPoints = new ArrayList();
    private static final double cinderBlockLength = 0.4;
    private static final double cinderBlockWidth = 0.2;
    private static final double cinderBlockHeight = 0.15;
    private static final double overlapToPreventGaps = 0.002;
    private static final AppearanceDefinition cinderBlockAppearance = YoAppearance.DarkGray();
    private static final double cinderBlockTiltDegrees = 15.0;
    private static final double cinderBlockTiltRadians = Math.toRadians(15.0);

    public DRCFinalsEnvironment(boolean door, boolean drill, boolean valve, boolean wakling, boolean stairs) {
        this.combinedTerrainObject = new CombinedTerrainObject3D(this.getClass().getSimpleName());
        this.combinedTerrainObject.addTerrainObject((TerrainObject3D)this.setUpGround("Ground"));
        this.addFullCourse3dModel(valve);
        if (door) {
            this.createDoor();
        }
        if (valve) {
            this.createValve();
        }
        if (drill) {
            this.createDrill();
        }
        if (wakling) {
            this.createWalkingCourse();
        }
        if (stairs) {
            this.createStairs();
        }
    }

    private void createWalkingCourse() {
        this.combinedTerrainObject.addTerrainObject((TerrainObject3D)this.setUpCinderBlockFieldActual("walking", -90.0, 10.0, 1.0));
    }

    private void addFullCourse3dModel(boolean doingValve) {
        this.combinedTerrainObject.getLinkGraphics().identity();
        this.combinedTerrainObject.getLinkGraphics().addModelFile("models/SCTestBed.obj");
    }

    private void createStairs() {
        AdjustableStairsEnvironment environment = new AdjustableStairsEnvironment();
        environment.setStairsParameters(4, 1.016, 0.2286, 0.2921);
        environment.setRailingParameters(0.05, 0.3, 0.05, 0.8128, 2, false);
        environment.setLandingPlatformParameters(1.27, 3.0, 1.143, 2);
        environment.setCourseAngle(-90.0);
        environment.setCourseStartDistance(14.2794);
        environment.setCourseOffsetSide(1.0);
        environment.generateTerrains();
        ArrayList stairs = ((CombinedTerrainObject3D)environment.getTerrainObject3D()).getTerrainObjects();
        for (TerrainObject3D object : stairs) {
            if (!(object instanceof CombinedTerrainObject3D) || ((CombinedTerrainObject3D)object).getName().contains("ground")) continue;
            this.combinedTerrainObject.addTerrainObject(object);
        }
    }

    private void createDrill() {
        Vector3D tableCenter = new Vector3D(-0.851, -6.833, 1.118);
        double drillHeight = 0.3;
        double drillRadius = 0.03;
        double drillMass = 1.5;
        double forceVectorScale = 0.002;
        RigidBodyTransform initialDrillTransform = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle(), (Tuple3DReadOnly)tableCenter);
        ContactableCylinderRobot drillRobot = new ContactableCylinderRobot("drill", initialDrillTransform, drillRadius, drillHeight, drillMass, "models/drill.obj");
        boolean groundContactGroupIdentifier = false;
        drillRobot.createAvailableContactPoints(0, 30, forceVectorScale, true);
        for (int i = 0; i < 4; ++i) {
            double angle = (double)i * 2.0 * Math.PI / 4.0;
            double x = 1.5 * drillRadius * Math.cos(angle);
            double y = 1.5 * drillRadius * Math.sin(angle);
            GroundContactPoint groundContactPoint = new GroundContactPoint("gc_drill_" + i, (Tuple3DReadOnly)new Vector3D(x, y, 0.0), (Robot)drillRobot);
            ((Joint)drillRobot.getRootJoints().get(0)).addGroundContactPoint(groundContactPoint);
        }
        LinearGroundContactModel groundContactModel = new LinearGroundContactModel((Robot)drillRobot, 0, 1422.0, 150.6, 50.0, 600.0, drillRobot.getRobotsYoRegistry());
        groundContactModel.setGroundProfile3D((GroundProfile3D)this.combinedTerrainObject);
        drillRobot.setGroundContactModel((GroundContactModel)groundContactModel);
        this.contactableRobots.add((Robot)drillRobot);
        this.combinedTerrainObject.addBox(-0.777, -6.916, -0.947, -6.746, 1.061, 1.08);
    }

    private void createDoor() {
        ContactableDoorRobot door = new ContactableDoorRobot("doorRobot", new Point3D());
        this.contactableRobots.add((Robot)door);
        door.createAvailableContactPoints(0, 15, 15, 0.02, true);
    }

    private void createValve() {
        double forceVectorScale = 0.02;
        String valveRobotName = "ValveRobot";
        ValveType valveType = ValveType.SMALL_VALVE;
        double x = -0.758;
        double y = -8.515;
        double z = 1.067;
        double yaw_degrees = -135.0;
        FramePose3D valvePose = new FramePose3D(ReferenceFrame.getWorldFrame());
        Point3D position = new Point3D(x, y, z);
        Quaternion orientation = new Quaternion();
        orientation.setYawPitchRoll(Math.toRadians(yaw_degrees), Math.toRadians(0.0), Math.toRadians(0.0));
        valvePose.set((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
        ContactableValveRobot valve = new ContactableValveRobot(valveRobotName, valveType, 0.5, valvePose);
        valve.createValveRobot();
        valve.createAvailableContactPoints(1, 30, forceVectorScale, true);
        this.contactableRobots.add((Robot)valve);
    }

    private CombinedTerrainObject3D setUpGround(String name) {
        CombinedTerrainObject3D combinedTerrainObject = new CombinedTerrainObject3D(name);
        combinedTerrainObject.addBox(-5.0, -30.0, 5.0, 5.0, -0.05, 0.0, YoAppearance.DarkGray());
        combinedTerrainObject.addBox(-1.2192, -0.025, 0.0, 0.025, 2.4384, YoAppearance.Beige());
        combinedTerrainObject.addBox(0.0 + ContactableDoorRobot.DEFAULT_DOOR_DIMENSIONS.getX(), -0.025, 1.2192 + ContactableDoorRobot.DEFAULT_DOOR_DIMENSIONS.getX(), 0.025, 2.4384, YoAppearance.Beige());
        return combinedTerrainObject;
    }

    public TerrainObject3D getTerrainObject3D() {
        return this.combinedTerrainObject;
    }

    public List<? extends Robot> getEnvironmentRobots() {
        return this.contactableRobots;
    }

    public void createAndSetContactControllerToARobot() {
        ContactController contactController = new ContactController();
        contactController.setContactParameters(100000.0, 100.0, 0.5, 0.3);
        contactController.addContactPoints(this.contactPoints);
        for (Robot r : this.contactableRobots) {
            if (!(r instanceof Contactable)) continue;
            contactController.addContactable((Contactable)r);
        }
        if (this.contactableRobots.size() > 0) {
            this.contactableRobots.get(0).setController((RobotController)contactController);
        }
    }

    public void addContactPoints(List<? extends ExternalForcePoint> externalForcePoints) {
        this.contactPoints.addAll(externalForcePoints);
    }

    public void addSelectableListenerToSelectables(SelectableObjectListener selectedListener) {
    }

    private CombinedTerrainObject3D setUpCinderBlockFieldActual(String name, double courseAngle, double startDistance, double leftRightOffset) {
        CombinedTerrainObject3D combinedTerrainObject = new CombinedTerrainObject3D(name);
        int nBlocksWide = 6;
        int nBlocksLong = 7;
        Object blockAngle = new double[nBlocksLong][nBlocksWide];
        Object blockHeight = new int[nBlocksLong][nBlocksWide];
        DefaultCommonAvatarEnvironment.BLOCKTYPE[][] blockType = new DefaultCommonAvatarEnvironment.BLOCKTYPE[nBlocksLong][nBlocksWide];
        for (int i = 0; i < nBlocksLong; ++i) {
            for (int j = 0; j < nBlocksWide; ++j) {
                blockHeight[i][j] = -1;
                blockAngle[i][j] = 0.0;
                blockType[i][j] = DefaultCommonAvatarEnvironment.BLOCKTYPE.ANGLED;
            }
        }
        blockHeight = new int[][]{{0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0}, {1, 2, 1, 1, 2, 1}, {1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0}};
        boolean NORTH = false;
        int SOUTH = 180;
        int WEST = 90;
        int EAST = -90;
        blockAngle = new double[][]{{0.0, -90.0, 180.0, 90.0, 0.0, -90.0}, {90.0, 0.0, -90.0, 180.0, 90.0, 0.0}, {180.0, 90.0, 0.0, -90.0, 180.0, 90.0}, {-90.0, 180.0, 90.0, 0.0, -90.0, 180.0}, {0.0, -90.0, 180.0, 90.0, 0.0, -90.0}, {90.0, 0.0, -90.0, 180.0, 90.0, 0.0}, {180.0, 90.0, 0.0, -90.0, 180.0, 90.0}};
        startDistance += 0.2;
        for (int i = 0; i < nBlocksLong; ++i) {
            for (int j = 0; j < nBlocksWide; ++j) {
                double xCenter = startDistance + (double)i * 0.4;
                double yCenter = leftRightOffset + (double)nBlocksWide * 0.4 / 2.0 - (double)j * 0.4 - 0.2;
                double[] point = new double[]{xCenter, yCenter};
                double[] rotatedPoint = this.rotateAroundOrigin(point, courseAngle);
                int h = blockHeight[i][j];
                double deg = blockAngle[i][j] + courseAngle;
                this.setUpRampBlock(combinedTerrainObject, rotatedPoint, h, deg);
            }
        }
        return combinedTerrainObject;
    }

    private void setUpRampBlock(CombinedTerrainObject3D combinedTerrainObject, double[] point, int h, double deg) {
        this.setUpRampBlock(combinedTerrainObject, point[0], point[1], h, deg);
    }

    private void setUpRampBlock(CombinedTerrainObject3D combinedTerrainObject, double xCenter, double yCenter, int numberFlatSupports, double yawDegrees) {
        if (numberFlatSupports < 0) {
            return;
        }
        this.setUpCinderBlockSquare(combinedTerrainObject, xCenter, yCenter, numberFlatSupports - 1, yawDegrees);
        double rampRise = 0.4 * Math.sin(cinderBlockTiltRadians);
        RigidBodyTransform blockSupportLocation = new RigidBodyTransform();
        blockSupportLocation.setRotationYawAndZeroTranslation(Math.toRadians(yawDegrees));
        double[] xySupportRotatedOffset = this.rotateAroundOrigin(new double[]{(0.4 - rampRise) / 2.0, 0.0}, yawDegrees);
        blockSupportLocation.getTranslation().set((Tuple3DReadOnly)new Vector3D(xCenter + xySupportRotatedOffset[0], yCenter + xySupportRotatedOffset[1], rampRise / 2.0 + (double)numberFlatSupports * 0.15));
        RotatableBoxTerrainObject newBox = new RotatableBoxTerrainObject(new Box3D((RigidBodyTransformReadOnly)blockSupportLocation, rampRise, 0.4, rampRise), cinderBlockAppearance);
        combinedTerrainObject.addTerrainObject((TerrainObject3D)newBox);
        double xOffset = 0.0;
        double yOffset = 0.1;
        double[] xyRotated1 = this.rotateAroundOrigin(new double[]{xOffset, yOffset}, yawDegrees);
        double[] xyRotated2 = this.rotateAroundOrigin(new double[]{xOffset, -yOffset}, yawDegrees);
        this.setUpSlopedCinderBlock(combinedTerrainObject, xCenter + xyRotated1[0], yCenter + xyRotated1[1], numberFlatSupports, yawDegrees);
        this.setUpSlopedCinderBlock(combinedTerrainObject, xCenter + xyRotated2[0], yCenter + xyRotated2[1], numberFlatSupports, yawDegrees);
    }

    private void setUpSlopedCinderBlock(CombinedTerrainObject3D combinedTerrainObject, double xCenter, double yCenter, int numberFlatSupports, double yawDegrees) {
        if (numberFlatSupports < 0) {
            return;
        }
        AppearanceDefinition app = cinderBlockAppearance;
        RigidBodyTransform location = new RigidBodyTransform();
        location.setRotationYawAndZeroTranslation(Math.toRadians(yawDegrees));
        RigidBodyTransform tilt = new RigidBodyTransform();
        tilt.setRotationPitchAndZeroTranslation(-cinderBlockTiltRadians);
        location.multiply((RigidBodyTransformReadOnly)tilt);
        double zCenter = (0.15 * Math.cos(cinderBlockTiltRadians) + 0.4 * Math.sin(cinderBlockTiltRadians)) / 2.0;
        location.getTranslation().set((Tuple3DReadOnly)new Vector3D(xCenter, yCenter, zCenter + (double)numberFlatSupports * 0.15));
        RotatableCinderBlockTerrainObject newBox = new RotatableCinderBlockTerrainObject(new Box3D((RigidBodyTransformReadOnly)location, 0.4, 0.2, 0.15), app);
        combinedTerrainObject.addTerrainObject((TerrainObject3D)newBox);
    }

    private void setUpCinderBlockSquare(CombinedTerrainObject3D combinedTerrainObject, double xCenter, double yCenter, int numberFlatSupports, double yawDegrees) {
        double xOffset = 0.0;
        double yOffset = 0.1;
        double[] xyRotated1 = this.rotateAroundOrigin(new double[]{xOffset, yOffset}, yawDegrees);
        double[] xyRotated2 = this.rotateAroundOrigin(new double[]{xOffset, -yOffset}, yawDegrees);
        this.setUpCinderBlock(combinedTerrainObject, xCenter + xyRotated1[0], yCenter + xyRotated1[1], numberFlatSupports, yawDegrees);
        this.setUpCinderBlock(combinedTerrainObject, xCenter + xyRotated2[0], yCenter + xyRotated2[1], numberFlatSupports, yawDegrees);
        if (numberFlatSupports > 0) {
            this.setUpCinderBlockSquare(combinedTerrainObject, xCenter, yCenter, numberFlatSupports - 1, yawDegrees + 90.0);
        }
    }

    private void setUpCinderBlock(CombinedTerrainObject3D combinedTerrainObject, double xCenter, double yCenter, int numberFlatSupports, double yawDegrees) {
        double[] centerPoint = new double[]{xCenter, yCenter};
        this.setUpCinderBlock(combinedTerrainObject, centerPoint, numberFlatSupports, yawDegrees);
    }

    private double[] rotateAroundOrigin(double[] xy, double angdeg) {
        double x = xy[0];
        double y = xy[1];
        double[] newPoint = new double[2];
        double angRad = Math.toRadians(angdeg);
        newPoint[0] = x * Math.cos(angRad) - y * Math.sin(angRad);
        newPoint[1] = y * Math.cos(angRad) + x * Math.sin(angRad);
        return newPoint;
    }

    private void setUpCinderBlock(CombinedTerrainObject3D combinedTerrainObject, double[] centerPoint, int numberFlatSupports, double yawDegrees) {
        if (numberFlatSupports < 0) {
            return;
        }
        AppearanceDefinition app = cinderBlockAppearance;
        double xCenter = centerPoint[0];
        double yCenter = centerPoint[1];
        RigidBodyTransform location = new RigidBodyTransform();
        location.setRotationYawAndZeroTranslation(Math.toRadians(yawDegrees));
        location.getTranslation().set((Tuple3DReadOnly)new Vector3D(xCenter, yCenter, 0.075 + (double)numberFlatSupports * 0.15));
        RotatableCinderBlockTerrainObject newBox = new RotatableCinderBlockTerrainObject(new Box3D((RigidBodyTransformReadOnly)location, 0.402, 0.202, 0.152), app);
        combinedTerrainObject.addTerrainObject((TerrainObject3D)newBox);
    }
}

