/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.graphviz.ReferenceFrameTreeViewer;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class RobotDefinitionTreeRenderer {
    private final List<JointDefinitionLabelProvider> jointLabelProviders = new ArrayList<JointDefinitionLabelProvider>();
    private final List<RigidBodyDefinitionLabelProvider> rigidBodyLabelProviders = new ArrayList<RigidBodyDefinitionLabelProvider>();

    public RobotDefinitionTreeRenderer(RobotDefinition robotDefinition, String filenamePostfix) {
        this.jointLabelProviders.add(JointDefinition::getName);
        this.rigidBodyLabelProviders.add(RigidBodyDefinition::getName);
        this.jointLabelProviders.add(joint -> joint.getClass().getSimpleName());
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                return "axis = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)((OneDoFJointDefinition)joint).getAxis());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                OneDoFJointDefinition oneDofJoint = (OneDoFJointDefinition)joint;
                return "joint limits lower = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getPositionLowerLimit()) + " upper = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getPositionUpperLimit());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                OneDoFJointDefinition oneDofJoint = (OneDoFJointDefinition)joint;
                return "velocity limits lower = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getVelocityLowerLimit()) + " upper = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getVelocityUpperLimit());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                OneDoFJointDefinition oneDofJoint = (OneDoFJointDefinition)joint;
                return "torque (effort) limits lower = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getEffortLowerLimit()) + " upper = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getEffortUpperLimit());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                OneDoFJointDefinition oneDofJoint = (OneDoFJointDefinition)joint;
                return "damping = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getDamping());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                OneDoFJointDefinition oneDofJoint = (OneDoFJointDefinition)joint;
                return "damping velocity soft limit = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getDampingVelocitySoftLimit());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                OneDoFJointDefinition oneDofJoint = (OneDoFJointDefinition)joint;
                return "stiction = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getStiction());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                OneDoFJointDefinition oneDofJoint = (OneDoFJointDefinition)joint;
                return "soft limit stop kp = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getKpSoftLimitStop()) + " kd = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, oneDofJoint.getKdSoftLimitStop());
            }
            return null;
        });
        this.jointLabelProviders.add(joint -> "translation to parent = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)joint.getTransformToParent().getTranslation()));
        this.jointLabelProviders.add(joint -> "rotation to parent (deg) = " + EuclidCoreIOTools.getYawPitchRollString((double)Math.toDegrees(joint.getTransformToParent().getYaw()), (double)Math.toDegrees(joint.getTransformToParent().getPitch()), (double)Math.toDegrees(joint.getTransformToParent().getRoll())));
        this.rigidBodyLabelProviders.add(rigidBody -> "mass = " + ReferenceFrameTreeViewer.getLabelOf((double[])new double[]{rigidBody.getMass()}));
        this.rigidBodyLabelProviders.add(rigidBody -> "moment of inertia =\n" + RobotDefinitionTreeRenderer.getMatrixLabel((Matrix3DReadOnly)rigidBody.getMomentOfInertia()));
        this.rigidBodyLabelProviders.add(rigidBody -> "inertia translation (CoM) to parent = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)rigidBody.getInertiaPose().getTranslation()));
        this.rigidBodyLabelProviders.add(rigidBody -> "inertia rotation to parent (deg) = " + EuclidCoreIOTools.getYawPitchRollString((double)Math.toDegrees(rigidBody.getInertiaPose().getYaw()), (double)Math.toDegrees(rigidBody.getInertiaPose().getPitch()), (double)Math.toDegrees(rigidBody.getInertiaPose().getRoll())));
        this.rigidBodyLabelProviders.add(rigidBody -> {
            if (!rigidBody.getVisualDefinitions().isEmpty()) {
                Object visualDefinitionLabel = "visuals:\n";
                for (VisualDefinition visualDefinition : rigidBody.getVisualDefinitions()) {
                    if (visualDefinition.getGeometryDefinition() instanceof ModelFileGeometryDefinition) {
                        ModelFileGeometryDefinition modelFileGeometryDefinition = (ModelFileGeometryDefinition)visualDefinition.getGeometryDefinition();
                        visualDefinitionLabel = (String)visualDefinitionLabel + visualDefinition.getName() + ": " + modelFileGeometryDefinition.getFileName() + "\n";
                    } else if (visualDefinition.getGeometryDefinition() instanceof Box3DDefinition) {
                        Box3DDefinition boxGeometryDefinition = (Box3DDefinition)visualDefinition.getGeometryDefinition();
                        visualDefinitionLabel = (String)visualDefinitionLabel + "box = " + EuclidCoreIOTools.getStringOf((String)"(", (String)" )", (String)", ", (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[]{boxGeometryDefinition.getSizeX(), boxGeometryDefinition.getSizeY(), boxGeometryDefinition.getSizeZ()});
                    } else if (visualDefinition.getGeometryDefinition() instanceof Sphere3DDefinition) {
                        Sphere3DDefinition sphereGeometryDefinition = (Sphere3DDefinition)visualDefinition.getGeometryDefinition();
                        visualDefinitionLabel = (String)visualDefinitionLabel + "sphere radius = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, sphereGeometryDefinition.getRadius()) + " resolution = " + sphereGeometryDefinition.getResolution() + "\n";
                    } else {
                        LogTools.warn((String)"Implement label for {}", (Object)visualDefinition.getGeometryDefinition().getClass().getSimpleName());
                    }
                    if (visualDefinition.getMaterialDefinition() != null) {
                        MaterialDefinition materialDefinition = visualDefinition.getMaterialDefinition();
                        if (materialDefinition.getName() != null) {
                            visualDefinitionLabel = (String)visualDefinitionLabel + materialDefinition.getName() + ": ";
                        }
                        if (materialDefinition.getDiffuseColor() != null) {
                            visualDefinitionLabel = (String)visualDefinitionLabel + "diffuse = " + EuclidCoreIOTools.getStringOf((String)"(", (String)" )", (String)", ", (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[]{materialDefinition.getDiffuseColor().getRed(), materialDefinition.getDiffuseColor().getGreen(), materialDefinition.getDiffuseColor().getBlue(), materialDefinition.getDiffuseColor().getAlpha()}) + "\n";
                        }
                        if (materialDefinition.getAmbientColor() != null) {
                            visualDefinitionLabel = (String)visualDefinitionLabel + "ambient = " + EuclidCoreIOTools.getStringOf((String)"RGBA (", (String)" )", (String)", ", (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[]{materialDefinition.getAmbientColor().getRed(), materialDefinition.getAmbientColor().getGreen(), materialDefinition.getAmbientColor().getBlue(), materialDefinition.getAmbientColor().getAlpha()}) + "\n";
                        }
                    }
                    visualDefinitionLabel = (String)visualDefinitionLabel + "   translation to parent = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)visualDefinition.getOriginPose().getTranslation()) + "\n";
                    YawPitchRoll yawPitchRollToParent = new YawPitchRoll((Orientation3DReadOnly)visualDefinition.getOriginPose().getRotationView());
                    visualDefinitionLabel = (String)visualDefinitionLabel + "   rotation to parent (deg) = " + EuclidCoreIOTools.getYawPitchRollString((double)Math.toDegrees(yawPitchRollToParent.getYaw()), (double)Math.toDegrees(yawPitchRollToParent.getPitch()), (double)Math.toDegrees(yawPitchRollToParent.getRoll())) + "\n";
                }
                return visualDefinitionLabel;
            }
            return null;
        });
        this.rigidBodyLabelProviders.add(rigidBody -> {
            if (!rigidBody.getCollisionShapeDefinitions().isEmpty()) {
                Object collisionShapeDefinitionsLabel = "collision shapes:\n";
                for (CollisionShapeDefinition collisionShape : rigidBody.getCollisionShapeDefinitions()) {
                    if (collisionShape.getGeometryDefinition() instanceof ModelFileGeometryDefinition) {
                        ModelFileGeometryDefinition modelFileGeometryDefinition = (ModelFileGeometryDefinition)collisionShape.getGeometryDefinition();
                        collisionShapeDefinitionsLabel = (String)collisionShapeDefinitionsLabel + collisionShape.getName() + ": " + modelFileGeometryDefinition.getFileName() + "\n";
                    } else if (collisionShape.getGeometryDefinition() instanceof Box3DDefinition) {
                        Box3DDefinition boxGeometryDefinition = (Box3DDefinition)collisionShape.getGeometryDefinition();
                        collisionShapeDefinitionsLabel = (String)collisionShapeDefinitionsLabel + "box = " + EuclidCoreIOTools.getStringOf((String)"(", (String)" )", (String)", ", (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[]{boxGeometryDefinition.getSizeX(), boxGeometryDefinition.getSizeY(), boxGeometryDefinition.getSizeZ()});
                    } else if (collisionShape.getGeometryDefinition() instanceof Sphere3DDefinition) {
                        Sphere3DDefinition sphereGeometryDefinition = (Sphere3DDefinition)collisionShape.getGeometryDefinition();
                        collisionShapeDefinitionsLabel = (String)collisionShapeDefinitionsLabel + "sphere radius = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, sphereGeometryDefinition.getRadius()) + " resolution = " + sphereGeometryDefinition.getResolution();
                    } else if (collisionShape.getGeometryDefinition() instanceof Cylinder3DDefinition) {
                        Cylinder3DDefinition cylinderGeometryDefinition = (Cylinder3DDefinition)collisionShape.getGeometryDefinition();
                        collisionShapeDefinitionsLabel = (String)collisionShapeDefinitionsLabel + "cylinder radius = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, cylinderGeometryDefinition.getRadius()) + " length = " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, cylinderGeometryDefinition.getLength()) + " resolution = " + cylinderGeometryDefinition.getResolution();
                    } else {
                        LogTools.warn((String)"Implement label for {}", (Object)collisionShape.getGeometryDefinition().getClass().getSimpleName());
                    }
                    collisionShapeDefinitionsLabel = (String)collisionShapeDefinitionsLabel + "   translation to parent = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)collisionShape.getOriginPose().getTranslation()) + "\n";
                    collisionShapeDefinitionsLabel = (String)collisionShapeDefinitionsLabel + "   rotation to parent (deg) = " + EuclidCoreIOTools.getYawPitchRollString((double)Math.toDegrees(collisionShape.getOriginPose().getYaw()), (double)Math.toDegrees(collisionShape.getOriginPose().getPitch()), (double)Math.toDegrees(collisionShape.getOriginPose().getRoll())) + "\n";
                }
                return collisionShapeDefinitionsLabel;
            }
            return null;
        });
        MutableGraph graph = Factory.mutGraph((String)"MultiBodySystemView").setDirected(true);
        MutableNode rootNode = this.createRigidBodyNode(robotDefinition.getRootBodyDefinition(), graph);
        this.addChildrenToGraph(robotDefinition.getRootBodyDefinition(), rootNode, graph);
        try {
            Graphviz.fromGraph((MutableGraph)graph).render(Format.PNG).toFile(new File(robotDefinition.getName() + filenamePostfix + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private MutableNode createRigidBodyNode(RigidBodyDefinition rigidBodyDefinition, MutableGraph graph) {
        Object label = this.rigidBodyLabelProviders.get(0).getLabel(rigidBodyDefinition);
        for (int i = 1; i < this.rigidBodyLabelProviders.size(); ++i) {
            String additionalLabel = this.rigidBodyLabelProviders.get(i).getLabel(rigidBodyDefinition);
            if (additionalLabel == null) continue;
            label = (String)label + "\n" + additionalLabel;
        }
        MutableNode rigidBodyNode = Factory.mutNode((String)label);
        rigidBodyNode.add((Attributes)Color.DARKORCHID);
        graph.add((LinkSource)rigidBodyNode);
        return rigidBodyNode;
    }

    private void addChildrenToGraph(RigidBodyDefinition currentBodyDefinition, MutableNode currentNode, MutableGraph graph) {
        for (JointDefinition childJoint : currentBodyDefinition.getChildrenJoints()) {
            RigidBodyDefinition childBody = childJoint.getSuccessor();
            MutableNode childJointNode = this.createJointNode(childJoint, graph);
            MutableNode childBodyNode = this.createRigidBodyNode(childBody, graph);
            graph.addLink((LinkTarget)currentNode.addLink((LinkTarget)childJointNode));
            graph.addLink((LinkTarget)childJointNode.addLink((LinkTarget)childBodyNode));
            this.addChildrenToGraph(childBody, childBodyNode, graph);
        }
    }

    private MutableNode createJointNode(JointDefinition joint, MutableGraph graph) {
        Object label = this.jointLabelProviders.get(0).getLabel(joint);
        for (int i = 1; i < this.jointLabelProviders.size(); ++i) {
            String additionalLabel = this.jointLabelProviders.get(i).getLabel(joint);
            if (additionalLabel == null) continue;
            label = (String)label + "\n" + additionalLabel;
        }
        MutableNode jointNode = Factory.mutNode((String)label);
        jointNode.add((Attributes)Color.DARKGREEN);
        graph.add((LinkSource)jointNode);
        return jointNode;
    }

    private static String getMatrixLabel(Matrix3DReadOnly matrix) {
        Object ret = EuclidCoreIOTools.getStringOf((String)"/", (String)" \\\\\n", (String)", ", (double[])new double[]{matrix.getM00(), matrix.getM01(), matrix.getM02()});
        ret = (String)ret + EuclidCoreIOTools.getStringOf((String)"|", (String)" |\n", (String)", ", (double[])new double[]{matrix.getM10(), matrix.getM11(), matrix.getM12()});
        ret = (String)ret + EuclidCoreIOTools.getStringOf((String)"\\\\", (String)" /", (String)", ", (double[])new double[]{matrix.getM20(), matrix.getM21(), matrix.getM22()});
        return ret;
    }

    public static interface JointDefinitionLabelProvider {
        public String getLabel(JointDefinition var1);
    }

    public static interface RigidBodyDefinitionLabelProvider {
        public String getLabel(RigidBodyDefinition var1);
    }
}

