/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import controller_msgs.msg.dds.HandJointAnglePacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.function.Consumer;
import us.ihmc.avatar.drcRobot.CommunicationsSyncedRobotModel;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Input;
import us.ihmc.ros2.ROS2NodeInterface;

public class ROS2SyncedRobotModel
extends CommunicationsSyncedRobotModel {
    private final ROS2Input<RobotConfigurationData> robotConfigurationDataInput;
    private final SideDependentList<ROS2Input<HandJointAnglePacket>> handJointAnglePacketInputs = new SideDependentList();

    public ROS2SyncedRobotModel(DRCRobotModel robotModel, ROS2NodeInterface ros2Node) {
        this(robotModel, ros2Node, robotModel.createFullRobotModel());
    }

    public ROS2SyncedRobotModel(DRCRobotModel robotModel, ROS2NodeInterface ros2Node, FullHumanoidRobotModel fullRobotModel) {
        super(robotModel, fullRobotModel, robotModel.getHandModels(), robotModel.getSensorInformation());
        this.robotConfigurationDataInput = new ROS2Input(ros2Node, RobotConfigurationData.class, ROS2Tools.getRobotConfigurationDataTopic((String)robotModel.getSimpleRobotName()), (Object)this.robotConfigurationData, message -> {
            FullRobotModelUtils.checkJointNameHash((int)this.jointNameHash, (int)message.getJointNameHash());
            return true;
        });
        this.robotConfigurationDataInput.addCallback(message -> this.resetDataReceptionTimer());
        for (RobotSide robotSide : RobotSide.values) {
            this.handJointAnglePacketInputs.set((Enum)robotSide, (Object)new ROS2Input(ros2Node, HandJointAnglePacket.class, ROS2Tools.getHandJointAnglePacketTopic((String)robotModel.getSimpleRobotName()), null, message -> robotSide.toByte() == message.getRobotSide()));
        }
    }

    @Override
    public RobotConfigurationData getLatestRobotConfigurationData() {
        return (RobotConfigurationData)this.robotConfigurationDataInput.getLatest();
    }

    @Override
    public HandJointAnglePacket getLatestHandJointAnglePacket(RobotSide robotSide) {
        return (HandJointAnglePacket)((ROS2Input)this.handJointAnglePacketInputs.get((Enum)robotSide)).getLatest();
    }

    public boolean hasReceivedFirstMessage() {
        return this.robotConfigurationDataInput.hasReceivedFirstMessage();
    }

    public void addRobotConfigurationDataReceivedCallback(Runnable callback) {
        this.robotConfigurationDataInput.addCallback(message -> callback.run());
    }

    public void addRobotConfigurationDataReceivedCallback(Consumer<RobotConfigurationData> callback) {
        this.robotConfigurationDataInput.addCallback(callback);
    }

    public void destroy() {
        this.robotConfigurationDataInput.destroy();
    }
}

