/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.ros2.ROS2NodeInterface;

public class ROS2SyncedBufferedRobotModel
extends ROS2SyncedRobotModel {
    public static final int HISTORY_LIMIT = 3000;
    private final ConcurrentLinkedQueue<RobotConfigurationData> robotConfigurationDataBuffer = new ConcurrentLinkedQueue();
    private final RigidBodyTransform interpolatedTransform = new RigidBodyTransform();
    private long monotonicNanos = -1L;
    private RobotConfigurationData nextRobotConfigrationData;

    public ROS2SyncedBufferedRobotModel(DRCRobotModel robotModel, ROS2NodeInterface ros2Node) {
        super(robotModel, ros2Node);
        this.addRobotConfigurationDataReceivedCallback((RobotConfigurationData robotConfigurationData) -> {
            this.robotConfigurationDataBuffer.add((RobotConfigurationData)robotConfigurationData);
            if (this.robotConfigurationDataBuffer.size() > 3000) {
                this.robotConfigurationDataBuffer.remove();
            }
        });
    }

    public void updateToBuffered(long monotonicNanos) {
        this.monotonicNanos = monotonicNanos;
        Iterator<RobotConfigurationData> iterator = this.robotConfigurationDataBuffer.iterator();
        this.robotConfigurationData = iterator.next();
        this.nextRobotConfigrationData = iterator.next();
        while (this.nextRobotConfigrationData.getMonotonicTime() < monotonicNanos) {
            this.robotConfigurationData = this.nextRobotConfigrationData;
            this.nextRobotConfigrationData = iterator.next();
        }
        this.updateInternal();
    }

    public RigidBodyTransformReadOnly interpolatedTransformToWorldFrame(ReferenceFrame referenceFrame) {
        if (this.nextRobotConfigrationData.getMonotonicTime() - this.robotConfigurationData.getMonotonicTime() < 100000L) {
            return referenceFrame.getTransformToWorldFrame();
        }
        this.interpolatedTransform.set(referenceFrame.getTransformToWorldFrame());
        long priorTickTime = this.robotConfigurationData.getMonotonicTime();
        this.robotConfigurationData = this.nextRobotConfigrationData;
        long nextTickTime = this.robotConfigurationData.getMonotonicTime();
        this.updateInternal();
        long queriedTime = this.monotonicNanos - priorTickTime;
        long dt = nextTickTime - priorTickTime;
        long alpha = queriedTime / dt;
        this.interpolatedTransform.interpolate(referenceFrame.getTransformToWorldFrame(), (double)alpha);
        return this.interpolatedTransform;
    }
}

