/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import controller_msgs.msg.dds.HandJointAnglePacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.SpatialVectorMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.HandModelUtils;
import us.ihmc.avatar.handControl.packetsAndConsumers.HandModel;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HandJointName;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.tools.Timer;
import us.ihmc.tools.TimerSnapshot;

public abstract class CommunicationsSyncedRobotModel {
    private DRCRobotModel robotModel;
    private final FullHumanoidRobotModel fullRobotModel;
    private final SideDependentList<HandModel> handModels;
    private final Timer dataReceptionTimer;
    protected RobotConfigurationData robotConfigurationData;
    protected SideDependentList<HandJointAnglePacket> handJointAnglePackets = new SideDependentList();
    private final OneDoFJointBasics[] allJoints;
    private final SideDependentList<HashMap<HandJointName, OneDoFJointBasics>> handJoints = new SideDependentList();
    protected final int jointNameHash;
    private final HumanoidReferenceFrames referenceFrames;
    private final FramePose3D temporaryPoseForQuickReading = new FramePose3D();
    private final ArrayList<SpatialVectorMessage> forceSensorData = new ArrayList();

    public CommunicationsSyncedRobotModel(DRCRobotModel robotModel, FullHumanoidRobotModel fullRobotModel, SideDependentList<HandModel> handModels, HumanoidRobotSensorInformation sensorInformation) {
        this.robotModel = robotModel;
        this.fullRobotModel = fullRobotModel;
        this.handModels = handModels;
        this.robotConfigurationData = new RobotConfigurationData();
        this.referenceFrames = new HumanoidReferenceFrames(fullRobotModel, sensorInformation);
        this.allJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        if (handModels != null) {
            HandModelUtils.getHandJoints(handModels, fullRobotModel, this.handJoints);
        }
        this.jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])this.allJoints, (ForceSensorDefinition[])fullRobotModel.getForceSensorDefinitions(), (IMUDefinition[])fullRobotModel.getIMUDefinitions());
        this.dataReceptionTimer = new Timer();
    }

    public void initializeToDefaultRobotInitialSetup(double groundHeight, double initialYaw, double x, double y) {
        this.robotModel.getDefaultRobotInitialSetup(groundHeight, initialYaw, x, y).initializeFullRobotModel(this.fullRobotModel);
        this.updateFramesForFullRobotModel();
    }

    public abstract RobotConfigurationData getLatestRobotConfigurationData();

    public abstract HandJointAnglePacket getLatestHandJointAnglePacket(RobotSide var1);

    protected synchronized void resetDataReceptionTimer() {
        this.dataReceptionTimer.reset();
    }

    public void update() {
        this.robotConfigurationData = this.getLatestRobotConfigurationData();
        for (RobotSide robotSide : RobotSide.values) {
            this.handJointAnglePackets.set((Enum)robotSide, (Object)this.getLatestHandJointAnglePacket(robotSide));
        }
        if (this.robotConfigurationData != null) {
            this.updateInternal();
        }
    }

    protected void updateInternal() {
        int i;
        this.fullRobotModel.getRootJoint().setJointOrientation((Orientation3DReadOnly)this.robotConfigurationData.getRootOrientation());
        this.fullRobotModel.getRootJoint().setJointPosition((Tuple3DReadOnly)this.robotConfigurationData.getRootPosition());
        for (i = 0; i < this.robotConfigurationData.getJointAngles().size(); ++i) {
            this.allJoints[i].setQ((double)this.robotConfigurationData.getJointAngles().get(i));
            this.allJoints[i].setQd((double)this.robotConfigurationData.getJointVelocities().get(i));
            this.allJoints[i].setTau((double)this.robotConfigurationData.getJointTorques().get(i));
        }
        this.forceSensorData.clear();
        for (i = 0; i < this.robotConfigurationData.getForceSensorData().size(); ++i) {
            SpatialVectorMessage spatialVectorMessage = (SpatialVectorMessage)this.robotConfigurationData.getForceSensorData().get(i);
            this.forceSensorData.add(spatialVectorMessage);
        }
        if (this.handModels != null) {
            HandModelUtils.copyHandJointAnglesFromMessagesToOneDoFJoints(this.handModels, this.handJoints, this.handJointAnglePackets);
        }
        this.updateFramesForFullRobotModel();
    }

    private void updateFramesForFullRobotModel() {
        try {
            this.fullRobotModel.getElevator().updateFramesRecursively();
            this.referenceFrames.updateFrames();
        }
        catch (NotARotationMatrixException e) {
            LogTools.error((String)e.getMessage());
        }
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public HumanoidReferenceFrames getReferenceFrames() {
        return this.referenceFrames;
    }

    public RobotConfigurationData getRobotConfigurationData() {
        return this.robotConfigurationData;
    }

    public ArrayList<SpatialVectorMessage> getForceSensorData() {
        return this.forceSensorData;
    }

    public long getTimestamp() {
        return this.robotConfigurationData.getMonotonicTime();
    }

    public FramePose3DReadOnly getFramePoseReadOnly(Function<HumanoidReferenceFrames, ReferenceFrame> frameSelector) {
        this.temporaryPoseForQuickReading.setFromReferenceFrame(frameSelector.apply(this.referenceFrames));
        return this.temporaryPoseForQuickReading;
    }

    public synchronized TimerSnapshot getDataReceptionTimerSnapshot() {
        return this.dataReceptionTimer.createSnapshot();
    }

    public DRCRobotModel getRobotModel() {
        return this.robotModel;
    }
}

