/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.diagnostics;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingWorker;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.factory.AvatarSimulation;
import us.ihmc.avatar.factory.AvatarSimulationFactory;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.corruptors.FullRobotModelCorruptor;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.FlatGroundEnvironment;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticsWhenHangingControllerState;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticsWhenHangingControllerStateFactory;
import us.ihmc.wholeBodyController.diagnostics.HumanoidDiagnosticsWhenHangingAnalyzer;
import us.ihmc.wholeBodyController.diagnostics.HumanoidJointPoseList;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoEnum;

public class HumanoidDiagnosticsWhenHangingSimulation {
    private final SimulationConstructionSet simulationConstructionSet;
    private final HumanoidDiagnosticsWhenHangingAnalyzer analyzer;
    private final DiagnosticsWhenHangingControllerState controller;
    private final boolean computeTorqueOffsetsBasedOnAverages;

    public HumanoidDiagnosticsWhenHangingSimulation(HumanoidJointPoseList humanoidJointPoseList, boolean useArms, boolean robotIsHanging, DRCRobotModel model, RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup, boolean computeTorqueOffsetsBasedOnAverages) {
        this.computeTorqueOffsetsBasedOnAverages = computeTorqueOffsetsBasedOnAverages;
        FlatGroundEnvironment environment = new FlatGroundEnvironment();
        DRCGuiInitialSetup guiInitialSetup = new DRCGuiInitialSetup(false, false);
        DRCSCSInitialSetup scsInitialSetup = new DRCSCSInitialSetup((CommonAvatarEnvironmentInterface)environment, model.getSimulateDT());
        scsInitialSetup.setRunMultiThreaded(false);
        scsInitialSetup.setInitializeEstimatorToActual(true);
        robotInitialSetup.setInitialGroundHeight(0.0);
        RobotContactPointParameters contactPointParameters = model.getContactPointParameters();
        ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
        ArrayList additionalContactNames = contactPointParameters.getAdditionalContactNames();
        ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionalContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
        }
        HumanoidRobotSensorInformation sensorInformation = model.getSensorInformation();
        SideDependentList footSensorNames = sensorInformation.getFeetForceSensorNames();
        HighLevelControllerParameters highLevelControllerParameters = model.getHighLevelControllerParameters();
        WalkingControllerParameters walkingControllerParameters = model.getWalkingControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = model.getCoPTrajectoryParameters();
        SideDependentList wristForceSensorNames = sensorInformation.getWristForceSensorNames();
        HighLevelHumanoidControllerFactory controllerFactory = new HighLevelHumanoidControllerFactory(contactableBodiesFactory, footSensorNames, wristForceSensorNames, highLevelControllerParameters, walkingControllerParameters, model.getPushRecoveryControllerParameters(), copTrajectoryParameters, model.getSplitFractionCalculatorParameters());
        controllerFactory.useDefaultDoNothingControlState();
        controllerFactory.useDefaultWalkingControlState();
        controllerFactory.addRequestableTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, HighLevelControllerName.WALKING);
        controllerFactory.addRequestableTransition(HighLevelControllerName.WALKING, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        HighLevelControllerName fallbackControllerState = highLevelControllerParameters.getFallbackControllerState();
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, fallbackControllerState);
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.WALKING, fallbackControllerState);
        controllerFactory.setInitialState(HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        DiagnosticsWhenHangingControllerStateFactory diagnosticsWhenHangingControllerStateFactory = new DiagnosticsWhenHangingControllerStateFactory(humanoidJointPoseList, useArms, robotIsHanging, null);
        diagnosticsWhenHangingControllerStateFactory.setTransitionRequested(true);
        controllerFactory.addCustomControlState((HighLevelControllerStateFactory)diagnosticsWhenHangingControllerStateFactory);
        AvatarSimulationFactory avatarSimulationFactory = new AvatarSimulationFactory();
        avatarSimulationFactory.setRobotModel(model);
        avatarSimulationFactory.setShapeCollisionSettings(model.getShapeCollisionSettings());
        avatarSimulationFactory.setHighLevelHumanoidControllerFactory(controllerFactory);
        avatarSimulationFactory.setCommonAvatarEnvironment((CommonAvatarEnvironmentInterface)environment);
        avatarSimulationFactory.setRobotInitialSetup(robotInitialSetup);
        avatarSimulationFactory.setSCSInitialSetup(scsInitialSetup);
        avatarSimulationFactory.setGuiInitialSetup(guiInitialSetup);
        AvatarSimulation avatarSimulation = avatarSimulationFactory.createAvatarSimulation();
        this.simulationConstructionSet = avatarSimulation.getSimulationConstructionSet();
        avatarSimulation.start();
        FullRobotModelCorruptor fullRobotModelCorruptor = avatarSimulation.getFullRobotModelCorruptor();
        if (fullRobotModelCorruptor == null) {
            throw new RuntimeException("This only works with model corruption on. Change DRCControllerThread.ALLOW_MODEL_CORRUPTION to true!");
        }
        this.controller = diagnosticsWhenHangingControllerStateFactory.getController();
        this.analyzer = new HumanoidDiagnosticsWhenHangingAnalyzer(this.simulationConstructionSet, this.controller, fullRobotModelCorruptor);
        UpdateDiagnosticsWhenHangingHelpersButton updateDiagnosticsWhenHangingHelpersButton = new UpdateDiagnosticsWhenHangingHelpersButton(this.analyzer);
        this.simulationConstructionSet.addButton((AbstractButton)updateDiagnosticsWhenHangingHelpersButton);
        OptimizeDiagnosticsWhenHangingHelpersButton optimizeDiagnosticsWhenHangingHelpersButton = new OptimizeDiagnosticsWhenHangingHelpersButton(this.analyzer);
        this.simulationConstructionSet.addButton((AbstractButton)optimizeDiagnosticsWhenHangingHelpersButton);
        CutBufferToDiagnosticsStateButton cutBufferButton = new CutBufferToDiagnosticsStateButton(this.simulationConstructionSet);
        this.simulationConstructionSet.addButton((AbstractButton)cutBufferButton);
        CopyMeasuredTorqueToAppliedTorqueButton copyMeasuredTorqueToAppliedTorqueButton = new CopyMeasuredTorqueToAppliedTorqueButton(this.analyzer);
        this.simulationConstructionSet.addButton((AbstractButton)copyMeasuredTorqueToAppliedTorqueButton);
        this.analyzer.printOutAllCorruptorVariables();
    }

    public SimulationConstructionSet getSimulationConstructionSet() {
        return this.simulationConstructionSet;
    }

    public DiagnosticsWhenHangingControllerState getDiagnosticsWhenHangingController() {
        return this.controller;
    }

    public void updateDataAndComputeTorqueOffsetsBasedOnAverages(boolean computeTorqueOffsetsBasedOnAverages) {
        this.analyzer.updateDataAndComputeTorqueOffsetsBasedOnAverages(computeTorqueOffsetsBasedOnAverages);
    }

    public void setVariablesToOptimize(String[] containsToOptimizeCoM, String[] containsToOptimizeTorqueScores) {
        this.analyzer.setVariablesToOptimize(containsToOptimizeCoM, containsToOptimizeTorqueScores);
    }

    public void rememberCorruptorVariableValues() {
        this.analyzer.rememberCorruptorVariableValues();
    }

    public void restoreCorruptorVariableValues() {
        this.analyzer.restoreCorruptorVariableValues();
    }

    public void setCorruptorVariableValuesToOptimizeToZero() {
        this.analyzer.setCorruptorVariableValuesToOptimizeToZero();
    }

    private class UpdateDiagnosticsWhenHangingHelpersButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -112620995090732618L;
        private final HumanoidDiagnosticsWhenHangingAnalyzer analyzer;

        public UpdateDiagnosticsWhenHangingHelpersButton(HumanoidDiagnosticsWhenHangingAnalyzer analyzer) {
            super("UpdateDiagnostics");
            this.analyzer = analyzer;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.analyzer.updateDataAndComputeTorqueOffsetsBasedOnAverages(HumanoidDiagnosticsWhenHangingSimulation.this.computeTorqueOffsetsBasedOnAverages);
        }
    }

    private class OptimizeDiagnosticsWhenHangingHelpersButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -112620995090732618L;
        private final HumanoidDiagnosticsWhenHangingAnalyzer analyzer;

        public OptimizeDiagnosticsWhenHangingHelpersButton(HumanoidDiagnosticsWhenHangingAnalyzer analyzer) {
            super("Optimize");
            this.analyzer = analyzer;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getText().equals("Optimize")) {
                this.setText("StopOptimize");
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        OptimizeDiagnosticsWhenHangingHelpersButton.this.analyzer.optimizeCorruptorValues(HumanoidDiagnosticsWhenHangingSimulation.this.computeTorqueOffsetsBasedOnAverages);
                        OptimizeDiagnosticsWhenHangingHelpersButton.this.setText("Optimize");
                        return null;
                    }
                };
                worker.execute();
            } else {
                this.analyzer.stopOptimization();
            }
        }
    }

    private class CutBufferToDiagnosticsStateButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -2047087705497963648L;
        private final SimulationConstructionSet simulationConstructionSet;
        private final YoEnum<DiagnosticsWhenHangingControllerState.DiagnosticsWhenHangingState> diagnosticsState;

        public CutBufferToDiagnosticsStateButton(SimulationConstructionSet simulationConstructionSet) {
            super("Cut Buffer");
            this.simulationConstructionSet = simulationConstructionSet;
            this.diagnosticsState = (YoEnum)simulationConstructionSet.findVariable("DiagnosticsState");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.simulationConstructionSet.cropBuffer();
            while (true) {
                this.simulationConstructionSet.gotoInPointNow();
                while (true) {
                    if (this.diagnosticsState.getEnumValue() != DiagnosticsWhenHangingControllerState.DiagnosticsWhenHangingState.CHECK_DIAGNOSTICS) break;
                    if (this.simulationConstructionSet.getCurrentIndex() == this.simulationConstructionSet.getOutPoint()) {
                        return;
                    }
                    this.simulationConstructionSet.tickAndReadFromBuffer(1);
                }
                this.simulationConstructionSet.setInPoint();
                while (true) {
                    if (this.diagnosticsState.getEnumValue() == DiagnosticsWhenHangingControllerState.DiagnosticsWhenHangingState.CHECK_DIAGNOSTICS) {
                        this.simulationConstructionSet.setOutPoint();
                        this.simulationConstructionSet.cutBuffer();
                        break;
                    }
                    if (this.simulationConstructionSet.getCurrentIndex() == this.simulationConstructionSet.getOutPoint()) {
                        this.simulationConstructionSet.cutBuffer();
                        break;
                    }
                    this.simulationConstructionSet.tickAndReadFromBuffer(1);
                }
                this.simulationConstructionSet.setInOutPointFullBuffer();
            }
        }
    }

    private class CopyMeasuredTorqueToAppliedTorqueButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -8720505122426008775L;
        private final HumanoidDiagnosticsWhenHangingAnalyzer analyzer;

        public CopyMeasuredTorqueToAppliedTorqueButton(HumanoidDiagnosticsWhenHangingAnalyzer analyzer) {
            super("CopyMeasuredTorque");
            this.analyzer = analyzer;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            YoBufferProcessor dataProcessingFunction = new YoBufferProcessor(){

                public void process(int startIndex, int endIndex, int currentIndex) {
                    CopyMeasuredTorqueToAppliedTorqueButton.this.analyzer.copyMeasuredTorqueToAppliedTorque();
                }

                public void initialize(YoVariableHolder yoVariableHolder) {
                }
            };
            HumanoidDiagnosticsWhenHangingSimulation.this.simulationConstructionSet.applyDataProcessingFunction(dataProcessingFunction);
        }
    }
}

