/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.colorVision;

import ihmc_common_msgs.msg.dds.InstantMessage;
import java.time.Instant;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_calib3d;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_cudaimgproc;
import org.bytedeco.opencv.global.opencv_cudawarping;
import org.bytedeco.opencv.opencv_core.GpuMat;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.spinnaker.Spinnaker_C.spinImage;
import perception_msgs.msg.dds.ImageMessage;
import us.ihmc.avatar.colorVision.DualBlackflyComms;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.property.ROS2StoredPropertySet;
import us.ihmc.communication.ros2.ROS2Helper;
import us.ihmc.communication.ros2.ROS2IOTopicPair;
import us.ihmc.communication.ros2.ROS2PublishSubscribeAPI;
import us.ihmc.communication.ros2.ROS2TunedRigidBodyTransform;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.perception.BytedecoImage;
import us.ihmc.perception.CameraModel;
import us.ihmc.perception.comms.ImageMessageFormat;
import us.ihmc.perception.cuda.CUDAImageEncoder;
import us.ihmc.perception.opencv.OpenCVArUcoMarkerDetection;
import us.ihmc.perception.opencv.OpenCVArUcoMarkerROS2Publisher;
import us.ihmc.perception.parameters.IntrinsicCameraMatrixProperties;
import us.ihmc.perception.sceneGraph.arUco.ArUcoSceneTools;
import us.ihmc.perception.sceneGraph.ros2.ROS2SceneGraph;
import us.ihmc.perception.sensorHead.BlackflyLensProperties;
import us.ihmc.perception.sensorHead.SensorHeadParameters;
import us.ihmc.perception.spinnaker.SpinnakerBlackfly;
import us.ihmc.perception.tools.ImageMessageDataPacker;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.Timer;
import us.ihmc.tools.property.StoredPropertySetBasics;
import us.ihmc.tools.time.FrequencyCalculator;

public class DualBlackflyCamera {
    private static final boolean ENABLE_ARUCO_MARKER_DETECTION = true;
    private static final boolean DEBUG_SHUTDOWN = false;
    private final RobotSide side;
    private final Supplier<HumanoidReferenceFrames> humanoidReferenceFramesSupplier;
    private final FramePose3D cameraPose = new FramePose3D();
    private final ROS2Helper ros2Helper;
    private SpinnakerBlackfly spinnakerBlackfly;
    private final BlackflyLensProperties blackflyLensProperties;
    private final ROS2SceneGraph sceneGraph;
    private final FrequencyCalculator readFrequencyCalculator = new FrequencyCalculator();
    private final Timer printCameraReadRateTimer = new Timer();
    private final ROS2StoredPropertySet<IntrinsicCameraMatrixProperties> ousterFisheyeColoringIntrinsicsROS2;
    private final IntrinsicCameraMatrixProperties ousterFisheyeColoringIntrinsics;
    private final MutableReferenceFrame blackflyFrameForSceneNodeUpdate = new MutableReferenceFrame();
    private OpenCVArUcoMarkerDetection arUcoMarkerDetection;
    private OpenCVArUcoMarkerROS2Publisher arUcoMarkerPublisher;
    private final ROS2TunedRigidBodyTransform remoteTunableCameraTransform;
    private final AtomicReference<Instant> spinImageAcquisitionTime = new AtomicReference();
    private final ImageMessage imageMessage = new ImageMessage();
    private final IHMCROS2Publisher<ImageMessage> ros2ImagePublisher;
    private long imageMessageSequenceNumber = 0L;
    private final CUDAImageEncoder cudaImageEncoder;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private long imageFrameSize = 0L;
    private GpuMat distortedRGBImage;
    private GpuMat undistortedImage;
    private BytedecoImage undistortedBytedecoImage;
    private GpuMat undistortionMap1;
    private GpuMat undistortionMap2;
    private GpuMat sourceImageBeingUsedForProcessing;
    private GpuMat sourceImageBeingUsedForUndistortion;
    private final LinkedList<GpuMat> receivedImagesDeque = new LinkedList();
    private final Object newImageReadNotifier = new Object();
    private final Object encodingCompletionNotifier = new Object();
    private final Object undistortionCompletionNotifier = new Object();
    private long numberOfGpuMatsAllocated = 0L;
    private long numberOfGpuMatsDeallocated = 0L;
    private final Thread cameraReadThread;
    private final Thread imageEncodeAndPublishThread;
    private final Thread imageUndistortAndUpdateArUcoThread;
    private final Thread imageDeallocationThread;
    private volatile boolean destroyed = false;

    public DualBlackflyCamera(DRCRobotModel robotModel, RobotSide side, Supplier<HumanoidReferenceFrames> referenceFramesSupplier, ROS2Node ros2Node, SpinnakerBlackfly spinnakerBlackfly, BlackflyLensProperties blackflyLensProperties, ROS2SceneGraph sceneGraph) {
        this.side = side;
        this.humanoidReferenceFramesSupplier = referenceFramesSupplier;
        this.spinnakerBlackfly = spinnakerBlackfly;
        this.blackflyLensProperties = blackflyLensProperties;
        this.ousterFisheyeColoringIntrinsics = SensorHeadParameters.loadOusterFisheyeColoringIntrinsicsOnRobot((BlackflyLensProperties)blackflyLensProperties);
        this.sceneGraph = sceneGraph;
        ROS2Topic imageTopic = (ROS2Topic)PerceptionAPI.BLACKFLY_FISHEYE_COLOR_IMAGE.get((Enum)side);
        this.ros2ImagePublisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, (ROS2Topic)imageTopic, (ROS2QosProfile)ROS2QosProfile.BEST_EFFORT());
        this.ros2Helper = new ROS2Helper((ROS2NodeInterface)ros2Node);
        this.cudaImageEncoder = new CUDAImageEncoder();
        this.ousterFisheyeColoringIntrinsicsROS2 = new ROS2StoredPropertySet((ROS2PublishSubscribeAPI)this.ros2Helper, DualBlackflyComms.OUSTER_FISHEYE_COLORING_INTRINSICS, (StoredPropertySetBasics)this.ousterFisheyeColoringIntrinsics);
        RigidBodyTransform cameraTransformToParent = robotModel.getSensorInformation().getSituationalAwarenessCameraTransform(side);
        this.remoteTunableCameraTransform = ROS2TunedRigidBodyTransform.toBeTuned((ROS2PublishSubscribeAPI)this.ros2Helper, (ROS2IOTopicPair)((ROS2IOTopicPair)PerceptionAPI.SITUATIONAL_AWARENESS_CAMERA_TO_PARENT_TUNING.get((Enum)side)), (RigidBodyTransform)cameraTransformToParent);
        this.cameraReadThread = new Thread(() -> {
            this.printCameraReadRateTimer.reset();
            while (!this.destroyed) {
                this.cameraRead();
                this.readFrequencyCalculator.ping();
                if (this.printCameraReadRateTimer.getElapsedTime() > 10.0) {
                    LogTools.info((String)(side + " Blackfly reading at " + String.format("%.2f", this.getReadFrequency()) + "hz"));
                    this.printCameraReadRateTimer.reset();
                }
                Object object = this.newImageReadNotifier;
                synchronized (object) {
                    this.newImageReadNotifier.notifyAll();
                }
            }
        }, "SpinnakerCameraRead");
        this.imageEncodeAndPublishThread = new Thread(() -> {
            while (!this.destroyed) {
                try {
                    Object object = this.newImageReadNotifier;
                    synchronized (object) {
                        this.newImageReadNotifier.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    LogTools.error((Object)interruptedException);
                }
                this.imageProcessAndPublish();
            }
        }, "SpinnakerImageEncodeAndPublish");
        this.imageUndistortAndUpdateArUcoThread = new Thread(() -> {
            while (!this.destroyed) {
                try {
                    Object object = this.newImageReadNotifier;
                    synchronized (object) {
                        this.newImageReadNotifier.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    LogTools.error((Object)interruptedException);
                }
                this.undistortImageAndUpdateArUco();
            }
        }, "SpinnakerImageUndistortAndUpdateArUco");
        this.imageDeallocationThread = new Thread(() -> {
            block8: while (!this.destroyed) {
                GpuMat oldestGpuMat;
                try {
                    Object object = this.encodingCompletionNotifier;
                    synchronized (object) {
                        this.encodingCompletionNotifier.wait(500L);
                    }
                    object = this.undistortionCompletionNotifier;
                    synchronized (object) {
                        this.undistortionCompletionNotifier.wait(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    LogTools.error((Object)interruptedException);
                }
                if ((oldestGpuMat = this.receivedImagesDeque.peekFirst()) == null) continue;
                while (!oldestGpuMat.equals((Object)this.sourceImageBeingUsedForProcessing) && !oldestGpuMat.equals((Object)this.sourceImageBeingUsedForUndistortion)) {
                    GpuMat gpuMat = this.receivedImagesDeque.pollFirst();
                    gpuMat.release();
                    gpuMat.close();
                    ++this.numberOfGpuMatsDeallocated;
                    oldestGpuMat = this.receivedImagesDeque.peekFirst();
                    if (oldestGpuMat != null) continue;
                    continue block8;
                }
            }
        }, "SpinnakerImageDeallocation");
        this.cameraReadThread.start();
        this.imageEncodeAndPublishThread.start();
        this.imageUndistortAndUpdateArUcoThread.start();
        this.imageDeallocationThread.start();
    }

    private void initialize(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.imageFrameSize = (long)imageWidth * (long)imageHeight;
        LogTools.info((String)"Blackfly {} resolution detected: {} x {}", (Object)this.spinnakerBlackfly.getSerialNumber(), (Object)imageWidth, (Object)imageHeight);
        this.distortedRGBImage = new GpuMat(imageWidth, imageHeight, opencv_core.CV_8UC3);
        this.undistortedImage = new GpuMat(imageWidth, imageHeight, opencv_core.CV_8UC3);
        this.undistortedBytedecoImage = new BytedecoImage(imageWidth, imageHeight, opencv_core.CV_8UC3);
        this.initializeImageUndistortion();
    }

    private void initializeImageUndistortion() {
        Mat cameraMatrix = new Mat(3, 3, 6);
        opencv_core.setIdentity((Mat)cameraMatrix);
        cameraMatrix.ptr(0, 0).putDouble(this.blackflyLensProperties.getFocalLengthXForUndistortion());
        cameraMatrix.ptr(1, 1).putDouble(this.blackflyLensProperties.getFocalLengthYForUndistortion());
        cameraMatrix.ptr(0, 2).putDouble(this.blackflyLensProperties.getPrincipalPointXForUndistortion());
        cameraMatrix.ptr(1, 2).putDouble(this.blackflyLensProperties.getPrincipalPointYForUndistortion());
        Mat newCameraMatrixEstimate = new Mat(3, 3, 6);
        opencv_core.setIdentity((Mat)newCameraMatrixEstimate);
        Mat distortionCoefficients = new Mat(new double[]{this.blackflyLensProperties.getK1ForUndistortion(), this.blackflyLensProperties.getK2ForUndistortion(), this.blackflyLensProperties.getK3ForUndistortion(), this.blackflyLensProperties.getK4ForUndistortion()});
        Size sourceImageSize = new Size(this.imageWidth, this.imageHeight);
        Size undistortedImageSize = new Size((int)(1.6 * (double)this.imageWidth), (int)(1.6 * (double)this.imageHeight));
        Mat rectificationTransformation = new Mat(3, 3, 6);
        opencv_core.setIdentity((Mat)rectificationTransformation);
        double balanceNewFocalLength = 0.0;
        double fovScaleFocalLengthDivisor = 1.0;
        opencv_calib3d.fisheyeEstimateNewCameraMatrixForUndistortRectify((Mat)cameraMatrix, (Mat)distortionCoefficients, (Size)sourceImageSize, (Mat)rectificationTransformation, (Mat)newCameraMatrixEstimate, (double)balanceNewFocalLength, (Size)undistortedImageSize, (double)fovScaleFocalLengthDivisor);
        Mat tempUndistortionMat1 = new Mat();
        Mat tempUndistortionMat2 = new Mat();
        opencv_calib3d.fisheyeInitUndistortRectifyMap((Mat)cameraMatrix, (Mat)distortionCoefficients, (Mat)rectificationTransformation, (Mat)newCameraMatrixEstimate, (Size)undistortedImageSize, (int)5, (Mat)tempUndistortionMat1, (Mat)tempUndistortionMat2);
        this.undistortionMap1 = new GpuMat();
        this.undistortionMap1.upload(tempUndistortionMat1);
        this.undistortionMap2 = new GpuMat();
        this.undistortionMap2.upload(tempUndistortionMat2);
        this.arUcoMarkerDetection = new OpenCVArUcoMarkerDetection();
        this.arUcoMarkerDetection.create(this.blackflyFrameForSceneNodeUpdate.getReferenceFrame());
        this.arUcoMarkerDetection.setSourceImageForDetection(this.undistortedBytedecoImage);
        newCameraMatrixEstimate.copyTo(this.arUcoMarkerDetection.getCameraMatrix());
        this.arUcoMarkerPublisher = new OpenCVArUcoMarkerROS2Publisher(this.arUcoMarkerDetection, (ROS2PublishSubscribeAPI)this.ros2Helper, this.sceneGraph.getArUcoMarkerIDToNodeMap());
        tempUndistortionMat2.close();
        tempUndistortionMat1.close();
        rectificationTransformation.close();
        undistortedImageSize.close();
        sourceImageSize.close();
        distortionCoefficients.close();
        newCameraMatrixEstimate.close();
        cameraMatrix.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cameraRead() {
        spinImage spinImage2 = new spinImage();
        this.spinnakerBlackfly.getNextImage(spinImage2);
        MutableReferenceFrame mutableReferenceFrame = this.blackflyFrameForSceneNodeUpdate;
        synchronized (mutableReferenceFrame) {
            this.blackflyFrameForSceneNodeUpdate.update(transformToParent -> transformToParent.set(this.humanoidReferenceFramesSupplier.get().getSituationalAwarenessCameraFrame(this.side).getTransformToWorldFrame()));
        }
        mutableReferenceFrame = this.cameraPose;
        synchronized (mutableReferenceFrame) {
            this.cameraPose.setToZero(this.humanoidReferenceFramesSupplier.get().getSituationalAwarenessCameraFrame(this.side));
            this.cameraPose.changeFrame(ReferenceFrame.getWorldFrame());
        }
        if (this.imageWidth == 0 || this.imageHeight == 0) {
            this.initialize(this.spinnakerBlackfly.getWidth(spinImage2), this.spinnakerBlackfly.getHeight(spinImage2));
        }
        BytePointer spinImageData = new BytePointer(this.imageFrameSize);
        this.spinnakerBlackfly.setPointerToSpinImageData(spinImage2, (Pointer)spinImageData);
        BytedecoImage sourceBytedecoImage = new BytedecoImage(this.imageWidth, this.imageHeight, opencv_core.CV_8UC1);
        sourceBytedecoImage.changeAddress(spinImageData.address());
        GpuMat deviceSourceImage = new GpuMat(this.imageWidth, this.imageHeight, opencv_core.CV_8UC1);
        deviceSourceImage.upload(sourceBytedecoImage.getBytedecoOpenCVMat());
        GpuMat latestImageSetter = new GpuMat(this.imageWidth, this.imageHeight, opencv_core.CV_8UC3);
        opencv_cudaimgproc.cvtColor((GpuMat)deviceSourceImage, (GpuMat)latestImageSetter, (int)46);
        this.receivedImagesDeque.offerLast(latestImageSetter);
        if (this.numberOfGpuMatsAllocated - this.numberOfGpuMatsDeallocated > 100L) {
            throw new RuntimeException("GpuMats are not being released in time");
        }
        ++this.numberOfGpuMatsAllocated;
        this.spinImageAcquisitionTime.set(Instant.now());
        deviceSourceImage.release();
        deviceSourceImage.close();
        spinImageData.close();
        this.spinnakerBlackfly.releaseImage(spinImage2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imageProcessAndPublish() {
        this.sourceImageBeingUsedForProcessing = this.receivedImagesDeque.peekLast();
        Instant spinImageAcquisitionTime = this.spinImageAcquisitionTime.get();
        if (this.sourceImageBeingUsedForProcessing == null || spinImageAcquisitionTime == null) {
            return;
        }
        this.remoteTunableCameraTransform.update();
        BytePointer jpegImageBytePointer = new BytePointer(this.imageFrameSize);
        this.cudaImageEncoder.encodeBGR(this.sourceImageBeingUsedForProcessing.data(), jpegImageBytePointer, this.imageWidth, this.imageHeight, this.sourceImageBeingUsedForProcessing.step());
        Object object = this.encodingCompletionNotifier;
        synchronized (object) {
            this.encodingCompletionNotifier.notify();
        }
        this.ousterFisheyeColoringIntrinsicsROS2.updateAndPublishThrottledStatus();
        ImageMessageDataPacker compressedImageDataPacker = new ImageMessageDataPacker(jpegImageBytePointer.limit());
        compressedImageDataPacker.pack(this.imageMessage, jpegImageBytePointer);
        MessageTools.toMessage((Instant)spinImageAcquisitionTime, (InstantMessage)this.imageMessage.getAcquisitionTime());
        this.imageMessage.setImageWidth(this.imageWidth);
        this.imageMessage.setImageHeight(this.imageHeight);
        this.imageMessage.setFocalLengthXPixels((float)this.ousterFisheyeColoringIntrinsics.getFocalLengthX());
        this.imageMessage.setFocalLengthYPixels((float)this.ousterFisheyeColoringIntrinsics.getFocalLengthY());
        this.imageMessage.setPrincipalPointXPixels((float)this.ousterFisheyeColoringIntrinsics.getPrinciplePointX());
        this.imageMessage.setPrincipalPointYPixels((float)this.ousterFisheyeColoringIntrinsics.getPrinciplePointY());
        CameraModel.EQUIDISTANT_FISHEYE.packMessageFormat(this.imageMessage);
        this.imageMessage.setSequenceNumber(this.imageMessageSequenceNumber++);
        ImageMessageFormat.COLOR_JPEG_BGR8.packMessageFormat(this.imageMessage);
        FramePose3D framePose3D = this.cameraPose;
        synchronized (framePose3D) {
            this.imageMessage.getPosition().set((Tuple3DReadOnly)this.cameraPose.getTranslation());
            this.imageMessage.getOrientation().set((QuaternionReadOnly)this.cameraPose.getRotation());
        }
        this.ros2ImagePublisher.publish((Object)this.imageMessage);
        jpegImageBytePointer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undistortImageAndUpdateArUco() {
        this.sourceImageBeingUsedForUndistortion = this.receivedImagesDeque.peekLast();
        if (this.sourceImageBeingUsedForUndistortion == null) {
            return;
        }
        opencv_cudaimgproc.cvtColor((GpuMat)this.sourceImageBeingUsedForUndistortion, (GpuMat)this.distortedRGBImage, (int)4);
        Object object = this.undistortionCompletionNotifier;
        synchronized (object) {
            this.undistortionCompletionNotifier.notify();
        }
        opencv_cudawarping.remap((GpuMat)this.distortedRGBImage, (GpuMat)this.undistortedImage, (GpuMat)this.undistortionMap1, (GpuMat)this.undistortionMap2, (int)1);
        this.undistortedImage.download(this.undistortedBytedecoImage.getBytedecoOpenCVMat());
        if (this.side == RobotSide.RIGHT) {
            this.arUcoMarkerDetection.update();
            this.arUcoMarkerPublisher.update();
            this.sceneGraph.updateSubscription();
            ArUcoSceneTools.updateSceneGraph((OpenCVArUcoMarkerDetection)this.arUcoMarkerDetection, (ROS2SceneGraph)this.sceneGraph);
            object = this.blackflyFrameForSceneNodeUpdate;
            synchronized (object) {
                this.sceneGraph.updateOnRobotOnly(this.blackflyFrameForSceneNodeUpdate.getReferenceFrame());
            }
            this.sceneGraph.updatePublication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        Object object = this.encodingCompletionNotifier;
        synchronized (object) {
            this.encodingCompletionNotifier.notify();
        }
        object = this.undistortionCompletionNotifier;
        synchronized (object) {
            this.undistortionCompletionNotifier.notify();
        }
        try {
            this.cameraReadThread.join();
            this.imageEncodeAndPublishThread.join();
            this.imageUndistortAndUpdateArUcoThread.join();
            this.imageDeallocationThread.join();
        }
        catch (InterruptedException interruptedException) {
            LogTools.error((Object)interruptedException);
        }
        this.cudaImageEncoder.destroy();
        if (this.spinnakerBlackfly != null) {
            this.spinnakerBlackfly.stopAcquiringImages();
        }
        if (this.arUcoMarkerDetection != null) {
            this.arUcoMarkerDetection.destroy();
        }
        this.spinnakerBlackfly = null;
        this.arUcoMarkerDetection = null;
    }

    public double getReadFrequency() {
        return this.readFrequencyCalculator.getFrequency();
    }
}

