/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.colorVision;

import us.ihmc.avatar.colorVision.DualBlackflyCamera;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.ros2.ROS2Helper;
import us.ihmc.communication.ros2.ROS2PublishSubscribeAPI;
import us.ihmc.log.LogTools;
import us.ihmc.perception.sceneGraph.ros2.ROS2SceneGraph;
import us.ihmc.perception.sensorHead.BlackflyLensProperties;
import us.ihmc.perception.spinnaker.SpinnakerBlackfly;
import us.ihmc.perception.spinnaker.SpinnakerBlackflyManager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.thread.Throttler;

public class DualBlackflyAndAruCoMarkerOnRobotProcess {
    private static final String LEFT_SERIAL_NUMBER = System.getProperty("blackfly.left.serial.number", "00000000");
    private static final String RIGHT_SERIAL_NUMBER = System.getProperty("blackfly.right.serial.number", "00000000");
    private final DRCRobotModel robotModel;
    private final ROS2SceneGraph sceneGraph;
    private final BlackflyLensProperties blackflyLensProperties;
    private final ROS2Node ros2Node;
    private final ROS2SyncedRobotModel syncedRobot;
    private final Thread syncedRobotUpdateThread;
    private final SpinnakerBlackflyManager spinnakerBlackflyManager = new SpinnakerBlackflyManager();
    private final SideDependentList<DualBlackflyCamera> dualBlackflyCameras = new SideDependentList();
    private volatile boolean running = true;

    public DualBlackflyAndAruCoMarkerOnRobotProcess(DRCRobotModel robotModel, BlackflyLensProperties blackflyLensProperties) {
        DualBlackflyCamera dualBlackflyCamera;
        SpinnakerBlackfly spinnakerBlackfly;
        this.robotModel = robotModel;
        this.blackflyLensProperties = blackflyLensProperties;
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"blackfly_node");
        this.syncedRobot = new ROS2SyncedRobotModel(robotModel, (ROS2NodeInterface)this.ros2Node);
        this.syncedRobot.initializeToDefaultRobotInitialSetup(0.0, 0.0, 0.0, 0.0);
        this.sceneGraph = new ROS2SceneGraph((ROS2PublishSubscribeAPI)new ROS2Helper((ROS2NodeInterface)this.ros2Node));
        if (!LEFT_SERIAL_NUMBER.equals("00000000")) {
            LogTools.info((String)"Adding Blackfly left with serial number: {}", (Object)LEFT_SERIAL_NUMBER);
            spinnakerBlackfly = this.spinnakerBlackflyManager.createSpinnakerBlackfly(LEFT_SERIAL_NUMBER);
            dualBlackflyCamera = this.createDualBlackflyCamera(RobotSide.LEFT, spinnakerBlackfly);
            this.dualBlackflyCameras.set((Enum)RobotSide.LEFT, (Object)dualBlackflyCamera);
        } else {
            LogTools.warn((String)"No serial number for left Blackfly specified. The sensor will not be available.");
        }
        if (!RIGHT_SERIAL_NUMBER.equals("00000000")) {
            LogTools.info((String)"Adding Blackfly right with serial number: {}", (Object)RIGHT_SERIAL_NUMBER);
            spinnakerBlackfly = this.spinnakerBlackflyManager.createSpinnakerBlackfly(RIGHT_SERIAL_NUMBER);
            dualBlackflyCamera = this.createDualBlackflyCamera(RobotSide.RIGHT, spinnakerBlackfly);
            this.dualBlackflyCameras.set((Enum)RobotSide.RIGHT, (Object)dualBlackflyCamera);
        } else {
            LogTools.warn((String)"No serial number for right Blackfly specified. The sensor will not be available.");
        }
        this.syncedRobotUpdateThread = new Thread(() -> {
            double highestFrequency = 0.0;
            Throttler throttler = new Throttler();
            while (this.running) {
                for (DualBlackflyCamera dualBlackflyCamera : this.dualBlackflyCameras.values()) {
                    highestFrequency = Math.max(20.0, Math.max(highestFrequency, dualBlackflyCamera.getReadFrequency()));
                }
                throttler.setFrequency(highestFrequency);
                throttler.waitAndRun();
                this.syncedRobot.update();
            }
        }, "ROS2SyncedRobotModel-update-thread");
        this.syncedRobotUpdateThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(this::destroy, this.getClass().getName() + "-Shutdown"));
    }

    private DualBlackflyCamera createDualBlackflyCamera(RobotSide side, SpinnakerBlackfly spinnakerBlackfly) {
        return new DualBlackflyCamera(this.robotModel, side, this.syncedRobot::getReferenceFrames, this.ros2Node, spinnakerBlackfly, this.blackflyLensProperties, this.sceneGraph);
    }

    private void destroy() {
        this.running = false;
        try {
            this.syncedRobotUpdateThread.join();
        }
        catch (InterruptedException e) {
            LogTools.error((Object)e);
        }
        System.out.println("Destroying dual blackfly processes");
        for (DualBlackflyCamera dualBlackflyCamera : this.dualBlackflyCameras) {
            if (dualBlackflyCamera == null) continue;
            dualBlackflyCamera.destroy();
        }
        this.spinnakerBlackflyManager.destroy();
        this.ros2Node.destroy();
    }
}

