/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import controller_msgs.msg.dds.FootstepDataListMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import us.ihmc.avatar.stepAdjustment.PlanarRegionFootstepPlanSnapper;
import us.ihmc.avatar.stepAdjustment.PlanarRegionSnapVisualizer;
import us.ihmc.avatar.stepAdjustment.SimpleSteppableRegionsCalculator;
import us.ihmc.commonWalkingControlModules.configurations.SteppingEnvironmentalConstraintParameters;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.YoSteppingEnvironmentalConstraintParameters;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepPlanAdjustment;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepValidityIndicator;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.footstepPlanning.graphSearch.collision.BoundingBoxCollisionDetector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PlanarRegionsListCommand;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class HumanoidSteppingPluginEnvironmentalConstraints
implements Consumer<PlanarRegionsListCommand>,
Updatable {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
    private final YoBoolean shouldSnapToRegions;
    private final YoBoolean checkFootHeightInWorld;
    private final YoBoolean checkFootHeightDelta;
    private final YoBoolean checkStepLengthIsStupid;
    private final YoInteger numberOfSteppableRegions;
    private final SteppingParameters steppingParameters;
    private final SteppingEnvironmentalConstraintParameters environmentalConstraintParameters;
    private final PlanarRegionFootstepPlanSnapper stepSnapper;
    private final List<FootstepValidityIndicator> footstepValidityIndicators = new ArrayList<FootstepValidityIndicator>();
    private final BoundingBoxCollisionDetector collisionDetector;
    private final SimpleSteppableRegionsCalculator steppableRegionsCalculator;
    private final PlanarRegionSnapVisualizer snapVisualizer;
    private final FramePoint3D pointInRegion = new FramePoint3D();

    public HumanoidSteppingPluginEnvironmentalConstraints(RobotContactPointParameters<RobotSide> contactPointParameters, SteppingParameters steppingParameters, SteppingEnvironmentalConstraintParameters environmentalConstraintParameters) {
        this.steppingParameters = steppingParameters;
        this.environmentalConstraintParameters = new YoSteppingEnvironmentalConstraintParameters(environmentalConstraintParameters, this.registry);
        this.steppableRegionsCalculator = new SimpleSteppableRegionsCalculator(() -> ((SteppingEnvironmentalConstraintParameters)this.environmentalConstraintParameters).getMinPlanarRegionAreaForStepping(), () -> ((SteppingEnvironmentalConstraintParameters)this.environmentalConstraintParameters).getMaxPlanarRegionNormalAngleForStepping());
        this.shouldSnapToRegions = new YoBoolean("shouldSnapToRegions", this.registry);
        this.checkFootHeightInWorld = new YoBoolean("checkFootHeightInWorld", this.registry);
        this.checkFootHeightDelta = new YoBoolean("checkFootHeightDelta", this.registry);
        this.checkStepLengthIsStupid = new YoBoolean("checkStepLengthIsStupid", this.registry);
        this.numberOfSteppableRegions = new YoInteger("numberOfSteppableRegions", this.registry);
        this.checkFootHeightDelta.set(true);
        this.checkFootHeightInWorld.set(false);
        this.checkStepLengthIsStupid.set(true);
        SideDependentList footPolygons = new SideDependentList();
        for (RobotSide robotSide : RobotSide.values) {
            ArrayList footPoints = (ArrayList)contactPointParameters.getFootContactPoints().get((Enum)robotSide);
            footPolygons.put((Enum)robotSide, (Object)new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)footPoints)));
        }
        this.stepSnapper = new PlanarRegionFootstepPlanSnapper(footPolygons, this.steppableRegionsCalculator, this.environmentalConstraintParameters, this.registry){

            @Override
            public void adjustFootstepPlan(FramePose3DReadOnly stanceFootPose, int stepIndexToStart, FootstepDataListMessage dataListToSnap) {
                if (!HumanoidSteppingPluginEnvironmentalConstraints.this.shouldSnapToRegions.getValue()) {
                    return;
                }
                super.adjustFootstepPlan(stanceFootPose, stepIndexToStart, dataListToSnap);
            }
        };
        this.snapVisualizer = new PlanarRegionSnapVisualizer(this.registry, this.graphicsListRegistry);
        this.stepSnapper.attachPlanarRegionSnapVisualizer(this.snapVisualizer);
        double collisionBoxDepth = 0.65;
        double collisionBoxWidth = 1.15;
        double collisionBoxHeight = 1.0;
        this.collisionDetector = new BoundingBoxCollisionDetector();
        this.collisionDetector.setBoxDimensions(collisionBoxDepth, collisionBoxWidth, collisionBoxHeight);
        this.footstepValidityIndicators.add(this::isSafeStepHeight);
        this.footstepValidityIndicators.add(this::isFootHeightRight);
        this.footstepValidityIndicators.add(this::isStepLengthStupid);
    }

    public void setShouldSnapToRegions(boolean shouldSnapToRegions) {
        this.shouldSnapToRegions.set(shouldSnapToRegions);
    }

    public void update(double timeInState) {
        this.snapVisualizer.reset();
    }

    @Override
    public void accept(PlanarRegionsListCommand planarRegionsListCommand) {
        this.steppableRegionsCalculator.consume(planarRegionsListCommand);
        this.numberOfSteppableRegions.set(this.steppableRegionsCalculator.getSteppableRegions().size());
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getGraphicsListRegistry() {
        return this.graphicsListRegistry;
    }

    public FootstepPlanAdjustment getFootstepPlanAdjustment() {
        return this.stepSnapper;
    }

    public List<FootstepValidityIndicator> getFootstepValidityIndicators() {
        return this.footstepValidityIndicators;
    }

    private boolean isSafeStepHeight(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (!this.checkFootHeightDelta.getBooleanValue()) {
            return true;
        }
        double heightChange = touchdownPose.getZ() - stancePose.getZ();
        return heightChange < this.steppingParameters.getMaxStepUp() && heightChange > -this.steppingParameters.getMaxStepDown();
    }

    private boolean isStepLengthStupid(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (!this.checkStepLengthIsStupid.getValue()) {
            return true;
        }
        return touchdownPose.getPosition().distanceXY(stancePose.getPosition()) < 1.2 * this.steppingParameters.getMaxStepLength();
    }

    private boolean isFootHeightRight(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (!this.checkFootHeightInWorld.getValue() || !this.shouldSnapToRegions.getValue()) {
            return true;
        }
        double heightAtPoint = Double.MIN_VALUE;
        for (int i = 0; i < this.steppableRegionsCalculator.getSteppableRegions().size(); ++i) {
            this.pointInRegion.set((FrameTuple3DReadOnly)touchdownPose.getPosition());
            PlanarRegion region = this.steppableRegionsCalculator.getSteppableRegions().get(i);
            region.transformFromWorldToLocal((Transformable)this.pointInRegion);
            if (!region.isPointInside(this.pointInRegion.getX(), this.pointInRegion.getY())) continue;
            heightAtPoint = Math.max(this.steppableRegionsCalculator.getSteppableRegions().get(i).getPlaneZGivenXY(touchdownPose.getX(), touchdownPose.getY()), heightAtPoint);
        }
        if (!Double.isFinite(heightAtPoint)) {
            heightAtPoint = stancePose.getZ();
        }
        return MathTools.epsilonEquals((double)heightAtPoint, (double)touchdownPose.getZ(), (double)0.03);
    }

    private boolean isSafeDistanceFromObstacle(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (this.steppableRegionsCalculator.getSteppableRegions().isEmpty() || !this.shouldSnapToRegions.getValue()) {
            return true;
        }
        double halfStanceWidth = 0.5 * this.steppingParameters.getInPlaceWidth();
        double heightOffset = this.steppingParameters.getMaxStepUp();
        double soleYaw = touchdownPose.getYaw();
        double lateralOffset = swingSide.negateIfLeftSide(halfStanceWidth);
        double offsetX = -lateralOffset * Math.sin(soleYaw);
        double offsetY = lateralOffset * Math.cos(soleYaw);
        this.collisionDetector.setBoxPose(touchdownPose.getX() + offsetX, touchdownPose.getY() + offsetY, touchdownPose.getZ() + heightOffset, soleYaw);
        return this.collisionDetector.checkForCollision() == null;
    }
}

