/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.AvatarControllerThreadInterface;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.CrossRobotCommandResolver;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.time.ThreadTimer;
import us.ihmc.yoVariables.variable.YoLong;

public class ControllerTask
extends HumanoidRobotControlTask {
    private final CrossRobotCommandResolver controllerResolver;
    private final CrossRobotCommandResolver masterResolver;
    private final AvatarControllerThreadInterface controllerThread;
    private final long divisor;
    private final ThreadTimer timer;
    private final YoLong ticksBehindScheduled;
    protected final List<Runnable> postControllerCallbacks = new ArrayList<Runnable>();
    protected final List<Runnable> schedulerThreadRunnables = new ArrayList<Runnable>();

    public ControllerTask(String prefix, AvatarControllerThreadInterface controllerThread, long divisor, double schedulerDt, FullHumanoidRobotModel masterFullRobotModel) {
        super(divisor);
        this.divisor = divisor;
        this.controllerThread = controllerThread;
        this.controllerResolver = new CrossRobotCommandResolver(controllerThread.getFullRobotModel());
        this.masterResolver = new CrossRobotCommandResolver(masterFullRobotModel);
        this.timer = new ThreadTimer(prefix, schedulerDt * (double)divisor, controllerThread.getYoVariableRegistry());
        this.ticksBehindScheduled = new YoLong(prefix + "TicksBehindScheduled", controllerThread.getYoVariableRegistry());
    }

    @Override
    protected boolean initialize() {
        this.timer.reset();
        this.ticksBehindScheduled.set(0L);
        return super.initialize();
    }

    protected void execute() {
        this.timer.start();
        long schedulerTick = this.controllerThread.getHumanoidRobotContextData().getSchedulerTick();
        this.ticksBehindScheduled.set(schedulerTick - this.timer.getTickCount() * this.divisor);
        this.controllerThread.run();
        ControllerTask.runAll(this.postControllerCallbacks);
        this.timer.stop();
    }

    protected void updateMasterContext(HumanoidRobotContextData masterContext) {
        ControllerTask.runAll(this.schedulerThreadRunnables);
        this.masterResolver.resolveHumanoidRobotContextDataController(this.controllerThread.getHumanoidRobotContextData(), masterContext);
    }

    protected void updateLocalContext(HumanoidRobotContextData masterContext) {
        this.controllerResolver.resolveHumanoidRobotContextDataScheduler(masterContext, this.controllerThread.getHumanoidRobotContextData());
        this.controllerResolver.resolveHumanoidRobotContextDataEstimator(masterContext, this.controllerThread.getHumanoidRobotContextData());
    }

    @Override
    public void addCallbackPostTask(Runnable runnable) {
        this.postControllerCallbacks.add(runnable);
    }

    @Override
    public void addRunnableOnSchedulerThread(Runnable runnable) {
        this.schedulerThreadRunnables.add(runnable);
    }
}

