/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import us.ihmc.avatar.AvatarControllerThreadInterface;
import us.ihmc.avatar.HumanoidSteppingPluginEnvironmentalConstraints;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextDataFactory;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextTools;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepValidityIndicator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.HumanoidSteppingPlugin;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.HumanoidSteppingPluginFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.StepGeneratorCommandInputManager;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.sensors.CenterOfMassDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class AvatarStepGeneratorThread
implements AvatarControllerThreadInterface {
    private final YoRegistry csgRegistry = new YoRegistry("csgRegistry");
    private final YoGraphicsListRegistry csgGraphics = new YoGraphicsListRegistry();
    private final HumanoidSteppingPlugin continuousStepGeneratorPlugin;
    private final FullHumanoidRobotModel fullRobotModel;
    private final HumanoidRobotContextData humanoidRobotContextData;
    private final HumanoidReferenceFrames humanoidReferenceFrames;
    private final YoBoolean firstTick = new YoBoolean("FirstTick", this.csgRegistry);
    private final YoLong timestampOffset = new YoLong("TimestampOffsetCSG", this.csgRegistry);
    private final YoDouble csgTime = new YoDouble("csgTime", this.csgRegistry);
    private final YoLong timestamp = new YoLong("TimestampCSG", this.csgRegistry);
    private final YoBoolean runCSG = new YoBoolean("RunCSG", this.csgRegistry);
    private final StepGeneratorCommandInputManager csgCommandInputManager;

    public AvatarStepGeneratorThread(HumanoidSteppingPluginFactory pluginFactory, HumanoidRobotContextDataFactory contextDataFactory, StatusMessageOutputManager walkingOutputManager, CommandInputManager walkingCommandInputManager, DRCRobotModel drcRobotModel, HumanoidSteppingPluginEnvironmentalConstraints environmentalConstraints, RealtimeROS2Node ros2Node) {
        this.fullRobotModel = drcRobotModel.createFullRobotModel();
        HumanoidRobotContextJointData processedJointData = new HumanoidRobotContextJointData(this.fullRobotModel.getOneDoFJoints().length);
        ForceSensorDataHolder forceSensorDataHolderForController = new ForceSensorDataHolder(Arrays.asList(this.fullRobotModel.getForceSensorDefinitions()));
        CenterOfMassDataHolder centerOfMassDataHolderForController = new CenterOfMassDataHolder();
        CenterOfPressureDataHolder centerOfPressureDataHolderForEstimator = new CenterOfPressureDataHolder(this.fullRobotModel);
        LowLevelOneDoFJointDesiredDataHolder desiredJointDataHolder = new LowLevelOneDoFJointDesiredDataHolder((OneDoFJointReadOnly[])this.fullRobotModel.getControllableOneDoFJoints());
        RobotMotionStatusHolder robotMotionStatusHolder = new RobotMotionStatusHolder();
        contextDataFactory.setForceSensorDataHolder(forceSensorDataHolderForController);
        contextDataFactory.setCenterOfMassDataHolder(centerOfMassDataHolderForController);
        contextDataFactory.setCenterOfPressureDataHolder(centerOfPressureDataHolderForEstimator);
        contextDataFactory.setRobotMotionStatusHolder(robotMotionStatusHolder);
        contextDataFactory.setJointDesiredOutputList(desiredJointDataHolder);
        contextDataFactory.setProcessedJointData(processedJointData);
        contextDataFactory.setSensorDataContext(new SensorDataContext((FullRobotModel)this.fullRobotModel));
        this.humanoidRobotContextData = contextDataFactory.createHumanoidRobotContextData();
        this.csgCommandInputManager = pluginFactory.getStepGeneratorCommandInputManager();
        if (environmentalConstraints != null) {
            pluginFactory.addPlanarRegionsListCommandConsumer((Consumer)environmentalConstraints);
            pluginFactory.setFootStepPlanAdjustment(environmentalConstraints.getFootstepPlanAdjustment());
            for (FootstepValidityIndicator footstepValidityIndicator : environmentalConstraints.getFootstepValidityIndicators()) {
                pluginFactory.addFootstepValidityIndicator(footstepValidityIndicator);
            }
            pluginFactory.addUpdatable((Updatable)environmentalConstraints);
        }
        if (ros2Node != null) {
            pluginFactory.createStepGeneratorNetworkSubscriber(drcRobotModel.getSimpleRobotName(), ros2Node);
        }
        this.humanoidReferenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        this.continuousStepGeneratorPlugin = pluginFactory.buildPlugin((CommonHumanoidReferenceFrames)this.humanoidReferenceFrames, drcRobotModel.getStepGeneratorDT(), drcRobotModel.getWalkingControllerParameters(), walkingOutputManager, walkingCommandInputManager, null, null, (DoubleProvider)this.csgTime);
        this.csgRegistry.addChild(this.continuousStepGeneratorPlugin.getRegistry());
        if (environmentalConstraints != null) {
            this.csgRegistry.addChild(environmentalConstraints.getRegistry());
            this.csgGraphics.registerYoGraphicsLists(environmentalConstraints.getGraphicsListRegistry().getYoGraphicsLists());
            ArrayList artifactLists = new ArrayList();
            environmentalConstraints.getGraphicsListRegistry().getRegisteredArtifactLists(artifactLists);
            this.csgGraphics.registerArtifactLists(artifactLists);
        }
        ParameterLoaderHelper.loadParameters((Object)this, (WholeBodyControllerParameters)drcRobotModel, (YoRegistry)this.csgRegistry);
    }

    public void initialize() {
        this.firstTick.set(true);
        this.humanoidRobotContextData.setControllerRan(false);
        this.humanoidRobotContextData.setEstimatorRan(false);
    }

    private void runOnFirstTick() {
    }

    @Override
    public void run() {
        this.runCSG.set(this.humanoidRobotContextData.getEstimatorRan());
        if (!this.runCSG.getValue()) {
            return;
        }
        try {
            HumanoidRobotContextTools.updateRobot((FullRobotModel)this.fullRobotModel, (HumanoidRobotContextJointData)this.humanoidRobotContextData.getProcessedJointData());
            this.humanoidReferenceFrames.updateFrames();
            this.timestamp.set(this.humanoidRobotContextData.getTimestamp());
            if (this.firstTick.getValue()) {
                this.timestampOffset.set(this.timestamp.getValue());
            }
            this.csgTime.set(Conversions.nanosecondsToSeconds((long)(this.timestamp.getValue() - this.timestampOffset.getValue())));
            if (this.firstTick.getValue()) {
                this.runOnFirstTick();
                this.firstTick.set(false);
            }
            this.continuousStepGeneratorPlugin.update(this.csgTime.getValue());
            this.humanoidRobotContextData.setPerceptionRan(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public YoRegistry getYoVariableRegistry() {
        return this.csgRegistry;
    }

    public YoGraphicsListRegistry getSCS1YoGraphicsListRegistry() {
        return this.csgGraphics;
    }

    @Override
    public YoGraphicGroupDefinition getSCS2YoGraphics() {
        YoGraphicGroupDefinition group = new YoGraphicGroupDefinition(this.getClass().getSimpleName());
        group.addChild(this.continuousStepGeneratorPlugin.getSCS2YoGraphics());
        return group.isEmpty() ? null : group;
    }

    @Override
    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    @Override
    public HumanoidRobotContextData getHumanoidRobotContextData() {
        return this.humanoidRobotContextData;
    }

    public StepGeneratorCommandInputManager getCsgCommandInputManager() {
        return this.csgCommandInputManager;
    }
}

