/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.OffsetAndYawRobotInitialSetup;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessorParameters;
import us.ihmc.avatar.simulationStarter.DRCSimulationStarter;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.tools.ConstantPlanarRegionsPublisher;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.PlanarRegionsListDefinedEnvironment;
import us.ihmc.tools.factories.FactoryTools;
import us.ihmc.tools.factories.OptionalFactoryField;
import us.ihmc.tools.factories.RequiredFactoryField;

public class AvatarStairsSimulation {
    private final RequiredFactoryField<DRCRobotModel> robotModel = new RequiredFactoryField("robotModel");
    private final OptionalFactoryField<Pose3D> startingPose = new OptionalFactoryField("startingPose");
    private final OptionalFactoryField<Integer> numberOfSteps = new OptionalFactoryField("numberOfSteps");
    private final OptionalFactoryField<Double> stepDepth = new OptionalFactoryField("stepDepth");
    private final OptionalFactoryField<Double> stepHeight = new OptionalFactoryField("stepHeight");
    private final OptionalFactoryField<Double> stepWidth = new OptionalFactoryField("stepWidth");
    private final OptionalFactoryField<Double> bottomPlatformWidth = new OptionalFactoryField("bottomPlatformWidth");
    private final OptionalFactoryField<Double> bottomPlatformLength = new OptionalFactoryField("bottomPlatformLength");
    private final OptionalFactoryField<Double> topPlatformWidth = new OptionalFactoryField("topPlatformWidth");
    private final OptionalFactoryField<Double> topPlatformLength = new OptionalFactoryField("topPlatformLength");
    private final OptionalFactoryField<Boolean> placeRobotAtTop = new OptionalFactoryField("placeRobotAtTop");

    public void setRobotModel(DRCRobotModel robotModel) {
        this.robotModel.set((Object)robotModel);
    }

    public void setStartingPose(Pose3D startingPose) {
        this.startingPose.set((Object)startingPose);
    }

    public void setNumberOfSteps(int numberOfSteps) {
        this.numberOfSteps.set((Object)numberOfSteps);
    }

    public void setStepDepth(double stepDepth) {
        this.stepDepth.set((Object)stepDepth);
    }

    public void setStepHeight(double stepHeight) {
        this.stepHeight.set((Object)stepHeight);
    }

    public void setStepWidth(double stepWidth) {
        this.stepWidth.set((Object)stepWidth);
    }

    public void setBottomPlatformWidth(double bottomPlatformWidth) {
        this.bottomPlatformWidth.set((Object)bottomPlatformWidth);
    }

    public void setBottomPlatformLength(double bottomPlatformLength) {
        this.bottomPlatformLength.set((Object)bottomPlatformLength);
    }

    public void setTopPlatformWidth(double topPlatformWidth) {
        this.topPlatformWidth.set((Object)topPlatformWidth);
    }

    public void setTopPlatformLength(double topPlatformLength) {
        this.topPlatformLength.set((Object)topPlatformLength);
    }

    public void setPlaceRobotAtTop(boolean placeRobotAtTop) {
        this.placeRobotAtTop.set((Object)placeRobotAtTop);
    }

    public void startSimulation() {
        this.startingPose.setDefaultValue((Object)new Pose3D());
        this.numberOfSteps.setDefaultValue((Object)5);
        this.stepDepth.setDefaultValue((Object)AvatarStairsSimulation.toMeters(11.0));
        this.stepHeight.setDefaultValue((Object)AvatarStairsSimulation.toMeters(6.75));
        this.stepWidth.setDefaultValue((Object)1.0);
        this.bottomPlatformWidth.setDefaultValue((Object)2.0);
        this.bottomPlatformLength.setDefaultValue((Object)2.0);
        this.topPlatformWidth.setDefaultValue((Object)1.0);
        this.topPlatformLength.setDefaultValue((Object)1.0);
        FactoryTools.checkAllFactoryFieldsAreSet((Object)this);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        RigidBodyTransform initialTransform = new RigidBodyTransform();
        ((Pose3D)this.startingPose.get()).get((RigidBodyTransformBasics)initialTransform);
        generator.setTransform(initialTransform);
        generator.addRectangle(((Double)this.bottomPlatformLength.get()).doubleValue(), ((Double)this.bottomPlatformWidth.get()).doubleValue());
        generator.translate(0.5 * ((Double)this.bottomPlatformLength.get() - (Double)this.stepDepth.get()), 0.0, 0.0);
        for (int i = 0; i < (Integer)this.numberOfSteps.get() - 1; ++i) {
            generator.translate(((Double)this.stepDepth.get()).doubleValue(), 0.0, ((Double)this.stepHeight.get()).doubleValue());
            generator.addRectangle(((Double)this.stepDepth.get()).doubleValue(), ((Double)this.stepWidth.get()).doubleValue());
        }
        generator.translate(0.5 * ((Double)this.topPlatformLength.get() + (Double)this.stepDepth.get()), 0.0, ((Double)this.stepHeight.get()).doubleValue());
        generator.addRectangle(((Double)this.topPlatformLength.get()).doubleValue(), ((Double)this.topPlatformWidth.get()).doubleValue());
        PlanarRegionsList planarRegionsList = generator.getPlanarRegionsList();
        PlanarRegionsListDefinedEnvironment simEnvironment = new PlanarRegionsListDefinedEnvironment(planarRegionsList, 0.02, true);
        DRCSimulationStarter simulationStarter = new DRCSimulationStarter((DRCRobotModel)this.robotModel.get(), (CommonAvatarEnvironmentInterface)simEnvironment);
        simulationStarter.setRunMultiThreaded(true);
        simulationStarter.setInitializeEstimatorToActual(true);
        if (((Boolean)this.placeRobotAtTop.get()).booleanValue()) {
            Pose3D robotPose = new Pose3D((Pose3DReadOnly)this.startingPose.get());
            robotPose.appendTranslation(0.5 * (Double)this.bottomPlatformLength.get(), 0.0, 0.0);
            robotPose.appendTranslation((double)((Integer)this.numberOfSteps.get()).intValue() * (Double)this.stepDepth.get(), 0.0, (double)((Integer)this.numberOfSteps.get()).intValue() * (Double)this.stepHeight.get());
            robotPose.appendYawRotation(Math.PI);
            simulationStarter.setStartingLocation(() -> new OffsetAndYawRobotInitialSetup((Tuple3DReadOnly)robotPose.getPosition(), robotPose.getYaw()));
        } else {
            simulationStarter.setStartingLocation(() -> new OffsetAndYawRobotInitialSetup((Tuple3DReadOnly)((Pose3D)this.startingPose.get()).getPosition(), ((Pose3D)this.startingPose.get()).getYaw()));
        }
        HumanoidNetworkProcessorParameters networkProcessorParameters = new HumanoidNetworkProcessorParameters();
        networkProcessorParameters.setUseFootstepPlanningToolboxModule(false);
        networkProcessorParameters.setUseWalkingPreviewModule(true);
        networkProcessorParameters.setUseBipedalSupportPlanarRegionPublisherModule(true);
        networkProcessorParameters.setUseSensorModule(true);
        networkProcessorParameters.setUseHumanoidAvatarREAStateUpdater(true);
        simulationStarter.startSimulation(networkProcessorParameters, false);
        ConstantPlanarRegionsPublisher constantPlanarRegionsPublisher = new ConstantPlanarRegionsPublisher(planarRegionsList);
        constantPlanarRegionsPublisher.start(2000);
    }

    private static double toMeters(double inches) {
        double inchesPerMeter = 39.3701;
        return inches / inchesPerMeter;
    }
}

