/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import java.util.List;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.sensorProcessing.outputData.LowLevelState;
import us.ihmc.yoVariables.registry.YoRegistry;

public interface AvatarSimulatedHandControlThread {
    public void run();

    public YoRegistry getYoVariableRegistry();

    public FullHumanoidRobotModel getFullRobotModel();

    public HumanoidRobotContextData getHumanoidRobotContextData();

    public List<OneDoFJointBasics> getControlledOneDoFJoints();

    public boolean hasControllerRan();

    public void cleanup();

    default public void updateFullRobotModel() {
        List<OneDoFJointBasics> controlledOneDoFJoints = this.getControlledOneDoFJoints();
        for (int i = 0; i < controlledOneDoFJoints.size(); ++i) {
            OneDoFJointBasics joint = controlledOneDoFJoints.get(i);
            LowLevelState measuredJointState = this.getHumanoidRobotContextData().getSensorDataContext().getMeasuredJointState(joint.getName());
            if (measuredJointState.isPositionValid()) {
                joint.setQ(measuredJointState.getPosition());
            }
            if (measuredJointState.isVelocityValid()) {
                joint.setQd(measuredJointState.getVelocity());
            }
            if (measuredJointState.isAccelerationValid()) {
                joint.setQdd(measuredJointState.getAcceleration());
            }
            if (!measuredJointState.isEffortValid()) continue;
            joint.setTau(measuredJointState.getEffort());
        }
    }
}

