/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D.interfaces;

import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public interface QuaternionBasics
extends QuaternionReadOnly,
Orientation3DBasics,
Tuple4DBasics {
    public static final double EPS_POW = 1.0E-12;

    @Override
    default public boolean containsNaN() {
        return QuaternionReadOnly.super.containsNaN();
    }

    public void setUnsafe(double var1, double var3, double var5, double var7);

    @Override
    default public void setToZero() {
        this.setUnsafe(0.0, 0.0, 0.0, 1.0);
    }

    @Override
    default public void absolute() {
        this.setUnsafe(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()), Math.abs(this.getS()));
    }

    @Override
    default public void negate() {
        this.setUnsafe(-this.getX(), -this.getY(), -this.getZ(), -this.getS());
    }

    default public void conjugate() {
        this.setUnsafe(-this.getX(), -this.getY(), -this.getZ(), this.getS());
    }

    @Override
    default public void invert() {
        this.conjugate();
    }

    default public void inverse() {
        this.conjugate();
        this.normalize();
    }

    @Override
    default public void normalize() {
        if (this.containsNaN()) {
            return;
        }
        double invNorm = this.norm();
        if (invNorm == 0.0) {
            this.setToZero();
            return;
        }
        invNorm = 1.0 / invNorm;
        double qx = this.getX() * invNorm;
        double qy = this.getY() * invNorm;
        double qz = this.getZ() * invNorm;
        double qs = this.getS() * invNorm;
        this.setUnsafe(qx, qy, qz, qs);
    }

    default public void normalizeAndLimitToPi() {
        this.normalize();
        if (this.getS() < 0.0) {
            this.negate();
        }
    }

    default public void pow(double alpha) {
        if (this.containsNaN()) {
            return;
        }
        double uNorm = EuclidCoreTools.norm(this.getX(), this.getY(), this.getZ());
        if (uNorm > 1.0E-12) {
            double angle = alpha * EuclidCoreTools.atan2(uNorm, this.getS());
            uNorm = EuclidCoreTools.sin(angle) / uNorm;
            double qx = this.getX() * uNorm;
            double qy = this.getY() * uNorm;
            double qz = this.getZ() * uNorm;
            this.set(qx, qy, qz, EuclidCoreTools.cos(angle));
        } else {
            this.setToZero();
        }
    }

    @Override
    default public void set(double x, double y, double z, double s) {
        this.setUnsafe(x, y, z, s);
        this.normalize();
    }

    @Override
    default public void set(Orientation3DReadOnly orientation3DReadOnly) {
        orientation3DReadOnly.get(this);
    }

    default public void set(QuaternionReadOnly other) {
        this.setUnsafe(other.getX(), other.getY(), other.getZ(), other.getS());
    }

    @Override
    default public void setAndNormalize(Tuple4DReadOnly other) {
        this.set(other);
    }

    default public void setAndNormalize(QuaternionReadOnly other) {
        this.set(other);
        this.normalize();
    }

    default public void setAndConjugate(QuaternionReadOnly other) {
        this.set(other);
        this.conjugate();
    }

    default public void setAndNegate(QuaternionReadOnly other) {
        this.set(other);
        this.negate();
    }

    @Override
    default public void setAxisAngle(double x, double y, double z, double angle) {
        QuaternionConversion.convertAxisAngleToQuaternion(x, y, z, angle, this);
    }

    @Override
    default public void setQuaternion(double x, double y, double z, double s) {
        this.setUnsafe(x, y, z, s);
    }

    @Override
    default public void setRotationVector(double x, double y, double z) {
        QuaternionConversion.convertRotationVectorToQuaternion(x, y, z, this);
    }

    @Override
    default public void setYawPitchRoll(double yaw, double pitch, double roll) {
        QuaternionConversion.convertYawPitchRollToQuaternion(yaw, pitch, roll, this);
    }

    @Override
    default public void setRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        QuaternionConversion.convertMatrixToQuaternion(m00, m01, m02, m10, m11, m12, m20, m21, m22, this);
    }

    @Override
    default public void setToYawOrientation(double yaw) {
        QuaternionConversion.computeYawQuaternion(yaw, this);
    }

    @Override
    default public void setToPitchOrientation(double pitch) {
        QuaternionConversion.computePitchQuaternion(pitch, this);
    }

    @Override
    default public void setToRollOrientation(double roll) {
        QuaternionConversion.computeRollQuaternion(roll, this);
    }

    default public void difference(QuaternionReadOnly q1, QuaternionReadOnly q2) {
        QuaternionTools.multiplyConjugateLeft(q1, q2, this);
    }

    default public void multiply(QuaternionReadOnly other) {
        QuaternionTools.multiply(this, other, this);
    }

    default public void multiply(QuaternionReadOnly q1, QuaternionReadOnly q2) {
        QuaternionTools.multiply(q1, q2, this);
    }

    @Override
    default public void append(Orientation3DReadOnly orientation) {
        QuaternionTools.multiply(this, false, orientation, false, this);
    }

    default public void multiplyConjugateOther(QuaternionReadOnly other) {
        QuaternionTools.multiplyConjugateRight(this, other, this);
    }

    @Override
    default public void appendInvertOther(Orientation3DReadOnly orientation) {
        QuaternionTools.multiply(this, false, orientation, true, this);
    }

    default public void multiplyConjugateThis(QuaternionReadOnly other) {
        QuaternionTools.multiplyConjugateLeft(this, other, this);
    }

    default public void multiplyConjugateBoth(QuaternionReadOnly other) {
        QuaternionTools.multiplyConjugateBoth(this, other, this);
    }

    @Override
    default public void appendYawRotation(double yaw) {
        QuaternionTools.appendYawRotation(this, yaw, this);
    }

    @Override
    default public void appendPitchRotation(double pitch) {
        QuaternionTools.appendPitchRotation(this, pitch, this);
    }

    @Override
    default public void appendRollRotation(double roll) {
        QuaternionTools.appendRollRotation(this, roll, this);
    }

    default public void preMultiply(QuaternionReadOnly other) {
        QuaternionTools.multiply(other, this, this);
    }

    @Override
    default public void prepend(Orientation3DReadOnly orientation) {
        QuaternionTools.multiply(orientation, false, this, false, this);
    }

    default public void preMultiplyConjugateOther(QuaternionReadOnly other) {
        QuaternionTools.multiplyConjugateLeft(other, this, this);
    }

    @Override
    default public void prependInvertOther(Orientation3DReadOnly orientation) {
        QuaternionTools.multiply(orientation, true, this, false, this);
    }

    default public void preMultiplyConjugateThis(QuaternionReadOnly other) {
        QuaternionTools.multiplyConjugateRight(other, this, this);
    }

    default public void preMultiplyConjugateBoth(QuaternionReadOnly other) {
        QuaternionTools.multiplyConjugateBoth(other, this, this);
    }

    @Override
    default public void prependYawRotation(double yaw) {
        QuaternionTools.prependYawRotation(yaw, this, this);
    }

    @Override
    default public void prependPitchRotation(double pitch) {
        QuaternionTools.prependPitchRotation(pitch, this, this);
    }

    @Override
    default public void prependRollRotation(double roll) {
        QuaternionTools.prependRollRotation(roll, this, this);
    }

    default public void interpolate(QuaternionReadOnly qf, double alpha) {
        this.interpolate(this, qf, alpha);
    }

    default public void interpolate(QuaternionReadOnly q0, QuaternionReadOnly qf, double alpha) {
        QuaternionTools.interpolate(q0, qf, alpha, this);
    }
}

