/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.ejml.MatrixDimensionException;
import org.ejml.data.Matrix;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation2DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class EuclidCoreTools {
    public static final double TwoPI = Math.PI * 2;
    public static final double EPS_NORM_FAST_SQRT = 2.107342E-8;
    public static final double EPS_ANGLE_SHIFT = 1.0E-12;
    public static final double CLAMP_EPS = 1.0E-10;
    public static final Point2DReadOnly origin2D = new Point2DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple2DReadOnly) {
                return Point2DReadOnly.super.equals((Tuple2DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Point3DReadOnly origin3D = new Point3DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        @Override
        public double getZ() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple3DReadOnly) {
                return Point3DReadOnly.super.equals((Tuple3DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Vector2DReadOnly zeroVector2D = new Vector2DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple2DReadOnly) {
                return Vector2DReadOnly.super.equals((Tuple2DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Vector3DReadOnly zeroVector3D = new Vector3DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        @Override
        public double getZ() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple3DReadOnly) {
                return Vector3DReadOnly.super.equals((Tuple3DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final QuaternionReadOnly neutralQuaternion = new QuaternionReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        @Override
        public double getZ() {
            return 0.0;
        }

        @Override
        public double getS() {
            return 1.0;
        }

        public int hashCode() {
            return -1106247679;
        }

        public boolean equals(Object object) {
            if (object instanceof QuaternionReadOnly) {
                return this.equals((QuaternionReadOnly)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Matrix3DReadOnly zeroMatrix3D = new Matrix3DReadOnly(){

        @Override
        public double getM00() {
            return 0.0;
        }

        @Override
        public double getM01() {
            return 0.0;
        }

        @Override
        public double getM02() {
            return 0.0;
        }

        @Override
        public double getM10() {
            return 0.0;
        }

        @Override
        public double getM11() {
            return 0.0;
        }

        @Override
        public double getM12() {
            return 0.0;
        }

        @Override
        public double getM20() {
            return 0.0;
        }

        @Override
        public double getM21() {
            return 0.0;
        }

        @Override
        public double getM22() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Matrix3DReadOnly) {
                return Matrix3DReadOnly.super.equals((Matrix3DReadOnly)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }

        public int hashCode() {
            return 1;
        }
    };
    public static final Matrix3DReadOnly identityMatrix3D = new Matrix3DReadOnly(){

        @Override
        public double getM00() {
            return 1.0;
        }

        @Override
        public double getM01() {
            return 0.0;
        }

        @Override
        public double getM02() {
            return 0.0;
        }

        @Override
        public double getM10() {
            return 0.0;
        }

        @Override
        public double getM11() {
            return 1.0;
        }

        @Override
        public double getM12() {
            return 0.0;
        }

        @Override
        public double getM20() {
            return 0.0;
        }

        @Override
        public double getM21() {
            return 0.0;
        }

        @Override
        public double getM22() {
            return 1.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Matrix3DReadOnly) {
                return Matrix3DReadOnly.super.equals((Matrix3DReadOnly)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }

        public int hashCode() {
            return 976224257;
        }
    };

    private EuclidCoreTools() {
    }

    public static double squareRoot(double value) {
        return Math.sqrt(value);
    }

    public static double fastSquareRoot(double squaredValueClosedToOne) {
        squaredValueClosedToOne = Math.abs(1.0 - squaredValueClosedToOne) < 2.107342E-8 ? 0.5 * (1.0 + squaredValueClosedToOne) : EuclidCoreTools.squareRoot(squaredValueClosedToOne);
        return squaredValueClosedToOne;
    }

    public static boolean containsNaN(double a, double b) {
        return Double.isNaN(a) || Double.isNaN(b);
    }

    public static boolean containsNaN(double a, double b, double c) {
        return Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c);
    }

    public static boolean containsNaN(double a, double b, double c, double d) {
        return Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c) || Double.isNaN(d);
    }

    public static boolean containsNaN(double a0, double a1, double a2, double a3, double a4, double a5, double a6, double a7, double a8) {
        if (Double.isNaN(a0) || Double.isNaN(a1) || Double.isNaN(a2)) {
            return true;
        }
        if (Double.isNaN(a3) || Double.isNaN(a4) || Double.isNaN(a5)) {
            return true;
        }
        return Double.isNaN(a6) || Double.isNaN(a7) || Double.isNaN(a8);
    }

    public static boolean containsNaN(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Double.isNaN(array[i])) continue;
            return true;
        }
        return false;
    }

    public static double square(double value) {
        return value * value;
    }

    public static double normSquared(double x, double y) {
        return x * x + y * y;
    }

    public static double normSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double normSquared(double x, double y, double z, double s) {
        return x * x + y * y + z * z + s * s;
    }

    public static double norm(double x, double y) {
        return EuclidCoreTools.squareRoot(EuclidCoreTools.normSquared(x, y));
    }

    public static double norm(double x, double y, double z) {
        return EuclidCoreTools.squareRoot(EuclidCoreTools.normSquared(x, y, z));
    }

    public static double norm(double x, double y, double z, double s) {
        return EuclidCoreTools.squareRoot(EuclidCoreTools.normSquared(x, y, z, s));
    }

    public static double fastNorm(double x, double y) {
        return EuclidCoreTools.fastSquareRoot(EuclidCoreTools.normSquared(x, y));
    }

    public static double fastNorm(double x, double y, double z) {
        return EuclidCoreTools.fastSquareRoot(EuclidCoreTools.normSquared(x, y, z));
    }

    public static double fastNorm(double x, double y, double z, double s) {
        return EuclidCoreTools.fastSquareRoot(EuclidCoreTools.normSquared(x, y, z, s));
    }

    public static double trimAngleMinusPiToPi(double angleToShift) {
        return EuclidCoreTools.shiftAngleInRange(angleToShift, -Math.PI);
    }

    public static double angleDifferenceMinusPiToPi(double angleA, double angleB) {
        return EuclidCoreTools.trimAngleMinusPiToPi(angleA - angleB);
    }

    public static double shiftAngleInRange(double angleToShift, double angleStart) {
        double deltaFromStart = (angleToShift - (angleStart -= 1.0E-12)) % (Math.PI * 2);
        if (deltaFromStart < 0.0) {
            deltaFromStart += Math.PI * 2;
        }
        return angleStart + deltaFromStart;
    }

    public static final double max(double a, double b, double c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    public static double max(double a, double b, double c, double d) {
        if (a > b) {
            if (a > c) {
                return a > d ? a : d;
            }
            return c > d ? c : d;
        }
        if (b > c) {
            return b > d ? b : d;
        }
        return c > d ? c : d;
    }

    public static final double min(double a, double b, double c) {
        if (a < b) {
            return a < c ? a : c;
        }
        return b < c ? b : c;
    }

    public static double min(double a, double b, double c, double d) {
        if (a < b) {
            if (a < c) {
                return a < d ? a : d;
            }
            return c < d ? c : d;
        }
        if (b < c) {
            return b < d ? b : d;
        }
        return c < d ? c : d;
    }

    public static final double med(double a, double b, double c) {
        if (a > b) {
            if (a > c) {
                return b > c ? b : c;
            }
            return a;
        }
        if (b > c) {
            return a > c ? a : c;
        }
        return b;
    }

    public static boolean equals(double expectedValue, double actualValue) {
        if (expectedValue == actualValue) {
            return true;
        }
        return Double.isNaN(expectedValue) && Double.isNaN(actualValue);
    }

    public static boolean epsilonEquals(double expectedValue, double actualValue, double epsilon) {
        return expectedValue == actualValue || Math.abs(expectedValue - actualValue) <= epsilon;
    }

    public static boolean equals(EuclidGeometry a, EuclidGeometry b) {
        return Objects.equals(a, b);
    }

    public static boolean epsilonEquals(EuclidGeometry a, EuclidGeometry b, double epsilon) {
        return a == b || a != null && a.epsilonEquals(b, epsilon);
    }

    public static boolean geometricallyEquals(EuclidGeometry a, EuclidGeometry b, double epsilon) {
        return a == b || a != null && a.geometricallyEquals(b, epsilon);
    }

    public static boolean isZero(double value, double epsilon) {
        return Math.abs(value) <= epsilon;
    }

    public static boolean areAllZero(double x, double y, double epsilon) {
        return EuclidCoreTools.isZero(x, epsilon) && EuclidCoreTools.isZero(y, epsilon);
    }

    public static boolean areAllZero(double x, double y, double z, double epsilon) {
        return EuclidCoreTools.isZero(x, epsilon) && EuclidCoreTools.isZero(y, epsilon) && EuclidCoreTools.isZero(z, epsilon);
    }

    public static boolean areAllZero(double x, double y, double z, double s, double epsilon) {
        return EuclidCoreTools.isZero(x, epsilon) && EuclidCoreTools.isZero(y, epsilon) && EuclidCoreTools.isZero(z, epsilon) && EuclidCoreTools.isZero(s, epsilon);
    }

    public static boolean angleGeometricallyEquals(double expectedAngle, double actualAngle, double epsilon) {
        return Math.abs(EuclidCoreTools.angleDifferenceMinusPiToPi(expectedAngle, actualAngle)) <= epsilon;
    }

    public static boolean isAngleZero(double angle, double epsilon) {
        if ((angle = Math.abs(angle) % (Math.PI * 2)) > Math.PI) {
            angle -= Math.PI * 2;
        }
        return Math.abs(angle) <= epsilon;
    }

    public static double clamp(double value, double minMax) {
        return EuclidCoreTools.clamp(value, -minMax, minMax);
    }

    public static double clamp(double value, double min, double max) {
        if (min > max + 1.0E-10) {
            throw new RuntimeException(EuclidCoreTools.class.getSimpleName() + ".clamp(double, double, double): min > max (" + min + " > " + max + ")");
        }
        return Math.min(max, Math.max(value, min));
    }

    public static double interpolate(double a, double b, double alpha) {
        return (1.0 - alpha) * a + alpha * b;
    }

    public static double tan(double a) {
        return StrictMath.tan(a);
    }

    public static double atan(double a) {
        return StrictMath.atan(a);
    }

    public static double atan2(double y, double x) {
        return StrictMath.atan2(y, x);
    }

    public static double cos(double a) {
        return StrictMath.cos(a);
    }

    public static double sin(double a) {
        return StrictMath.sin(a);
    }

    public static double acos(double a) {
        return StrictMath.acos(a);
    }

    public static double fastAcos(double cosX) {
        if (cosX == -1.0) {
            return Math.PI;
        }
        return 2.0 * EuclidCoreTools.atan2(EuclidCoreTools.squareRoot(1.0 - cosX * cosX), 1.0 + cosX);
    }

    public static double asin(double a) {
        return StrictMath.asin(a);
    }

    public static void checkMatrixMinimumSize(int minRows, int minColumns, Matrix matrixToTest) {
        if (matrixToTest.getNumCols() < minColumns || matrixToTest.getNumRows() < minRows) {
            throw new MatrixDimensionException("The matrix is too small, expected: [nRows >= " + minRows + ", nColumns >= " + minColumns + "], was: [nRows = " + matrixToTest.getNumRows() + ", nCols = " + matrixToTest.getNumCols() + "].");
        }
    }

    public static void reverse(List<?> list, int fromIndex, int toIndex) {
        int start = fromIndex;
        int end = toIndex - 1;
        while (start < end) {
            Collections.swap(list, start++, end--);
        }
    }

    public static <T> void rotate(List<T> list, int fromIndex, int toIndex, int distance) {
        int size = toIndex - fromIndex;
        if (size <= 1) {
            return;
        }
        if ((distance = EuclidCoreTools.wrap(distance, size)) == 0) {
            return;
        }
        int cycleStart = fromIndex;
        int nMoved = 0;
        while (nMoved != size) {
            T shifted = list.get(cycleStart);
            int i = cycleStart;
            do {
                if ((i += distance) >= toIndex) {
                    i -= size;
                }
                shifted = list.set(i, shifted);
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
    }

    public static int wrap(int index, int listSize) {
        if ((index %= listSize) < 0) {
            index += listSize;
        }
        return index;
    }

    public static int next(int index, int listSize) {
        return EuclidCoreTools.wrap(index + 1, listSize);
    }

    public static int previous(int index, int listSize) {
        return EuclidCoreTools.wrap(index - 1, listSize);
    }

    public static double finiteDifference(double previousValue, double currentValue, double dt) {
        return (currentValue - previousValue) / dt;
    }

    public static double finiteDifferenceAngle(double previousAngle, double currentAngle, double dt) {
        return EuclidCoreTools.angleDifferenceMinusPiToPi(currentAngle, previousAngle) / dt;
    }

    public static void finiteDifference(Tuple2DReadOnly previousValue, Tuple2DReadOnly currentValue, double dt, Vector2DBasics derivativeToPack) {
        derivativeToPack.sub(currentValue, previousValue);
        derivativeToPack.scale(1.0 / dt);
    }

    public static void finiteDifference(Tuple3DReadOnly previousValue, Tuple3DReadOnly currentValue, double dt, Vector3DBasics derivativeToPack) {
        derivativeToPack.sub(currentValue, previousValue);
        derivativeToPack.scale(1.0 / dt);
    }

    public static void finiteDifference(Tuple4DReadOnly previousValue, Tuple4DReadOnly currentValue, double dt, Vector4DBasics derivativeToPack) {
        derivativeToPack.sub(currentValue, previousValue);
        derivativeToPack.scale(1.0 / dt);
    }

    public static double finiteDifference(Orientation2DReadOnly previousOrientation, Orientation2DReadOnly currentOrientation, double dt) {
        return EuclidCoreTools.finiteDifferenceAngle(previousOrientation.getYaw(), currentOrientation.getYaw(), dt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void finiteDifference(Orientation3DReadOnly previousOrientation, Orientation3DReadOnly currentOrientation, double dt, Vector3DBasics angularVelocityToPack) {
        if (previousOrientation instanceof QuaternionReadOnly) {
            QuaternionReadOnly qPrev = (QuaternionReadOnly)previousOrientation;
            if (currentOrientation instanceof QuaternionReadOnly) {
                QuaternionReadOnly qCurr = (QuaternionReadOnly)currentOrientation;
                QuaternionTools.finiteDifference(qPrev, qCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof RotationMatrixReadOnly) {
                RotationMatrixReadOnly rCurr = (RotationMatrixReadOnly)currentOrientation;
                RotationMatrixTools.finiteDifference(qPrev, rCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof AxisAngleReadOnly) {
                AxisAngleReadOnly aaCurr = (AxisAngleReadOnly)currentOrientation;
                QuaternionTools.finiteDifference(qPrev, aaCurr, dt, angularVelocityToPack);
                return;
            } else {
                if (!(currentOrientation instanceof YawPitchRollReadOnly)) throw EuclidCoreTools.newUnsupportedOrientationException(previousOrientation, currentOrientation);
                YawPitchRollReadOnly yprCurr = (YawPitchRollReadOnly)currentOrientation;
                QuaternionTools.finiteDifference(qPrev, yprCurr, dt, angularVelocityToPack);
            }
            return;
        } else if (previousOrientation instanceof RotationMatrixReadOnly) {
            RotationMatrixReadOnly rPrev = (RotationMatrixReadOnly)previousOrientation;
            if (currentOrientation instanceof RotationMatrixReadOnly) {
                RotationMatrixReadOnly rCurr = (RotationMatrixReadOnly)currentOrientation;
                RotationMatrixTools.finiteDifference(rPrev, rCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof QuaternionReadOnly) {
                QuaternionReadOnly qCurr = (QuaternionReadOnly)currentOrientation;
                RotationMatrixTools.finiteDifference(rPrev, qCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof AxisAngleReadOnly) {
                AxisAngleReadOnly aaCurr = (AxisAngleReadOnly)currentOrientation;
                RotationMatrixTools.finiteDifference(rPrev, aaCurr, dt, angularVelocityToPack);
                return;
            } else {
                if (!(currentOrientation instanceof YawPitchRollReadOnly)) throw EuclidCoreTools.newUnsupportedOrientationException(previousOrientation, currentOrientation);
                YawPitchRollReadOnly yprCurr = (YawPitchRollReadOnly)currentOrientation;
                RotationMatrixTools.finiteDifference(rPrev, yprCurr, dt, angularVelocityToPack);
            }
            return;
        } else if (previousOrientation instanceof AxisAngleReadOnly) {
            AxisAngleReadOnly aaPrev = (AxisAngleReadOnly)previousOrientation;
            if (currentOrientation instanceof AxisAngleReadOnly) {
                AxisAngleReadOnly aaCurr = (AxisAngleReadOnly)currentOrientation;
                AxisAngleTools.finiteDifference(aaPrev, aaCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof QuaternionReadOnly) {
                QuaternionReadOnly qCurr = (QuaternionReadOnly)currentOrientation;
                QuaternionTools.finiteDifference(aaPrev, qCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof RotationMatrixReadOnly) {
                RotationMatrixReadOnly rCurr = (RotationMatrixReadOnly)currentOrientation;
                RotationMatrixTools.finiteDifference(aaPrev, rCurr, dt, angularVelocityToPack);
                return;
            } else {
                if (!(currentOrientation instanceof YawPitchRollReadOnly)) throw EuclidCoreTools.newUnsupportedOrientationException(previousOrientation, currentOrientation);
                YawPitchRollReadOnly yprCurr = (YawPitchRollReadOnly)currentOrientation;
                YawPitchRollTools.finiteDifference(aaPrev, yprCurr, dt, angularVelocityToPack);
            }
            return;
        } else {
            if (!(previousOrientation instanceof YawPitchRollReadOnly)) throw EuclidCoreTools.newUnsupportedOrientationException(previousOrientation, currentOrientation);
            YawPitchRollReadOnly yprPrev = (YawPitchRollReadOnly)previousOrientation;
            if (currentOrientation instanceof YawPitchRollReadOnly) {
                YawPitchRollReadOnly yprCurr = (YawPitchRollReadOnly)currentOrientation;
                YawPitchRollTools.finiteDifference(yprPrev, yprCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof RotationMatrixReadOnly) {
                RotationMatrixReadOnly rCurr = (RotationMatrixReadOnly)currentOrientation;
                RotationMatrixTools.finiteDifference(yprPrev, rCurr, dt, angularVelocityToPack);
                return;
            } else if (currentOrientation instanceof QuaternionReadOnly) {
                QuaternionReadOnly qCurr = (QuaternionReadOnly)currentOrientation;
                QuaternionTools.finiteDifference(yprPrev, qCurr, dt, angularVelocityToPack);
                return;
            } else {
                if (!(currentOrientation instanceof AxisAngleReadOnly)) throw EuclidCoreTools.newUnsupportedOrientationException(previousOrientation, currentOrientation);
                AxisAngleReadOnly aaCurr = (AxisAngleReadOnly)currentOrientation;
                YawPitchRollTools.finiteDifference(yprPrev, aaCurr, dt, angularVelocityToPack);
            }
        }
    }

    public static void finiteDifference(RigidBodyTransformReadOnly previousTransform, RigidBodyTransformReadOnly currentTransform, double dt, Vector3DBasics angularVelocityToPack, Vector3DBasics linearVelocityToPack) {
        EuclidCoreTools.finiteDifference(previousTransform.getRotation(), currentTransform.getRotation(), dt, angularVelocityToPack);
        EuclidCoreTools.finiteDifference(previousTransform.getTranslation(), currentTransform.getTranslation(), dt, linearVelocityToPack);
    }

    public static double integrate(double previousValue, double derivative, double dt) {
        return previousValue + dt * derivative;
    }

    public static double integrateAngle(double previousAngle, double angularVelocity, double dt) {
        return EuclidCoreTools.trimAngleMinusPiToPi(previousAngle + dt * angularVelocity);
    }

    public static void integrate(Tuple2DReadOnly previousValue, Vector2DReadOnly derivative, double dt, Tuple2DBasics currentValueToPack) {
        currentValueToPack.scaleAdd(dt, derivative, previousValue);
    }

    public static void integrate(Tuple3DReadOnly previousValue, Vector3DReadOnly derivative, double dt, Tuple3DBasics currentValueToPack) {
        currentValueToPack.scaleAdd(dt, derivative, previousValue);
    }

    public static void integrate(Tuple4DReadOnly previousValue, Vector4DReadOnly derivative, double dt, Tuple4DBasics currentValueToPack) {
        currentValueToPack.set(previousValue.getX() + dt * derivative.getX(), previousValue.getY() + dt * derivative.getY(), previousValue.getZ() + dt * derivative.getZ(), previousValue.getS() + dt * derivative.getS());
    }

    public static void integrate(Orientation2DReadOnly previousOrientation, double angularVelocity, double dt, Orientation2DBasics currentOrientationToPack) {
        currentOrientationToPack.setYaw(EuclidCoreTools.integrateAngle(previousOrientation.getYaw(), angularVelocity, dt));
    }

    public static void integrate(Orientation3DReadOnly previousOrientation, Vector3DReadOnly angularVelocity, double dt, Orientation3DBasics currentOrientationToPack) {
        double rx = angularVelocity.getX() * dt;
        double ry = angularVelocity.getY() * dt;
        double rz = angularVelocity.getZ() * dt;
        if (currentOrientationToPack instanceof QuaternionBasics) {
            QuaternionBasics qCurr = (QuaternionBasics)currentOrientationToPack;
            QuaternionTools.appendRotationVector(previousOrientation, rx, ry, rz, qCurr);
        } else if (currentOrientationToPack instanceof RotationMatrixBasics) {
            RotationMatrixBasics rCurr = (RotationMatrixBasics)currentOrientationToPack;
            RotationMatrixTools.appendRotationVector(previousOrientation, rx, ry, rz, rCurr);
        } else if (currentOrientationToPack instanceof AxisAngleBasics) {
            AxisAngleBasics aaCurr = (AxisAngleBasics)currentOrientationToPack;
            AxisAngleTools.appendRotationVector(previousOrientation, rx, ry, rz, aaCurr);
        } else if (currentOrientationToPack instanceof YawPitchRollBasics) {
            YawPitchRollBasics yprCurr = (YawPitchRollBasics)currentOrientationToPack;
            YawPitchRollTools.appendRotationVector(previousOrientation, rx, ry, rz, yprCurr);
        } else {
            throw EuclidCoreTools.newUnsupportedOrientationException(previousOrientation, currentOrientationToPack);
        }
    }

    public static void integrate(RigidBodyTransformReadOnly previousTransform, Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity, double dt, RigidBodyTransformBasics currentTransformToPack) {
        EuclidCoreTools.integrate(previousTransform.getRotation(), angularVelocity, dt, currentTransformToPack.getRotation());
        EuclidCoreTools.integrate(previousTransform.getTranslation(), linearVelocity, dt, currentTransformToPack.getTranslation());
    }

    private static UnsupportedOperationException newUnsupportedOrientationException(Orientation3DReadOnly previousOrientation, Orientation3DReadOnly currentOrientation) {
        return new UnsupportedOperationException("Unsupported orientation type: [currentOrientation = %s, previousOrientation = %s].".formatted(currentOrientation.getClass().getSimpleName(), previousOrientation.getClass().getSimpleName()));
    }

    public static boolean isFinite(Tuple3DReadOnly tuple) {
        return Double.isFinite(tuple.getX()) && Double.isFinite(tuple.getY()) && Double.isFinite(tuple.getZ());
    }

    public static boolean epsilonEquals(RigidBodyTransformReadOnly a, RigidBodyTransformReadOnly b, double rotationEpsilon, double translationEpsilon) {
        return a.getRotation().geometricallyEquals(b.getRotation(), rotationEpsilon) && a.getTranslation().geometricallyEquals(b.getTranslation(), translationEpsilon);
    }

    public static double angleFromFirstToSecondVector3D(double firstVectorX, double firstVectorY, double firstVectorZ, boolean isFirstVectorUnitary, double secondVectorX, double secondVectorY, double secondVectorZ, boolean isSecondVectorUnitary) {
        double firstVectorLength = isFirstVectorUnitary ? 1.0 : EuclidCoreTools.norm(firstVectorX, firstVectorY, firstVectorZ);
        double secondVectorLength = isSecondVectorUnitary ? 1.0 : EuclidCoreTools.norm(secondVectorX, secondVectorY, secondVectorZ);
        double dotProduct = firstVectorX * secondVectorX + firstVectorY * secondVectorY + firstVectorZ * secondVectorZ;
        if ((dotProduct /= firstVectorLength * secondVectorLength) > 1.0) {
            dotProduct = 1.0;
        } else if (dotProduct < -1.0) {
            dotProduct = -1.0;
        }
        return EuclidCoreTools.acos(dotProduct);
    }

    public static double angleFromFirstToSecondVector3D(Vector3DReadOnly firstVector, Vector3DReadOnly secondVector) {
        return EuclidCoreTools.angleFromFirstToSecondVector3D(firstVector.getX(), firstVector.getY(), firstVector.getZ(), firstVector instanceof UnitVector3DReadOnly, secondVector.getX(), secondVector.getY(), secondVector.getZ(), secondVector instanceof UnitVector3DReadOnly);
    }

    public static void differentiateOrientation(QuaternionReadOnly qStart, QuaternionReadOnly qEnd, double duration, Vector3DBasics angularVelocityToPack) {
        double q1x = qStart.getX();
        double q1y = qStart.getY();
        double q1z = qStart.getZ();
        double q1s = qStart.getS();
        double q2x = qEnd.getX();
        double q2y = qEnd.getY();
        double q2z = qEnd.getZ();
        double q2s = qEnd.getS();
        double diffx = q1s * q2x - q1x * q2s - q1y * q2z + q1z * q2y;
        double diffy = q1s * q2y + q1x * q2z - q1y * q2s - q1z * q2x;
        double diffz = q1s * q2z - q1x * q2y + q1y * q2x - q1z * q2s;
        double diffs = q1s * q2s + q1x * q2x + q1y * q2y + q1z * q2z;
        if (diffs < 0.0) {
            diffx = -diffx;
            diffy = -diffy;
            diffz = -diffz;
            diffs = -diffs;
        }
        double sinHalfTheta = EuclidCoreTools.norm(diffx, diffy, diffz);
        double angle = EuclidCoreTools.epsilonEquals(1.0, diffs, 1.0E-12) ? 2.0 * sinHalfTheta / diffs : 2.0 * EuclidCoreTools.atan2(sinHalfTheta, diffs);
        angularVelocityToPack.set(diffx, diffy, diffz);
        angularVelocityToPack.scale(angle / (sinHalfTheta * duration));
    }

    public static void setYawPitchRollDegrees(Orientation3DBasics orientation3DBasics, double yaw, double pitch, double roll) {
        orientation3DBasics.setYawPitchRoll(Math.toRadians(yaw), Math.toRadians(pitch), Math.toRadians(roll));
    }

    public static void projectRotationOnAxis(QuaternionReadOnly rotation, Vector3DReadOnly axis, QuaternionBasics result) {
        double dotProduct = rotation.getX() * axis.getX() + rotation.getY() * axis.getY() + rotation.getZ() * axis.getZ();
        double scale = dotProduct / axis.normSquared();
        double projectedX = scale * axis.getX();
        double projectedY = scale * axis.getY();
        double projectedZ = scale * axis.getZ();
        result.set(projectedX, projectedY, projectedZ, rotation.getS());
        result.normalize();
    }

    public static void extractNormalPart(Tuple3DReadOnly input, Vector3DReadOnly normalAxis, Tuple3DBasics inputNormalPartToPack) {
        double normalX = normalAxis.getX();
        double normalY = normalAxis.getY();
        double normalZ = normalAxis.getZ();
        double normalLengthSquared = EuclidCoreTools.normSquared(normalX, normalY, normalZ);
        double dot = TupleTools.dot(normalAxis, input) / normalLengthSquared;
        inputNormalPartToPack.setAndScale(dot, normalAxis);
    }

    public static void extractTangentialPart(Tuple3DReadOnly input, Vector3DReadOnly normalAxis, Tuple3DBasics inputTagentialPartToPack) {
        double normalX = normalAxis.getX();
        double normalY = normalAxis.getY();
        double normalZ = normalAxis.getZ();
        double normalLengthSquared = EuclidCoreTools.normSquared(normalX, normalY, normalZ);
        double dot = TupleTools.dot(normalX, normalY, normalZ, input) / normalLengthSquared;
        double normalPartX = dot * normalX;
        double normalPartY = dot * normalY;
        double normalPartZ = dot * normalZ;
        inputTagentialPartToPack.set(input);
        inputTagentialPartToPack.sub(normalPartX, normalPartY, normalPartZ);
    }

    public static void setNormalPart(Tuple3DReadOnly input, Vector3DReadOnly normalAxis, Tuple3DBasics tupleToModify) {
        double normalX = normalAxis.getX();
        double normalY = normalAxis.getY();
        double normalZ = normalAxis.getZ();
        double normalLengthSquared = EuclidCoreTools.normSquared(normalX, normalY, normalZ);
        double dot = (TupleTools.dot(normalAxis, input) - TupleTools.dot(normalAxis, tupleToModify)) / normalLengthSquared;
        tupleToModify.scaleAdd(dot, normalAxis, tupleToModify);
    }

    public static void transform(Matrix3DReadOnly matrix, double xOriginal, double yOriginal, double zOriginal, Tuple3DBasics tupleTransformed) {
        double x = matrix.getM00() * xOriginal + matrix.getM01() * yOriginal + matrix.getM02() * zOriginal;
        double y = matrix.getM10() * xOriginal + matrix.getM11() * yOriginal + matrix.getM12() * zOriginal;
        double z = matrix.getM20() * xOriginal + matrix.getM21() * yOriginal + matrix.getM22() * zOriginal;
        tupleTransformed.set(x, y, z);
    }

    public static boolean isZero(Tuple3DReadOnly tuple, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple.getX(), 0.0, epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(tuple.getY(), 0.0, epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple.getZ(), 0.0, epsilon);
    }

    public static boolean isZero(Tuple2DReadOnly tuple, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple.getX(), 0.0, epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple.getY(), 0.0, epsilon);
    }
}

