/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class EuclidCoreIOTools {
    public static final String DEFAULT_FORMAT = EuclidCoreIOTools.getStringFormat(6, 3);

    private EuclidCoreIOTools() {
    }

    public static String getRigidBodyTransformString(RigidBodyTransform rigidBodyTransform) {
        return EuclidCoreIOTools.getRigidBodyTransformString(DEFAULT_FORMAT, rigidBodyTransform);
    }

    public static String getRigidBodyTransformString(String format, RigidBodyTransform rigidBodyTransform) {
        if (rigidBodyTransform == null) {
            return "null";
        }
        return EuclidCoreIOTools.getHomogeneousTransformString(format, rigidBodyTransform.getRotation(), rigidBodyTransform.getTranslation());
    }

    public static String getAffineTransformString(AffineTransformReadOnly affineTransform) {
        return EuclidCoreIOTools.getAffineTransformString(DEFAULT_FORMAT, affineTransform);
    }

    public static String getAffineTransformString(String format, AffineTransformReadOnly affineTransform) {
        if (affineTransform == null) {
            return "null";
        }
        return EuclidCoreIOTools.getHomogeneousTransformString(format, affineTransform.getLinearTransform(), affineTransform.getTranslation());
    }

    private static String getHomogeneousTransformString(String format, Matrix3DReadOnly matrix, Tuple3DReadOnly translation) {
        Object ret = "";
        for (int i = 0; i < 3; ++i) {
            ret = (String)ret + EuclidCoreIOTools.getStringOf(null, " ", " ", format, matrix.getElement(i, 0), matrix.getElement(i, 1), matrix.getElement(i, 2));
            ret = (String)ret + "| " + EuclidCoreIOTools.toString(format, translation.getElement(i)) + "\n";
        }
        ret = (String)ret + EuclidCoreIOTools.getStringOf(null, " ", " ", format, 0.0, 0.0, 0.0);
        ret = (String)ret + "| " + EuclidCoreIOTools.toString(format, 1.0);
        return ret;
    }

    public static String getQuaternionBasedTransformString(QuaternionBasedTransform quaternionBasedTransform) {
        return EuclidCoreIOTools.getQuaternionBasedTransformString(DEFAULT_FORMAT, quaternionBasedTransform);
    }

    public static String getQuaternionBasedTransformString(String format, QuaternionBasedTransform quaternionBasedTransform) {
        if (quaternionBasedTransform == null) {
            return "null";
        }
        return EuclidCoreIOTools.getQuaternionBasedTransformString(format, quaternionBasedTransform.getRotation(), quaternionBasedTransform.getTranslation());
    }

    private static String getQuaternionBasedTransformString(String format, QuaternionReadOnly quaternion, Tuple3DReadOnly translation) {
        if (quaternion == null) {
            return "null";
        }
        Object ret = "";
        ret = (String)ret + EuclidCoreIOTools.getStringOf("Quaternion:  (", " )\n", ", ", format, quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getS());
        ret = (String)ret + EuclidCoreIOTools.getStringOf("Translation: (", " )", ", ", format, translation.getX(), translation.getY(), translation.getZ());
        return ret;
    }

    public static String getTuple2DString(Tuple2DReadOnly tuple) {
        return EuclidCoreIOTools.getTuple2DString(DEFAULT_FORMAT, tuple);
    }

    public static String getTuple2DString(String format, Tuple2DReadOnly tuple) {
        if (tuple == null) {
            return "null";
        }
        return EuclidCoreIOTools.getStringOf("(", " )", ", ", format, tuple.getX(), tuple.getY());
    }

    public static String getTuple3DString(Tuple3DReadOnly tuple) {
        return EuclidCoreIOTools.getTuple3DString(DEFAULT_FORMAT, tuple);
    }

    public static String getTuple3DString(String format, Tuple3DReadOnly tuple) {
        if (tuple == null) {
            return "null";
        }
        return EuclidCoreIOTools.getStringOf("(", " )", ", ", format, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static String getTuple4DString(Tuple4DReadOnly tuple) {
        return EuclidCoreIOTools.getTuple4DString(DEFAULT_FORMAT, tuple);
    }

    public static String getTuple4DString(String format, Tuple4DReadOnly tuple) {
        if (tuple == null) {
            return "null";
        }
        return EuclidCoreIOTools.getStringOf("(", " )", ", ", format, tuple.getX(), tuple.getY(), tuple.getZ(), tuple.getS());
    }

    public static String getAxisAngleString(AxisAngleReadOnly axisAngle) {
        return EuclidCoreIOTools.getAxisAngleString(DEFAULT_FORMAT, axisAngle);
    }

    public static String getAxisAngleString(String format, AxisAngleReadOnly axisAngle) {
        if (axisAngle == null) {
            return "null";
        }
        return EuclidCoreIOTools.getStringOf("(", " )", ", ", format, axisAngle.getX(), axisAngle.getY(), axisAngle.getZ(), axisAngle.getAngle());
    }

    public static String getOrientation2DString(Orientation2DReadOnly orientation2D) {
        return EuclidCoreIOTools.getOrientation2DString(DEFAULT_FORMAT, orientation2D);
    }

    public static String getOrientation2DString(String format, Orientation2DReadOnly orientation2D) {
        if (orientation2D == null) {
            return "null";
        }
        return EuclidCoreIOTools.getOrientation2DString(format, orientation2D.getYaw());
    }

    public static String getOrientation2DString(String format, double orientation2DAngle) {
        return EuclidCoreIOTools.getStringOf("(", " )", ", ", format, orientation2DAngle);
    }

    public static String getMatrix3DString(Matrix3DReadOnly matrix) {
        return EuclidCoreIOTools.getMatrix3DString(DEFAULT_FORMAT, matrix);
    }

    public static String getMatrix3DString(String format, Matrix3DReadOnly matrix) {
        if (matrix == null) {
            return "null";
        }
        return EuclidCoreIOTools.getMatrix3DString(format, matrix.getM00(), matrix.getM01(), matrix.getM02(), matrix.getM10(), matrix.getM11(), matrix.getM12(), matrix.getM20(), matrix.getM21(), matrix.getM22());
    }

    public static String getMatrix3DString(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return EuclidCoreIOTools.getMatrix3DString(DEFAULT_FORMAT, m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static String getMatrix3DString(String format, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        Object ret = EuclidCoreIOTools.getStringOf("/", " \\\n", ", ", format, m00, m01, m02);
        ret = (String)ret + EuclidCoreIOTools.getStringOf("|", " |\n", ", ", format, m10, m11, m12);
        ret = (String)ret + EuclidCoreIOTools.getStringOf("\\", " /", ", ", format, m20, m21, m22);
        return ret;
    }

    public static String getYawPitchRollString(YawPitchRollReadOnly yawPitchRoll) {
        return EuclidCoreIOTools.getYawPitchRollString(DEFAULT_FORMAT, yawPitchRoll);
    }

    public static String getYawPitchRollString(String format, YawPitchRollReadOnly yawPitchRoll) {
        if (yawPitchRoll == null) {
            return "null";
        }
        return EuclidCoreIOTools.getYawPitchRollString(format, yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll());
    }

    public static String getStringAsYawPitchRoll(Orientation3DReadOnly orientation) {
        return EuclidCoreIOTools.getStringAsYawPitchRoll(DEFAULT_FORMAT, orientation);
    }

    public static String getStringAsYawPitchRoll(String format, Orientation3DReadOnly orientation) {
        if (orientation == null) {
            return "null";
        }
        return EuclidCoreIOTools.getYawPitchRollString(format, orientation.getYaw(), orientation.getPitch(), orientation.getRoll());
    }

    public static String getYawPitchRollString(double yaw, double pitch, double roll) {
        return EuclidCoreIOTools.getYawPitchRollString(DEFAULT_FORMAT, yaw, pitch, roll);
    }

    public static String getYawPitchRollString(String format, double yaw, double pitch, double roll) {
        return EuclidCoreIOTools.getStringOf("yaw-pitch-roll: (", ")", ", ", format, yaw, pitch, roll);
    }

    public static String getStringOf(String separator, double ... values) {
        return EuclidCoreIOTools.getStringOf(separator, DEFAULT_FORMAT, values);
    }

    public static String getStringOf(String separator, String format, double ... values) {
        return EuclidCoreIOTools.getStringOf(null, null, separator, format, values);
    }

    public static String getStringOf(String prefix, String suffix, String separator, double ... values) {
        return EuclidCoreIOTools.getStringOf(prefix, suffix, separator, DEFAULT_FORMAT, values);
    }

    public static String getStringOf(String prefix, String suffix, String separator, String format, double ... values) {
        if (values == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (values.length > 0) {
            sb.append(EuclidCoreIOTools.toString(format, values[0]));
            for (int i = 1; i < values.length; ++i) {
                sb.append(separator);
                sb.append(EuclidCoreIOTools.toString(format, values[i]));
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String getStringOf(String separator, float ... values) {
        return EuclidCoreIOTools.getStringOf(separator, DEFAULT_FORMAT, values);
    }

    public static String getStringOf(String separator, String format, float ... values) {
        return EuclidCoreIOTools.getStringOf(null, null, separator, format, values);
    }

    public static String getStringOf(String prefix, String suffix, String separator, float ... values) {
        return EuclidCoreIOTools.getStringOf(prefix, suffix, separator, DEFAULT_FORMAT, values);
    }

    public static String getStringOf(String prefix, String suffix, String separator, String format, float ... values) {
        if (values == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (values.length > 0) {
            sb.append(EuclidCoreIOTools.toString(format, values[0]));
            for (int i = 1; i < values.length; ++i) {
                sb.append(separator);
                sb.append(EuclidCoreIOTools.toString(format, values[i]));
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String getStringOf(String separator, boolean ... values) {
        return EuclidCoreIOTools.getStringOf(null, null, separator, values);
    }

    public static String getStringOf(String prefix, String suffix, String separator, boolean ... values) {
        if (values == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (values.length > 0) {
            sb.append(Boolean.toString(values[0]));
            for (int i = 1; i < values.length; ++i) {
                sb.append(separator);
                sb.append(Boolean.toString(values[i]));
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String getStringOf(String separator, int ... values) {
        return EuclidCoreIOTools.getStringOf(null, null, separator, values);
    }

    public static String getStringOf(String prefix, String suffix, String separator, int ... values) {
        if (values == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (values.length > 0) {
            sb.append(Integer.toString(values[0]));
            for (int i = 1; i < values.length; ++i) {
                sb.append(separator);
                sb.append(Integer.toString(values[i]));
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String getStringOf(String separator, long ... values) {
        return EuclidCoreIOTools.getStringOf(null, null, separator, values);
    }

    public static String getStringOf(String prefix, String suffix, String separator, long ... values) {
        if (values == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (values.length > 0) {
            sb.append(Long.toString(values[0]));
            for (int i = 1; i < values.length; ++i) {
                sb.append(separator);
                sb.append(Long.toString(values[i]));
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String getArrayString(String separator, Object[] array) {
        return EuclidCoreIOTools.getArrayString(null, null, separator, array);
    }

    public static String getArrayString(String prefix, String suffix, String separator, Object[] array) {
        return EuclidCoreIOTools.getArrayString(prefix, suffix, separator, array, Object::toString);
    }

    public static <T> String getArrayString(String separator, T[] array, Function<T, String> elementToStringFunction) {
        return EuclidCoreIOTools.getArrayString(null, null, separator, array, elementToStringFunction);
    }

    public static <T> String getArrayString(String prefix, String suffix, String separator, T[] array, Function<T, String> elementToStringFunction) {
        if (array == null) {
            return "null";
        }
        return EuclidCoreIOTools.getCollectionString(prefix, suffix, separator, Arrays.asList(array), elementToStringFunction);
    }

    public static String getCollectionString(String separator, Collection<?> collection) {
        return EuclidCoreIOTools.getCollectionString(null, null, separator, collection);
    }

    public static String getCollectionString(String prefix, String suffix, String separator, Collection<?> collection) {
        return EuclidCoreIOTools.getCollectionString(prefix, suffix, separator, collection, Object::toString);
    }

    public static <T> String getCollectionString(String separator, Collection<? extends T> collection, Function<T, String> elementToStringFunction) {
        return EuclidCoreIOTools.getCollectionString(null, null, separator, collection, elementToStringFunction);
    }

    public static <T> String getCollectionString(String prefix, String suffix, String separator, Collection<? extends T> collection, Function<T, String> elementToStringFunction) {
        if (collection == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (!collection.isEmpty()) {
            Iterator<T> iterator = collection.iterator();
            sb.append(elementToStringFunction.apply(iterator.next()));
            while (iterator.hasNext()) {
                T next = iterator.next();
                sb.append(separator);
                sb.append(next == null ? "null" : elementToStringFunction.apply(next));
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String toString(String format, double value) {
        return format != null ? String.format(format, value) : Double.toString(value);
    }

    public static String toString(String format, float value) {
        return format != null ? String.format(format, Float.valueOf(value)) : Float.toString(value);
    }

    public static String toString(String format, boolean value) {
        return format != null ? String.format(format, value) : Boolean.toString(value);
    }

    public static String toString(String format, int value) {
        return format != null ? String.format(format, value) : Integer.toString(value);
    }

    public static String toString(String format, long value) {
        return format != null ? String.format(format, value) : Long.toString(value);
    }

    public static String getStringFormat(int numberOfChar, int precision) {
        return "%" + numberOfChar + "." + precision + "f";
    }
}

