/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Tuple3DBasics
extends Tuple3DReadOnly,
Clearable,
Transformable {
    public void setX(double var1);

    public void setY(double var1);

    public void setZ(double var1);

    @Override
    default public void setToZero() {
        this.set(0.0, 0.0, 0.0);
    }

    @Override
    default public void setToNaN() {
        this.set(Double.NaN, Double.NaN, Double.NaN);
    }

    @Override
    default public boolean containsNaN() {
        return Tuple3DReadOnly.super.containsNaN();
    }

    default public void absolute() {
        this.set(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()));
    }

    default public void negate() {
        this.set(-this.getX(), -this.getY(), -this.getZ());
    }

    default public void normalize() {
        if (this.containsNaN()) {
            return;
        }
        this.scale(1.0 / this.norm());
    }

    default public void clipToMax(double max) {
        this.set(Math.min(max, this.getX()), Math.min(max, this.getY()), Math.min(max, this.getZ()));
    }

    default public void clipToMin(double min) {
        this.set(Math.max(min, this.getX()), Math.max(min, this.getY()), Math.max(min, this.getZ()));
    }

    default public void clipToMinMax(double min, double max) {
        this.setAndClipToMinMax(min, max, this);
    }

    default public boolean clipToMaxNorm(double maxNorm) {
        if (maxNorm < 1.0E-7) {
            this.setToZero();
            return true;
        }
        double normSquared = this.normSquared();
        if (normSquared < maxNorm * maxNorm) {
            return false;
        }
        this.scale(maxNorm / EuclidCoreTools.squareRoot(normSquared));
        return true;
    }

    default public void setElement(Axis3D axis, double value) {
        axis.insert(this, value);
    }

    default public void setElement(int index, double value) {
        switch (index) {
            case 0: {
                this.setX(value);
                break;
            }
            case 1: {
                this.setY(value);
                break;
            }
            case 2: {
                this.setZ(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
        }
    }

    default public void set(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    default public void set(Tuple2DReadOnly tuple2DReadOnly) {
        this.set(tuple2DReadOnly.getX(), tuple2DReadOnly.getY(), this.getZ());
    }

    default public void set(Tuple2DReadOnly tuple2DReadOnly, double z) {
        this.set(tuple2DReadOnly.getX(), tuple2DReadOnly.getY(), z);
    }

    default public void set(Tuple3DReadOnly tupleReadOnly) {
        this.set(tupleReadOnly.getX(), tupleReadOnly.getY(), tupleReadOnly.getZ());
    }

    default public void set(double[] tupleArray) {
        this.set(tupleArray[0], tupleArray[1], tupleArray[2]);
    }

    default public void set(int startIndex, double[] tupleArray) {
        this.set(tupleArray[startIndex++], tupleArray[startIndex++], tupleArray[startIndex]);
    }

    default public void set(float[] tupleArray) {
        this.set(tupleArray[0], tupleArray[1], tupleArray[2]);
    }

    default public void set(int startIndex, float[] tupleArray) {
        this.set(tupleArray[startIndex++], tupleArray[startIndex++], tupleArray[startIndex]);
    }

    default public void set(DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(3, 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(0, 0), matrix.unsafe_get(1, 0), matrix.unsafe_get(2, 0));
    }

    default public void set(int startRow, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 3, 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(startRow++, 0), matrix.unsafe_get(startRow++, 0), matrix.unsafe_get(startRow, 0));
    }

    default public void set(int startRow, int column, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 3, column + 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow, column));
    }

    default public void setAndAbsolute(Tuple3DReadOnly other) {
        this.set(Math.abs(other.getX()), Math.abs(other.getY()), Math.abs(other.getZ()));
    }

    default public void setAndNegate(Tuple3DReadOnly other) {
        this.set(-other.getX(), -other.getY(), -other.getZ());
    }

    default public void setAndNormalize(Tuple3DReadOnly other) {
        this.set(other);
        this.normalize();
    }

    default public void setAndScale(double scalar, Tuple3DReadOnly other) {
        this.set(scalar * other.getX(), scalar * other.getY(), scalar * other.getZ());
    }

    default public void setAndClipToMax(double max, Tuple3DReadOnly other) {
        this.set(Math.min(max, other.getX()), Math.min(max, other.getY()), Math.min(max, other.getZ()));
    }

    default public void setAndClipToMin(double min, Tuple3DReadOnly other) {
        this.set(Math.max(min, other.getX()), Math.max(min, other.getY()), Math.max(min, other.getZ()));
    }

    default public void setAndClipToMinMax(double min, double max, Tuple3DReadOnly other) {
        double x = other.getX();
        double y = other.getY();
        double z = other.getZ();
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        if (y < min) {
            y = min;
        } else if (y > max) {
            y = max;
        }
        if (z < min) {
            z = min;
        } else if (z > max) {
            z = max;
        }
        this.set(x, y, z);
    }

    default public void addX(double x) {
        this.setX(this.getX() + x);
    }

    default public void addY(double y) {
        this.setY(this.getY() + y);
    }

    default public void addZ(double z) {
        this.setZ(this.getZ() + z);
    }

    default public void add(double x, double y, double z) {
        this.set(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    default public void add(Tuple3DReadOnly other) {
        this.add(other.getX(), other.getY(), other.getZ());
    }

    default public void add(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        this.set(tuple1.getX() + tuple2.getX(), tuple1.getY() + tuple2.getY(), tuple1.getZ() + tuple2.getZ());
    }

    default public void subX(double x) {
        this.setX(this.getX() - x);
    }

    default public void subY(double y) {
        this.setY(this.getY() - y);
    }

    default public void subZ(double z) {
        this.setZ(this.getZ() - z);
    }

    default public void sub(double x, double y, double z) {
        this.set(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    default public void sub(Tuple3DReadOnly other) {
        this.sub(other.getX(), other.getY(), other.getZ());
    }

    default public void sub(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        this.set(tuple1.getX() - tuple2.getX(), tuple1.getY() - tuple2.getY(), tuple1.getZ() - tuple2.getZ());
    }

    default public void scale(double scalar) {
        this.scale(scalar, scalar, scalar);
    }

    default public void scale(double scalarX, double scalarY, double scalarZ) {
        this.set(scalarX * this.getX(), scalarY * this.getY(), scalarZ * this.getZ());
    }

    default public void scaleAdd(double scalar, Tuple3DReadOnly other) {
        this.scale(scalar);
        this.add(other);
    }

    default public void scaleAdd(double scalar, Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        double x = scalar * tuple1.getX() + tuple2.getX();
        double y = scalar * tuple1.getY() + tuple2.getY();
        double z = scalar * tuple1.getZ() + tuple2.getZ();
        this.set(x, y, z);
    }

    default public void scaleSub(double scalar, Tuple3DReadOnly other) {
        this.scale(scalar);
        this.sub(other);
    }

    default public void scaleSub(double scalar, Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        double x = scalar * tuple1.getX() - tuple2.getX();
        double y = scalar * tuple1.getY() - tuple2.getY();
        double z = scalar * tuple1.getZ() - tuple2.getZ();
        this.set(x, y, z);
    }

    default public void interpolate(Tuple3DReadOnly other, double alpha) {
        this.interpolate(this, other, alpha);
    }

    default public void interpolate(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2, double alpha) {
        double x = EuclidCoreTools.interpolate(tuple1.getX(), tuple2.getX(), alpha);
        double y = EuclidCoreTools.interpolate(tuple1.getY(), tuple2.getY(), alpha);
        double z = EuclidCoreTools.interpolate(tuple1.getZ(), tuple2.getZ(), alpha);
        this.set(x, y, z);
    }
}

