/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Point3DReadOnly
extends Tuple3DReadOnly {
    default public double distance(Point3DReadOnly other) {
        return this.differenceNorm(other);
    }

    default public double distanceSquared(Point3DReadOnly other) {
        return this.differenceNormSquared(other);
    }

    default public double distanceXY(Point3DReadOnly other) {
        return EuclidCoreTools.squareRoot(this.distanceXYSquared(other));
    }

    default public double distanceXYSquared(Point3DReadOnly other) {
        double dx = this.getX() - other.getX();
        double dy = this.getY() - other.getY();
        return EuclidCoreTools.normSquared(dx, dy);
    }

    default public double distanceXY(Point2DReadOnly point2DReadOnly) {
        return EuclidCoreTools.squareRoot(this.distanceXYSquared(point2DReadOnly));
    }

    default public double distanceXYSquared(Point2DReadOnly point2DReadOnly) {
        double dx = this.getX() - point2DReadOnly.getX();
        double dy = this.getY() - point2DReadOnly.getY();
        return EuclidCoreTools.normSquared(dx, dy);
    }

    default public double distanceFromOrigin() {
        return EuclidCoreTools.squareRoot(this.distanceFromOriginSquared());
    }

    default public double distanceFromOriginSquared() {
        return EuclidCoreTools.normSquared(this.getX(), this.getY(), this.getZ());
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Point3DReadOnly)) {
            return false;
        }
        Point3DReadOnly other = (Point3DReadOnly)geometry;
        return this.distance(other) <= epsilon;
    }
}

