/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.interfaces.LinearTransform3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tools.SingularValueDecomposition3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class LinearTransform3D
implements LinearTransform3DBasics,
Settable<LinearTransform3D> {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private double m20;
    private double m21;
    private double m22;
    private boolean isRotation = true;
    private boolean rotationDirty = true;
    private boolean isIdentity = true;
    private boolean identityDirty = true;
    private boolean svdDirty = true;
    private final SingularValueDecomposition3D svd = new SingularValueDecomposition3D();
    private final SingularValueDecomposition3D.SVD3DOutput svdOutput = this.svd.getOutput();
    private final QuaternionReadOnly U = EuclidCoreFactories.newObservableQuaternionReadOnly(i -> this.updateSVD(), this.svdOutput.getU());
    private final Vector3DReadOnly scaleView = EuclidCoreFactories.newObservableVector3DReadOnly(a -> this.updateSVD(), this.svdOutput.getW());
    private final QuaternionReadOnly Vt = EuclidCoreFactories.newObservableQuaternionReadOnly(i -> this.updateSVD(), EuclidCoreFactories.newConjugateLinkedQuaternion(this.svdOutput.getV()));
    private boolean quaternionViewDirty = true;
    private final QuaternionReadOnly quaternionView = new QuaternionReadOnly(){
        private double x;
        private double y;
        private double z;
        private double s;

        private void update() {
            if (LinearTransform3D.this.quaternionViewDirty) {
                LinearTransform3D.this.quaternionViewDirty = false;
                LinearTransform3D.this.updateSVD();
                double ux = LinearTransform3D.this.U.getX();
                double uy = LinearTransform3D.this.U.getY();
                double uz = LinearTransform3D.this.U.getZ();
                double us = LinearTransform3D.this.U.getS();
                if (LinearTransform3D.this.isRotationMatrix()) {
                    this.x = ux;
                    this.y = uy;
                    this.z = uz;
                    this.s = us;
                } else {
                    double vx = LinearTransform3D.this.Vt.getX();
                    double vy = LinearTransform3D.this.Vt.getY();
                    double vz = LinearTransform3D.this.Vt.getZ();
                    double vs = LinearTransform3D.this.Vt.getS();
                    this.x = us * vx + ux * vs + uy * vz - uz * vy;
                    this.y = us * vy - ux * vz + uy * vs + uz * vx;
                    this.z = us * vz + ux * vy - uy * vx + uz * vs;
                    this.s = us * vs - ux * vx - uy * vy - uz * vz;
                }
            }
        }

        @Override
        public double getX() {
            this.update();
            return this.x;
        }

        @Override
        public double getY() {
            this.update();
            return this.y;
        }

        @Override
        public double getZ() {
            this.update();
            return this.z;
        }

        @Override
        public double getS() {
            this.update();
            return this.s;
        }

        public int hashCode() {
            return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ(), this.getS());
        }

        public boolean equals(Object object) {
            if (object instanceof QuaternionReadOnly) {
                return this.equals((QuaternionReadOnly)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };

    public LinearTransform3D() {
        this.setIdentity();
    }

    public LinearTransform3D(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public LinearTransform3D(double[] matrixArray) {
        this.set(matrixArray);
    }

    public LinearTransform3D(DMatrix matrix) {
        this.set(matrix);
    }

    public LinearTransform3D(Matrix3DReadOnly matrix3D) {
        this.set(matrix3D);
    }

    public LinearTransform3D(Orientation3DReadOnly orientation) {
        this.set(orientation);
    }

    private void markDirty() {
        this.svdDirty = true;
        this.identityDirty = true;
        this.rotationDirty = true;
        this.quaternionViewDirty = true;
    }

    private void updateSVD() {
        if (this.svdDirty) {
            if (this.isRotationMatrix()) {
                this.svdDirty = false;
                if (this.isIdentity()) {
                    this.svdOutput.setIdentity();
                } else {
                    QuaternionConversion.convertMatrixToQuaternion(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22, this.svdOutput.getU());
                    this.svdOutput.getW().set(1.0, 1.0, 1.0);
                    this.svdOutput.getV().setToZero();
                }
            } else {
                this.svdDirty = false;
                this.svd.decompose(this);
            }
        }
    }

    @Override
    public double determinant() {
        if (this.svdDirty) {
            return LinearTransform3DBasics.super.determinant();
        }
        return this.svdOutput.getW().getX() * this.svdOutput.getW().getY() * this.svdOutput.getW().getZ();
    }

    @Override
    public void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.isRotation = true;
        this.rotationDirty = false;
        this.isIdentity = true;
        this.identityDirty = false;
        this.quaternionViewDirty = true;
        this.svdDirty = false;
        this.svdOutput.setIdentity();
    }

    @Override
    public void setToZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.isRotation = false;
        this.rotationDirty = false;
        this.isIdentity = false;
        this.identityDirty = false;
        this.quaternionViewDirty = true;
        this.svdDirty = false;
        this.svdOutput.setToZero();
    }

    @Override
    public void setToNaN() {
        this.m00 = Double.NaN;
        this.m01 = Double.NaN;
        this.m02 = Double.NaN;
        this.m10 = Double.NaN;
        this.m11 = Double.NaN;
        this.m12 = Double.NaN;
        this.m20 = Double.NaN;
        this.m21 = Double.NaN;
        this.m22 = Double.NaN;
        this.isRotation = false;
        this.rotationDirty = false;
        this.isIdentity = false;
        this.identityDirty = false;
        this.quaternionViewDirty = true;
        this.svdDirty = false;
        this.svdOutput.setToNaN();
    }

    @Override
    public void resetScale() {
        if (this.isIdentity() || this.isRotationMatrix()) {
            return;
        }
        this.updateSVD();
        this.svdOutput.getW().set(1.0, 1.0, 1.0);
        this.svdOutput.getU().appendInvertOther(this.svdOutput.getV());
        this.svdOutput.getV().setToZero();
        this.svdOutput.getU().get(this);
        this.rotationDirty = false;
        this.isRotation = true;
        this.quaternionViewDirty = true;
    }

    @Override
    public boolean isRotationMatrix() {
        if (this.rotationDirty) {
            this.rotationDirty = false;
            this.isRotation = !this.svdDirty ? EuclidCoreTools.epsilonEquals(1.0, this.getScaleX(), 1.0E-7) && EuclidCoreTools.epsilonEquals(1.0, this.getScaleY(), 1.0E-7) && EuclidCoreTools.epsilonEquals(1.0, this.getScaleZ(), 1.0E-7) : LinearTransform3DBasics.super.isRotationMatrix();
        }
        return this.isRotation;
    }

    public boolean isRotationMatrixLazy() {
        if (!this.rotationDirty && this.isRotation) {
            return true;
        }
        if (!this.svdDirty) {
            return this.isRotationMatrix();
        }
        return false;
    }

    @Override
    public boolean isIdentity() {
        if (this.identityDirty) {
            this.identityDirty = false;
            this.isIdentity = LinearTransform3DBasics.super.isIdentity();
            if (this.isIdentity) {
                this.isRotation = true;
            }
        }
        return this.isIdentity;
    }

    @Override
    public void transpose() {
        double temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        temp = this.m02;
        this.m02 = this.m20;
        this.m20 = temp;
        temp = this.m12;
        this.m12 = this.m21;
        this.m21 = temp;
        this.quaternionViewDirty = true;
        if (!this.svdDirty) {
            this.svdOutput.transpose();
        }
    }

    @Override
    public void invert() {
        if (this.isIdentity()) {
            return;
        }
        if (this.isRotationMatrixLazy()) {
            double temp = this.m01;
            this.m01 = this.m10;
            this.m10 = temp;
            temp = this.m02;
            this.m02 = this.m20;
            this.m20 = temp;
            temp = this.m12;
            this.m12 = this.m21;
            this.m21 = temp;
            if (!this.svdDirty) {
                this.svdOutput.getU().conjugate();
            }
        } else {
            LinearTransform3DBasics.super.invert();
            if (!this.svdDirty) {
                this.svdOutput.invert();
                this.svdDirty = false;
            }
        }
        this.quaternionViewDirty = true;
    }

    @Override
    public void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.markDirty();
    }

    @Override
    public void set(Matrix3DReadOnly matrix3D) {
        if (matrix3D instanceof RotationMatrixReadOnly) {
            this.set((RotationMatrixReadOnly)matrix3D);
        } else if (matrix3D instanceof LinearTransform3D) {
            this.set((LinearTransform3D)matrix3D);
        } else {
            LinearTransform3DBasics.super.set(matrix3D);
        }
    }

    @Override
    public void set(RotationMatrixReadOnly rotationMatrix) {
        if (!rotationMatrix.isDirty() && rotationMatrix.isIdentity()) {
            this.setIdentity();
            return;
        }
        this.m00 = rotationMatrix.getM00();
        this.m01 = rotationMatrix.getM01();
        this.m02 = rotationMatrix.getM02();
        this.m10 = rotationMatrix.getM10();
        this.m11 = rotationMatrix.getM11();
        this.m12 = rotationMatrix.getM12();
        this.m20 = rotationMatrix.getM20();
        this.m21 = rotationMatrix.getM21();
        this.m22 = rotationMatrix.getM22();
        this.isRotation = true;
        this.rotationDirty = false;
        this.identityDirty = rotationMatrix.isDirty();
        this.isIdentity = false;
        this.quaternionViewDirty = true;
        this.svdDirty = true;
    }

    @Override
    public void set(LinearTransform3D other) {
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
        this.isRotation = other.isRotation;
        this.rotationDirty = other.rotationDirty;
        this.isIdentity = other.isIdentity;
        this.identityDirty = other.identityDirty;
        this.quaternionViewDirty = true;
        this.svdDirty = other.svdDirty;
        if (!this.svdDirty) {
            this.svdOutput.set(other.svdOutput);
        }
    }

    @Override
    public void setRotationVector(Vector3DReadOnly rotationVector) {
        LinearTransform3DBasics.super.setRotationVector(rotationVector);
        this.isRotation = true;
        this.rotationDirty = false;
    }

    @Override
    public void setEuler(double rotX, double rotY, double rotZ) {
        LinearTransform3DBasics.super.setEuler(rotX, rotY, rotZ);
        this.isRotation = true;
        this.rotationDirty = false;
    }

    @Override
    public void setScale(double x, double y, double z) {
        if (EuclidCoreTools.areAllZero(x, y, z, 1.0E-12)) {
            this.setToZero();
            return;
        }
        this.resetScale();
        if (!(EuclidCoreTools.epsilonEquals(1.0, x, 1.0E-12) && EuclidCoreTools.epsilonEquals(1.0, y, 1.0E-12) && EuclidCoreTools.epsilonEquals(1.0, z, 1.0E-12))) {
            if (!this.svdDirty) {
                this.svdOutput.getW().set(x, y, z);
                this.scaleColumns(x, y, z);
                this.isRotation = false;
                this.rotationDirty = false;
                this.svdDirty = false;
                this.isIdentity = false;
                this.identityDirty = false;
            } else if (this.isRotationMatrixLazy()) {
                this.svdOutput.getU().setRotationMatrix(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
                this.svdOutput.getW().set(x, y, z);
                this.svdOutput.getV().setToZero();
                this.scaleColumns(x, y, z);
                this.isRotation = false;
                this.rotationDirty = false;
                this.svdDirty = false;
                this.isIdentity = false;
                this.identityDirty = false;
            } else {
                this.scaleColumns(x, y, z);
            }
        }
    }

    @Override
    public void appendRotation(Orientation3DReadOnly orientation) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().append(orientation);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.appendRotation(orientation);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.appendRotation(orientation);
        }
    }

    @Override
    public void appendRotationInvertOther(Orientation3DReadOnly orientation) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().appendInvertOther(orientation);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.appendRotationInvertOther(orientation);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.appendRotationInvertOther(orientation);
        }
    }

    @Override
    public void appendYawRotation(double yaw) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().appendYawRotation(yaw);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.appendYawRotation(yaw);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.appendYawRotation(yaw);
        }
    }

    @Override
    public void appendPitchRotation(double pitch) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().appendPitchRotation(pitch);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.appendPitchRotation(pitch);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.appendPitchRotation(pitch);
        }
    }

    @Override
    public void appendRollRotation(double roll) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().appendRollRotation(roll);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.appendRollRotation(roll);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.appendRollRotation(roll);
        }
    }

    @Override
    public void appendScale(double x, double y, double z) {
        if (EuclidCoreTools.areAllZero(x, y, z, 1.0E-12)) {
            this.setToZero();
        } else if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getW().scale(x, y, z);
                LinearTransform3DBasics.super.appendScale(x, y, z);
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.appendScale(x, y, z);
                this.isRotation = EuclidCoreTools.epsilonEquals(1.0, x, 1.0E-7) && EuclidCoreTools.epsilonEquals(1.0, y, 1.0E-7) && EuclidCoreTools.epsilonEquals(1.0, z, 1.0E-7);
                this.rotationDirty = false;
            }
        } else {
            LinearTransform3DBasics.super.appendScale(x, y, z);
        }
    }

    @Override
    public void prependRotation(Orientation3DReadOnly orientation) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().prepend(orientation);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.prependRotation(orientation);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.prependRotation(orientation);
        }
    }

    @Override
    public void prependRotationInvertOther(Orientation3DReadOnly orientation) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().prependInvertOther(orientation);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.prependRotationInvertOther(orientation);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.prependRotationInvertOther(orientation);
        }
    }

    @Override
    public void prependYawRotation(double yaw) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().prependYawRotation(yaw);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.prependYawRotation(yaw);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.prependYawRotation(yaw);
        }
    }

    @Override
    public void prependPitchRotation(double pitch) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().prependPitchRotation(pitch);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.prependPitchRotation(pitch);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.prependPitchRotation(pitch);
        }
    }

    @Override
    public void prependRollRotation(double roll) {
        if (this.isRotationMatrixLazy()) {
            if (!this.svdDirty) {
                this.svdOutput.getU().prependRollRotation(roll);
                this.set(this.svdOutput.getU());
                this.svdDirty = false;
            } else {
                LinearTransform3DBasics.super.prependRollRotation(roll);
            }
            this.isRotation = true;
            this.rotationDirty = false;
        } else {
            LinearTransform3DBasics.super.prependRollRotation(roll);
        }
    }

    @Override
    public void setM00(double m00) {
        if (this.m00 != m00) {
            this.markDirty();
            this.m00 = m00;
        }
    }

    @Override
    public void setM01(double m01) {
        if (this.m01 != m01) {
            this.markDirty();
            this.m01 = m01;
        }
    }

    @Override
    public void setM02(double m02) {
        if (this.m02 != m02) {
            this.markDirty();
            this.m02 = m02;
        }
    }

    @Override
    public void setM10(double m10) {
        if (this.m10 != m10) {
            this.markDirty();
            this.m10 = m10;
        }
    }

    @Override
    public void setM11(double m11) {
        if (this.m11 != m11) {
            this.markDirty();
            this.m11 = m11;
        }
    }

    @Override
    public void setM12(double m12) {
        if (this.m12 != m12) {
            this.markDirty();
            this.m12 = m12;
        }
    }

    @Override
    public void setM20(double m20) {
        if (this.m20 != m20) {
            this.markDirty();
            this.m20 = m20;
        }
    }

    @Override
    public void setM21(double m21) {
        if (this.m21 != m21) {
            this.markDirty();
            this.m21 = m21;
        }
    }

    @Override
    public void setM22(double m22) {
        if (this.m22 != m22) {
            this.markDirty();
            this.m22 = m22;
        }
    }

    @Override
    public QuaternionReadOnly getAsQuaternion() {
        return this.quaternionView;
    }

    @Override
    public QuaternionReadOnly getPreScaleQuaternion() {
        return this.U;
    }

    @Override
    public Vector3DReadOnly getScaleVector() {
        return this.scaleView;
    }

    @Override
    public QuaternionReadOnly getPostScaleQuaternion() {
        return this.Vt;
    }

    @Override
    public double getM00() {
        return this.m00;
    }

    @Override
    public double getM01() {
        return this.m01;
    }

    @Override
    public double getM02() {
        return this.m02;
    }

    @Override
    public double getM10() {
        return this.m10;
    }

    @Override
    public double getM11() {
        return this.m11;
    }

    @Override
    public double getM12() {
        return this.m12;
    }

    @Override
    public double getM20() {
        return this.m20;
    }

    @Override
    public double getM21() {
        return this.m21;
    }

    @Override
    public double getM22() {
        return this.m22;
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix3DReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }
}

