/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.axisAngle.interfaces;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;

public interface AxisAngleReadOnly
extends Orientation3DReadOnly {
    @Override
    default public boolean isZeroOrientation(double epsilon) {
        return Math.abs(this.getAngle()) <= epsilon;
    }

    public UnitVector3DReadOnly getAxis();

    public double getAngle();

    default public float getAngle32() {
        return (float)this.getAngle();
    }

    default public double getX() {
        return this.getAxis().getX();
    }

    default public float getX32() {
        return (float)this.getX();
    }

    default public double getY() {
        return this.getAxis().getY();
    }

    default public float getY32() {
        return (float)this.getY();
    }

    default public double getZ() {
        return this.getAxis().getZ();
    }

    default public float getZ32() {
        return (float)this.getZ();
    }

    @Override
    default public boolean containsNaN() {
        return EuclidCoreTools.containsNaN(this.getX(), this.getY(), this.getZ(), this.getAngle());
    }

    default public double axisNorm() {
        return this.getAxis().norm();
    }

    @Override
    default public boolean isOrientation2D(double epsilon) {
        return Math.abs(this.getAngle()) < epsilon || Math.abs(this.getX()) < epsilon && Math.abs(this.getY()) < epsilon;
    }

    @Override
    default public double distance(Orientation3DReadOnly other, boolean limitToPi) {
        return AxisAngleTools.distance(this, other, limitToPi);
    }

    @Override
    default public double angle() {
        return this.getAngle();
    }

    @Override
    default public double angle(boolean limitToPi) {
        return Math.abs(EuclidCoreTools.trimAngleMinusPiToPi(this.angle()));
    }

    @Override
    default public void get(CommonMatrix3DBasics rotationMatrixToPack) {
        RotationMatrixConversion.convertAxisAngleToMatrix(this, rotationMatrixToPack);
    }

    @Override
    default public void get(AxisAngleBasics axisAngleToPack) {
        axisAngleToPack.setAxisAngle(this.getX(), this.getY(), this.getZ(), this.getAngle());
    }

    @Override
    default public void get(QuaternionBasics quaternionToPack) {
        quaternionToPack.setAxisAngle(this.getX(), this.getY(), this.getZ(), this.getAngle());
    }

    @Override
    default public void get(YawPitchRollBasics yawPitchRollToPack) {
        yawPitchRollToPack.setAxisAngle(this.getX(), this.getY(), this.getZ(), this.getAngle());
    }

    @Override
    default public void getRotationVector(Vector3DBasics rotationVectorToPack) {
        RotationVectorConversion.convertAxisAngleToRotationVector(this, rotationVectorToPack);
    }

    @Override
    default public void getEuler(Tuple3DBasics eulerAnglesToPack) {
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll(this, eulerAnglesToPack);
    }

    @Override
    default public double getYaw() {
        return YawPitchRollConversion.computeYaw(this);
    }

    @Override
    default public double getPitch() {
        return YawPitchRollConversion.computePitch(this);
    }

    @Override
    default public double getRoll() {
        return YawPitchRollConversion.computeRoll(this);
    }

    default public void get(double[] axisAngleArrayToPack) {
        this.get(0, axisAngleArrayToPack);
    }

    default public void get(int startIndex, double[] axisAngleArrayToPack) {
        axisAngleArrayToPack[startIndex++] = this.getX();
        axisAngleArrayToPack[startIndex++] = this.getY();
        axisAngleArrayToPack[startIndex++] = this.getZ();
        axisAngleArrayToPack[startIndex] = this.getAngle();
    }

    default public void get(float[] axisAngleArrayToPack) {
        this.get(0, axisAngleArrayToPack);
    }

    default public void get(int startIndex, float[] axisAngleArrayToPack) {
        axisAngleArrayToPack[startIndex++] = this.getX32();
        axisAngleArrayToPack[startIndex++] = this.getY32();
        axisAngleArrayToPack[startIndex++] = this.getZ32();
        axisAngleArrayToPack[startIndex] = this.getAngle32();
    }

    default public double getElement(int index) {
        switch (index) {
            case 0: {
                return this.getX();
            }
            case 1: {
                return this.getY();
            }
            case 2: {
                return this.getZ();
            }
            case 3: {
                return this.getAngle();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public float getElement32(int index) {
        switch (index) {
            case 0: {
                return this.getX32();
            }
            case 1: {
                return this.getY32();
            }
            case 2: {
                return this.getZ32();
            }
            case 3: {
                return this.getAngle32();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    default public void transform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        AxisAngleTools.transform(this, tupleOriginal, tupleTransformed);
    }

    @Override
    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        AxisAngleTools.transform(this, tupleOriginal, tupleTransformed, checkIfOrientation2D);
    }

    @Override
    default public void transform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        AxisAngleTools.transform(this, matrixOriginal, matrixTransformed);
    }

    @Override
    default public void transform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        AxisAngleTools.transform(this, vectorOriginal, vectorTransformed);
    }

    @Override
    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        AxisAngleTools.inverseTransform(this, tupleOriginal, tupleTransformed);
    }

    @Override
    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        AxisAngleTools.inverseTransform(this, tupleOriginal, tupleTransformed, checkIfOrientation2D);
    }

    @Override
    default public void inverseTransform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        AxisAngleTools.inverseTransform(this, vectorOriginal, vectorTransformed);
    }

    @Override
    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        AxisAngleTools.inverseTransform(this, matrixOriginal, matrixTransformed);
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof AxisAngleReadOnly)) {
            return false;
        }
        AxisAngleReadOnly other = (AxisAngleReadOnly)geometry;
        if (!EuclidCoreTools.equals(this.getX(), other.getX())) {
            return false;
        }
        if (!EuclidCoreTools.equals(this.getY(), other.getY())) {
            return false;
        }
        if (!EuclidCoreTools.equals(this.getZ(), other.getZ())) {
            return false;
        }
        return EuclidCoreTools.equals(this.getAngle(), other.getAngle());
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof AxisAngleReadOnly)) {
            return false;
        }
        AxisAngleReadOnly other = (AxisAngleReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals(this.getX(), other.getX(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getY(), other.getY(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getZ(), other.getZ(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(this.getAngle(), other.getAngle(), epsilon);
    }

    @Override
    default public String toString(String format) {
        return EuclidCoreIOTools.getAxisAngleString(format, this);
    }
}

