/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.orientation.interfaces;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;

public interface Orientation3DReadOnly {
    public static final double ORIENTATION_2D_EPSILON = 1.0E-8;
    public static final double ZERO_EPSILON = 1.0E-8;

    public boolean containsNaN();

    default public boolean isZeroOrientation() {
        return this.isZeroOrientation(1.0E-8);
    }

    public boolean isZeroOrientation(double var1);

    default public boolean isOrientation2D() {
        return this.isOrientation2D(1.0E-8);
    }

    public boolean isOrientation2D(double var1);

    default public void checkIfOrientation2D() {
        this.checkIfOrientation2D(1.0E-8);
    }

    default public void checkIfOrientation2D(double epsilon) {
        if (!this.isOrientation2D(epsilon)) {
            throw new NotAnOrientation2DException(this);
        }
    }

    public void get(CommonMatrix3DBasics var1);

    public void get(AxisAngleBasics var1);

    public void get(QuaternionBasics var1);

    public void get(YawPitchRollBasics var1);

    public void getRotationVector(Vector3DBasics var1);

    public void getEuler(Tuple3DBasics var1);

    public double getYaw();

    public double getPitch();

    public double getRoll();

    default public void transform(Tuple3DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    public void transform(Tuple3DReadOnly var1, Tuple3DBasics var2);

    default public void addTransform(Tuple3DBasics tupleToTransform) {
        this.addTransform(tupleToTransform, tupleToTransform);
    }

    default public void addTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double x = tupleTransformed.getX();
        double y = tupleTransformed.getY();
        double z = tupleTransformed.getZ();
        this.transform(tupleOriginal, tupleTransformed);
        tupleTransformed.add(x, y, z);
    }

    default public void subTransform(Tuple3DBasics tupleToTransform) {
        this.subTransform(tupleToTransform, tupleToTransform);
    }

    default public void subTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double x = tupleTransformed.getX();
        double y = tupleTransformed.getY();
        double z = tupleTransformed.getZ();
        this.transform(tupleOriginal, tupleTransformed);
        tupleTransformed.sub(x, y, z);
        tupleTransformed.negate();
    }

    default public void transform(Tuple2DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform, true);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.transform(tupleOriginal, tupleTransformed, true);
    }

    default public void transform(Tuple2DBasics tupleToTransform, boolean checkIfOrientation2D) {
        this.transform(tupleToTransform, tupleToTransform, checkIfOrientation2D);
    }

    public void transform(Tuple2DReadOnly var1, Tuple2DBasics var2, boolean var3);

    default public void transform(Matrix3DBasics matrixToTransform) {
        this.transform(matrixToTransform, matrixToTransform);
    }

    public void transform(Matrix3DReadOnly var1, Matrix3DBasics var2);

    default public void transform(Vector4DBasics vectorToTransform) {
        this.transform(vectorToTransform, vectorToTransform);
    }

    public void transform(Vector4DReadOnly var1, Vector4DBasics var2);

    default public void transform(RotationMatrixBasics matrixToTransform) {
        this.transform(matrixToTransform, matrixToTransform);
    }

    default public void transform(RotationMatrixReadOnly matrixOriginal, RotationMatrixBasics matrixTransformed) {
        RotationMatrixTools.multiply(this, false, matrixOriginal, false, (CommonMatrix3DBasics)matrixTransformed);
    }

    default public void transform(Orientation3DBasics orientationToTransform) {
        this.transform(orientationToTransform, orientationToTransform);
    }

    default public void transform(Orientation3DReadOnly orientationOriginal, Orientation3DBasics orientationTransformed) {
        if (orientationTransformed != orientationOriginal) {
            orientationTransformed.set(orientationOriginal);
        }
        orientationTransformed.prepend(this);
    }

    default public void inverseTransform(Tuple3DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, tupleToTransform);
    }

    public void inverseTransform(Tuple3DReadOnly var1, Tuple3DBasics var2);

    default public void inverseTransform(Tuple2DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, tupleToTransform, true);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.inverseTransform(tupleOriginal, tupleTransformed, true);
    }

    default public void inverseTransform(Tuple2DBasics tupleToTransform, boolean checkIfOrientation2D) {
        this.inverseTransform(tupleToTransform, tupleToTransform, checkIfOrientation2D);
    }

    public void inverseTransform(Tuple2DReadOnly var1, Tuple2DBasics var2, boolean var3);

    default public void inverseTransform(Matrix3DBasics matrixToTransform) {
        this.inverseTransform(matrixToTransform, matrixToTransform);
    }

    public void inverseTransform(Matrix3DReadOnly var1, Matrix3DBasics var2);

    default public void inverseTransform(Vector4DBasics vectorToTransform) {
        this.inverseTransform(vectorToTransform, vectorToTransform);
    }

    public void inverseTransform(Vector4DReadOnly var1, Vector4DBasics var2);

    default public void inverseTransform(RotationMatrixBasics matrixToTransform) {
        this.inverseTransform(matrixToTransform, matrixToTransform);
    }

    default public void inverseTransform(RotationMatrixReadOnly matrixOriginal, RotationMatrixBasics matrixTransformed) {
        RotationMatrixTools.multiply(this, true, matrixOriginal, false, (CommonMatrix3DBasics)matrixTransformed);
    }

    default public void inverseTransform(Orientation3DBasics orientationToTransform) {
        this.inverseTransform(orientationToTransform, orientationToTransform);
    }

    default public void inverseTransform(Orientation3DReadOnly orientationOriginal, Orientation3DBasics orientationTransformed) {
        if (orientationTransformed != orientationOriginal) {
            orientationTransformed.set(orientationOriginal);
        }
        orientationTransformed.prependInvertOther(this);
    }

    default public String toStringAsYawPitchRoll() {
        return EuclidCoreIOTools.getStringAsYawPitchRoll(this);
    }
}

