/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class Quaternion
implements QuaternionBasics,
GeometryObject<Quaternion> {
    private double x;
    private double y;
    private double z;
    private double s;

    public Quaternion() {
        this.setToZero();
    }

    public Quaternion(double x, double y, double z, double s) {
        this.set(x, y, z, s);
    }

    public Quaternion(double[] quaternionArray) {
        this.set(quaternionArray);
    }

    public Quaternion(DMatrix matrix) {
        this.set(matrix);
    }

    public Quaternion(Orientation3DReadOnly orientation) {
        this.set(orientation);
    }

    public Quaternion(QuaternionReadOnly other) {
        this.set(other);
    }

    public Quaternion(Tuple4DReadOnly other) {
        this.set(other);
    }

    public Quaternion(Vector3DReadOnly rotationVector) {
        this.setRotationVector(rotationVector);
    }

    public Quaternion(double yaw, double pitch, double roll) {
        this.setYawPitchRoll(yaw, pitch, roll);
    }

    @Override
    public void set(Quaternion other) {
        QuaternionBasics.super.set(other);
    }

    @Override
    public void setUnsafe(double qx, double qy, double qz, double qs) {
        this.x = qx;
        this.y = qy;
        this.z = qz;
        this.s = qs;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getS() {
        return this.s;
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple4DReadOnly) {
            return this.equals((Tuple4DReadOnly)object);
        }
        return false;
    }

    @Override
    public boolean epsilonEquals(Quaternion other, double epsilon) {
        return QuaternionBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    public boolean geometricallyEquals(Quaternion other, double epsilon) {
        return QuaternionBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidCoreIOTools.getTuple4DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.x, this.y, this.z, this.s);
    }
}

