/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid;

import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public enum Axis3D implements UnitVector3DReadOnly
{
    X(1.0, 0.0, 0.0){

        @Override
        public double extract(Tuple3DReadOnly tuple) {
            return tuple.getX();
        }

        @Override
        public void insert(Tuple3DBasics tupleToUpdate, double value) {
            tupleToUpdate.setX(value);
        }

        @Override
        public Axis3D next() {
            return Y;
        }

        @Override
        public Axis3D previous() {
            return Z;
        }
    }
    ,
    Y(0.0, 1.0, 0.0){

        @Override
        public double extract(Tuple3DReadOnly tuple) {
            return tuple.getY();
        }

        @Override
        public void insert(Tuple3DBasics tupleToUpdate, double value) {
            tupleToUpdate.setY(value);
        }

        @Override
        public Axis3D next() {
            return Z;
        }

        @Override
        public Axis3D previous() {
            return X;
        }
    }
    ,
    Z(0.0, 0.0, 1.0){

        @Override
        public double extract(Tuple3DReadOnly tuple) {
            return tuple.getZ();
        }

        @Override
        public void insert(Tuple3DBasics tupleToUpdate, double value) {
            tupleToUpdate.setZ(value);
        }

        @Override
        public Axis3D next() {
            return X;
        }

        @Override
        public Axis3D previous() {
            return Y;
        }
    };

    public static final Axis3D[] values;
    private final double x;
    private final double y;
    private final double z;
    private final UnitVector3DReadOnly negated = EuclidCoreFactories.newNegativeLinkedUnitVector3D(this);

    private Axis3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public UnitVector3DReadOnly negated() {
        return this.negated;
    }

    @Override
    public double dot(Vector3DReadOnly other) {
        return this.extract(other);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getRawX() {
        return this.x;
    }

    @Override
    public double getRawY() {
        return this.y;
    }

    @Override
    public double getRawZ() {
        return this.z;
    }

    public abstract void insert(Tuple3DBasics var1, double var2);

    public abstract double extract(Tuple3DReadOnly var1);

    public abstract Axis3D next();

    public abstract Axis3D previous();

    @Deprecated
    public static double get(Tuple3DReadOnly tuple, Axis3D axis) {
        return axis.extract(tuple);
    }

    public static void set(Tuple3DBasics tupleToModify, Axis3D axis, double value) {
        axis.insert(tupleToModify, value);
    }

    @Deprecated
    public Axis3D getNextClockwiseAxis() {
        return this.previous();
    }

    @Deprecated
    public Axis3D getNextCounterClockwiseAxis() {
        return this.next();
    }

    static {
        values = Axis3D.values();
    }
}

