/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Vector3DReadOnly
extends Tuple3DReadOnly {
    default public double length() {
        return EuclidCoreTools.squareRoot(this.lengthSquared());
    }

    default public double lengthSquared() {
        return EuclidCoreTools.normSquared(this.getX(), this.getY(), this.getZ());
    }

    default public double dot(Vector3DReadOnly other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    default public double angle(Vector3DReadOnly other) {
        double normalizedDot = this.dot(other) / (this.length() * other.length());
        if (normalizedDot < -1.0) {
            normalizedDot = -1.0;
        } else if (normalizedDot > 1.0) {
            normalizedDot = 1.0;
        }
        return EuclidCoreTools.acos(normalizedDot);
    }

    default public boolean geometricallyEquals(Vector3DReadOnly other, double epsilon) {
        double dz;
        double dy;
        double dx = this.getX() - other.getX();
        return EuclidCoreTools.norm(dx, dy = this.getY() - other.getY(), dz = this.getZ() - other.getZ()) <= epsilon;
    }
}

