/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Vector3DBasics
extends Tuple3DBasics,
Vector3DReadOnly,
Transformable {
    public static final double EPS_MAX_LENGTH = 1.0E-7;

    default public void normalize() {
        if (this.containsNaN()) {
            return;
        }
        this.scale(1.0 / this.length());
    }

    default public void setAndNormalize(Tuple3DReadOnly other) {
        this.set(other);
        this.normalize();
    }

    default public void cross(Tuple3DReadOnly other) {
        this.cross(this, other);
    }

    default public void cross(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        double x = tuple1.getY() * tuple2.getZ() - tuple1.getZ() * tuple2.getY();
        double y = tuple1.getZ() * tuple2.getX() - tuple1.getX() * tuple2.getZ();
        double z = tuple1.getX() * tuple2.getY() - tuple1.getY() * tuple2.getX();
        this.set(x, y, z);
    }

    default public boolean clipToMaxLength(double maxLength) {
        if (maxLength < 1.0E-7) {
            this.setToZero();
            return true;
        }
        double lengthSquared = this.lengthSquared();
        if (lengthSquared < maxLength * maxLength) {
            return false;
        }
        this.scale(maxLength / EuclidCoreTools.squareRoot(lengthSquared));
        return true;
    }

    @Override
    default public void applyTransform(Transform transform) {
        transform.transform(this);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this);
    }
}

