/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class TupleTools {
    private TupleTools() {
    }

    public static double dot(double x, double y, Tuple2DReadOnly tuple) {
        return x * tuple.getX() + y * tuple.getY();
    }

    public static double dot(double x, double y, double z, Tuple3DReadOnly tuple) {
        return x * tuple.getX() + y * tuple.getY() + z * tuple.getZ();
    }

    public static double dot(double x, double y, double z, double s, Tuple4DReadOnly tuple) {
        return x * tuple.getX() + y * tuple.getY() + z * tuple.getZ() + s * tuple.getS();
    }

    public static double dot(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        return tuple1.getX() * tuple2.getX() + tuple1.getY() * tuple2.getY();
    }

    public static double dot(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        return tuple1.getX() * tuple2.getX() + tuple1.getY() * tuple2.getY() + tuple1.getZ() * tuple2.getZ();
    }

    public static boolean epsilonEquals(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple1.getX(), tuple2.getX(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple1.getY(), tuple2.getY(), epsilon);
    }

    public static boolean epsilonEquals(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple1.getX(), tuple2.getX(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(tuple1.getY(), tuple2.getY(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple1.getZ(), tuple2.getZ(), epsilon);
    }

    public static boolean epsilonEquals(Tuple4DReadOnly tuple1, Tuple4DReadOnly tuple2, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple1.getX(), tuple2.getX(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(tuple1.getY(), tuple2.getY(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(tuple1.getZ(), tuple2.getZ(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple1.getS(), tuple2.getS(), epsilon);
    }

    public static boolean isTupleZero(Tuple2DReadOnly tuple, double epsilon) {
        return EuclidCoreTools.areAllZero(tuple.getX(), tuple.getY(), epsilon);
    }

    public static boolean isTupleZero(Tuple3DReadOnly tuple, double epsilon) {
        return EuclidCoreTools.areAllZero(tuple.getX(), tuple.getY(), tuple.getZ(), epsilon);
    }

    public static boolean isTupleZero(Tuple4DReadOnly tuple, double epsilon) {
        return EuclidCoreTools.areAllZero(tuple.getX(), tuple.getY(), tuple.getZ(), tuple.getS(), epsilon);
    }
}

