/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class QuaternionConversion {
    public static final double EPS = 1.0E-7;

    private QuaternionConversion() {
    }

    public static final void computeYawQuaternion(double yaw, QuaternionBasics quaternionToPack) {
        double halfYaw = 0.5 * yaw;
        quaternionToPack.setUnsafe(0.0, 0.0, EuclidCoreTools.sin(halfYaw), EuclidCoreTools.cos(halfYaw));
    }

    public static final void computePitchQuaternion(double pitch, QuaternionBasics quaternionToPack) {
        double halfPitch = 0.5 * pitch;
        quaternionToPack.setUnsafe(0.0, EuclidCoreTools.sin(halfPitch), 0.0, EuclidCoreTools.cos(halfPitch));
    }

    public static final void computeRollQuaternion(double roll, QuaternionBasics quaternionToPack) {
        double halfRoll = 0.5 * roll;
        quaternionToPack.setUnsafe(EuclidCoreTools.sin(halfRoll), 0.0, 0.0, EuclidCoreTools.cos(halfRoll));
    }

    public static final void convertAxisAngleToQuaternion(AxisAngleReadOnly axisAngle, QuaternionBasics quaternionToPack) {
        QuaternionConversion.convertAxisAngleToQuaternion(axisAngle.getX(), axisAngle.getY(), axisAngle.getZ(), axisAngle.getAngle(), quaternionToPack);
    }

    public static final void convertAxisAngleToQuaternion(double ux, double uy, double uz, double angle, QuaternionBasics quaternionToPack) {
        if (EuclidCoreTools.containsNaN(ux, uy, uz, angle)) {
            quaternionToPack.setToNaN();
            return;
        }
        double uNorm = EuclidCoreTools.fastNorm(ux, uy, uz);
        if (uNorm < 1.0E-7) {
            quaternionToPack.setToZero();
        } else {
            double halfTheta = 0.5 * angle;
            double cosHalfTheta = EuclidCoreTools.cos(halfTheta);
            double sinHalfTheta = EuclidCoreTools.sin(halfTheta) / uNorm;
            quaternionToPack.setUnsafe(ux * sinHalfTheta, uy * sinHalfTheta, uz * sinHalfTheta, cosHalfTheta);
        }
    }

    public static void convertMatrixToQuaternion(RotationMatrixReadOnly rotationMatrix, QuaternionBasics quaternionToPack) {
        double m00 = rotationMatrix.getM00();
        double m01 = rotationMatrix.getM01();
        double m02 = rotationMatrix.getM02();
        double m10 = rotationMatrix.getM10();
        double m11 = rotationMatrix.getM11();
        double m12 = rotationMatrix.getM12();
        double m20 = rotationMatrix.getM20();
        double m21 = rotationMatrix.getM21();
        double m22 = rotationMatrix.getM22();
        QuaternionConversion.convertMatrixToQuaternion(m00, m01, m02, m10, m11, m12, m20, m21, m22, quaternionToPack);
    }

    public static void convertMatrixToQuaternion(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, QuaternionBasics quaternionToPack) {
        double qz;
        double qy;
        double qx;
        double qs;
        if (EuclidCoreTools.containsNaN(m00, m01, m02, m10, m11, m12, m20, m21, m22)) {
            quaternionToPack.setToNaN();
            return;
        }
        double s = m00 + m11 + m22;
        if (s > -0.19) {
            qs = 0.5 * EuclidCoreTools.squareRoot(s + 1.0);
            double inv = 0.25 / qs;
            qx = inv * (m21 - m12);
            qy = inv * (m02 - m20);
            qz = inv * (m10 - m01);
        } else {
            s = m00 - m11 - m22;
            if (s > -0.19) {
                qx = 0.5 * EuclidCoreTools.squareRoot(s + 1.0);
                double inv = 0.25 / qx;
                qs = inv * (m21 - m12);
                qy = inv * (m10 + m01);
                qz = inv * (m20 + m02);
            } else {
                s = m11 - m00 - m22;
                if (s > -0.19) {
                    qy = 0.5 * EuclidCoreTools.squareRoot(s + 1.0);
                    double inv = 0.25 / qy;
                    qs = inv * (m02 - m20);
                    qx = inv * (m10 + m01);
                    qz = inv * (m12 + m21);
                } else {
                    s = m22 - m00 - m11;
                    qz = 0.5 * EuclidCoreTools.squareRoot(s + 1.0);
                    double inv = 0.25 / qz;
                    qs = inv * (m10 - m01);
                    qx = inv * (m20 + m02);
                    qy = inv * (m12 + m21);
                }
            }
        }
        quaternionToPack.setUnsafe(qx, qy, qz, qs);
    }

    public static void convertRotationVectorToQuaternion(Vector3DReadOnly rotationVector, QuaternionBasics quaternionToPack) {
        QuaternionConversion.convertRotationVectorToQuaternion(rotationVector.getX(), rotationVector.getY(), rotationVector.getZ(), quaternionToPack);
    }

    public static void convertRotationVectorToQuaternion(double rx, double ry, double rz, QuaternionBasics quaternionToPack) {
        if (EuclidCoreTools.containsNaN(rx, ry, rz)) {
            quaternionToPack.setToNaN();
            return;
        }
        double norm = EuclidCoreTools.norm(rx, ry, rz);
        if (norm < 1.0E-7) {
            quaternionToPack.setUnsafe(0.5 * rx, 0.5 * ry, 0.5 * rz, 1.0);
        } else {
            double halfTheta = 0.5 * norm;
            double cosHalfTheta = EuclidCoreTools.cos(halfTheta);
            double sinHalfTheta = EuclidCoreTools.sin(halfTheta) / norm;
            quaternionToPack.setUnsafe(rx * sinHalfTheta, ry * sinHalfTheta, rz * sinHalfTheta, cosHalfTheta);
        }
    }

    public static void convertYawPitchRollToQuaternion(YawPitchRollReadOnly yawPitchRoll, QuaternionBasics quaternionToPack) {
        QuaternionConversion.convertYawPitchRollToQuaternion(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), quaternionToPack);
    }

    public static void convertYawPitchRollToQuaternion(double yaw, double pitch, double roll, QuaternionBasics quaternionToPack) {
        double halfYaw = 0.5 * yaw;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = 0.5 * pitch;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = 0.5 * roll;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        quaternionToPack.setUnsafe(qx, qy, qz, qs);
    }
}

