/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.orientation.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Orientation2DReadOnly {
    public double getYaw();

    default public boolean containsNaN() {
        return Double.isNaN(this.getYaw());
    }

    default public double difference(Orientation2DReadOnly other) {
        return EuclidCoreTools.angleDifferenceMinusPiToPi(this.getYaw(), other.getYaw());
    }

    default public double distance(Orientation2DReadOnly other) {
        return Math.abs(this.difference(other));
    }

    default public void transform(Tuple2DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(this.getYaw(), tupleOriginal, tupleTransformed);
    }

    default public void transform(Tuple3DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    default public void transform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(this.getYaw(), tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(Tuple2DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, tupleToTransform);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(-this.getYaw(), tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(Tuple3DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(-this.getYaw(), tupleOriginal, tupleTransformed);
    }

    default public boolean epsilonEquals(Orientation2DReadOnly other, double epsilon) {
        return EuclidCoreTools.epsilonEquals(this.getYaw(), other.getYaw(), epsilon);
    }

    default public boolean geometricallyEquals(Orientation2DReadOnly other, double epsilon) {
        return Math.abs(this.difference(other)) <= epsilon;
    }

    default public boolean equals(Orientation2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getYaw() == other.getYaw();
    }
}

