/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix.interfaces;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;

public interface RotationMatrixReadOnly
extends Matrix3DReadOnly,
Orientation3DReadOnly {
    public boolean isDirty();

    @Override
    default public boolean containsNaN() {
        return Matrix3DReadOnly.super.containsNaN();
    }

    @Override
    default public boolean isZeroOrientation() {
        return this.isIdentity();
    }

    @Override
    default public boolean isZeroOrientation(double epsilon) {
        return this.isIdentity(epsilon);
    }

    @Override
    default public boolean isOrientation2D(double epsilon) {
        return this.isIdentity() || this.isMatrix2D(epsilon);
    }

    default public double distance(RotationMatrixReadOnly other) {
        return RotationMatrixTools.distance(this, other);
    }

    @Override
    default public void get(CommonMatrix3DBasics rotationMatrixToPack) {
        rotationMatrixToPack.set(this);
    }

    @Override
    default public void get(AxisAngleBasics axisAngleToPack) {
        axisAngleToPack.setRotationMatrix(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    @Override
    default public void get(QuaternionBasics quaternionToPack) {
        quaternionToPack.setRotationMatrix(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    @Override
    default public void get(YawPitchRollBasics yawPitchRollToPack) {
        yawPitchRollToPack.setRotationMatrix(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    @Override
    default public void getRotationVector(Vector3DBasics rotationVectorToPack) {
        RotationVectorConversion.convertMatrixToRotationVector(this, rotationVectorToPack);
    }

    @Override
    default public void getEuler(Tuple3DBasics eulerAnglesToPack) {
        YawPitchRollConversion.convertMatrixToYawPitchRoll(this, eulerAnglesToPack);
    }

    @Override
    default public double getYaw() {
        return YawPitchRollConversion.computeYaw(this);
    }

    @Override
    default public double getPitch() {
        return YawPitchRollConversion.computePitch(this);
    }

    @Override
    default public double getRoll() {
        return YawPitchRollConversion.computeRoll(this);
    }

    @Override
    default public void addTransform(Tuple3DBasics tupleToTransform) {
        this.addTransform(tupleToTransform, tupleToTransform);
    }

    @Override
    default public void addTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        if (this.isIdentity()) {
            tupleTransformed.add(tupleOriginal);
        } else {
            Matrix3DReadOnly.super.addTransform(tupleOriginal, tupleTransformed);
        }
    }

    @Override
    default public void subTransform(Tuple3DBasics tupleToTransform) {
        this.subTransform(tupleToTransform, tupleToTransform);
    }

    @Override
    default public void subTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        if (this.isIdentity()) {
            tupleTransformed.sub(tupleOriginal);
        } else {
            Matrix3DTools.subTransform(this, tupleOriginal, tupleTransformed);
        }
    }

    @Override
    default public void transform(Tuple3DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    @Override
    default public void transform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        if (this.isIdentity() && tupleOriginal != tupleTransformed) {
            tupleTransformed.set(tupleOriginal);
        } else {
            Matrix3DReadOnly.super.transform(tupleOriginal, tupleTransformed);
        }
    }

    @Override
    default public void transform(Tuple2DBasics tupleToTransform) {
        this.transform(tupleToTransform, true);
    }

    @Override
    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.transform(tupleOriginal, tupleTransformed, true);
    }

    @Override
    default public void transform(Tuple2DBasics tupleToTransform, boolean checkIfOrientation2D) {
        this.transform(tupleToTransform, tupleToTransform, checkIfOrientation2D);
    }

    @Override
    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        if (this.isIdentity() && tupleOriginal != tupleTransformed) {
            tupleTransformed.set(tupleOriginal);
        } else {
            Matrix3DReadOnly.super.transform(tupleOriginal, tupleTransformed, checkIfOrientation2D);
        }
    }

    @Override
    default public void transform(Vector4DBasics vectorToTransform) {
        this.transform(vectorToTransform, vectorToTransform);
    }

    @Override
    default public void transform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        if (this.isIdentity() && vectorOriginal != vectorTransformed) {
            vectorTransformed.set(vectorOriginal);
        } else {
            Matrix3DReadOnly.super.transform(vectorOriginal, vectorTransformed);
        }
    }

    @Override
    default public void transform(Matrix3DBasics matrixToTransform) {
        this.transform(matrixToTransform, matrixToTransform);
    }

    @Override
    default public void transform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        if (this.isIdentity() && matrixOriginal != matrixTransformed) {
            matrixTransformed.set(matrixOriginal);
        } else {
            Matrix3DTools.multiply(this, matrixOriginal, matrixTransformed);
            Matrix3DTools.multiplyTransposeRight(matrixTransformed, this, matrixTransformed);
        }
    }

    @Override
    default public void inverseTransform(Tuple3DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, tupleToTransform);
    }

    @Override
    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        if (this.isIdentity() && tupleOriginal != tupleTransformed) {
            tupleTransformed.set(tupleOriginal);
        } else {
            double x = this.getM00() * tupleOriginal.getX() + this.getM10() * tupleOriginal.getY() + this.getM20() * tupleOriginal.getZ();
            double y = this.getM01() * tupleOriginal.getX() + this.getM11() * tupleOriginal.getY() + this.getM21() * tupleOriginal.getZ();
            double z = this.getM02() * tupleOriginal.getX() + this.getM12() * tupleOriginal.getY() + this.getM22() * tupleOriginal.getZ();
            tupleTransformed.set(x, y, z);
        }
    }

    @Override
    default public void inverseTransform(Tuple2DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, true);
    }

    @Override
    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.inverseTransform(tupleOriginal, tupleTransformed, true);
    }

    @Override
    default public void inverseTransform(Tuple2DBasics tupleToTransform, boolean checkIfOrientation2D) {
        this.inverseTransform(tupleToTransform, tupleToTransform, checkIfOrientation2D);
    }

    @Override
    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        if (this.isIdentity() && tupleOriginal != tupleTransformed) {
            tupleTransformed.set(tupleOriginal);
        } else {
            if (checkIfOrientation2D) {
                this.checkIfOrientation2D();
            }
            double x = this.getM00() * tupleOriginal.getX() + this.getM10() * tupleOriginal.getY();
            double y = this.getM01() * tupleOriginal.getX() + this.getM11() * tupleOriginal.getY();
            tupleTransformed.set(x, y);
        }
    }

    @Override
    default public void inverseTransform(Vector4DBasics vectorToTransform) {
        this.inverseTransform(vectorToTransform, vectorToTransform);
    }

    @Override
    default public void inverseTransform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        if (this.isIdentity() && vectorOriginal != vectorTransformed) {
            vectorTransformed.set(vectorOriginal);
        } else {
            double x = this.getM00() * vectorOriginal.getX() + this.getM10() * vectorOriginal.getY() + this.getM20() * vectorOriginal.getZ();
            double y = this.getM01() * vectorOriginal.getX() + this.getM11() * vectorOriginal.getY() + this.getM21() * vectorOriginal.getZ();
            double z = this.getM02() * vectorOriginal.getX() + this.getM12() * vectorOriginal.getY() + this.getM22() * vectorOriginal.getZ();
            vectorTransformed.set(x, y, z, vectorOriginal.getS());
        }
    }

    @Override
    default public void inverseTransform(Matrix3DBasics matrixToTransform) {
        this.inverseTransform(matrixToTransform, matrixToTransform);
    }

    @Override
    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        if (this.isIdentity() && matrixOriginal != matrixTransformed) {
            matrixTransformed.set(matrixOriginal);
        } else {
            Matrix3DTools.multiplyTransposeLeft(this, matrixOriginal, matrixTransformed);
            Matrix3DTools.multiply(matrixTransformed, this, matrixTransformed);
        }
    }

    default public boolean geometricallyEquals(RotationMatrixReadOnly other, double epsilon) {
        return this.distance(other) <= epsilon;
    }
}

