/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Matrix3DBasics
extends CommonMatrix3DBasics,
Transformable {
    public void setM00(double var1);

    public void setM01(double var1);

    public void setM02(double var1);

    public void setM10(double var1);

    public void setM11(double var1);

    public void setM12(double var1);

    public void setM20(double var1);

    public void setM21(double var1);

    public void setM22(double var1);

    default public void setElement(int row, int column, double value) {
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        this.setM00(value);
                        return;
                    }
                    case 1: {
                        this.setM01(value);
                        return;
                    }
                    case 2: {
                        this.setM02(value);
                        return;
                    }
                }
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
            case 1: {
                switch (column) {
                    case 0: {
                        this.setM10(value);
                        return;
                    }
                    case 1: {
                        this.setM11(value);
                        return;
                    }
                    case 2: {
                        this.setM12(value);
                        return;
                    }
                }
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
            case 2: {
                switch (column) {
                    case 0: {
                        this.setM20(value);
                        return;
                    }
                    case 1: {
                        this.setM21(value);
                        return;
                    }
                    case 2: {
                        this.setM22(value);
                        return;
                    }
                }
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
        }
        throw Matrix3DTools.rowOutOfBoundsException(2, row);
    }

    @Override
    default public void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.setM00(m00);
        this.setM01(m01);
        this.setM02(m02);
        this.setM10(m10);
        this.setM11(m11);
        this.setM12(m12);
        this.setM20(m20);
        this.setM21(m21);
        this.setM22(m22);
    }

    default public void multiplyOuter() {
        Matrix3DTools.multiplyOuter(this, this);
    }

    default public void multiplyInner() {
        Matrix3DTools.multiplyInner(this, this);
    }

    default public void negate() {
        this.setM00(-this.getM00());
        this.setM01(-this.getM01());
        this.setM02(-this.getM02());
        this.setM10(-this.getM10());
        this.setM11(-this.getM11());
        this.setM12(-this.getM12());
        this.setM20(-this.getM20());
        this.setM21(-this.getM21());
        this.setM22(-this.getM22());
    }

    default public void setToTildeForm(Tuple3DReadOnly tuple) {
        double x = tuple.getX();
        double y = tuple.getY();
        double z = tuple.getZ();
        this.setM00(0.0);
        this.setM01(-z);
        this.setM02(y);
        this.setM10(z);
        this.setM11(0.0);
        this.setM12(-x);
        this.setM20(-y);
        this.setM21(x);
        this.setM22(0.0);
    }

    default public void setToDiagonal(double m00, double m11, double m22) {
        this.set(m00, 0.0, 0.0, 0.0, m11, 0.0, 0.0, 0.0, m22);
    }

    default public void setToDiagonal(Tuple3DReadOnly tuple) {
        this.setToDiagonal(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    default public void setAndMultiplyOuter(Matrix3DReadOnly other) {
        this.set(other);
        this.multiplyOuter();
    }

    default public void setAndMultiplyInner(Matrix3DReadOnly other) {
        this.set(other);
        this.multiplyInner();
    }

    @Override
    default public void setAndInvert(Matrix3DReadOnly other) {
        this.set(other);
        this.invert();
    }

    @Override
    default public void setAndTranspose(Matrix3DReadOnly other) {
        this.set(other);
        this.transpose();
    }

    default public void setAndNegate(Matrix3DReadOnly other) {
        this.set(other);
        this.negate();
    }

    default public void setToYawMatrix(double yaw) {
        RotationMatrixConversion.computeYawMatrix(yaw, this);
    }

    default public void setToPitchMatrix(double pitch) {
        RotationMatrixConversion.computePitchMatrix(pitch, this);
    }

    default public void setToRollMatrix(double roll) {
        RotationMatrixConversion.computeRollMatrix(roll, this);
    }

    default public void setRow(int row, double[] rowArray) {
        this.setRow(row, rowArray[0], rowArray[1], rowArray[2]);
    }

    default public void setRow(int row, Tuple3DReadOnly rowValues) {
        this.setRow(row, rowValues.getX(), rowValues.getY(), rowValues.getZ());
    }

    default public void setRow(int row, double x, double y, double z) {
        switch (row) {
            case 0: {
                this.setM00(x);
                this.setM01(y);
                this.setM02(z);
                return;
            }
            case 1: {
                this.setM10(x);
                this.setM11(y);
                this.setM12(z);
                return;
            }
            case 2: {
                this.setM20(x);
                this.setM21(y);
                this.setM22(z);
                return;
            }
        }
        throw Matrix3DTools.rowOutOfBoundsException(2, row);
    }

    default public void setColumn(int column, double[] columnArray) {
        this.setColumn(column, columnArray[0], columnArray[1], columnArray[2]);
    }

    default public void setColumn(int column, Tuple3DReadOnly columnValues) {
        this.setColumn(column, columnValues.getX(), columnValues.getY(), columnValues.getZ());
    }

    default public void setColumn(int column, double x, double y, double z) {
        switch (column) {
            case 0: {
                this.setM00(x);
                this.setM10(y);
                this.setM20(z);
                break;
            }
            case 1: {
                this.setM01(x);
                this.setM11(y);
                this.setM21(z);
                break;
            }
            case 2: {
                this.setM02(x);
                this.setM12(y);
                this.setM22(z);
                break;
            }
            default: {
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
        }
    }

    default public void addM00(double m00) {
        this.setM00(this.getM00() + m00);
    }

    default public void addM01(double m01) {
        this.setM01(this.getM01() + m01);
    }

    default public void addM02(double m02) {
        this.setM02(this.getM02() + m02);
    }

    default public void addM10(double m10) {
        this.setM10(this.getM10() + m10);
    }

    default public void addM11(double m11) {
        this.setM11(this.getM11() + m11);
    }

    default public void addM12(double m12) {
        this.setM12(this.getM12() + m12);
    }

    default public void addM20(double m20) {
        this.setM20(this.getM20() + m20);
    }

    default public void addM21(double m21) {
        this.setM21(this.getM21() + m21);
    }

    default public void addM22(double m22) {
        this.setM22(this.getM22() + m22);
    }

    default public void add(Matrix3DReadOnly other) {
        this.addM00(other.getM00());
        this.addM01(other.getM01());
        this.addM02(other.getM02());
        this.addM10(other.getM10());
        this.addM11(other.getM11());
        this.addM12(other.getM12());
        this.addM20(other.getM20());
        this.addM21(other.getM21());
        this.addM22(other.getM22());
    }

    default public void add(Matrix3DReadOnly matrix1, Matrix3DReadOnly matrix2) {
        this.setM00(matrix1.getM00() + matrix2.getM00());
        this.setM01(matrix1.getM01() + matrix2.getM01());
        this.setM02(matrix1.getM02() + matrix2.getM02());
        this.setM10(matrix1.getM10() + matrix2.getM10());
        this.setM11(matrix1.getM11() + matrix2.getM11());
        this.setM12(matrix1.getM12() + matrix2.getM12());
        this.setM20(matrix1.getM20() + matrix2.getM20());
        this.setM21(matrix1.getM21() + matrix2.getM21());
        this.setM22(matrix1.getM22() + matrix2.getM22());
    }

    default public void subM00(double m00) {
        this.setM00(this.getM00() - m00);
    }

    default public void subM01(double m01) {
        this.setM01(this.getM01() - m01);
    }

    default public void subM02(double m02) {
        this.setM02(this.getM02() - m02);
    }

    default public void subM10(double m10) {
        this.setM10(this.getM10() - m10);
    }

    default public void subM11(double m11) {
        this.setM11(this.getM11() - m11);
    }

    default public void subM12(double m12) {
        this.setM12(this.getM12() - m12);
    }

    default public void subM20(double m20) {
        this.setM20(this.getM20() - m20);
    }

    default public void subM21(double m21) {
        this.setM21(this.getM21() - m21);
    }

    default public void subM22(double m22) {
        this.setM22(this.getM22() - m22);
    }

    default public void sub(Matrix3DReadOnly other) {
        this.subM00(other.getM00());
        this.subM01(other.getM01());
        this.subM02(other.getM02());
        this.subM10(other.getM10());
        this.subM11(other.getM11());
        this.subM12(other.getM12());
        this.subM20(other.getM20());
        this.subM21(other.getM21());
        this.subM22(other.getM22());
    }

    default public void sub(Matrix3DReadOnly matrix1, Matrix3DReadOnly matrix2) {
        this.setM00(matrix1.getM00() - matrix2.getM00());
        this.setM01(matrix1.getM01() - matrix2.getM01());
        this.setM02(matrix1.getM02() - matrix2.getM02());
        this.setM10(matrix1.getM10() - matrix2.getM10());
        this.setM11(matrix1.getM11() - matrix2.getM11());
        this.setM12(matrix1.getM12() - matrix2.getM12());
        this.setM20(matrix1.getM20() - matrix2.getM20());
        this.setM21(matrix1.getM21() - matrix2.getM21());
        this.setM22(matrix1.getM22() - matrix2.getM22());
    }

    default public void fill(double scalar) {
        this.setM00(scalar);
        this.setM01(scalar);
        this.setM02(scalar);
        this.setM10(scalar);
        this.setM11(scalar);
        this.setM12(scalar);
        this.setM20(scalar);
        this.setM21(scalar);
        this.setM22(scalar);
    }

    default public void scaleM00(double scalar) {
        this.setM00(scalar * this.getM00());
    }

    default public void scaleM01(double scalar) {
        this.setM01(scalar * this.getM01());
    }

    default public void scaleM02(double scalar) {
        this.setM02(scalar * this.getM02());
    }

    default public void scaleM10(double scalar) {
        this.setM10(scalar * this.getM10());
    }

    default public void scaleM11(double scalar) {
        this.setM11(scalar * this.getM11());
    }

    default public void scaleM12(double scalar) {
        this.setM12(scalar * this.getM12());
    }

    default public void scaleM20(double scalar) {
        this.setM20(scalar * this.getM20());
    }

    default public void scaleM21(double scalar) {
        this.setM21(scalar * this.getM21());
    }

    default public void scaleM22(double scalar) {
        this.setM22(scalar * this.getM22());
    }

    default public void scale(double scalar) {
        this.scaleM00(scalar);
        this.scaleM01(scalar);
        this.scaleM02(scalar);
        this.scaleM10(scalar);
        this.scaleM11(scalar);
        this.scaleM12(scalar);
        this.scaleM20(scalar);
        this.scaleM21(scalar);
        this.scaleM22(scalar);
    }

    default public void scaleRows(double scalarRow0, double scalarRow1, double scalarRow2) {
        this.scaleM00(scalarRow0);
        this.scaleM01(scalarRow0);
        this.scaleM02(scalarRow0);
        this.scaleM10(scalarRow1);
        this.scaleM11(scalarRow1);
        this.scaleM12(scalarRow1);
        this.scaleM20(scalarRow2);
        this.scaleM21(scalarRow2);
        this.scaleM22(scalarRow2);
    }

    default public void scaleColumns(double scalarColumn0, double scalarColumn1, double scalarColumn2) {
        this.scaleM00(scalarColumn0);
        this.scaleM01(scalarColumn1);
        this.scaleM02(scalarColumn2);
        this.scaleM10(scalarColumn0);
        this.scaleM11(scalarColumn1);
        this.scaleM12(scalarColumn2);
        this.scaleM20(scalarColumn0);
        this.scaleM21(scalarColumn1);
        this.scaleM22(scalarColumn2);
    }

    default public void scaleRow(int row, double scalar) {
        switch (row) {
            case 0: {
                this.scaleM00(scalar);
                this.scaleM01(scalar);
                this.scaleM02(scalar);
                return;
            }
            case 1: {
                this.scaleM10(scalar);
                this.scaleM11(scalar);
                this.scaleM12(scalar);
                return;
            }
            case 2: {
                this.scaleM20(scalar);
                this.scaleM21(scalar);
                this.scaleM22(scalar);
                return;
            }
        }
        throw Matrix3DTools.rowOutOfBoundsException(2, row);
    }

    default public void scaleColumn(int column, double scalar) {
        switch (column) {
            case 0: {
                this.scaleM00(scalar);
                this.scaleM10(scalar);
                this.scaleM20(scalar);
                break;
            }
            case 1: {
                this.scaleM01(scalar);
                this.scaleM11(scalar);
                this.scaleM21(scalar);
                break;
            }
            case 2: {
                this.scaleM02(scalar);
                this.scaleM12(scalar);
                this.scaleM22(scalar);
                break;
            }
            default: {
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
        }
    }

    @Override
    default public void applyTransform(Transform transform) {
        transform.transform(this);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this);
    }

    default public void multiply(Matrix3DReadOnly other) {
        Matrix3DTools.multiply(this, other, this);
    }

    default public void multiplyTransposeThis(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyTransposeLeft(this, other, this);
    }

    default public void multiplyTransposeOther(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyTransposeRight(this, other, this);
    }

    default public void multiplyTransposeBoth(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyTransposeBoth(this, other, this);
    }

    default public void multiplyInvertThis(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyInvertLeft(this, other, (CommonMatrix3DBasics)this);
    }

    default public void multiplyInvertOther(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)this, other, (CommonMatrix3DBasics)this);
    }

    default public void multiplyInvertOther(RotationMatrixReadOnly other) {
        Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)this, other, (CommonMatrix3DBasics)this);
    }

    default public void preMultiply(Matrix3DReadOnly other) {
        Matrix3DTools.multiply(other, this, this);
    }

    default public void preMultiplyTransposeThis(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyTransposeRight(other, this, this);
    }

    default public void preMultiplyTransposeOther(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyTransposeLeft(other, this, this);
    }

    default public void preMultiplyTransposeBoth(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyTransposeBoth(other, this, this);
    }

    default public void preMultiplyInvertThis(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyInvertRight(other, this, (CommonMatrix3DBasics)this);
    }

    default public void preMultiplyInvertOther(Matrix3DReadOnly other) {
        Matrix3DTools.multiplyInvertLeft(other, (Matrix3DReadOnly)this, (CommonMatrix3DBasics)this);
    }

    default public void preMultiplyInvertOther(RotationMatrixReadOnly other) {
        Matrix3DTools.multiplyInvertLeft(other, (Matrix3DReadOnly)this, (CommonMatrix3DBasics)this);
    }
}

