/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple4D.Tuple4DReadOnlyTest;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public abstract class Tuple4DBasicsTest<T extends Tuple4DBasics>
extends Tuple4DReadOnlyTest<T> {
    @Test
    public abstract void testSetDoubles();

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            Tuple4DBasics tuple = (Tuple4DBasics)this.createTuple(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple.setToNaN();
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getX()));
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getY()));
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getZ()));
        }
    }

    @Test
    public void testNormalize() {
        Tuple4DBasics tuple1;
        int i;
        Random random = new Random(312310L);
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple1.normalize();
            double expectedLength = 1.0;
            double actualLength = tuple1.norm();
            Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)this.getEpsilon());
            Tuple4DBasics tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.normalize();
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tuple1 = (Tuple4DBasics)this.createTuple(scale * tuple2.getX(), scale * tuple2.getY(), scale * tuple2.getZ(), scale * tuple2.getS());
            tuple1.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
            tuple1.setToNaN();
            tuple1.normalize();
            for (int index = 0; index < 4; ++index) {
                Assertions.assertTrue((boolean)Double.isNaN(tuple1.getElement(index)));
            }
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple4DBasics)this.createRandomTuple(random);
            Tuple4DBasics tuple2 = (Tuple4DBasics)this.createEmptyTuple();
            tuple2.setAndNormalize((Tuple4DReadOnly)tuple1);
            double expectedLength = 1.0;
            double actualLength = tuple2.norm();
            Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)this.getEpsilon());
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.normalize();
            Tuple4DBasics tuple3 = (Tuple4DBasics)this.createEmptyTuple();
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tuple3 = (Tuple4DBasics)this.createTuple(scale * tuple2.getX(), scale * tuple2.getY(), scale * tuple2.getZ(), scale * tuple2.getS());
            tuple1.setAndNormalize((Tuple4DReadOnly)tuple3);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
            tuple3.setToNaN();
            tuple1.setToZero();
            tuple1.setAndNormalize((Tuple4DReadOnly)tuple3);
            for (int index = 0; index < 4; ++index) {
                Assertions.assertTrue((boolean)Double.isNaN(tuple1.getElement(index)));
            }
        }
    }

    @Test
    public void testAbsolute() throws Exception {
        Random random = new Random(621541L);
        Tuple4DBasics tuple1 = (Tuple4DBasics)this.createEmptyTuple();
        Tuple4DBasics tuple2 = (Tuple4DBasics)this.createEmptyTuple();
        for (double signX = -1.0; signX <= 1.0; signX += 2.0) {
            for (double signY = -1.0; signY <= 1.0; signY += 2.0) {
                for (double signZ = -1.0; signZ <= 1.0; signZ += 2.0) {
                    for (double signS = -1.0; signS <= 1.0; signS += 2.0) {
                        Tuple4DBasics original = (Tuple4DBasics)this.createRandomTuple(random);
                        double xPos = Math.abs(original.getX());
                        double yPos = Math.abs(original.getY());
                        double zPos = Math.abs(original.getZ());
                        double sPos = Math.abs(original.getS());
                        tuple1 = (Tuple4DBasics)this.createTuple(signX * xPos, signY * yPos, signZ * zPos, signS * sPos);
                        tuple2.setAndAbsolute((Tuple4DReadOnly)tuple1);
                        Assertions.assertEquals((double)tuple2.getX(), (double)xPos, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getY(), (double)yPos, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getZ(), (double)zPos, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getS(), (double)sPos, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getX(), (double)(signX * xPos), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getY(), (double)(signY * yPos), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getZ(), (double)(signZ * zPos), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getS(), (double)(signS * sPos), (double)this.getEpsilon());
                        tuple1.absolute();
                        Assertions.assertEquals((double)tuple1.getX(), (double)xPos, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getY(), (double)yPos, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getZ(), (double)zPos, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getS(), (double)sPos, (double)this.getEpsilon());
                    }
                }
            }
        }
    }

    @Test
    public void testNegate() throws Exception {
        Random random = new Random(621541L);
        Tuple4DBasics tuple1 = (Tuple4DBasics)this.createEmptyTuple();
        Tuple4DBasics tuple2 = (Tuple4DBasics)this.createEmptyTuple();
        for (double signX = -1.0; signX <= 1.0; signX += 2.0) {
            for (double signY = -1.0; signY <= 1.0; signY += 2.0) {
                for (double signZ = -1.0; signZ <= 1.0; signZ += 2.0) {
                    for (double signS = -1.0; signS <= 1.0; signS += 2.0) {
                        Tuple4DBasics original = (Tuple4DBasics)this.createRandomTuple(random);
                        double xOriginal = signX * original.getX();
                        double yOriginal = signY * original.getY();
                        double zOriginal = signZ * original.getZ();
                        double sOriginal = signS * original.getS();
                        tuple1 = (Tuple4DBasics)this.createTuple(xOriginal, yOriginal, zOriginal, sOriginal);
                        tuple2.setToNaN();
                        tuple2.setAndNegate((Tuple4DReadOnly)tuple1);
                        Assertions.assertEquals((double)tuple2.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getY(), (double)(-yOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getZ(), (double)(-zOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getS(), (double)(-sOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getX(), (double)xOriginal, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getY(), (double)yOriginal, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getZ(), (double)zOriginal, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getS(), (double)sOriginal, (double)this.getEpsilon());
                        tuple1.negate();
                        Assertions.assertEquals((double)tuple1.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getY(), (double)(-yOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getZ(), (double)(-zOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getS(), (double)(-sOriginal), (double)this.getEpsilon());
                    }
                }
            }
        }
    }

    @Test
    public void testSetters() throws Exception {
        DMatrixRMaj matrix;
        int index;
        Object[] tupleArray;
        int i;
        Random random = new Random(621541L);
        Tuple4DBasics tuple1 = (Tuple4DBasics)this.createEmptyTuple();
        Tuple4DBasics tuple2 = (Tuple4DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple1.set((Tuple4DReadOnly)tuple2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple1.set((Tuple4DReadOnly)tuple2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new double[10];
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.get(tupleArray);
            tuple1.set(tupleArray);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new double[10];
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.get(2, tupleArray);
            tuple1.set(2, tupleArray);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new float[10];
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.get((float[])tupleArray);
            tuple1.set((float[])tupleArray);
            for (index = 0; index < 4; ++index) {
                Assertions.assertEquals((double)tuple2.getElement32(index), (double)tuple1.getElement32(index), (double)Math.max(this.getEpsilon(), 1.0E-6));
            }
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new float[10];
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.get(2, (float[])tupleArray);
            tuple1.set(2, (float[])tupleArray);
            for (index = 0; index < 4; ++index) {
                Assertions.assertEquals((double)tuple2.getElement32(index), (double)tuple1.getElement32(index), (double)Math.max(this.getEpsilon(), 1.0E-6));
            }
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(5, 4);
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.get((DMatrix)matrix);
            tuple1.set((DMatrix)matrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(10, 4);
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.get(5, (DMatrix)matrix);
            tuple1.set(5, (DMatrix)matrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(10, 4);
            tuple2 = (Tuple4DBasics)this.createRandomTuple(random);
            tuple2.get(5, 2, (DMatrix)matrix);
            tuple1.set(5, 2, (DMatrix)matrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
    }
}

