/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.TransformTest;
import us.ihmc.euclid.transform.interfaces.AffineTransformBasics;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class QuaternionBasedTransformTest
extends TransformTest<QuaternionBasedTransform> {
    private static final double EPS = 1.0E-10;

    @Test
    public void testConstructors() throws Exception {
        Random random = new Random(345L);
        QuaternionBasedTransform transform = new QuaternionBasedTransform();
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)transform.getTranslation());
        QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasedTransform actual = new QuaternionBasedTransform((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual = new QuaternionBasedTransform((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)expected));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(7, 1);
        quaternion.get((DMatrix)denseMatrix);
        translation.get(4, (DMatrix)denseMatrix);
        QuaternionBasedTransform transform2 = new QuaternionBasedTransform((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)transform2.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform2.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        double[] array = new double[7];
        quaternion.get(array);
        translation.get(4, array);
        transform2 = new QuaternionBasedTransform(array);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)transform2.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform2.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        QuaternionBasedTransform transform3 = new QuaternionBasedTransform((RotationMatrixReadOnly)new RotationMatrix((Orientation3DReadOnly)quaternion), (Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)transform3.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform3.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        transform3 = new QuaternionBasedTransform((Orientation3DReadOnly)quaternion, (Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)transform3.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform3.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        transform3 = new QuaternionBasedTransform((Orientation3DReadOnly)new AxisAngle((Orientation3DReadOnly)quaternion), (Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)transform3.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform3.getTranslation(), (double)1.0E-10);
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(45L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        Assertions.assertNotEquals((double)transform.getRotation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getZ(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getS(), (double)1.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getZ(), (double)0.0);
        transform.setToZero();
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)transform.getTranslation());
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(45L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        Assertions.assertFalse((boolean)Double.isNaN(transform.getRotation().getX()));
        Assertions.assertFalse((boolean)Double.isNaN(transform.getRotation().getY()));
        Assertions.assertFalse((boolean)Double.isNaN(transform.getRotation().getZ()));
        Assertions.assertFalse((boolean)Double.isNaN(transform.getRotation().getS()));
        Assertions.assertFalse((boolean)Double.isNaN(transform.getTranslation().getX()));
        Assertions.assertFalse((boolean)Double.isNaN(transform.getTranslation().getY()));
        Assertions.assertFalse((boolean)Double.isNaN(transform.getTranslation().getZ()));
        transform.setToNaN();
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)transform.getTranslation());
        transform.setToZero();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)transform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(), (EuclidGeometry)transform.getTranslation(), (double)1.0E-10);
        transform.setRotationToNaN();
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(), (EuclidGeometry)transform.getTranslation(), (double)1.0E-10);
        transform.setToZero();
        transform.setTranslationToNaN();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)transform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)transform.getTranslation());
    }

    @Test
    public void testContainsNaN() throws Exception {
        QuaternionBasedTransform transform = new QuaternionBasedTransform();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)transform.containsNaN());
        transform.setUnsafe(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)transform.containsNaN());
    }

    @Test
    public void testResetRotation() throws Exception {
        Random random = new Random(3453L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        Vector3D expectedTranslation = new Vector3D();
        expectedTranslation.set((Tuple3DReadOnly)transform.getTranslation());
        Assertions.assertNotEquals((double)transform.getRotation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getZ(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getS(), (double)1.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getZ(), (double)0.0);
        transform.setRotationToZero();
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)transform.getTranslation(), (double)1.0E-10);
    }

    @Test
    public void testResetTranslation() throws Exception {
        Random random = new Random(45L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        Quaternion expectedQuaternion = new Quaternion();
        expectedQuaternion.set((QuaternionReadOnly)transform.getRotation());
        Assertions.assertNotEquals((double)transform.getRotation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getZ(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getS(), (double)1.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getZ(), (double)0.0);
        transform.setTranslationToZero();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)transform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)transform.getTranslation());
    }

    @Test
    public void testSet() throws Exception {
        Random random = new Random(3453L);
        QuaternionBasedTransform actualTransform = new QuaternionBasedTransform();
        Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        double x = translation.getX();
        double y = translation.getY();
        double z = translation.getZ();
        actualTransform.set(qx, qy, qz, qs, x, y, z);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        qx = quaternion.getX();
        qy = quaternion.getY();
        qz = quaternion.getZ();
        qs = quaternion.getS();
        x = translation.getX();
        y = translation.getY();
        z = translation.getZ();
        actualTransform.setUnsafe(qx, qy, qz, qs, x, y, z);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        QuaternionBasedTransform expectedTransform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actualTransform.set(expectedTransform);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-10);
        expectedTransform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actualTransform.set((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)expectedTransform));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(7, 1);
        quaternion.get((DMatrix)denseMatrix);
        translation.get(4, (DMatrix)denseMatrix);
        actualTransform.set((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        double[] array = new double[7];
        quaternion.get(array);
        translation.get(4, array);
        actualTransform.set(array);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actualTransform.set((RotationMatrixReadOnly)new RotationMatrix((Orientation3DReadOnly)quaternion), (Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)quaternion, (Orientation3DReadOnly)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actualTransform.set((Orientation3DReadOnly)new AxisAngle((Orientation3DReadOnly)quaternion), (Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actualTransform.set((Orientation3DReadOnly)quaternion, (Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
    }

    @Test
    public void testSetIdentity() throws Exception {
        Random random = new Random(45L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        Assertions.assertNotEquals((double)transform.getRotation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getZ(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getRotation().getS(), (double)1.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getX(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getY(), (double)0.0);
        Assertions.assertNotEquals((double)transform.getTranslation().getZ(), (double)0.0);
        transform.setIdentity();
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)transform.getTranslation());
    }

    @Test
    public void testSetRotation() throws Exception {
        Random random = new Random(3454L);
        QuaternionBasedTransform actualTransform = new QuaternionBasedTransform();
        Vector3D expectedTranslation = new Vector3D();
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actualTransform.getRotation().set((Orientation3DReadOnly)new AxisAngle((Orientation3DReadOnly)quaternion));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actualTransform.getRotation().set((QuaternionReadOnly)quaternion);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actualTransform.getRotation().set((Orientation3DReadOnly)new RotationMatrix((Orientation3DReadOnly)quaternion));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D rotationVector = new Vector3D();
        quaternion.getRotationVector((Vector3DBasics)rotationVector);
        actualTransform.getRotation().setRotationVector((Vector3DReadOnly)rotationVector);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        rigidBodyTransform.getRotation().setToYawOrientation(yaw);
        QuaternionBasedTransform expectedTransform = new QuaternionBasedTransform((RigidBodyTransformReadOnly)rigidBodyTransform);
        actualTransform.getRotation().setToYawOrientation(yaw);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-10);
        rigidBodyTransform = new RigidBodyTransform();
        double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        rigidBodyTransform.getRotation().setToPitchOrientation(pitch);
        expectedTransform = new QuaternionBasedTransform((RigidBodyTransformReadOnly)rigidBodyTransform);
        actualTransform.getRotation().setToPitchOrientation(pitch);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-10);
        rigidBodyTransform = new RigidBodyTransform();
        double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        rigidBodyTransform.getRotation().setToRollOrientation(roll);
        expectedTransform = new QuaternionBasedTransform((RigidBodyTransformReadOnly)rigidBodyTransform);
        actualTransform.getRotation().setToRollOrientation(roll);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-10);
        rigidBodyTransform = new RigidBodyTransform();
        yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        double pitch2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        double roll2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        rigidBodyTransform.getRotation().setYawPitchRoll(yaw, pitch2, roll2);
        QuaternionBasedTransform expectedTransform2 = new QuaternionBasedTransform((RigidBodyTransformReadOnly)rigidBodyTransform);
        actualTransform.getRotation().setYawPitchRoll(yaw, pitch2, roll2);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform2, (EuclidGeometry)actualTransform, (double)1.0E-10);
        actualTransform.setRotationToZero();
        actualTransform.getRotation().setEuler((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw));
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform2, (EuclidGeometry)actualTransform, (double)1.0E-10);
        actualTransform.setRotationToZero();
        actualTransform.getRotation().setEuler(roll2, pitch2, yaw);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform2, (EuclidGeometry)actualTransform, (double)1.0E-10);
    }

    @Test
    public void testSetTranslation() throws Exception {
        Random random = new Random(456456L);
        QuaternionBasedTransform actualTransform = new QuaternionBasedTransform();
        Quaternion expectedQuaternion = new Quaternion();
        expectedQuaternion.set((QuaternionReadOnly)actualTransform.getRotation());
        Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        double x = translation.getX();
        double y = translation.getY();
        double z = translation.getZ();
        actualTransform.getTranslation().setX(x);
        actualTransform.getTranslation().setY(y);
        actualTransform.getTranslation().setZ(z);
        for (int row = 0; row < 3; ++row) {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        }
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        x = translation.getX();
        y = translation.getY();
        z = translation.getZ();
        actualTransform.getTranslation().set(x, y, z);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
        translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actualTransform.getTranslation().set((Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualTransform.getRotation(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)actualTransform.getTranslation(), (double)1.0E-10);
    }

    @Test
    public void testGet() throws Exception {
        Random random = new Random(34543L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasics expectedQuaternion = transform.getRotation();
        Vector3DBasics expectedTranslation = transform.getTranslation();
        Quaternion actualQuaternion = new Quaternion();
        Vector3D actualTranslation = new Vector3D();
        DMatrixRMaj denseMatrix = new DMatrixRMaj(7, 1);
        transform.get((DMatrix)denseMatrix);
        actualQuaternion.set((DMatrix)denseMatrix);
        actualTranslation.set(4, (DMatrix)denseMatrix);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTranslation, (double)1.0E-10);
        actualQuaternion = new Quaternion();
        actualTranslation = new Vector3D();
        int startRow = random.nextInt(10);
        int column = random.nextInt(10);
        DMatrixRMaj denseMatrix2 = new DMatrixRMaj(7 + startRow, 1 + column);
        transform.get(startRow, column, (DMatrix)denseMatrix2);
        actualQuaternion.set(startRow, column, (DMatrix)denseMatrix2);
        actualTranslation.set(4 + startRow, column, (DMatrix)denseMatrix2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTranslation, (double)1.0E-10);
        actualQuaternion = new Quaternion();
        actualTranslation = new Vector3D();
        double[] denseMatrix22 = new double[7];
        transform.get(denseMatrix22);
        actualQuaternion.set(denseMatrix22);
        actualTranslation.set(4, denseMatrix22);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTranslation, (double)1.0E-10);
        actualQuaternion = new Quaternion();
        actualTranslation = new Vector3D();
        transform.get((Orientation3DBasics)actualQuaternion, (Tuple3DBasics)actualTranslation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTranslation, (double)1.0E-10);
        actualQuaternion = new Quaternion();
        actualTranslation = new Vector3D();
        RotationMatrix rotationMatrix = new RotationMatrix();
        transform.get((RotationMatrixBasics)rotationMatrix, (Tuple3DBasics)actualTranslation);
        actualQuaternion.set((Orientation3DReadOnly)rotationMatrix);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTranslation, (double)1.0E-10);
    }

    @Test
    public void testGetRotation() throws Exception {
        Random random = new Random(3453L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasics expectedQuaternion = transform.getRotation();
        Quaternion actualQuaternion = new Quaternion();
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.set((Orientation3DReadOnly)transform.getRotation());
        actualQuaternion.set((Orientation3DReadOnly)rotationMatrix);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedQuaternion, (Orientation3DReadOnly)actualQuaternion, (double)1.0E-10);
        actualQuaternion.setToNaN();
        actualQuaternion.set((QuaternionReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedQuaternion, (Orientation3DReadOnly)actualQuaternion, (double)1.0E-10);
        AxisAngle axisAngle = new AxisAngle();
        axisAngle.set((Orientation3DReadOnly)transform.getRotation());
        actualQuaternion.set((Orientation3DReadOnly)axisAngle);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedQuaternion, (Orientation3DReadOnly)actualQuaternion, (double)1.0E-10);
        Vector3D rotationVector = new Vector3D();
        transform.getRotation().getRotationVector((Vector3DBasics)rotationVector);
        actualQuaternion.setRotationVector((Vector3DReadOnly)rotationVector);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedQuaternion, (Orientation3DReadOnly)actualQuaternion, (double)1.0E-10);
        Vector3D eulerAngles = new Vector3D();
        transform.getRotation().getEuler((Tuple3DBasics)eulerAngles);
        actualQuaternion.setEuler((Vector3DReadOnly)eulerAngles);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedQuaternion, (Orientation3DReadOnly)actualQuaternion, (double)1.0E-10);
    }

    @Test
    public void testGetTranslation() throws Exception {
        Random random = new Random(34L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D actual = new Vector3D();
        transform.getTranslation().set((Tuple3DReadOnly)expected);
        actual.set((Tuple3DReadOnly)transform.getTranslation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)transform.getTranslation(), (EuclidGeometry)actual, (double)1.0E-10);
        Vector3D translation = new Vector3D();
        translation.set(transform.getTranslationX(), transform.getTranslationY(), transform.getTranslationZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform.getTranslation(), (double)1.0E-10);
    }

    @Test
    public void testInvert() throws Exception {
        Random random = new Random(345L);
        QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        rigidBodyTransform.set((RigidBodyTransformReadOnly)original);
        rigidBodyTransform.invert();
        expected.set((RigidBodyTransformReadOnly)rigidBodyTransform);
        actual.set(original);
        actual.invert();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        rigidBodyTransform.set((RigidBodyTransformReadOnly)original);
        rigidBodyTransform.invertRotation();
        expected.set((RigidBodyTransformReadOnly)rigidBodyTransform);
        actual.set(original);
        actual.invertRotation();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
    }

    @Test
    public void testInterpolate() throws Exception {
        Random random = new Random(23542342L);
        QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasedTransform q0 = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasedTransform qf = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual.interpolate(q0, qf, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)q0, (EuclidGeometry)actual, (double)1.0E-10);
        actual.interpolate(qf, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)q0, (EuclidGeometry)actual, (double)1.0E-10);
        actual.interpolate(qf, 1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qf, (EuclidGeometry)actual, (double)1.0E-10);
        actual.interpolate(q0, qf, 1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qf, (EuclidGeometry)actual, (double)1.0E-10);
        for (int i = 0; i < 1000; ++i) {
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            Vector3D interpolatedVector = new Vector3D();
            Quaternion interpolatedRotation = new Quaternion();
            interpolatedVector.interpolate((Tuple3DReadOnly)q0.getTranslation(), (Tuple3DReadOnly)qf.getTranslation(), alpha);
            interpolatedRotation.interpolate((QuaternionReadOnly)q0.getRotation(), (QuaternionReadOnly)qf.getRotation(), alpha);
            expected.set((Orientation3DReadOnly)interpolatedRotation, (Tuple3DReadOnly)interpolatedVector);
            actual.interpolate(q0, qf, alpha);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
            actual.set(q0);
            actual.interpolate(qf, alpha);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testAppendTranslation() throws Exception {
        QuaternionBasedTransform translationTransform;
        QuaternionBasedTransform original;
        int i;
        Random random = new Random(35454L);
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            translationTransform = new QuaternionBasedTransform();
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            translationTransform.getTranslation().set(x, y, z);
            expected.set(original);
            expected.multiply((RigidBodyTransformReadOnly)translationTransform);
            actual.set(original);
            actual.appendTranslation(x, y, z);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            translationTransform = new QuaternionBasedTransform();
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            translationTransform.getTranslation().set((Tuple3DReadOnly)translation);
            expected.set(original);
            expected.multiply((RigidBodyTransformReadOnly)translationTransform);
            actual.set(original);
            actual.appendTranslation((Tuple3DReadOnly)translation);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testAppendOrientation() throws Exception {
        Random random = new Random(46575L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            QuaternionBasedTransform orientationTransform = new QuaternionBasedTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)new Vector3D());
            QuaternionBasedTransform expected = new QuaternionBasedTransform();
            expected.set(original);
            expected.multiply((RigidBodyTransformReadOnly)orientationTransform);
            QuaternionBasedTransform actual = new QuaternionBasedTransform();
            actual.set(original);
            actual.appendOrientation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testAppendYawPitchRoll() throws Exception {
        RotationMatrix expectedRotation;
        QuaternionBasedTransform original;
        int i;
        Random random = new Random(35454L);
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRotation = new RotationMatrix((Orientation3DReadOnly)original.getRotation());
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.appendYawRotation(yaw);
            expected.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            actual.set(original);
            actual.appendYawRotation(yaw);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRotation = new RotationMatrix((Orientation3DReadOnly)original.getRotation());
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.appendPitchRotation(pitch);
            expected.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            actual.set(original);
            actual.appendPitchRotation(pitch);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRotation = new RotationMatrix((Orientation3DReadOnly)original.getRotation());
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.appendRollRotation(roll);
            expected.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            actual.set(original);
            actual.appendRollRotation(roll);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPrependTranslation() throws Exception {
        QuaternionBasedTransform translationTransform;
        QuaternionBasedTransform original;
        int i;
        Random random = new Random(35454L);
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            translationTransform = new QuaternionBasedTransform();
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            translationTransform.getTranslation().set(x, y, z);
            expected.set(original);
            expected.preMultiply((RigidBodyTransformReadOnly)translationTransform);
            actual.set(original);
            actual.prependTranslation(x, y, z);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            translationTransform = new QuaternionBasedTransform();
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            translationTransform.getTranslation().set((Tuple3DReadOnly)translation);
            expected.set(original);
            expected.preMultiply((RigidBodyTransformReadOnly)translationTransform);
            actual.set(original);
            actual.prependTranslation((Tuple3DReadOnly)translation);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPrependOrientation() throws Exception {
        Random random = new Random(3456L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            QuaternionBasedTransform orientationTransform = new QuaternionBasedTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)new Vector3D());
            QuaternionBasedTransform expected = new QuaternionBasedTransform();
            expected.set(original);
            expected.preMultiply((RigidBodyTransformReadOnly)orientationTransform);
            QuaternionBasedTransform actual = new QuaternionBasedTransform();
            actual.set(original);
            actual.prependOrientation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPrependYawPitchRoll() throws Exception {
        QuaternionBasedTransform original;
        int i;
        Random random = new Random(35454L);
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform yawTransform = new QuaternionBasedTransform();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawTransform.getRotation().setToYawOrientation(yaw);
            expected.set(original);
            expected.preMultiply((RigidBodyTransformReadOnly)yawTransform);
            actual.set(original);
            actual.prependYawRotation(yaw);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform pitchTransform = new QuaternionBasedTransform();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchTransform.getRotation().setToPitchOrientation(pitch);
            expected.set(original);
            expected.preMultiply((RigidBodyTransformReadOnly)pitchTransform);
            actual.set(original);
            actual.prependPitchRotation(pitch);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform rollTransform = new QuaternionBasedTransform();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollTransform.getRotation().setToRollOrientation(roll);
            expected.set(original);
            expected.preMultiply((RigidBodyTransformReadOnly)rollTransform);
            actual.set(original);
            actual.prependRollRotation(roll);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiply() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiply((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiply((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiply((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiply((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyWithAffineTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiply((AffineTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiply((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertThis() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertOther() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertThisWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertOtherWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertThisWithAffineTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertOtherWithAffineTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.multiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.multiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiply() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyWithAffineTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiply((AffineTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiply((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertThis() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertOther() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertThisWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertOtherWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertThisWithAffineTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertOtherWithAffineTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasedTransform original = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            QuaternionBasedTransform actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            RigidBodyTransform expectedRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expectedRigidBody.set((RigidBodyTransformReadOnly)original);
            expectedRigidBody.preMultiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            expected.set((RigidBodyTransformReadOnly)expectedRigidBody);
            actual.set(original);
            actual.preMultiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransform() throws Exception {
        Random random = new Random(34L);
        QuaternionBasedTransform qTransform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        RigidBodyTransform rTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)qTransform);
        RigidBodyTransform rTransform2D = new RigidBodyTransform();
        rTransform2D.getRotation().setToYawOrientation(Math.PI * 2 * random.nextDouble() - Math.PI);
        rTransform2D.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        QuaternionBasedTransform qTransform2D = new QuaternionBasedTransform((RigidBodyTransformReadOnly)rTransform2D);
        Point3D original = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D expected = new Point3D();
        Point3D actual = new Point3D();
        actual.set(original);
        qTransform.transform((Point3DBasics)actual);
        rTransform.transform((Point3DReadOnly)original, (Point3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextPoint3D((Random)random);
        expected = new Point3D();
        actual = new Point3D();
        qTransform.transform((Point3DReadOnly)original, (Point3DBasics)actual);
        rTransform.transform((Point3DReadOnly)original, (Point3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector3D((Random)random);
        expected = new Vector3D();
        actual = new Vector3D();
        actual.set((Vector3D)original);
        qTransform.transform((Vector3DBasics)actual);
        rTransform.transform((Vector3DReadOnly)original, (Vector3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector3D((Random)random);
        expected = new Vector3D();
        actual = new Vector3D();
        qTransform.transform((Vector3DReadOnly)original, (Vector3DBasics)actual);
        rTransform.transform((Vector3DReadOnly)original, (Vector3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expected = new Quaternion();
        actual = new Quaternion();
        actual.set((Quaternion)original);
        qTransform.transform((Orientation3DBasics)actual);
        rTransform.transform((Orientation3DReadOnly)original, (Orientation3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expected = new Quaternion();
        actual = new Quaternion();
        qTransform.transform((Orientation3DReadOnly)original, (Orientation3DBasics)actual);
        rTransform.transform((Orientation3DReadOnly)original, (Orientation3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector4D((Random)random);
        expected = new Vector4D();
        actual = new Vector4D();
        actual.set((Vector4D)original);
        qTransform.transform((Vector4DBasics)actual);
        rTransform.transform((Vector4DReadOnly)original, (Vector4DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector4D((Random)random);
        expected = new Vector4D();
        actual = new Vector4D();
        qTransform.transform((Vector4DReadOnly)original, (Vector4DBasics)actual);
        rTransform.transform((Vector4DReadOnly)original, (Vector4DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        expected = new Matrix3D();
        actual = new Matrix3D();
        actual.set((Matrix3D)original);
        qTransform.transform((Matrix3DBasics)actual);
        rTransform.transform((Matrix3DReadOnly)original, (Matrix3DBasics)expected);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        expected = new Matrix3D();
        actual = new Matrix3D();
        qTransform.transform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
        rTransform.transform((Matrix3DReadOnly)original, (Matrix3DBasics)expected);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        expected = new RotationMatrix();
        actual = new RotationMatrix();
        actual.set((RotationMatrix)original);
        qTransform.transform((RotationMatrixBasics)actual);
        expected.set((RotationMatrix)original);
        rTransform.transform((RotationMatrixBasics)expected);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextPoint2D((Random)random);
        expected = new Point2D();
        actual = new Point2D();
        actual.set((Point2D)original);
        qTransform2D.transform((Point2DBasics)actual);
        rTransform2D.transform((Point2DReadOnly)original, (Point2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        actual.set((Point2D)original);
        qTransform2D.transform((Point2DBasics)actual, true);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextPoint2D((Random)random);
        expected = new Point2D();
        actual = new Point2D();
        qTransform2D.transform((Point2DReadOnly)original, (Point2DBasics)actual);
        rTransform2D.transform((Point2DReadOnly)original, (Point2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        qTransform2D.transform((Point2DReadOnly)original, (Point2DBasics)actual, true);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector2D((Random)random);
        expected = new Vector2D();
        actual = new Vector2D();
        actual.set((Vector2D)original);
        qTransform2D.transform((Vector2DBasics)actual);
        rTransform2D.transform((Vector2DReadOnly)original, (Vector2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector2D((Random)random);
        expected = new Vector2D();
        actual = new Vector2D();
        qTransform2D.transform((Vector2DReadOnly)original, (Vector2DBasics)actual);
        rTransform2D.transform((Vector2DReadOnly)original, (Vector2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
    }

    @Test
    public void testInverseTransform() throws Exception {
        Random random = new Random(34L);
        QuaternionBasedTransform qTransform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        RigidBodyTransform rTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)qTransform);
        RigidBodyTransform rTransform2D = new RigidBodyTransform();
        rTransform2D.getRotation().setToYawOrientation(Math.PI * 2 * random.nextDouble() - Math.PI);
        rTransform2D.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        QuaternionBasedTransform qTransform2D = new QuaternionBasedTransform((RigidBodyTransformReadOnly)rTransform2D);
        Point3D original = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D expected = new Point3D();
        Point3D actual = new Point3D();
        actual.set(original);
        qTransform.inverseTransform((Point3DBasics)actual);
        rTransform.inverseTransform((Point3DReadOnly)original, (Point3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextPoint3D((Random)random);
        expected = new Point3D();
        actual = new Point3D();
        qTransform.inverseTransform((Point3DReadOnly)original, (Point3DBasics)actual);
        rTransform.inverseTransform((Point3DReadOnly)original, (Point3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector3D((Random)random);
        expected = new Vector3D();
        actual = new Vector3D();
        actual.set((Vector3D)original);
        qTransform.inverseTransform((Vector3DBasics)actual);
        rTransform.inverseTransform((Vector3DReadOnly)original, (Vector3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector3D((Random)random);
        expected = new Vector3D();
        actual = new Vector3D();
        qTransform.inverseTransform((Vector3DReadOnly)original, (Vector3DBasics)actual);
        rTransform.inverseTransform((Vector3DReadOnly)original, (Vector3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextPoint2D((Random)random);
        expected = new Point2D();
        actual = new Point2D();
        actual.set((Point2D)original);
        qTransform2D.inverseTransform((Point2DBasics)actual);
        rTransform2D.inverseTransform((Point2DReadOnly)original, (Point2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextPoint2D((Random)random);
        expected = new Point2D();
        actual = new Point2D();
        qTransform2D.inverseTransform((Point2DReadOnly)original, (Point2DBasics)actual);
        rTransform2D.inverseTransform((Point2DReadOnly)original, (Point2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector2D((Random)random);
        expected = new Vector2D();
        actual = new Vector2D();
        actual.set((Vector2D)original);
        qTransform2D.inverseTransform((Vector2DBasics)actual);
        rTransform2D.inverseTransform((Vector2DReadOnly)original, (Vector2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        original = EuclidCoreRandomTools.nextVector2D((Random)random);
        expected = new Vector2D();
        actual = new Vector2D();
        qTransform2D.inverseTransform((Vector2DReadOnly)original, (Vector2DBasics)actual);
        rTransform2D.inverseTransform((Vector2DReadOnly)original, (Vector2DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithOtherRigidBodyTransform() throws Exception {
        Random random = new Random(23423L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expected = new RigidBodyTransform();
        RigidBodyTransform actual = new RigidBodyTransform();
        expected.set((RigidBodyTransformReadOnly)transform);
        expected.multiply((RigidBodyTransformReadOnly)original);
        transform.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        actual.set(original);
        transform.transform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        RigidBodyTransform inverse = new RigidBodyTransform((RigidBodyTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)expected);
        transform.inverseTransform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        actual.set(original);
        transform.inverseTransform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(23423L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        RigidBodyTransform originalRigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expectedRigidBodyTransform = new RigidBodyTransform();
        QuaternionBasedTransform original = new QuaternionBasedTransform((RigidBodyTransformReadOnly)originalRigidBodyTransform);
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        transform.transform((RigidBodyTransformReadOnly)originalRigidBodyTransform, (RigidBodyTransformBasics)expectedRigidBodyTransform);
        expected.set((RigidBodyTransformReadOnly)expectedRigidBodyTransform);
        transform.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        actual.set(original);
        transform.transform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        RigidBodyTransform inverse = new RigidBodyTransform((RigidBodyTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)expected);
        transform.inverseTransform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        actual.set(original);
        transform.inverseTransform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithAffineTransform() throws Exception {
        Random random = new Random(23423L);
        QuaternionBasedTransform transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        RigidBodyTransform originalRigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expectedRigidBodyTransform = new RigidBodyTransform();
        Vector3D scale = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
        AffineTransform original = new AffineTransform((RigidBodyTransformReadOnly)originalRigidBodyTransform);
        original.appendScale((Tuple3DReadOnly)scale);
        AffineTransform expected = new AffineTransform();
        AffineTransform actual = new AffineTransform();
        transform.transform((RigidBodyTransformReadOnly)originalRigidBodyTransform, (RigidBodyTransformBasics)expectedRigidBodyTransform);
        expected.set((RigidBodyTransformReadOnly)expectedRigidBodyTransform);
        expected.appendScale((Tuple3DReadOnly)scale);
        transform.transform((AffineTransformReadOnly)original, (AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        actual.set(original);
        transform.transform((AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        RigidBodyTransform inverse = new RigidBodyTransform((RigidBodyTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((AffineTransformReadOnly)original, (AffineTransformBasics)expected);
        transform.inverseTransform((AffineTransformReadOnly)original, (AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        actual.set(original);
        transform.inverseTransform((AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(2354L);
        QuaternionBasedTransform t1 = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasedTransform t2 = new QuaternionBasedTransform();
        Assertions.assertFalse((boolean)t1.equals((EuclidGeometry)t2));
        Assertions.assertFalse((boolean)t1.equals(null));
        Assertions.assertFalse((boolean)t1.equals((Object)new double[4]));
        t2.set(t1);
        Assertions.assertTrue((boolean)t1.equals((EuclidGeometry)t2));
        QuaternionBasedTransform t2AsObject = t2;
        Assertions.assertTrue((boolean)t1.equals((Object)t2AsObject));
        double smallestEpsilon = 1.0E-16;
        double[] coeffs = new double[7];
        int index = 0;
        while (index < 3) {
            t2.set(t1);
            Assertions.assertTrue((boolean)t1.equals((EuclidGeometry)t2));
            t1.get(coeffs);
            int n = index;
            coeffs[n] = coeffs[n] + smallestEpsilon;
            t2.set(coeffs);
            Assertions.assertFalse((boolean)t1.equals((EuclidGeometry)t2));
            t2.set(t1);
            Assertions.assertTrue((boolean)t1.equals((EuclidGeometry)t2));
            t1.get(coeffs);
            int n2 = index++;
            coeffs[n2] = coeffs[n2] - smallestEpsilon;
            t2.set(coeffs);
            Assertions.assertFalse((boolean)t1.equals((EuclidGeometry)t2));
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(2354L);
        QuaternionBasedTransform m1 = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        QuaternionBasedTransform m2 = new QuaternionBasedTransform();
        double epsilon = 0.001;
        double[] coeffs = new double[9];
        Assertions.assertFalse((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
        m2.set(m1);
        Assertions.assertTrue((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
        int index = 0;
        while (index < 3) {
            m2.set(m1);
            Assertions.assertTrue((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
            m1.get(coeffs);
            int n = index;
            coeffs[n] = coeffs[n] + 0.999 * epsilon;
            m2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6]);
            Assertions.assertTrue((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
            m2.set(m1);
            Assertions.assertTrue((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
            m1.get(coeffs);
            int n2 = index;
            coeffs[n2] = coeffs[n2] + 1.001 * epsilon;
            m2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6]);
            Assertions.assertFalse((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
            m2.set(m1);
            Assertions.assertTrue((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
            m1.get(coeffs);
            int n3 = index;
            coeffs[n3] = coeffs[n3] - 0.999 * epsilon;
            m2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6]);
            Assertions.assertTrue((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
            m2.set(m1);
            Assertions.assertTrue((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
            m1.get(coeffs);
            int n4 = index++;
            coeffs[n4] = coeffs[n4] - 1.001 * epsilon;
            m2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6]);
            Assertions.assertFalse((boolean)m1.epsilonEquals((EuclidGeometry)m2, epsilon));
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        QuaternionBasedTransform qbtB;
        Quaternion quaternion;
        AxisAngle aa;
        double angleDiff;
        QuaternionBasedTransform qbtA;
        double epsilon;
        int i;
        Random random = new Random(19825L);
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            qbtA = this.createRandomTransform(random);
            angleDiff = 0.99 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            quaternion = new Quaternion((Orientation3DReadOnly)aa);
            quaternion.preMultiply((QuaternionReadOnly)qbtA.getRotation());
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)quaternion, (Tuple3DReadOnly)qbtA.getTranslation());
            Assertions.assertTrue((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertTrue((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            qbtA = this.createRandomTransform(random);
            angleDiff = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            quaternion = new Quaternion((Orientation3DReadOnly)aa);
            quaternion.preMultiply((QuaternionReadOnly)qbtA.getRotation());
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)quaternion, (Tuple3DReadOnly)qbtA.getTranslation());
            Assertions.assertFalse((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertFalse((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            qbtA = this.createRandomTransform(random);
            Vector3D translation = new Vector3D((Tuple3DReadOnly)qbtA.getTranslation());
            Vector3D perturb = new Vector3D((Tuple3DReadOnly)translation);
            perturb.setX(translation.getX() + 0.9 * epsilon);
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)qbtA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertTrue((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertTrue((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
            perturb.setX(translation.getX() + 1.1 * epsilon);
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)qbtA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertFalse((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertFalse((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
            perturb = new Vector3D((Tuple3DReadOnly)translation);
            perturb.setY(translation.getY() + 0.9 * epsilon);
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)qbtA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertTrue((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertTrue((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
            perturb.setY(translation.getY() + 1.1 * epsilon);
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)qbtA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertFalse((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertFalse((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
            perturb = new Vector3D((Tuple3DReadOnly)translation);
            perturb.setZ(translation.getZ() + 0.9 * epsilon);
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)qbtA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertTrue((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertTrue((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
            perturb.setZ(translation.getZ() + 1.1 * epsilon);
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)qbtA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertFalse((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertFalse((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            qbtA = this.createRandomTransform(random);
            double angleDiff2 = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff2);
            quaternion = new Quaternion((Orientation3DReadOnly)aa);
            quaternion.preMultiply((QuaternionReadOnly)qbtA.getRotation());
            qbtB = new QuaternionBasedTransform((Orientation3DReadOnly)quaternion, (Tuple3DReadOnly)qbtA.getTranslation());
            Assertions.assertFalse((boolean)qbtA.geometricallyEquals((EuclidGeometry)qbtB, epsilon));
            Assertions.assertFalse((boolean)qbtB.geometricallyEquals((EuclidGeometry)qbtA, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(12345L);
        QuaternionBasedTransform qbt = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        int newHashCode = qbt.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)qbt.hashCode());
        int previousHashCode = qbt.hashCode();
        for (int i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            qbt = new QuaternionBasedTransform((Orientation3DReadOnly)quaternion, (Tuple3DReadOnly)translation);
            newHashCode = qbt.hashCode();
            Assertions.assertNotEquals((int)previousHashCode, (int)newHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Test
    public void testToString() throws Exception {
        QuaternionBasedTransform quaternionB;
        QuaternionBasedTransform quaternionA;
        int i;
        Random random = new Random(12345L);
        for (i = 0; i < 1000; ++i) {
            quaternionA = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            quaternionB = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            Assertions.assertNotEquals((Object)quaternionA.toString(), (Object)quaternionB.toString());
        }
        for (i = 0; i < 1000; ++i) {
            quaternionA = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            quaternionB = new QuaternionBasedTransform((RigidBodyTransformReadOnly)quaternionA);
            Assertions.assertEquals((Object)quaternionA.toString(), (Object)quaternionB.toString());
        }
    }

    @Override
    public QuaternionBasedTransform createRandomTransform(Random random) {
        return EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
    }

    @Override
    public QuaternionBasedTransform createRandomTransform2D(Random random) {
        RigidBodyTransform rTransform2D = new RigidBodyTransform();
        rTransform2D.getRotation().setToYawOrientation(Math.PI * 2 * random.nextDouble() - Math.PI);
        rTransform2D.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        QuaternionBasedTransform qTransform2D = new QuaternionBasedTransform((RigidBodyTransformReadOnly)rTransform2D);
        return qTransform2D;
    }
}

