/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class EuclidShape3DCollisionResultTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testConstructors() {
        Random random = new Random(654651L);
        EuclidShape3DCollisionResult collisionResult = new EuclidShape3DCollisionResult();
        Assertions.assertNull((Object)collisionResult.getShapeA());
        Assertions.assertNull((Object)collisionResult.getShapeB());
        Assertions.assertFalse((boolean)collisionResult.areShapesColliding());
        Assertions.assertEquals((double)0.0, (double)collisionResult.getDistance());
        Assertions.assertEquals((double)0.0, (double)collisionResult.getSignedDistance());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)collisionResult.getPointOnA());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)collisionResult.getNormalOnA());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)collisionResult.getPointOnB());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)collisionResult.getNormalOnB());
        for (int i = 0; i < 1000; ++i) {
            EuclidShape3DCollisionResult expected = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)expected);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)0.0);
        }
    }

    @Test
    public void testSetters() {
        Shape3DBasics expected;
        EuclidShape3DCollisionResult tested;
        EuclidShape3DCollisionResult original;
        EuclidShape3DCollisionResult expected2;
        EuclidShape3DCollisionResult collisionResult;
        int i;
        Random random = new Random(1654L);
        for (i = 0; i < 1000; ++i) {
            collisionResult = new EuclidShape3DCollisionResult();
            expected2 = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            collisionResult.set(expected2);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected2, (EuclidShape3DCollisionResultReadOnly)collisionResult, (double)0.0);
        }
        for (i = 0; i < 1000; ++i) {
            collisionResult = new EuclidShape3DCollisionResult();
            expected2 = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            collisionResult.set((EuclidShape3DCollisionResultReadOnly)expected2);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected2, (EuclidShape3DCollisionResultReadOnly)collisionResult, (double)0.0);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            tested = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            expected = EuclidShapeRandomTools.nextShape3D((Random)random);
            tested.setShapeA((Shape3DReadOnly)expected);
            Assertions.assertEquals((Object)expected, (Object)tested.getShapeA());
            Assertions.assertEquals((Object)original.getShapeB(), (Object)tested.getShapeB());
            Assertions.assertEquals((Object)original.areShapesColliding(), (Object)tested.areShapesColliding());
            Assertions.assertEquals((double)original.getDistance(), (double)tested.getDistance());
            Assertions.assertEquals((double)original.getSignedDistance(), (double)tested.getSignedDistance());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnA(), (EuclidGeometry)tested.getPointOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnB(), (EuclidGeometry)tested.getPointOnB(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnA(), (EuclidGeometry)tested.getNormalOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnB(), (EuclidGeometry)tested.getNormalOnB(), (double)0.0);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            tested = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            expected = EuclidShapeRandomTools.nextShape3D((Random)random);
            tested.setShapeB((Shape3DReadOnly)expected);
            Assertions.assertEquals((Object)original.getShapeA(), (Object)tested.getShapeA());
            Assertions.assertEquals((Object)expected, (Object)tested.getShapeB());
            Assertions.assertEquals((Object)original.areShapesColliding(), (Object)tested.areShapesColliding());
            Assertions.assertEquals((double)original.getDistance(), (double)tested.getDistance());
            Assertions.assertEquals((double)original.getSignedDistance(), (double)tested.getSignedDistance());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnA(), (EuclidGeometry)tested.getPointOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnB(), (EuclidGeometry)tested.getPointOnB(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnA(), (EuclidGeometry)tested.getNormalOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnB(), (EuclidGeometry)tested.getNormalOnB(), (double)0.0);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            tested = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            boolean expected3 = random.nextBoolean();
            tested.setShapesAreColliding(expected3);
            Assertions.assertEquals((Object)original.getShapeA(), (Object)tested.getShapeA());
            Assertions.assertEquals((Object)original.getShapeB(), (Object)tested.getShapeB());
            Assertions.assertEquals((Object)expected3, (Object)tested.areShapesColliding());
            Assertions.assertEquals((double)original.getDistance(), (double)tested.getDistance());
            Assertions.assertEquals((double)original.getSignedDistance(), (double)tested.getSignedDistance());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnA(), (EuclidGeometry)tested.getPointOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnB(), (EuclidGeometry)tested.getPointOnB(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnA(), (EuclidGeometry)tested.getNormalOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnB(), (EuclidGeometry)tested.getNormalOnB(), (double)0.0);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            tested = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            double expected4 = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            tested.setSignedDistance(expected4);
            Assertions.assertEquals((double)Math.abs(expected4), (double)tested.getDistance());
            Assertions.assertEquals((double)expected4, (double)tested.getSignedDistance());
            Assertions.assertEquals((Object)original.getShapeA(), (Object)tested.getShapeA());
            Assertions.assertEquals((Object)original.getShapeB(), (Object)tested.getShapeB());
            Assertions.assertEquals((Object)original.areShapesColliding(), (Object)tested.areShapesColliding());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnA(), (EuclidGeometry)tested.getPointOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getPointOnB(), (EuclidGeometry)tested.getPointOnB(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnA(), (EuclidGeometry)tested.getNormalOnA(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original.getNormalOnB(), (EuclidGeometry)tested.getNormalOnB(), (double)0.0);
        }
    }

    @Test
    public void testContainsNaN() {
        Random random = new Random(484L);
        EuclidShape3DCollisionResult tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
        Assertions.assertFalse((boolean)tested.containsNaN());
        ((Shape3DBasics)tested.getShapeA()).setToNaN();
        Assertions.assertFalse((boolean)tested.containsNaN());
        tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
        Assertions.assertFalse((boolean)tested.containsNaN());
        ((Shape3DBasics)tested.getShapeB()).setToNaN();
        Assertions.assertFalse((boolean)tested.containsNaN());
        tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
        Assertions.assertFalse((boolean)tested.containsNaN());
        tested.setSignedDistance(Double.NaN);
        Assertions.assertTrue((boolean)tested.containsNaN());
        tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
        Assertions.assertFalse((boolean)tested.containsNaN());
        tested.getPointOnA().setToNaN();
        Assertions.assertTrue((boolean)tested.containsNaN());
        tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
        Assertions.assertFalse((boolean)tested.containsNaN());
        tested.getPointOnB().setToNaN();
        Assertions.assertTrue((boolean)tested.containsNaN());
        tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
        Assertions.assertFalse((boolean)tested.containsNaN());
        tested.getNormalOnA().setToNaN();
        Assertions.assertTrue((boolean)tested.containsNaN());
        tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
        Assertions.assertFalse((boolean)tested.containsNaN());
        tested.getNormalOnB().setToNaN();
        Assertions.assertTrue((boolean)tested.containsNaN());
    }

    @Test
    public void setToZero() {
        Random random = new Random(641981L);
        for (int i = 0; i < 1000; ++i) {
            Box3D shapeAOriginal = EuclidShapeRandomTools.nextBox3D((Random)random);
            Box3D shapeA = new Box3D((Box3DReadOnly)shapeAOriginal);
            Sphere3D shapeBOriginal = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D shapeB = new Sphere3D((Sphere3DReadOnly)shapeBOriginal);
            EuclidShape3DCollisionResult tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            tested.setShapeA((Shape3DReadOnly)shapeA);
            tested.setShapeB((Shape3DReadOnly)shapeB);
            tested.setToZero();
            Assertions.assertEquals((Object)shapeAOriginal, (Object)shapeA);
            Assertions.assertEquals((Object)shapeBOriginal, (Object)shapeB);
            Assertions.assertFalse((boolean)tested.areShapesColliding());
            Assertions.assertEquals((double)0.0, (double)tested.getDistance());
            Assertions.assertEquals((double)0.0, (double)tested.getSignedDistance());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)tested.getPointOnA());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)tested.getPointOnB());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)tested.getNormalOnA());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)tested.getNormalOnB());
        }
    }

    @Test
    public void setToNaN() {
        Random random = new Random(641981L);
        for (int i = 0; i < 1000; ++i) {
            Box3D shapeAOriginal = EuclidShapeRandomTools.nextBox3D((Random)random);
            Box3D shapeA = new Box3D((Box3DReadOnly)shapeAOriginal);
            Sphere3D shapeBOriginal = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D shapeB = new Sphere3D((Sphere3DReadOnly)shapeBOriginal);
            EuclidShape3DCollisionResult tested = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            tested.setShapeA((Shape3DReadOnly)shapeA);
            tested.setShapeB((Shape3DReadOnly)shapeB);
            tested.setToNaN();
            Assertions.assertEquals((Object)shapeAOriginal, (Object)shapeA);
            Assertions.assertEquals((Object)shapeBOriginal, (Object)shapeB);
            Assertions.assertFalse((boolean)tested.areShapesColliding());
            Assertions.assertTrue((boolean)Double.isNaN(tested.getDistance()));
            Assertions.assertTrue((boolean)Double.isNaN(tested.getSignedDistance()));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)tested.getPointOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)tested.getPointOnB());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)tested.getNormalOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)tested.getNormalOnB());
        }
    }

    @Test
    public void testSwapShapes() {
        Random random = new Random(189648L);
        for (int i = 0; i < 1000; ++i) {
            EuclidShape3DCollisionResult original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            EuclidShape3DCollisionResult swapped = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            swapped.swapShapes();
            Assertions.assertEquals((Object)original.getShapeA(), (Object)swapped.getShapeB());
            Assertions.assertEquals((Object)original.getShapeB(), (Object)swapped.getShapeA());
            Assertions.assertEquals((Object)original.areShapesColliding(), (Object)swapped.areShapesColliding());
            Assertions.assertEquals((double)original.getDistance(), (double)swapped.getDistance());
            Assertions.assertEquals((double)original.getSignedDistance(), (double)swapped.getSignedDistance());
            Assertions.assertEquals((Object)original.getPointOnA(), (Object)swapped.getPointOnB());
            Assertions.assertEquals((Object)original.getPointOnB(), (Object)swapped.getPointOnA());
            Assertions.assertEquals((Object)original.getNormalOnA(), (Object)swapped.getNormalOnB());
            Assertions.assertEquals((Object)original.getNormalOnB(), (Object)swapped.getNormalOnA());
        }
    }

    @Test
    public void testEpsilonEquals() {
        Random random = new Random(4841L);
        for (int i = 0; i < 1000; ++i) {
            EuclidShape3DCollisionResult original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            if (random.nextInt(5) == 0) {
                original.getPointOnA().setToNaN();
            }
            if (random.nextInt(5) == 0) {
                original.getPointOnB().setToNaN();
            }
            if (random.nextInt(5) == 0) {
                original.getNormalOnA().setToNaN();
            }
            if (random.nextInt(5) == 0) {
                original.getNormalOnB().setToNaN();
            }
            EuclidShape3DCollisionResult tested = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
            tested.setShapeA((Shape3DReadOnly)EuclidShapeRandomTools.nextShape3D((Random)random));
            Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, Double.POSITIVE_INFINITY));
            tested.set(original);
            Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
            tested.setShapeB((Shape3DReadOnly)EuclidShapeRandomTools.nextShape3D((Random)random));
            Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, Double.POSITIVE_INFINITY));
            tested.set(original);
            Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
            tested.setShapesAreColliding(!original.areShapesColliding());
            Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, Double.POSITIVE_INFINITY));
            tested.set(original);
            Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
            tested.swapShapes();
            Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, Double.POSITIVE_INFINITY));
            tested.set(original);
            double epsilon = random.nextDouble();
            double sign = random.nextBoolean() ? -1.0 : 1.0;
            tested.setSignedDistance(original.getSignedDistance() + 0.99 * epsilon * sign);
            Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
            tested.setSignedDistance(original.getSignedDistance() + 1.01 * epsilon * sign);
            Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                if (!tested.getPointOnA().containsNaN()) {
                    tested.set(original);
                    Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
                    tested.getPointOnA().setElement(axisIndex, original.getPointOnA().getElement(axisIndex) + 0.99 * epsilon * sign);
                    Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
                    tested.getPointOnA().setElement(axisIndex, original.getPointOnA().getElement(axisIndex) + 1.01 * epsilon * sign);
                    Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
                }
                if (!tested.getPointOnB().containsNaN()) {
                    tested.set(original);
                    Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
                    tested.getPointOnB().setElement(axisIndex, original.getPointOnB().getElement(axisIndex) + 0.99 * epsilon * sign);
                    Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
                    tested.getPointOnB().setElement(axisIndex, original.getPointOnB().getElement(axisIndex) + 1.01 * epsilon * sign);
                    Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
                }
                if (!tested.getNormalOnA().containsNaN()) {
                    tested.set(original);
                    Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
                    tested.getNormalOnA().setElement(axisIndex, original.getNormalOnA().getElement(axisIndex) + 0.99 * epsilon * sign);
                    Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
                    tested.getNormalOnA().setElement(axisIndex, original.getNormalOnA().getElement(axisIndex) + 1.01 * epsilon * sign);
                    Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
                }
                if (tested.getNormalOnB().containsNaN()) continue;
                tested.set(original);
                Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, 0.0));
                tested.getNormalOnB().setElement(axisIndex, original.getNormalOnB().getElement(axisIndex) + 0.99 * epsilon * sign);
                Assertions.assertTrue((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
                tested.getNormalOnB().setElement(axisIndex, original.getNormalOnB().getElement(axisIndex) + 1.01 * epsilon * sign);
                Assertions.assertFalse((boolean)original.epsilonEquals((EuclidGeometry)tested, epsilon));
            }
        }
    }

    @Test
    public void testGeometricallyEquals() {
        Random random = new Random(4841L);
        for (int i = 0; i < 1000; ++i) {
            EuclidShape3DCollisionResult original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            if (random.nextInt(5) == 0) {
                original.getPointOnA().setToNaN();
            }
            if (random.nextInt(5) == 0) {
                original.getPointOnB().setToNaN();
            }
            if (random.nextInt(5) == 0) {
                original.getNormalOnA().setToNaN();
            }
            if (random.nextInt(5) == 0) {
                original.getNormalOnB().setToNaN();
            }
            EuclidShape3DCollisionResult tested = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
            tested.setShapeA((Shape3DReadOnly)EuclidShapeRandomTools.nextShape3D((Random)random));
            Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, Double.POSITIVE_INFINITY));
            tested.set(original);
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
            tested.setShapeB((Shape3DReadOnly)EuclidShapeRandomTools.nextShape3D((Random)random));
            Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, Double.POSITIVE_INFINITY));
            tested.set(original);
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
            tested.setShapesAreColliding(!original.areShapesColliding());
            Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, Double.POSITIVE_INFINITY));
            tested.set(original);
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
            tested.swapShapes();
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
            tested.set(original);
            double epsilon = random.nextDouble();
            double sign = random.nextBoolean() ? -1.0 : 1.0;
            tested.setSignedDistance(original.getSignedDistance() + 0.99 * epsilon * sign);
            if (random.nextBoolean()) {
                tested.swapShapes();
            }
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
            tested.set(original);
            if (random.nextBoolean()) {
                tested.swapShapes();
            }
            tested.setSignedDistance(original.getSignedDistance() + 1.01 * epsilon * sign);
            Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
            Vector3D belowTolerance = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            Vector3D aboveTolerance = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            if (!original.getPointOnA().containsNaN()) {
                tested.set(original);
                Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
                tested.getPointOnA().add((Tuple3DReadOnly)original.getPointOnA(), (Tuple3DReadOnly)belowTolerance);
                if (random.nextBoolean()) {
                    tested.swapShapes();
                }
                Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
                tested.set(original);
                tested.getPointOnA().add((Tuple3DReadOnly)original.getPointOnA(), (Tuple3DReadOnly)aboveTolerance);
                if (random.nextBoolean()) {
                    tested.swapShapes();
                }
                Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
            }
            if (!original.getPointOnB().containsNaN()) {
                tested.set(original);
                Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
                tested.getPointOnB().add((Tuple3DReadOnly)original.getPointOnB(), (Tuple3DReadOnly)belowTolerance);
                if (random.nextBoolean()) {
                    tested.swapShapes();
                }
                Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
                tested.set(original);
                tested.getPointOnB().add((Tuple3DReadOnly)original.getPointOnB(), (Tuple3DReadOnly)aboveTolerance);
                if (random.nextBoolean()) {
                    tested.swapShapes();
                }
                Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
            }
            if (!original.getNormalOnA().containsNaN()) {
                tested.set(original);
                Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
                tested.getNormalOnA().add((Tuple3DReadOnly)original.getNormalOnA(), (Tuple3DReadOnly)belowTolerance);
                if (random.nextBoolean()) {
                    tested.swapShapes();
                }
                Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
                tested.set(original);
                tested.getNormalOnA().add((Tuple3DReadOnly)original.getNormalOnA(), (Tuple3DReadOnly)aboveTolerance);
                if (random.nextBoolean()) {
                    tested.swapShapes();
                }
                Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
            }
            if (original.getNormalOnB().containsNaN()) continue;
            tested.set(original);
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, 0.0));
            tested.getNormalOnB().add((Tuple3DReadOnly)original.getNormalOnB(), (Tuple3DReadOnly)belowTolerance);
            if (random.nextBoolean()) {
                tested.swapShapes();
            }
            Assertions.assertTrue((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
            tested.set(original);
            tested.getNormalOnB().add((Tuple3DReadOnly)original.getNormalOnB(), (Tuple3DReadOnly)aboveTolerance);
            if (random.nextBoolean()) {
                tested.swapShapes();
            }
            Assertions.assertFalse((boolean)original.geometricallyEquals((EuclidGeometry)tested, epsilon));
        }
    }

    @Test
    public void testEquals() {
        Random random = new Random(4841L);
        for (int i = 0; i < 1000; ++i) {
            EuclidShape3DCollisionResult original = EuclidShapeRandomTools.nextEuclidShape3DCollisionResult((Random)random);
            EuclidShape3DCollisionResult tested = new EuclidShape3DCollisionResult((EuclidShape3DCollisionResultReadOnly)original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.setShapeA((Shape3DReadOnly)EuclidShapeRandomTools.nextShape3D((Random)random));
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            tested.set(original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.setShapeB((Shape3DReadOnly)EuclidShapeRandomTools.nextShape3D((Random)random));
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            tested.set(original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.setShapesAreColliding(!original.areShapesColliding());
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            tested.set(original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.swapShapes();
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            tested.set(original);
            double sign = random.nextBoolean() ? -1.0 : 1.0;
            tested.setSignedDistance(original.getSignedDistance() + 1.0E-12 * sign);
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                tested.set(original);
                Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
                tested.getPointOnA().setElement(axisIndex, original.getPointOnA().getElement(axisIndex) + 1.0E-12);
                Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
                tested.set(original);
                Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
                tested.getPointOnB().setElement(axisIndex, original.getPointOnB().getElement(axisIndex) + 1.0E-12);
                Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
                tested.set(original);
                Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
                tested.getNormalOnA().setElement(axisIndex, original.getNormalOnA().getElement(axisIndex) + 1.0E-12);
                Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
                tested.set(original);
                Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
                tested.getNormalOnB().setElement(axisIndex, original.getNormalOnB().getElement(axisIndex) + 1.0E-12);
                Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            }
            tested.set(original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.getPointOnA().setToNaN();
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            tested.set(original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.getPointOnB().setToNaN();
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            tested.set(original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.getNormalOnA().setToNaN();
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
            tested.set(original);
            Assertions.assertTrue((boolean)original.equals((EuclidGeometry)tested));
            tested.getNormalOnB().setToNaN();
            Assertions.assertFalse((boolean)original.equals((EuclidGeometry)tested));
        }
    }
}

