/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import java.util.function.Predicate;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameTuple4DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Tuple4DBasicsTest;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public abstract class FrameTuple4DBasicsTest<F extends FrameTuple4DBasics>
extends FrameTuple4DReadOnlyTest<F> {
    public static final double EPSILON = 1.0E-10;

    public abstract Tuple4DBasics createRandomFramelessTuple(Random var1);

    public final F createTuple(ReferenceFrame referenceFrame) {
        return (F)((FrameTuple4DBasics)this.createFrameTuple(referenceFrame, 0.0, 0.0, 0.0, 0.0));
    }

    public final F createTuple(ReferenceFrame referenceFrame, Tuple4DReadOnly tuple) {
        return (F)((FrameTuple4DBasics)this.createFrameTuple(referenceFrame, tuple.getX(), tuple.getY(), tuple.getZ(), tuple.getS()));
    }

    public final F createTuple(F frameTuple) {
        return this.createTuple(frameTuple.getReferenceFrame(), (Tuple4DReadOnly)frameTuple);
    }

    @Override
    public final F createRandomFrameTuple(Random random, ReferenceFrame referenceFrame) {
        return (F)((FrameTuple4DBasics)this.createFrameTuple(referenceFrame, random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()));
    }

    @Test
    public void testSet() throws Exception {
        ReferenceFrame differentFrame;
        int differenceFrameIndex;
        F actual;
        ReferenceFrame initialFrame;
        int initialFrameIndex;
        Tuple4DBasics expected;
        ReferenceFrame[] referenceFrames;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            expected = this.createRandomFramelessTuple(random);
            initialFrameIndex = random.nextInt(referenceFrames.length);
            initialFrame = referenceFrames[initialFrameIndex];
            actual = this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set(initialFrame, (Tuple4DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, actual, (double)1.0E-10);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((Tuple4DReadOnly)this.createRandomFramelessTuple(random));
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            expected.set(actual);
            differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, (Tuple4DReadOnly)this.createRandomFramelessTuple(random));
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, actual, (double)1.0E-10);
            }
        }
        for (i = 0; i < 1000; ++i) {
            referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            expected = this.createRandomFramelessTuple(random);
            initialFrameIndex = random.nextInt(referenceFrames.length);
            initialFrame = referenceFrames[initialFrameIndex];
            actual = this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set(initialFrame, expected.getX(), expected.getY(), expected.getZ(), expected.getS());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, actual, (double)1.0E-10);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((Tuple4DReadOnly)this.createRandomFramelessTuple(random));
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            expected.set(actual);
            differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, actual, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            Tuple4DBasics expectedGeometryObject = this.createRandomFramelessTuple(random);
            expectedGeometryObject.setToZero();
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            F frameGeometryObject = this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals(frameGeometryObject, 1.0E-10));
            frameGeometryObject.setToZero();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedGeometryObject, frameGeometryObject, (double)1.0E-10);
            frameGeometryObject = this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals(frameGeometryObject, 1.0E-10));
            frameGeometryObject.setToZero(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedGeometryObject, frameGeometryObject, (double)1.0E-10);
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(574L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            F frameGeometryObject = this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN();
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN(frameGeometryObject);
            frameGeometryObject = this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN(frameGeometryObject);
        }
    }

    @Test
    public void testSetIncludingFrame() throws Exception {
        Exception expectedException;
        F frameTuple;
        Object input;
        Vector4D tuple;
        ReferenceFrame newFrame;
        int i;
        Random random = new Random(2342L);
        ReferenceFrame initialFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y = random.nextDouble();
            double z = random.nextDouble();
            double s = random.nextDouble();
            ReferenceFrame newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            F frameTuple2 = this.createRandomFrameTuple(random, initialFrame);
            Vector4D tuple2 = new Vector4D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple2.getReferenceFrame());
            frameTuple2.setIncludingFrame(newFrame2, x, y, z, s);
            tuple2.set(x, y, z, s);
            Assertions.assertEquals((Object)newFrame2, (Object)frameTuple2.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple2, frameTuple2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion input2 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            F frameTuple3 = this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector4D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple3.getReferenceFrame());
            frameTuple3.setIncludingFrame(newFrame, (Tuple4DReadOnly)input2);
            tuple.set((Tuple4DReadOnly)input2);
            Assertions.assertEquals((Object)newFrame, (Object)frameTuple3.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, frameTuple3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] input3 = new double[random.nextInt(20)];
            for (int j = 0; j < input3.length; ++j) {
                input3[j] = random.nextDouble();
            }
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            F frameTuple4 = this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector4D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple4.getReferenceFrame());
            Exception expectedException2 = null;
            try {
                tuple.set(input3);
            }
            catch (Exception e) {
                expectedException2 = e;
            }
            try {
                frameTuple4.setIncludingFrame(newFrame, input3);
                if (expectedException2 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame, (Object)frameTuple4.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, frameTuple4, (double)1.0E-10);
                continue;
            }
            catch (Exception e) {
                if (expectedException2 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException2.getClass())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + String.valueOf(e) + "\nexpected: " + String.valueOf(expectedException2)));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startIndex = random.nextInt(10);
            input = new double[random.nextInt(20)];
            for (int j = 0; j < ((double[])input).length; ++j) {
                input[j] = random.nextDouble();
            }
            ReferenceFrame newFrame3 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameTuple = this.createRandomFrameTuple(random, initialFrame);
            Vector4D tuple3 = new Vector4D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple.getReferenceFrame());
            expectedException = null;
            try {
                tuple3.set(startIndex, input);
            }
            catch (Exception e) {
                expectedException = e;
            }
            try {
                frameTuple.setIncludingFrame(newFrame3, startIndex, input);
                if (expectedException != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame3, (Object)frameTuple.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple3, frameTuple, (double)1.0E-10);
                continue;
            }
            catch (Exception e) {
                if (expectedException == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException.getClass())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + String.valueOf(e) + "\nexpected: " + String.valueOf(expectedException)));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj input4 = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            F frameTuple5 = this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector4D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple5.getReferenceFrame());
            Exception expectedException3 = null;
            try {
                tuple.set((DMatrix)input4);
            }
            catch (Exception e) {
                expectedException3 = e;
            }
            try {
                frameTuple5.setIncludingFrame(newFrame, (DMatrix)input4);
                if (expectedException3 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame, (Object)frameTuple5.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, frameTuple5, (double)1.0E-10);
                continue;
            }
            catch (Exception e) {
                if (expectedException3 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException3.getClass()) || !e.getMessage().equals(expectedException3.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + String.valueOf(e) + "\nexpected: " + String.valueOf(expectedException3)));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startRow = random.nextInt(10);
            input = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            ReferenceFrame newFrame4 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameTuple = this.createRandomFrameTuple(random, initialFrame);
            Vector4D tuple4 = new Vector4D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple.getReferenceFrame());
            expectedException = null;
            try {
                tuple4.set(startRow, (DMatrix)input);
            }
            catch (Exception e) {
                expectedException = e;
            }
            try {
                frameTuple.setIncludingFrame(newFrame4, startRow, (DMatrix)input);
                if (expectedException != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame4, (Object)frameTuple.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple4, frameTuple, (double)1.0E-10);
                continue;
            }
            catch (Exception e) {
                if (expectedException == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException.getClass()) || !e.getMessage().equals(expectedException.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + String.valueOf(e) + "\nexpected: " + String.valueOf(expectedException)));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startRow = random.nextInt(10);
            int column = random.nextInt(10);
            DMatrixRMaj input5 = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            ReferenceFrame newFrame5 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            F frameTuple6 = this.createRandomFrameTuple(random, initialFrame);
            Vector4D tuple5 = new Vector4D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple6.getReferenceFrame());
            Exception expectedException4 = null;
            try {
                tuple5.set(startRow, column, (DMatrix)input5);
            }
            catch (Exception e) {
                expectedException4 = e;
            }
            try {
                frameTuple6.setIncludingFrame(newFrame5, startRow, column, (DMatrix)input5);
                if (expectedException4 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame5, (Object)frameTuple6.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple5, frameTuple6, (double)1.0E-10);
                continue;
            }
            catch (Exception e) {
                if (expectedException4 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException4.getClass()) || !e.getMessage().equals(expectedException4.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + String.valueOf(e) + "\nexpected: " + String.valueOf(expectedException4)));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            F frameTupleReadOnly = this.createRandomFrameTuple(random, frameA);
            frameTuple = this.createRandomFrameTuple(random, frameB);
            frameTuple.setIncludingFrame(frameTupleReadOnly);
            Assertions.assertTrue((frameTupleReadOnly.getReferenceFrame() == frameTuple.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals(frameTuple, frameTupleReadOnly, (double)1.0E-10);
            EuclidFrameTestTools.assertEquals(frameTuple, frameTupleReadOnly, (double)1.0E-10);
        }
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFrameTuple, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithTuple4D() throws Exception {
        FrameTypeCopier frameTypeBuilder = (frame, tuple) -> this.createTuple(frame, (Tuple4DReadOnly)tuple);
        RandomFramelessTypeBuilder framelessTypeBuilber = this::createRandomFramelessTuple;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilber, methodFilter, 10);
    }

    @Override
    public void testOverloading() throws Exception {
        super.testOverloading();
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameTuple4DBasics.class, Tuple4DBasics.class, true, 1);
    }

    @Test
    public void testTuple4DBasicsFeatures() throws Exception {
        Tuple4DBasicsTest tuple4dBasicsTest = new Tuple4DBasicsTest<F>(){

            @Override
            public void testSetDoubles() {
            }

            @Override
            public F createEmptyTuple() {
                return (FrameTuple4DBasics)FrameTuple4DBasicsTest.this.createEmptyFrameTuple();
            }

            @Override
            public F createTuple(double x, double y, double z, double s) {
                return (FrameTuple4DBasics)FrameTuple4DBasicsTest.this.createFrameTuple(x, y, z, s);
            }

            @Override
            public F createRandomTuple(Random random) {
                return (FrameTuple4DBasics)FrameTuple4DBasicsTest.this.createRandomFrameTuple(random);
            }

            @Override
            public double getEpsilon() {
                return 1.0E-10;
            }
        };
        for (Method testMethod : tuple4dBasicsTest.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            testMethod.invoke((Object)tuple4dBasicsTest, new Object[0]);
        }
    }
}

