/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameSphere3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameShapeAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameSphere3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;

public class FrameSphere3DTest {
    @Test
    public void testAPIOverloading() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameSphere3DReadOnly.class, Sphere3DReadOnly.class, false);
        tester.assertOverloadingWithFrameObjects(FixedFrameSphere3DBasics.class, Sphere3DBasics.class, false);
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Sphere3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Sphere3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Sphere3D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FrameSphere3D.class, Sphere3D.class, false, 1, methodFilter);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{FixedFrameBoundingBox3DBasics.class}));
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{ReferenceFrame.class, FrameBoundingBox3DBasics.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(EuclidFrameShapeRandomTools::nextFrameSphere3D, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithSphere3D() {
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality((frame, sphere) -> new FrameSphere3D(frame, (Sphere3DReadOnly)((Sphere3D)sphere)), EuclidShapeRandomTools::nextSphere3D, methodFilter, 10);
    }

    @Test
    public void testSetMatchingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFrameSphere3D, 10);
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFrameSphere3D, 10);
    }
}

